package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ExcludedApps;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.OfficeProductId;
import odata.msgraph.client.beta.enums.OfficeSuiteInstallProgressDisplayLevel;
import odata.msgraph.client.beta.enums.OfficeUpdateChannel;
import odata.msgraph.client.beta.enums.WindowsArchitecture;


/**
 * <i>“Contains properties and inherited properties for the Office365 Suite App.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "autoAcceptEula", 
    "excludedApps", 
    "installProgressDisplayLevel", 
    "localesToInstall", 
    "officeConfigurationXml", 
    "officePlatformArchitecture", 
    "productIds", 
    "shouldUninstallOlderVersionsOfOffice", 
    "targetVersion", 
    "updateChannel", 
    "updateVersion", 
    "useSharedComputerActivation"})
@JsonInclude(Include.NON_NULL)
public class OfficeSuiteApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeSuiteApp";
    }

    @JsonProperty("autoAcceptEula")
    protected Boolean autoAcceptEula;

    @JsonProperty("excludedApps")
    protected ExcludedApps excludedApps;

    @JsonProperty("installProgressDisplayLevel")
    protected OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel;

    @JsonProperty("localesToInstall")
    protected List<String> localesToInstall;

    @JsonProperty("localesToInstall@nextLink")
    protected String localesToInstallNextLink;

    @JsonProperty("officeConfigurationXml")
    protected byte[] officeConfigurationXml;

    @JsonProperty("officePlatformArchitecture")
    protected WindowsArchitecture officePlatformArchitecture;

    @JsonProperty("productIds")
    protected List<OfficeProductId> productIds;

    @JsonProperty("productIds@nextLink")
    protected String productIdsNextLink;

    @JsonProperty("shouldUninstallOlderVersionsOfOffice")
    protected Boolean shouldUninstallOlderVersionsOfOffice;

    @JsonProperty("targetVersion")
    protected String targetVersion;

    @JsonProperty("updateChannel")
    protected OfficeUpdateChannel updateChannel;

    @JsonProperty("updateVersion")
    protected String updateVersion;

    @JsonProperty("useSharedComputerActivation")
    protected Boolean useSharedComputerActivation;

    protected OfficeSuiteApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOfficeSuiteApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private Boolean autoAcceptEula;
        private ExcludedApps excludedApps;
        private OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel;
        private List<String> localesToInstall;
        private String localesToInstallNextLink;
        private byte[] officeConfigurationXml;
        private WindowsArchitecture officePlatformArchitecture;
        private List<OfficeProductId> productIds;
        private String productIdsNextLink;
        private Boolean shouldUninstallOlderVersionsOfOffice;
        private String targetVersion;
        private OfficeUpdateChannel updateChannel;
        private String updateVersion;
        private Boolean useSharedComputerActivation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        /**
         * <i>“The value to accept the EULA automatically on the enduser's device.”</i>
         * 
         * @param autoAcceptEula
         *            value of {@code autoAcceptEula} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder autoAcceptEula(Boolean autoAcceptEula) {
            this.autoAcceptEula = autoAcceptEula;
            this.changedFields = changedFields.add("autoAcceptEula");
            return this;
        }

        /**
         * <i>“The property to represent the apps which are excluded from the selected
         * Office365 Product Id.”</i>
         * 
         * @param excludedApps
         *            value of {@code excludedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludedApps(ExcludedApps excludedApps) {
            this.excludedApps = excludedApps;
            this.changedFields = changedFields.add("excludedApps");
            return this;
        }

        /**
         * <i>“To specify the level of display for the Installation Progress Setup UI on the
         * Device.”</i>
         * 
         * @param installProgressDisplayLevel
         *            value of {@code installProgressDisplayLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installProgressDisplayLevel(OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel) {
            this.installProgressDisplayLevel = installProgressDisplayLevel;
            this.changedFields = changedFields.add("installProgressDisplayLevel");
            return this;
        }

        /**
         * <i>“The property to represent the locales which are installed when the apps from
         * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
         * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
         * 
         * @param localesToInstall
         *            value of {@code localesToInstall} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localesToInstall(List<String> localesToInstall) {
            this.localesToInstall = localesToInstall;
            this.changedFields = changedFields.add("localesToInstall");
            return this;
        }

        /**
         * <i>“The property to represent the locales which are installed when the apps from
         * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
         * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
         * 
         * @param localesToInstall
         *            value of {@code localesToInstall} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localesToInstall(String... localesToInstall) {
            return localesToInstall(Arrays.asList(localesToInstall));
        }

        /**
         * <i>“The property to represent the locales which are installed when the apps from
         * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
         * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
         * 
         * @param localesToInstallNextLink
         *            value of {@code localesToInstall@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localesToInstallNextLink(String localesToInstallNextLink) {
            this.localesToInstallNextLink = localesToInstallNextLink;
            this.changedFields = changedFields.add("localesToInstall");
            return this;
        }

        /**
         * <i>“The property to represent the XML configuration file that can be specified for
         * Office ProPlus Apps. Takes precedence over all other properties. When present,
         * the XML configuration file will be used to create the app.”</i>
         * 
         * @param officeConfigurationXml
         *            value of {@code officeConfigurationXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder officeConfigurationXml(byte[] officeConfigurationXml) {
            this.officeConfigurationXml = officeConfigurationXml;
            this.changedFields = changedFields.add("officeConfigurationXml");
            return this;
        }

        /**
         * <i>“The property to represent the Office365 app suite version.”</i>
         * 
         * @param officePlatformArchitecture
         *            value of {@code officePlatformArchitecture} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder officePlatformArchitecture(WindowsArchitecture officePlatformArchitecture) {
            this.officePlatformArchitecture = officePlatformArchitecture;
            this.changedFields = changedFields.add("officePlatformArchitecture");
            return this;
        }

        /**
         * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
         * 
         * @param productIds
         *            value of {@code productIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productIds(List<OfficeProductId> productIds) {
            this.productIds = productIds;
            this.changedFields = changedFields.add("productIds");
            return this;
        }

        /**
         * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
         * 
         * @param productIds
         *            value of {@code productIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productIds(OfficeProductId... productIds) {
            return productIds(Arrays.asList(productIds));
        }

        /**
         * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
         * 
         * @param productIdsNextLink
         *            value of {@code productIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder productIdsNextLink(String productIdsNextLink) {
            this.productIdsNextLink = productIdsNextLink;
            this.changedFields = changedFields.add("productIds");
            return this;
        }

        /**
         * <i>“The property to determine whether to uninstall existing Office MSI if an
         * Office365 app suite is deployed to the device or not.”</i>
         * 
         * @param shouldUninstallOlderVersionsOfOffice
         *            value of {@code shouldUninstallOlderVersionsOfOffice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder shouldUninstallOlderVersionsOfOffice(Boolean shouldUninstallOlderVersionsOfOffice) {
            this.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
            this.changedFields = changedFields.add("shouldUninstallOlderVersionsOfOffice");
            return this;
        }

        /**
         * <i>“The property to represent the specific target version for the Office365 app
         * suite that should be remained deployed on the devices.”</i>
         * 
         * @param targetVersion
         *            value of {@code targetVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            this.changedFields = changedFields.add("targetVersion");
            return this;
        }

        /**
         * <i>“The property to represent the Office365 Update Channel.”</i>
         * 
         * @param updateChannel
         *            value of {@code updateChannel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateChannel(OfficeUpdateChannel updateChannel) {
            this.updateChannel = updateChannel;
            this.changedFields = changedFields.add("updateChannel");
            return this;
        }

        /**
         * <i>“The property to represent the update version in which the specific target
         * version is available for the Office365 app suite.”</i>
         * 
         * @param updateVersion
         *            value of {@code updateVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder updateVersion(String updateVersion) {
            this.updateVersion = updateVersion;
            this.changedFields = changedFields.add("updateVersion");
            return this;
        }

        /**
         * <i>“The property to represent that whether the shared computer activation is used
         * not for Office365 app suite.”</i>
         * 
         * @param useSharedComputerActivation
         *            value of {@code useSharedComputerActivation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder useSharedComputerActivation(Boolean useSharedComputerActivation) {
            this.useSharedComputerActivation = useSharedComputerActivation;
            this.changedFields = changedFields.add("useSharedComputerActivation");
            return this;
        }

        public OfficeSuiteApp build() {
            OfficeSuiteApp _x = new OfficeSuiteApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.officeSuiteApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.autoAcceptEula = autoAcceptEula;
            _x.excludedApps = excludedApps;
            _x.installProgressDisplayLevel = installProgressDisplayLevel;
            _x.localesToInstall = localesToInstall;
            _x.localesToInstallNextLink = localesToInstallNextLink;
            _x.officeConfigurationXml = officeConfigurationXml;
            _x.officePlatformArchitecture = officePlatformArchitecture;
            _x.productIds = productIds;
            _x.productIdsNextLink = productIdsNextLink;
            _x.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
            _x.targetVersion = targetVersion;
            _x.updateChannel = updateChannel;
            _x.updateVersion = updateVersion;
            _x.useSharedComputerActivation = useSharedComputerActivation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The value to accept the EULA automatically on the enduser's device.”</i>
     * 
     * @return property autoAcceptEula
     */
    @Property(name="autoAcceptEula")
    @JsonIgnore
    public Optional<Boolean> getAutoAcceptEula() {
        return Optional.ofNullable(autoAcceptEula);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code autoAcceptEula}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value to accept the EULA automatically on the enduser's device.”</i>
     * 
     * @param autoAcceptEula
     *            new value of {@code autoAcceptEula} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code autoAcceptEula} field changed
     */
    public OfficeSuiteApp withAutoAcceptEula(Boolean autoAcceptEula) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("autoAcceptEula");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.autoAcceptEula = autoAcceptEula;
        return _x;
    }

    /**
     * <i>“The property to represent the apps which are excluded from the selected
     * Office365 Product Id.”</i>
     * 
     * @return property excludedApps
     */
    @Property(name="excludedApps")
    @JsonIgnore
    public Optional<ExcludedApps> getExcludedApps() {
        return Optional.ofNullable(excludedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code excludedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the apps which are excluded from the selected
     * Office365 Product Id.”</i>
     * 
     * @param excludedApps
     *            new value of {@code excludedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code excludedApps} field changed
     */
    public OfficeSuiteApp withExcludedApps(ExcludedApps excludedApps) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("excludedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.excludedApps = excludedApps;
        return _x;
    }

    /**
     * <i>“To specify the level of display for the Installation Progress Setup UI on the
     * Device.”</i>
     * 
     * @return property installProgressDisplayLevel
     */
    @Property(name="installProgressDisplayLevel")
    @JsonIgnore
    public Optional<OfficeSuiteInstallProgressDisplayLevel> getInstallProgressDisplayLevel() {
        return Optional.ofNullable(installProgressDisplayLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installProgressDisplayLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“To specify the level of display for the Installation Progress Setup UI on the
     * Device.”</i>
     * 
     * @param installProgressDisplayLevel
     *            new value of {@code installProgressDisplayLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installProgressDisplayLevel} field changed
     */
    public OfficeSuiteApp withInstallProgressDisplayLevel(OfficeSuiteInstallProgressDisplayLevel installProgressDisplayLevel) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("installProgressDisplayLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.installProgressDisplayLevel = installProgressDisplayLevel;
        return _x;
    }

    /**
     * <i>“The property to represent the locales which are installed when the apps from
     * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
     * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
     * 
     * @return property localesToInstall
     */
    @Property(name="localesToInstall")
    @JsonIgnore
    public CollectionPage<String> getLocalesToInstall() {
        return new CollectionPage<String>(contextPath, String.class, this.localesToInstall, Optional.ofNullable(localesToInstallNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code localesToInstall}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the locales which are installed when the apps from
     * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
     * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
     * 
     * @param localesToInstall
     *            new value of {@code localesToInstall} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localesToInstall} field changed
     */
    public OfficeSuiteApp withLocalesToInstall(List<String> localesToInstall) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("localesToInstall");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.localesToInstall = localesToInstall;
        return _x;
    }

    /**
     * <i>“The property to represent the locales which are installed when the apps from
     * Office365 is installed. It uses standard RFC 6033. Ref: https://technet.
     * microsoft.com/en-us/library/cc179219(v=office.16).aspx”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property localesToInstall
     */
    @Property(name="localesToInstall")
    @JsonIgnore
    public CollectionPage<String> getLocalesToInstall(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.localesToInstall, Optional.ofNullable(localesToInstallNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The property to represent the XML configuration file that can be specified for
     * Office ProPlus Apps. Takes precedence over all other properties. When present,
     * the XML configuration file will be used to create the app.”</i>
     * 
     * @return property officeConfigurationXml
     */
    @Property(name="officeConfigurationXml")
    @JsonIgnore
    public Optional<byte[]> getOfficeConfigurationXml() {
        return Optional.ofNullable(officeConfigurationXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * officeConfigurationXml} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to represent the XML configuration file that can be specified for
     * Office ProPlus Apps. Takes precedence over all other properties. When present,
     * the XML configuration file will be used to create the app.”</i>
     * 
     * @param officeConfigurationXml
     *            new value of {@code officeConfigurationXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code officeConfigurationXml} field changed
     */
    public OfficeSuiteApp withOfficeConfigurationXml(byte[] officeConfigurationXml) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("officeConfigurationXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.officeConfigurationXml = officeConfigurationXml;
        return _x;
    }

    /**
     * <i>“The property to represent the Office365 app suite version.”</i>
     * 
     * @return property officePlatformArchitecture
     */
    @Property(name="officePlatformArchitecture")
    @JsonIgnore
    public Optional<WindowsArchitecture> getOfficePlatformArchitecture() {
        return Optional.ofNullable(officePlatformArchitecture);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * officePlatformArchitecture} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to represent the Office365 app suite version.”</i>
     * 
     * @param officePlatformArchitecture
     *            new value of {@code officePlatformArchitecture} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code officePlatformArchitecture} field changed
     */
    public OfficeSuiteApp withOfficePlatformArchitecture(WindowsArchitecture officePlatformArchitecture) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("officePlatformArchitecture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.officePlatformArchitecture = officePlatformArchitecture;
        return _x;
    }

    /**
     * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
     * 
     * @return property productIds
     */
    @Property(name="productIds")
    @JsonIgnore
    public CollectionPage<OfficeProductId> getProductIds() {
        return new CollectionPage<OfficeProductId>(contextPath, OfficeProductId.class, this.productIds, Optional.ofNullable(productIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code productIds} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
     * 
     * @param productIds
     *            new value of {@code productIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code productIds} field changed
     */
    public OfficeSuiteApp withProductIds(List<OfficeProductId> productIds) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("productIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.productIds = productIds;
        return _x;
    }

    /**
     * <i>“The Product Ids that represent the Office365 Suite SKU.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property productIds
     */
    @Property(name="productIds")
    @JsonIgnore
    public CollectionPage<OfficeProductId> getProductIds(HttpRequestOptions options) {
        return new CollectionPage<OfficeProductId>(contextPath, OfficeProductId.class, this.productIds, Optional.ofNullable(productIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The property to determine whether to uninstall existing Office MSI if an
     * Office365 app suite is deployed to the device or not.”</i>
     * 
     * @return property shouldUninstallOlderVersionsOfOffice
     */
    @Property(name="shouldUninstallOlderVersionsOfOffice")
    @JsonIgnore
    public Optional<Boolean> getShouldUninstallOlderVersionsOfOffice() {
        return Optional.ofNullable(shouldUninstallOlderVersionsOfOffice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * shouldUninstallOlderVersionsOfOffice} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The property to determine whether to uninstall existing Office MSI if an
     * Office365 app suite is deployed to the device or not.”</i>
     * 
     * @param shouldUninstallOlderVersionsOfOffice
     *            new value of {@code shouldUninstallOlderVersionsOfOffice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code shouldUninstallOlderVersionsOfOffice} field changed
     */
    public OfficeSuiteApp withShouldUninstallOlderVersionsOfOffice(Boolean shouldUninstallOlderVersionsOfOffice) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("shouldUninstallOlderVersionsOfOffice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
        return _x;
    }

    /**
     * <i>“The property to represent the specific target version for the Office365 app
     * suite that should be remained deployed on the devices.”</i>
     * 
     * @return property targetVersion
     */
    @Property(name="targetVersion")
    @JsonIgnore
    public Optional<String> getTargetVersion() {
        return Optional.ofNullable(targetVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the specific target version for the Office365 app
     * suite that should be remained deployed on the devices.”</i>
     * 
     * @param targetVersion
     *            new value of {@code targetVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetVersion} field changed
     */
    public OfficeSuiteApp withTargetVersion(String targetVersion) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("targetVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.targetVersion = targetVersion;
        return _x;
    }

    /**
     * <i>“The property to represent the Office365 Update Channel.”</i>
     * 
     * @return property updateChannel
     */
    @Property(name="updateChannel")
    @JsonIgnore
    public Optional<OfficeUpdateChannel> getUpdateChannel() {
        return Optional.ofNullable(updateChannel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateChannel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the Office365 Update Channel.”</i>
     * 
     * @param updateChannel
     *            new value of {@code updateChannel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateChannel} field changed
     */
    public OfficeSuiteApp withUpdateChannel(OfficeUpdateChannel updateChannel) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("updateChannel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.updateChannel = updateChannel;
        return _x;
    }

    /**
     * <i>“The property to represent the update version in which the specific target
     * version is available for the Office365 app suite.”</i>
     * 
     * @return property updateVersion
     */
    @Property(name="updateVersion")
    @JsonIgnore
    public Optional<String> getUpdateVersion() {
        return Optional.ofNullable(updateVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code updateVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The property to represent the update version in which the specific target
     * version is available for the Office365 app suite.”</i>
     * 
     * @param updateVersion
     *            new value of {@code updateVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code updateVersion} field changed
     */
    public OfficeSuiteApp withUpdateVersion(String updateVersion) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("updateVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.updateVersion = updateVersion;
        return _x;
    }

    /**
     * <i>“The property to represent that whether the shared computer activation is used
     * not for Office365 app suite.”</i>
     * 
     * @return property useSharedComputerActivation
     */
    @Property(name="useSharedComputerActivation")
    @JsonIgnore
    public Optional<Boolean> getUseSharedComputerActivation() {
        return Optional.ofNullable(useSharedComputerActivation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * useSharedComputerActivation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The property to represent that whether the shared computer activation is used
     * not for Office365 app suite.”</i>
     * 
     * @param useSharedComputerActivation
     *            new value of {@code useSharedComputerActivation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code useSharedComputerActivation} field changed
     */
    public OfficeSuiteApp withUseSharedComputerActivation(Boolean useSharedComputerActivation) {
        OfficeSuiteApp _x = _copy();
        _x.changedFields = changedFields.add("useSharedComputerActivation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeSuiteApp");
        _x.useSharedComputerActivation = useSharedComputerActivation;
        return _x;
    }

    public OfficeSuiteApp withUnmappedField(String name, Object value) {
        OfficeSuiteApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeSuiteApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OfficeSuiteApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeSuiteApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OfficeSuiteApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OfficeSuiteApp _copy() {
        OfficeSuiteApp _x = new OfficeSuiteApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.autoAcceptEula = autoAcceptEula;
        _x.excludedApps = excludedApps;
        _x.installProgressDisplayLevel = installProgressDisplayLevel;
        _x.localesToInstall = localesToInstall;
        _x.officeConfigurationXml = officeConfigurationXml;
        _x.officePlatformArchitecture = officePlatformArchitecture;
        _x.productIds = productIds;
        _x.shouldUninstallOlderVersionsOfOffice = shouldUninstallOlderVersionsOfOffice;
        _x.targetVersion = targetVersion;
        _x.updateChannel = updateChannel;
        _x.updateVersion = updateVersion;
        _x.useSharedComputerActivation = useSharedComputerActivation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeSuiteApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("autoAcceptEula=");
        b.append(this.autoAcceptEula);
        b.append(", ");
        b.append("excludedApps=");
        b.append(this.excludedApps);
        b.append(", ");
        b.append("installProgressDisplayLevel=");
        b.append(this.installProgressDisplayLevel);
        b.append(", ");
        b.append("localesToInstall=");
        b.append(this.localesToInstall);
        b.append(", ");
        b.append("officeConfigurationXml=");
        b.append(this.officeConfigurationXml);
        b.append(", ");
        b.append("officePlatformArchitecture=");
        b.append(this.officePlatformArchitecture);
        b.append(", ");
        b.append("productIds=");
        b.append(this.productIds);
        b.append(", ");
        b.append("shouldUninstallOlderVersionsOfOffice=");
        b.append(this.shouldUninstallOlderVersionsOfOffice);
        b.append(", ");
        b.append("targetVersion=");
        b.append(this.targetVersion);
        b.append(", ");
        b.append("updateChannel=");
        b.append(this.updateChannel);
        b.append(", ");
        b.append("updateVersion=");
        b.append(this.updateVersion);
        b.append(", ");
        b.append("useSharedComputerActivation=");
        b.append(this.useSharedComputerActivation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
