package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.SharedInsightCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TrendingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsedInsightCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "shared", 
    "trending", 
    "used"})
@JsonInclude(Include.NON_NULL)
public class OfficeGraphInsights extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.officeGraphInsights";
    }

    @JsonProperty("shared")
    protected List<SharedInsight> shared;

    @JsonProperty("trending")
    protected List<Trending> trending;

    @JsonProperty("used")
    protected List<UsedInsight> used;

    protected OfficeGraphInsights() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOfficeGraphInsights() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<SharedInsight> shared;
        private List<Trending> trending;
        private List<UsedInsight> used;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder shared(List<SharedInsight> shared) {
            this.shared = shared;
            this.changedFields = changedFields.add("shared");
            return this;
        }

        public Builder shared(SharedInsight... shared) {
            return shared(Arrays.asList(shared));
        }

        public Builder trending(List<Trending> trending) {
            this.trending = trending;
            this.changedFields = changedFields.add("trending");
            return this;
        }

        public Builder trending(Trending... trending) {
            return trending(Arrays.asList(trending));
        }

        public Builder used(List<UsedInsight> used) {
            this.used = used;
            this.changedFields = changedFields.add("used");
            return this;
        }

        public Builder used(UsedInsight... used) {
            return used(Arrays.asList(used));
        }

        public OfficeGraphInsights build() {
            OfficeGraphInsights _x = new OfficeGraphInsights();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.officeGraphInsights";
            _x.id = id;
            _x.shared = shared;
            _x.trending = trending;
            _x.used = used;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public OfficeGraphInsights withUnmappedField(String name, Object value) {
        OfficeGraphInsights _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="shared")
    @JsonIgnore
    public SharedInsightCollectionRequest getShared() {
        return new SharedInsightCollectionRequest(
                        contextPath.addSegment("shared"), Optional.ofNullable(shared));
    }

    @NavigationProperty(name="trending")
    @JsonIgnore
    public TrendingCollectionRequest getTrending() {
        return new TrendingCollectionRequest(
                        contextPath.addSegment("trending"), Optional.ofNullable(trending));
    }

    @NavigationProperty(name="used")
    @JsonIgnore
    public UsedInsightCollectionRequest getUsed() {
        return new UsedInsightCollectionRequest(
                        contextPath.addSegment("used"), Optional.ofNullable(used));
    }

    public OfficeGraphInsights withShared(List<SharedInsight> shared) {
        OfficeGraphInsights _x = _copy();
        _x.changedFields = changedFields.add("shared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeGraphInsights");
        _x.shared = shared;
        return _x;
    }

    public OfficeGraphInsights withTrending(List<Trending> trending) {
        OfficeGraphInsights _x = _copy();
        _x.changedFields = changedFields.add("trending");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeGraphInsights");
        _x.trending = trending;
        return _x;
    }

    public OfficeGraphInsights withUsed(List<UsedInsight> used) {
        OfficeGraphInsights _x = _copy();
        _x.changedFields = changedFields.add("used");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.officeGraphInsights");
        _x.used = used;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeGraphInsights patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OfficeGraphInsights _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OfficeGraphInsights put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OfficeGraphInsights _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OfficeGraphInsights _copy() {
        OfficeGraphInsights _x = new OfficeGraphInsights();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.shared = shared;
        _x.trending = trending;
        _x.used = used;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OfficeGraphInsights[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("shared=");
        b.append(this.shared);
        b.append(", ");
        b.append("trending=");
        b.append(this.trending);
        b.append(", ");
        b.append("used=");
        b.append(this.used);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
