package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "exchange", 
    "office365", 
    "oneDrive", 
    "reportDate", 
    "reportPeriod", 
    "reportRefreshDate", 
    "sharePoint", 
    "skypeForBusiness", 
    "teams", 
    "yammer"})
@JsonInclude(Include.NON_NULL)
public class Office365ActiveUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.office365ActiveUserCounts";
    }

    @JsonProperty("exchange")
    protected Long exchange;

    @JsonProperty("office365")
    protected Long office365;

    @JsonProperty("oneDrive")
    protected Long oneDrive;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("sharePoint")
    protected Long sharePoint;

    @JsonProperty("skypeForBusiness")
    protected Long skypeForBusiness;

    @JsonProperty("teams")
    protected Long teams;

    @JsonProperty("yammer")
    protected Long yammer;

    protected Office365ActiveUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOffice365ActiveUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long exchange;
        private Long office365;
        private Long oneDrive;
        private LocalDate reportDate;
        private String reportPeriod;
        private LocalDate reportRefreshDate;
        private Long sharePoint;
        private Long skypeForBusiness;
        private Long teams;
        private Long yammer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder exchange(Long exchange) {
            this.exchange = exchange;
            this.changedFields = changedFields.add("exchange");
            return this;
        }

        public Builder office365(Long office365) {
            this.office365 = office365;
            this.changedFields = changedFields.add("office365");
            return this;
        }

        public Builder oneDrive(Long oneDrive) {
            this.oneDrive = oneDrive;
            this.changedFields = changedFields.add("oneDrive");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder sharePoint(Long sharePoint) {
            this.sharePoint = sharePoint;
            this.changedFields = changedFields.add("sharePoint");
            return this;
        }

        public Builder skypeForBusiness(Long skypeForBusiness) {
            this.skypeForBusiness = skypeForBusiness;
            this.changedFields = changedFields.add("skypeForBusiness");
            return this;
        }

        public Builder teams(Long teams) {
            this.teams = teams;
            this.changedFields = changedFields.add("teams");
            return this;
        }

        public Builder yammer(Long yammer) {
            this.yammer = yammer;
            this.changedFields = changedFields.add("yammer");
            return this;
        }

        public Office365ActiveUserCounts build() {
            Office365ActiveUserCounts _x = new Office365ActiveUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.office365ActiveUserCounts";
            _x.id = id;
            _x.exchange = exchange;
            _x.office365 = office365;
            _x.oneDrive = oneDrive;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            _x.reportRefreshDate = reportRefreshDate;
            _x.sharePoint = sharePoint;
            _x.skypeForBusiness = skypeForBusiness;
            _x.teams = teams;
            _x.yammer = yammer;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="exchange")
    @JsonIgnore
    public Optional<Long> getExchange() {
        return Optional.ofNullable(exchange);
    }

    public Office365ActiveUserCounts withExchange(Long exchange) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("exchange");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.exchange = exchange;
        return _x;
    }

    @Property(name="office365")
    @JsonIgnore
    public Optional<Long> getOffice365() {
        return Optional.ofNullable(office365);
    }

    public Office365ActiveUserCounts withOffice365(Long office365) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("office365");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.office365 = office365;
        return _x;
    }

    @Property(name="oneDrive")
    @JsonIgnore
    public Optional<Long> getOneDrive() {
        return Optional.ofNullable(oneDrive);
    }

    public Office365ActiveUserCounts withOneDrive(Long oneDrive) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("oneDrive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.oneDrive = oneDrive;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public Office365ActiveUserCounts withReportDate(LocalDate reportDate) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public Office365ActiveUserCounts withReportPeriod(String reportPeriod) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public Office365ActiveUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="sharePoint")
    @JsonIgnore
    public Optional<Long> getSharePoint() {
        return Optional.ofNullable(sharePoint);
    }

    public Office365ActiveUserCounts withSharePoint(Long sharePoint) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("sharePoint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.sharePoint = sharePoint;
        return _x;
    }

    @Property(name="skypeForBusiness")
    @JsonIgnore
    public Optional<Long> getSkypeForBusiness() {
        return Optional.ofNullable(skypeForBusiness);
    }

    public Office365ActiveUserCounts withSkypeForBusiness(Long skypeForBusiness) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("skypeForBusiness");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.skypeForBusiness = skypeForBusiness;
        return _x;
    }

    @Property(name="teams")
    @JsonIgnore
    public Optional<Long> getTeams() {
        return Optional.ofNullable(teams);
    }

    public Office365ActiveUserCounts withTeams(Long teams) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("teams");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.teams = teams;
        return _x;
    }

    @Property(name="yammer")
    @JsonIgnore
    public Optional<Long> getYammer() {
        return Optional.ofNullable(yammer);
    }

    public Office365ActiveUserCounts withYammer(Long yammer) {
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = changedFields.add("yammer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.office365ActiveUserCounts");
        _x.yammer = yammer;
        return _x;
    }

    public Office365ActiveUserCounts withUnmappedField(String name, Object value) {
        Office365ActiveUserCounts _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActiveUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Office365ActiveUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Office365ActiveUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Office365ActiveUserCounts _copy() {
        Office365ActiveUserCounts _x = new Office365ActiveUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.exchange = exchange;
        _x.office365 = office365;
        _x.oneDrive = oneDrive;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        _x.reportRefreshDate = reportRefreshDate;
        _x.sharePoint = sharePoint;
        _x.skypeForBusiness = skypeForBusiness;
        _x.teams = teams;
        _x.yammer = yammer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Office365ActiveUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("exchange=");
        b.append(this.exchange);
        b.append(", ");
        b.append("office365=");
        b.append(this.office365);
        b.append(", ");
        b.append("oneDrive=");
        b.append(this.oneDrive);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("sharePoint=");
        b.append(this.sharePoint);
        b.append(", ");
        b.append("skypeForBusiness=");
        b.append(this.skypeForBusiness);
        b.append(", ");
        b.append("teams=");
        b.append(this.teams);
        b.append(", ");
        b.append("yammer=");
        b.append(this.yammer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
