package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;


/**
 * <i>“Warranty status entity for a given OEM”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "available", 
    "enabled", 
    "oemName"})
@JsonInclude(Include.NON_NULL)
public class OemWarrantyInformationOnboarding extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.oemWarrantyInformationOnboarding";
    }

    @JsonProperty("available")
    protected Boolean available;

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("oemName")
    protected String oemName;

    protected OemWarrantyInformationOnboarding() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOemWarrantyInformationOnboarding() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean available;
        private Boolean enabled;
        private String oemName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Specifies whether warranty API is available. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param available
         *            value of {@code available} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder available(Boolean available) {
            this.available = available;
            this.changedFields = changedFields.add("available");
            return this;
        }

        /**
         * <i>“Specifies whether warranty query is enabled for given OEM. This property is read
         * -only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param enabled
         *            value of {@code enabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        /**
         * <i>“OEM name. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param oemName
         *            value of {@code oemName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder oemName(String oemName) {
            this.oemName = oemName;
            this.changedFields = changedFields.add("oemName");
            return this;
        }

        public OemWarrantyInformationOnboarding build() {
            OemWarrantyInformationOnboarding _x = new OemWarrantyInformationOnboarding();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.oemWarrantyInformationOnboarding";
            _x.id = id;
            _x.available = available;
            _x.enabled = enabled;
            _x.oemName = oemName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Specifies whether warranty API is available. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property available
     */
    @Property(name="available")
    @JsonIgnore
    public Optional<Boolean> getAvailable() {
        return Optional.ofNullable(available);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code available} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies whether warranty API is available. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param available
     *            new value of {@code available} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code available} field changed
     */
    public OemWarrantyInformationOnboarding withAvailable(Boolean available) {
        OemWarrantyInformationOnboarding _x = _copy();
        _x.changedFields = changedFields.add("available");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oemWarrantyInformationOnboarding");
        _x.available = available;
        return _x;
    }

    /**
     * <i>“Specifies whether warranty query is enabled for given OEM. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property enabled
     */
    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies whether warranty query is enabled for given OEM. This property is read
     * -only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param enabled
     *            new value of {@code enabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabled} field changed
     */
    public OemWarrantyInformationOnboarding withEnabled(Boolean enabled) {
        OemWarrantyInformationOnboarding _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oemWarrantyInformationOnboarding");
        _x.enabled = enabled;
        return _x;
    }

    /**
     * <i>“OEM name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property oemName
     */
    @Property(name="oemName")
    @JsonIgnore
    public Optional<String> getOemName() {
        return Optional.ofNullable(oemName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code oemName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“OEM name. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param oemName
     *            new value of {@code oemName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code oemName} field changed
     */
    public OemWarrantyInformationOnboarding withOemName(String oemName) {
        OemWarrantyInformationOnboarding _x = _copy();
        _x.changedFields = changedFields.add("oemName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.oemWarrantyInformationOnboarding");
        _x.oemName = oemName;
        return _x;
    }

    public OemWarrantyInformationOnboarding withUnmappedField(String name, Object value) {
        OemWarrantyInformationOnboarding _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OemWarrantyInformationOnboarding patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        OemWarrantyInformationOnboarding _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public OemWarrantyInformationOnboarding put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        OemWarrantyInformationOnboarding _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private OemWarrantyInformationOnboarding _copy() {
        OemWarrantyInformationOnboarding _x = new OemWarrantyInformationOnboarding();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.available = available;
        _x.enabled = enabled;
        _x.oemName = oemName;
        return _x;
    }

    @Action(name = "disable")
    @JsonIgnore
    public ActionRequestNoReturn disable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disable"), _parameters);
    }

    @Action(name = "enable")
    @JsonIgnore
    public ActionRequestNoReturn enable() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enable"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OemWarrantyInformationOnboarding[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("available=");
        b.append(this.available);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("oemName=");
        b.append(this.oemName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
