package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "body", 
    "hasAttachments", 
    "isDeleted", 
    "subject", 
    "attachments", 
    "extensions", 
    "multiValueExtendedProperties", 
    "singleValueExtendedProperties"})
@JsonInclude(Include.NON_NULL)
public class Note extends OutlookItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.note";
    }

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("attachments")
    protected List<Attachment> attachments;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    protected Note() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNote() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> categories;
        private String categoriesNextLink;
        private String changeKey;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private ItemBody body;
        private Boolean hasAttachments;
        private Boolean isDeleted;
        private String subject;
        private List<Attachment> attachments;
        private List<Extension> extensions;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param attachments
         *            value of {@code attachments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attachments(List<Attachment> attachments) {
            this.attachments = attachments;
            this.changedFields = changedFields.add("attachments");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param attachments
         *            value of {@code attachments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attachments(Attachment... attachments) {
            return attachments(Arrays.asList(attachments));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param extensions
         *            value of {@code extensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param extensions
         *            value of {@code extensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        public Note build() {
            Note _x = new Note();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.note";
            _x.id = id;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.changeKey = changeKey;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.body = body;
            _x.hasAttachments = hasAttachments;
            _x.isDeleted = isDeleted;
            _x.subject = subject;
            _x.attachments = attachments;
            _x.extensions = extensions;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public Note withBody(ItemBody body) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.body = body;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public Note withHasAttachments(Boolean hasAttachments) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public Note withIsDeleted(Boolean isDeleted) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Note withSubject(String subject) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.subject = subject;
        return _x;
    }

    public Note withUnmappedField(String name, Object value) {
        Note _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property attachments
     */
    @NavigationProperty(name="attachments")
    @JsonIgnore
    public AttachmentCollectionRequest getAttachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"), Optional.ofNullable(attachments));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property extensions
     */
    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code attachments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param attachments
     *            new value of {@code attachments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code attachments} field changed
     */
    public Note withAttachments(List<Attachment> attachments) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("attachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.attachments = attachments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extensions} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param extensions
     *            new value of {@code extensions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extensions} field changed
     */
    public Note withExtensions(List<Extension> extensions) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.extensions = extensions;
        return _x;
    }

    public Note withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    public Note withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        Note _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.note");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Note patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Note _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Note put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Note _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Note _copy() {
        Note _x = new Note();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categories = categories;
        _x.changeKey = changeKey;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.body = body;
        _x.hasAttachments = hasAttachments;
        _x.isDeleted = isDeleted;
        _x.subject = subject;
        _x.attachments = attachments;
        _x.extensions = extensions;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Note[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("attachments=");
        b.append(this.attachments);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
