package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“IPv6 DHCP server addresses may not be matched. This is because Windows(circa
 * Redstone) does not expose this information to the Natural Authentication service
 * .”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "dnsSuffixList", 
    "ipV6DNSServerList", 
    "ipV6Gateway", 
    "ipV6Prefix"})
@JsonInclude(Include.NON_NULL)
public class NetworkIPv6ConfigurationManagementCondition extends NetworkManagementCondition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.networkIPv6ConfigurationManagementCondition";
    }

    @JsonProperty("dnsSuffixList")
    protected List<String> dnsSuffixList;

    @JsonProperty("dnsSuffixList@nextLink")
    protected String dnsSuffixListNextLink;

    @JsonProperty("ipV6DNSServerList")
    protected List<String> ipV6DNSServerList;

    @JsonProperty("ipV6DNSServerList@nextLink")
    protected String ipV6DNSServerListNextLink;

    @JsonProperty("ipV6Gateway")
    protected String ipV6Gateway;

    @JsonProperty("ipV6Prefix")
    protected String ipV6Prefix;

    protected NetworkIPv6ConfigurationManagementCondition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNetworkIPv6ConfigurationManagementCondition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<DevicePlatformType> applicablePlatforms;
        private String applicablePlatformsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String eTag;
        private OffsetDateTime modifiedDateTime;
        private String uniqueName;
        private List<String> dnsSuffixList;
        private String dnsSuffixListNextLink;
        private List<String> ipV6DNSServerList;
        private String ipV6DNSServerListNextLink;
        private String ipV6Gateway;
        private String ipV6Prefix;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicablePlatforms(List<DevicePlatformType> applicablePlatforms) {
            this.applicablePlatforms = applicablePlatforms;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        public Builder applicablePlatforms(DevicePlatformType... applicablePlatforms) {
            return applicablePlatforms(Arrays.asList(applicablePlatforms));
        }

        public Builder applicablePlatformsNextLink(String applicablePlatformsNextLink) {
            this.applicablePlatformsNextLink = applicablePlatformsNextLink;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = changedFields.add("uniqueName");
            return this;
        }

        /**
         * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
         * 
         * @param dnsSuffixList
         *            value of {@code dnsSuffixList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixList(List<String> dnsSuffixList) {
            this.dnsSuffixList = dnsSuffixList;
            this.changedFields = changedFields.add("dnsSuffixList");
            return this;
        }

        /**
         * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
         * 
         * @param dnsSuffixList
         *            value of {@code dnsSuffixList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixList(String... dnsSuffixList) {
            return dnsSuffixList(Arrays.asList(dnsSuffixList));
        }

        /**
         * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
         * 
         * @param dnsSuffixListNextLink
         *            value of {@code dnsSuffixList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsSuffixListNextLink(String dnsSuffixListNextLink) {
            this.dnsSuffixListNextLink = dnsSuffixListNextLink;
            this.changedFields = changedFields.add("dnsSuffixList");
            return this;
        }

        /**
         * <i>“An IPv6 DNS servers configured for the adapter.”</i>
         * 
         * @param ipV6DNSServerList
         *            value of {@code ipV6DNSServerList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV6DNSServerList(List<String> ipV6DNSServerList) {
            this.ipV6DNSServerList = ipV6DNSServerList;
            this.changedFields = changedFields.add("ipV6DNSServerList");
            return this;
        }

        /**
         * <i>“An IPv6 DNS servers configured for the adapter.”</i>
         * 
         * @param ipV6DNSServerList
         *            value of {@code ipV6DNSServerList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV6DNSServerList(String... ipV6DNSServerList) {
            return ipV6DNSServerList(Arrays.asList(ipV6DNSServerList));
        }

        /**
         * <i>“An IPv6 DNS servers configured for the adapter.”</i>
         * 
         * @param ipV6DNSServerListNextLink
         *            value of {@code ipV6DNSServerList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV6DNSServerListNextLink(String ipV6DNSServerListNextLink) {
            this.ipV6DNSServerListNextLink = ipV6DNSServerListNextLink;
            this.changedFields = changedFields.add("ipV6DNSServerList");
            return this;
        }

        /**
         * <i>“The IPv6 gateway address to. e.g 2001:db8::1”</i>
         * 
         * @param ipV6Gateway
         *            value of {@code ipV6Gateway} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV6Gateway(String ipV6Gateway) {
            this.ipV6Gateway = ipV6Gateway;
            this.changedFields = changedFields.add("ipV6Gateway");
            return this;
        }

        /**
         * <i>“The IPv6 subnet to be connected to. e.g. 2001:db8::/32”</i>
         * 
         * @param ipV6Prefix
         *            value of {@code ipV6Prefix} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ipV6Prefix(String ipV6Prefix) {
            this.ipV6Prefix = ipV6Prefix;
            this.changedFields = changedFields.add("ipV6Prefix");
            return this;
        }

        public NetworkIPv6ConfigurationManagementCondition build() {
            NetworkIPv6ConfigurationManagementCondition _x = new NetworkIPv6ConfigurationManagementCondition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.networkIPv6ConfigurationManagementCondition";
            _x.id = id;
            _x.applicablePlatforms = applicablePlatforms;
            _x.applicablePlatformsNextLink = applicablePlatformsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.eTag = eTag;
            _x.modifiedDateTime = modifiedDateTime;
            _x.uniqueName = uniqueName;
            _x.dnsSuffixList = dnsSuffixList;
            _x.dnsSuffixListNextLink = dnsSuffixListNextLink;
            _x.ipV6DNSServerList = ipV6DNSServerList;
            _x.ipV6DNSServerListNextLink = ipV6DNSServerListNextLink;
            _x.ipV6Gateway = ipV6Gateway;
            _x.ipV6Prefix = ipV6Prefix;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
     * 
     * @return property dnsSuffixList
     */
    @Property(name="dnsSuffixList")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixList() {
        return new CollectionPage<String>(contextPath, String.class, this.dnsSuffixList, Optional.ofNullable(dnsSuffixListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dnsSuffixList}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
     * 
     * @param dnsSuffixList
     *            new value of {@code dnsSuffixList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dnsSuffixList} field changed
     */
    public NetworkIPv6ConfigurationManagementCondition withDnsSuffixList(List<String> dnsSuffixList) {
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("dnsSuffixList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv6ConfigurationManagementCondition");
        _x.dnsSuffixList = dnsSuffixList;
        return _x;
    }

    /**
     * <i>“Valid DNS suffixes for the current network. e.g. seattle.contoso.com”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dnsSuffixList
     */
    @Property(name="dnsSuffixList")
    @JsonIgnore
    public CollectionPage<String> getDnsSuffixList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.dnsSuffixList, Optional.ofNullable(dnsSuffixListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“An IPv6 DNS servers configured for the adapter.”</i>
     * 
     * @return property ipV6DNSServerList
     */
    @Property(name="ipV6DNSServerList")
    @JsonIgnore
    public CollectionPage<String> getIpV6DNSServerList() {
        return new CollectionPage<String>(contextPath, String.class, this.ipV6DNSServerList, Optional.ofNullable(ipV6DNSServerListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipV6DNSServerList
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“An IPv6 DNS servers configured for the adapter.”</i>
     * 
     * @param ipV6DNSServerList
     *            new value of {@code ipV6DNSServerList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipV6DNSServerList} field changed
     */
    public NetworkIPv6ConfigurationManagementCondition withIpV6DNSServerList(List<String> ipV6DNSServerList) {
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("ipV6DNSServerList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv6ConfigurationManagementCondition");
        _x.ipV6DNSServerList = ipV6DNSServerList;
        return _x;
    }

    /**
     * <i>“An IPv6 DNS servers configured for the adapter.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property ipV6DNSServerList
     */
    @Property(name="ipV6DNSServerList")
    @JsonIgnore
    public CollectionPage<String> getIpV6DNSServerList(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.ipV6DNSServerList, Optional.ofNullable(ipV6DNSServerListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The IPv6 gateway address to. e.g 2001:db8::1”</i>
     * 
     * @return property ipV6Gateway
     */
    @Property(name="ipV6Gateway")
    @JsonIgnore
    public Optional<String> getIpV6Gateway() {
        return Optional.ofNullable(ipV6Gateway);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipV6Gateway}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The IPv6 gateway address to. e.g 2001:db8::1”</i>
     * 
     * @param ipV6Gateway
     *            new value of {@code ipV6Gateway} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipV6Gateway} field changed
     */
    public NetworkIPv6ConfigurationManagementCondition withIpV6Gateway(String ipV6Gateway) {
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("ipV6Gateway");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv6ConfigurationManagementCondition");
        _x.ipV6Gateway = ipV6Gateway;
        return _x;
    }

    /**
     * <i>“The IPv6 subnet to be connected to. e.g. 2001:db8::/32”</i>
     * 
     * @return property ipV6Prefix
     */
    @Property(name="ipV6Prefix")
    @JsonIgnore
    public Optional<String> getIpV6Prefix() {
        return Optional.ofNullable(ipV6Prefix);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ipV6Prefix} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The IPv6 subnet to be connected to. e.g. 2001:db8::/32”</i>
     * 
     * @param ipV6Prefix
     *            new value of {@code ipV6Prefix} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ipV6Prefix} field changed
     */
    public NetworkIPv6ConfigurationManagementCondition withIpV6Prefix(String ipV6Prefix) {
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("ipV6Prefix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.networkIPv6ConfigurationManagementCondition");
        _x.ipV6Prefix = ipV6Prefix;
        return _x;
    }

    public NetworkIPv6ConfigurationManagementCondition withUnmappedField(String name, Object value) {
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NetworkIPv6ConfigurationManagementCondition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public NetworkIPv6ConfigurationManagementCondition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        NetworkIPv6ConfigurationManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private NetworkIPv6ConfigurationManagementCondition _copy() {
        NetworkIPv6ConfigurationManagementCondition _x = new NetworkIPv6ConfigurationManagementCondition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicablePlatforms = applicablePlatforms;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.eTag = eTag;
        _x.modifiedDateTime = modifiedDateTime;
        _x.uniqueName = uniqueName;
        _x.dnsSuffixList = dnsSuffixList;
        _x.ipV6DNSServerList = ipV6DNSServerList;
        _x.ipV6Gateway = ipV6Gateway;
        _x.ipV6Prefix = ipV6Prefix;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("NetworkIPv6ConfigurationManagementCondition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicablePlatforms=");
        b.append(this.applicablePlatforms);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("uniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("dnsSuffixList=");
        b.append(this.dnsSuffixList);
        b.append(", ");
        b.append("ipV6DNSServerList=");
        b.append(this.ipV6DNSServerList);
        b.append(", ");
        b.append("ipV6Gateway=");
        b.append(this.ipV6Gateway);
        b.append(", ");
        b.append("ipV6Prefix=");
        b.append(this.ipV6Prefix);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
