package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MobileThreatPartnerTenantState;


/**
 * <i>“Entity which represents a connection to Mobile threat defense partner.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowPartnerToCollectIOSApplicationMetadata", 
    "allowPartnerToCollectIOSPersonalApplicationMetadata", 
    "androidDeviceBlockedOnMissingPartnerData", 
    "androidEnabled", 
    "androidMobileApplicationManagementEnabled", 
    "iosDeviceBlockedOnMissingPartnerData", 
    "iosEnabled", 
    "iosMobileApplicationManagementEnabled", 
    "lastHeartbeatDateTime", 
    "macDeviceBlockedOnMissingPartnerData", 
    "macEnabled", 
    "microsoftDefenderForEndpointAttachEnabled", 
    "partnerState", 
    "partnerUnresponsivenessThresholdInDays", 
    "partnerUnsupportedOsVersionBlocked", 
    "windowsDeviceBlockedOnMissingPartnerData", 
    "windowsEnabled"})
@JsonInclude(Include.NON_NULL)
public class MobileThreatDefenseConnector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileThreatDefenseConnector";
    }

    @JsonProperty("allowPartnerToCollectIOSApplicationMetadata")
    protected Boolean allowPartnerToCollectIOSApplicationMetadata;

    @JsonProperty("allowPartnerToCollectIOSPersonalApplicationMetadata")
    protected Boolean allowPartnerToCollectIOSPersonalApplicationMetadata;

    @JsonProperty("androidDeviceBlockedOnMissingPartnerData")
    protected Boolean androidDeviceBlockedOnMissingPartnerData;

    @JsonProperty("androidEnabled")
    protected Boolean androidEnabled;

    @JsonProperty("androidMobileApplicationManagementEnabled")
    protected Boolean androidMobileApplicationManagementEnabled;

    @JsonProperty("iosDeviceBlockedOnMissingPartnerData")
    protected Boolean iosDeviceBlockedOnMissingPartnerData;

    @JsonProperty("iosEnabled")
    protected Boolean iosEnabled;

    @JsonProperty("iosMobileApplicationManagementEnabled")
    protected Boolean iosMobileApplicationManagementEnabled;

    @JsonProperty("lastHeartbeatDateTime")
    protected OffsetDateTime lastHeartbeatDateTime;

    @JsonProperty("macDeviceBlockedOnMissingPartnerData")
    protected Boolean macDeviceBlockedOnMissingPartnerData;

    @JsonProperty("macEnabled")
    protected Boolean macEnabled;

    @JsonProperty("microsoftDefenderForEndpointAttachEnabled")
    protected Boolean microsoftDefenderForEndpointAttachEnabled;

    @JsonProperty("partnerState")
    protected MobileThreatPartnerTenantState partnerState;

    @JsonProperty("partnerUnresponsivenessThresholdInDays")
    protected Integer partnerUnresponsivenessThresholdInDays;

    @JsonProperty("partnerUnsupportedOsVersionBlocked")
    protected Boolean partnerUnsupportedOsVersionBlocked;

    @JsonProperty("windowsDeviceBlockedOnMissingPartnerData")
    protected Boolean windowsDeviceBlockedOnMissingPartnerData;

    @JsonProperty("windowsEnabled")
    protected Boolean windowsEnabled;

    protected MobileThreatDefenseConnector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileThreatDefenseConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean allowPartnerToCollectIOSApplicationMetadata;
        private Boolean allowPartnerToCollectIOSPersonalApplicationMetadata;
        private Boolean androidDeviceBlockedOnMissingPartnerData;
        private Boolean androidEnabled;
        private Boolean androidMobileApplicationManagementEnabled;
        private Boolean iosDeviceBlockedOnMissingPartnerData;
        private Boolean iosEnabled;
        private Boolean iosMobileApplicationManagementEnabled;
        private OffsetDateTime lastHeartbeatDateTime;
        private Boolean macDeviceBlockedOnMissingPartnerData;
        private Boolean macEnabled;
        private Boolean microsoftDefenderForEndpointAttachEnabled;
        private MobileThreatPartnerTenantState partnerState;
        private Integer partnerUnresponsivenessThresholdInDays;
        private Boolean partnerUnsupportedOsVersionBlocked;
        private Boolean windowsDeviceBlockedOnMissingPartnerData;
        private Boolean windowsEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“For IOS devices, allows the admin to configure whether the data sync partner may
         * also collect metadata about installed applications from Intune”</i>
         * 
         * @param allowPartnerToCollectIOSApplicationMetadata
         *            value of {@code allowPartnerToCollectIOSApplicationMetadata} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowPartnerToCollectIOSApplicationMetadata(Boolean allowPartnerToCollectIOSApplicationMetadata) {
            this.allowPartnerToCollectIOSApplicationMetadata = allowPartnerToCollectIOSApplicationMetadata;
            this.changedFields = changedFields.add("allowPartnerToCollectIOSApplicationMetadata");
            return this;
        }

        /**
         * <i>“For IOS devices, allows the admin to configure whether the data sync partner may
         * also collect metadata about personally installed applications from Intune”</i>
         * 
         * @param allowPartnerToCollectIOSPersonalApplicationMetadata
         *            value of {@code allowPartnerToCollectIOSPersonalApplicationMetadata} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowPartnerToCollectIOSPersonalApplicationMetadata(Boolean allowPartnerToCollectIOSPersonalApplicationMetadata) {
            this.allowPartnerToCollectIOSPersonalApplicationMetadata = allowPartnerToCollectIOSPersonalApplicationMetadata;
            this.changedFields = changedFields.add("allowPartnerToCollectIOSPersonalApplicationMetadata");
            return this;
        }

        /**
         * <i>“For Android, set whether Intune must receive data from the data sync partner
         * prior to marking a device compliant”</i>
         * 
         * @param androidDeviceBlockedOnMissingPartnerData
         *            value of {@code androidDeviceBlockedOnMissingPartnerData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDeviceBlockedOnMissingPartnerData(Boolean androidDeviceBlockedOnMissingPartnerData) {
            this.androidDeviceBlockedOnMissingPartnerData = androidDeviceBlockedOnMissingPartnerData;
            this.changedFields = changedFields.add("androidDeviceBlockedOnMissingPartnerData");
            return this;
        }

        /**
         * <i>“For Android, set whether data from the data sync partner should be used during
         * compliance evaluations”</i>
         * 
         * @param androidEnabled
         *            value of {@code androidEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidEnabled(Boolean androidEnabled) {
            this.androidEnabled = androidEnabled;
            this.changedFields = changedFields.add("androidEnabled");
            return this;
        }

        /**
         * <i>“For Android, set whether data from the data sync partner should be used during
         * Mobile Application Management (MAM) evaluations. Only one partner per platform
         * may be enabled for Mobile Application Management (MAM) evaluation.”</i>
         * 
         * @param androidMobileApplicationManagementEnabled
         *            value of {@code androidMobileApplicationManagementEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidMobileApplicationManagementEnabled(Boolean androidMobileApplicationManagementEnabled) {
            this.androidMobileApplicationManagementEnabled = androidMobileApplicationManagementEnabled;
            this.changedFields = changedFields.add("androidMobileApplicationManagementEnabled");
            return this;
        }

        /**
         * <i>“For IOS, set whether Intune must receive data from the data sync partner prior
         * to marking a device compliant”</i>
         * 
         * @param iosDeviceBlockedOnMissingPartnerData
         *            value of {@code iosDeviceBlockedOnMissingPartnerData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosDeviceBlockedOnMissingPartnerData(Boolean iosDeviceBlockedOnMissingPartnerData) {
            this.iosDeviceBlockedOnMissingPartnerData = iosDeviceBlockedOnMissingPartnerData;
            this.changedFields = changedFields.add("iosDeviceBlockedOnMissingPartnerData");
            return this;
        }

        /**
         * <i>“For IOS, get or set whether data from the data sync partner should be used
         * during compliance evaluations”</i>
         * 
         * @param iosEnabled
         *            value of {@code iosEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosEnabled(Boolean iosEnabled) {
            this.iosEnabled = iosEnabled;
            this.changedFields = changedFields.add("iosEnabled");
            return this;
        }

        /**
         * <i>“For IOS, get or set whether data from the data sync partner should be used
         * during Mobile Application Management (MAM) evaluations. Only one partner per
         * platform may be enabled for Mobile Application Management (MAM) evaluation.”</i>
         * 
         * @param iosMobileApplicationManagementEnabled
         *            value of {@code iosMobileApplicationManagementEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosMobileApplicationManagementEnabled(Boolean iosMobileApplicationManagementEnabled) {
            this.iosMobileApplicationManagementEnabled = iosMobileApplicationManagementEnabled;
            this.changedFields = changedFields.add("iosMobileApplicationManagementEnabled");
            return this;
        }

        /**
         * <i>“DateTime of last Heartbeat recieved from the Data Sync Partner”</i>
         * 
         * @param lastHeartbeatDateTime
         *            value of {@code lastHeartbeatDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastHeartbeatDateTime(OffsetDateTime lastHeartbeatDateTime) {
            this.lastHeartbeatDateTime = lastHeartbeatDateTime;
            this.changedFields = changedFields.add("lastHeartbeatDateTime");
            return this;
        }

        /**
         * <i>“For Mac, get or set whether Intune must receive data from the data sync partner
         * prior to marking a device compliant”</i>
         * 
         * @param macDeviceBlockedOnMissingPartnerData
         *            value of {@code macDeviceBlockedOnMissingPartnerData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macDeviceBlockedOnMissingPartnerData(Boolean macDeviceBlockedOnMissingPartnerData) {
            this.macDeviceBlockedOnMissingPartnerData = macDeviceBlockedOnMissingPartnerData;
            this.changedFields = changedFields.add("macDeviceBlockedOnMissingPartnerData");
            return this;
        }

        /**
         * <i>“For Mac, get or set whether data from the data sync partner should be used
         * during compliance evaluations”</i>
         * 
         * @param macEnabled
         *            value of {@code macEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder macEnabled(Boolean macEnabled) {
            this.macEnabled = macEnabled;
            this.changedFields = changedFields.add("macEnabled");
            return this;
        }

        /**
         * <i>“When TRUE, configuration profile management via Microsoft Defender for Endpoint
         * is enabled. When FALSE, configuration profile management via Microsoft Defender
         * for Endpoint is disabled.”</i>
         * 
         * @param microsoftDefenderForEndpointAttachEnabled
         *            value of {@code microsoftDefenderForEndpointAttachEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftDefenderForEndpointAttachEnabled(Boolean microsoftDefenderForEndpointAttachEnabled) {
            this.microsoftDefenderForEndpointAttachEnabled = microsoftDefenderForEndpointAttachEnabled;
            this.changedFields = changedFields.add("microsoftDefenderForEndpointAttachEnabled");
            return this;
        }

        /**
         * <i>“Data Sync Partner state for this account”</i>
         * 
         * @param partnerState
         *            value of {@code partnerState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerState(MobileThreatPartnerTenantState partnerState) {
            this.partnerState = partnerState;
            this.changedFields = changedFields.add("partnerState");
            return this;
        }

        /**
         * <i>“Get or Set days the per tenant tolerance to unresponsiveness for this partner
         * integration”</i>
         * 
         * @param partnerUnresponsivenessThresholdInDays
         *            value of {@code partnerUnresponsivenessThresholdInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerUnresponsivenessThresholdInDays(Integer partnerUnresponsivenessThresholdInDays) {
            this.partnerUnresponsivenessThresholdInDays = partnerUnresponsivenessThresholdInDays;
            this.changedFields = changedFields.add("partnerUnresponsivenessThresholdInDays");
            return this;
        }

        /**
         * <i>“Get or set whether to block devices on the enabled platforms that do not meet
         * the minimum version requirements of the Data Sync Partner”</i>
         * 
         * @param partnerUnsupportedOsVersionBlocked
         *            value of {@code partnerUnsupportedOsVersionBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder partnerUnsupportedOsVersionBlocked(Boolean partnerUnsupportedOsVersionBlocked) {
            this.partnerUnsupportedOsVersionBlocked = partnerUnsupportedOsVersionBlocked;
            this.changedFields = changedFields.add("partnerUnsupportedOsVersionBlocked");
            return this;
        }

        /**
         * <i>“For Windows, set whether Intune must receive data from the data sync partner
         * prior to marking a device compliant”</i>
         * 
         * @param windowsDeviceBlockedOnMissingPartnerData
         *            value of {@code windowsDeviceBlockedOnMissingPartnerData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsDeviceBlockedOnMissingPartnerData(Boolean windowsDeviceBlockedOnMissingPartnerData) {
            this.windowsDeviceBlockedOnMissingPartnerData = windowsDeviceBlockedOnMissingPartnerData;
            this.changedFields = changedFields.add("windowsDeviceBlockedOnMissingPartnerData");
            return this;
        }

        /**
         * <i>“For Windows, get or set whether data from the data sync partner should be used
         * during compliance evaluations”</i>
         * 
         * @param windowsEnabled
         *            value of {@code windowsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsEnabled(Boolean windowsEnabled) {
            this.windowsEnabled = windowsEnabled;
            this.changedFields = changedFields.add("windowsEnabled");
            return this;
        }

        public MobileThreatDefenseConnector build() {
            MobileThreatDefenseConnector _x = new MobileThreatDefenseConnector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileThreatDefenseConnector";
            _x.id = id;
            _x.allowPartnerToCollectIOSApplicationMetadata = allowPartnerToCollectIOSApplicationMetadata;
            _x.allowPartnerToCollectIOSPersonalApplicationMetadata = allowPartnerToCollectIOSPersonalApplicationMetadata;
            _x.androidDeviceBlockedOnMissingPartnerData = androidDeviceBlockedOnMissingPartnerData;
            _x.androidEnabled = androidEnabled;
            _x.androidMobileApplicationManagementEnabled = androidMobileApplicationManagementEnabled;
            _x.iosDeviceBlockedOnMissingPartnerData = iosDeviceBlockedOnMissingPartnerData;
            _x.iosEnabled = iosEnabled;
            _x.iosMobileApplicationManagementEnabled = iosMobileApplicationManagementEnabled;
            _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
            _x.macDeviceBlockedOnMissingPartnerData = macDeviceBlockedOnMissingPartnerData;
            _x.macEnabled = macEnabled;
            _x.microsoftDefenderForEndpointAttachEnabled = microsoftDefenderForEndpointAttachEnabled;
            _x.partnerState = partnerState;
            _x.partnerUnresponsivenessThresholdInDays = partnerUnresponsivenessThresholdInDays;
            _x.partnerUnsupportedOsVersionBlocked = partnerUnsupportedOsVersionBlocked;
            _x.windowsDeviceBlockedOnMissingPartnerData = windowsDeviceBlockedOnMissingPartnerData;
            _x.windowsEnabled = windowsEnabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“For IOS devices, allows the admin to configure whether the data sync partner may
     * also collect metadata about installed applications from Intune”</i>
     * 
     * @return property allowPartnerToCollectIOSApplicationMetadata
     */
    @Property(name="allowPartnerToCollectIOSApplicationMetadata")
    @JsonIgnore
    public Optional<Boolean> getAllowPartnerToCollectIOSApplicationMetadata() {
        return Optional.ofNullable(allowPartnerToCollectIOSApplicationMetadata);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowPartnerToCollectIOSApplicationMetadata} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For IOS devices, allows the admin to configure whether the data sync partner may
     * also collect metadata about installed applications from Intune”</i>
     * 
     * @param allowPartnerToCollectIOSApplicationMetadata
     *            new value of {@code allowPartnerToCollectIOSApplicationMetadata} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowPartnerToCollectIOSApplicationMetadata} field changed
     */
    public MobileThreatDefenseConnector withAllowPartnerToCollectIOSApplicationMetadata(Boolean allowPartnerToCollectIOSApplicationMetadata) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("allowPartnerToCollectIOSApplicationMetadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.allowPartnerToCollectIOSApplicationMetadata = allowPartnerToCollectIOSApplicationMetadata;
        return _x;
    }

    /**
     * <i>“For IOS devices, allows the admin to configure whether the data sync partner may
     * also collect metadata about personally installed applications from Intune”</i>
     * 
     * @return property allowPartnerToCollectIOSPersonalApplicationMetadata
     */
    @Property(name="allowPartnerToCollectIOSPersonalApplicationMetadata")
    @JsonIgnore
    public Optional<Boolean> getAllowPartnerToCollectIOSPersonalApplicationMetadata() {
        return Optional.ofNullable(allowPartnerToCollectIOSPersonalApplicationMetadata);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowPartnerToCollectIOSPersonalApplicationMetadata} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“For IOS devices, allows the admin to configure whether the data sync partner may
     * also collect metadata about personally installed applications from Intune”</i>
     * 
     * @param allowPartnerToCollectIOSPersonalApplicationMetadata
     *            new value of {@code allowPartnerToCollectIOSPersonalApplicationMetadata} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowPartnerToCollectIOSPersonalApplicationMetadata} field changed
     */
    public MobileThreatDefenseConnector withAllowPartnerToCollectIOSPersonalApplicationMetadata(Boolean allowPartnerToCollectIOSPersonalApplicationMetadata) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("allowPartnerToCollectIOSPersonalApplicationMetadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.allowPartnerToCollectIOSPersonalApplicationMetadata = allowPartnerToCollectIOSPersonalApplicationMetadata;
        return _x;
    }

    /**
     * <i>“For Android, set whether Intune must receive data from the data sync partner
     * prior to marking a device compliant”</i>
     * 
     * @return property androidDeviceBlockedOnMissingPartnerData
     */
    @Property(name="androidDeviceBlockedOnMissingPartnerData")
    @JsonIgnore
    public Optional<Boolean> getAndroidDeviceBlockedOnMissingPartnerData() {
        return Optional.ofNullable(androidDeviceBlockedOnMissingPartnerData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidDeviceBlockedOnMissingPartnerData} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For Android, set whether Intune must receive data from the data sync partner
     * prior to marking a device compliant”</i>
     * 
     * @param androidDeviceBlockedOnMissingPartnerData
     *            new value of {@code androidDeviceBlockedOnMissingPartnerData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidDeviceBlockedOnMissingPartnerData} field changed
     */
    public MobileThreatDefenseConnector withAndroidDeviceBlockedOnMissingPartnerData(Boolean androidDeviceBlockedOnMissingPartnerData) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("androidDeviceBlockedOnMissingPartnerData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.androidDeviceBlockedOnMissingPartnerData = androidDeviceBlockedOnMissingPartnerData;
        return _x;
    }

    /**
     * <i>“For Android, set whether data from the data sync partner should be used during
     * compliance evaluations”</i>
     * 
     * @return property androidEnabled
     */
    @Property(name="androidEnabled")
    @JsonIgnore
    public Optional<Boolean> getAndroidEnabled() {
        return Optional.ofNullable(androidEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code androidEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“For Android, set whether data from the data sync partner should be used during
     * compliance evaluations”</i>
     * 
     * @param androidEnabled
     *            new value of {@code androidEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidEnabled} field changed
     */
    public MobileThreatDefenseConnector withAndroidEnabled(Boolean androidEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("androidEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.androidEnabled = androidEnabled;
        return _x;
    }

    /**
     * <i>“For Android, set whether data from the data sync partner should be used during
     * Mobile Application Management (MAM) evaluations. Only one partner per platform
     * may be enabled for Mobile Application Management (MAM) evaluation.”</i>
     * 
     * @return property androidMobileApplicationManagementEnabled
     */
    @Property(name="androidMobileApplicationManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getAndroidMobileApplicationManagementEnabled() {
        return Optional.ofNullable(androidMobileApplicationManagementEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidMobileApplicationManagementEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For Android, set whether data from the data sync partner should be used during
     * Mobile Application Management (MAM) evaluations. Only one partner per platform
     * may be enabled for Mobile Application Management (MAM) evaluation.”</i>
     * 
     * @param androidMobileApplicationManagementEnabled
     *            new value of {@code androidMobileApplicationManagementEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidMobileApplicationManagementEnabled} field changed
     */
    public MobileThreatDefenseConnector withAndroidMobileApplicationManagementEnabled(Boolean androidMobileApplicationManagementEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("androidMobileApplicationManagementEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.androidMobileApplicationManagementEnabled = androidMobileApplicationManagementEnabled;
        return _x;
    }

    /**
     * <i>“For IOS, set whether Intune must receive data from the data sync partner prior
     * to marking a device compliant”</i>
     * 
     * @return property iosDeviceBlockedOnMissingPartnerData
     */
    @Property(name="iosDeviceBlockedOnMissingPartnerData")
    @JsonIgnore
    public Optional<Boolean> getIosDeviceBlockedOnMissingPartnerData() {
        return Optional.ofNullable(iosDeviceBlockedOnMissingPartnerData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iosDeviceBlockedOnMissingPartnerData} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For IOS, set whether Intune must receive data from the data sync partner prior
     * to marking a device compliant”</i>
     * 
     * @param iosDeviceBlockedOnMissingPartnerData
     *            new value of {@code iosDeviceBlockedOnMissingPartnerData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosDeviceBlockedOnMissingPartnerData} field changed
     */
    public MobileThreatDefenseConnector withIosDeviceBlockedOnMissingPartnerData(Boolean iosDeviceBlockedOnMissingPartnerData) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("iosDeviceBlockedOnMissingPartnerData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.iosDeviceBlockedOnMissingPartnerData = iosDeviceBlockedOnMissingPartnerData;
        return _x;
    }

    /**
     * <i>“For IOS, get or set whether data from the data sync partner should be used
     * during compliance evaluations”</i>
     * 
     * @return property iosEnabled
     */
    @Property(name="iosEnabled")
    @JsonIgnore
    public Optional<Boolean> getIosEnabled() {
        return Optional.ofNullable(iosEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code iosEnabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“For IOS, get or set whether data from the data sync partner should be used
     * during compliance evaluations”</i>
     * 
     * @param iosEnabled
     *            new value of {@code iosEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosEnabled} field changed
     */
    public MobileThreatDefenseConnector withIosEnabled(Boolean iosEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("iosEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.iosEnabled = iosEnabled;
        return _x;
    }

    /**
     * <i>“For IOS, get or set whether data from the data sync partner should be used
     * during Mobile Application Management (MAM) evaluations. Only one partner per
     * platform may be enabled for Mobile Application Management (MAM) evaluation.”</i>
     * 
     * @return property iosMobileApplicationManagementEnabled
     */
    @Property(name="iosMobileApplicationManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getIosMobileApplicationManagementEnabled() {
        return Optional.ofNullable(iosMobileApplicationManagementEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iosMobileApplicationManagementEnabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For IOS, get or set whether data from the data sync partner should be used
     * during Mobile Application Management (MAM) evaluations. Only one partner per
     * platform may be enabled for Mobile Application Management (MAM) evaluation.”</i>
     * 
     * @param iosMobileApplicationManagementEnabled
     *            new value of {@code iosMobileApplicationManagementEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosMobileApplicationManagementEnabled} field changed
     */
    public MobileThreatDefenseConnector withIosMobileApplicationManagementEnabled(Boolean iosMobileApplicationManagementEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("iosMobileApplicationManagementEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.iosMobileApplicationManagementEnabled = iosMobileApplicationManagementEnabled;
        return _x;
    }

    /**
     * <i>“DateTime of last Heartbeat recieved from the Data Sync Partner”</i>
     * 
     * @return property lastHeartbeatDateTime
     */
    @Property(name="lastHeartbeatDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastHeartbeatDateTime() {
        return Optional.ofNullable(lastHeartbeatDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastHeartbeatDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime of last Heartbeat recieved from the Data Sync Partner”</i>
     * 
     * @param lastHeartbeatDateTime
     *            new value of {@code lastHeartbeatDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastHeartbeatDateTime} field changed
     */
    public MobileThreatDefenseConnector withLastHeartbeatDateTime(OffsetDateTime lastHeartbeatDateTime) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("lastHeartbeatDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
        return _x;
    }

    /**
     * <i>“For Mac, get or set whether Intune must receive data from the data sync partner
     * prior to marking a device compliant”</i>
     * 
     * @return property macDeviceBlockedOnMissingPartnerData
     */
    @Property(name="macDeviceBlockedOnMissingPartnerData")
    @JsonIgnore
    public Optional<Boolean> getMacDeviceBlockedOnMissingPartnerData() {
        return Optional.ofNullable(macDeviceBlockedOnMissingPartnerData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * macDeviceBlockedOnMissingPartnerData} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For Mac, get or set whether Intune must receive data from the data sync partner
     * prior to marking a device compliant”</i>
     * 
     * @param macDeviceBlockedOnMissingPartnerData
     *            new value of {@code macDeviceBlockedOnMissingPartnerData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macDeviceBlockedOnMissingPartnerData} field changed
     */
    public MobileThreatDefenseConnector withMacDeviceBlockedOnMissingPartnerData(Boolean macDeviceBlockedOnMissingPartnerData) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("macDeviceBlockedOnMissingPartnerData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.macDeviceBlockedOnMissingPartnerData = macDeviceBlockedOnMissingPartnerData;
        return _x;
    }

    /**
     * <i>“For Mac, get or set whether data from the data sync partner should be used
     * during compliance evaluations”</i>
     * 
     * @return property macEnabled
     */
    @Property(name="macEnabled")
    @JsonIgnore
    public Optional<Boolean> getMacEnabled() {
        return Optional.ofNullable(macEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code macEnabled} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“For Mac, get or set whether data from the data sync partner should be used
     * during compliance evaluations”</i>
     * 
     * @param macEnabled
     *            new value of {@code macEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code macEnabled} field changed
     */
    public MobileThreatDefenseConnector withMacEnabled(Boolean macEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("macEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.macEnabled = macEnabled;
        return _x;
    }

    /**
     * <i>“When TRUE, configuration profile management via Microsoft Defender for Endpoint
     * is enabled. When FALSE, configuration profile management via Microsoft Defender
     * for Endpoint is disabled.”</i>
     * 
     * @return property microsoftDefenderForEndpointAttachEnabled
     */
    @Property(name="microsoftDefenderForEndpointAttachEnabled")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftDefenderForEndpointAttachEnabled() {
        return Optional.ofNullable(microsoftDefenderForEndpointAttachEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftDefenderForEndpointAttachEnabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“When TRUE, configuration profile management via Microsoft Defender for Endpoint
     * is enabled. When FALSE, configuration profile management via Microsoft Defender
     * for Endpoint is disabled.”</i>
     * 
     * @param microsoftDefenderForEndpointAttachEnabled
     *            new value of {@code microsoftDefenderForEndpointAttachEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftDefenderForEndpointAttachEnabled} field changed
     */
    public MobileThreatDefenseConnector withMicrosoftDefenderForEndpointAttachEnabled(Boolean microsoftDefenderForEndpointAttachEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("microsoftDefenderForEndpointAttachEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.microsoftDefenderForEndpointAttachEnabled = microsoftDefenderForEndpointAttachEnabled;
        return _x;
    }

    /**
     * <i>“Data Sync Partner state for this account”</i>
     * 
     * @return property partnerState
     */
    @Property(name="partnerState")
    @JsonIgnore
    public Optional<MobileThreatPartnerTenantState> getPartnerState() {
        return Optional.ofNullable(partnerState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code partnerState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Data Sync Partner state for this account”</i>
     * 
     * @param partnerState
     *            new value of {@code partnerState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerState} field changed
     */
    public MobileThreatDefenseConnector withPartnerState(MobileThreatPartnerTenantState partnerState) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("partnerState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.partnerState = partnerState;
        return _x;
    }

    /**
     * <i>“Get or Set days the per tenant tolerance to unresponsiveness for this partner
     * integration”</i>
     * 
     * @return property partnerUnresponsivenessThresholdInDays
     */
    @Property(name="partnerUnresponsivenessThresholdInDays")
    @JsonIgnore
    public Optional<Integer> getPartnerUnresponsivenessThresholdInDays() {
        return Optional.ofNullable(partnerUnresponsivenessThresholdInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * partnerUnresponsivenessThresholdInDays} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Get or Set days the per tenant tolerance to unresponsiveness for this partner
     * integration”</i>
     * 
     * @param partnerUnresponsivenessThresholdInDays
     *            new value of {@code partnerUnresponsivenessThresholdInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerUnresponsivenessThresholdInDays} field changed
     */
    public MobileThreatDefenseConnector withPartnerUnresponsivenessThresholdInDays(Integer partnerUnresponsivenessThresholdInDays) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("partnerUnresponsivenessThresholdInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.partnerUnresponsivenessThresholdInDays = partnerUnresponsivenessThresholdInDays;
        return _x;
    }

    /**
     * <i>“Get or set whether to block devices on the enabled platforms that do not meet
     * the minimum version requirements of the Data Sync Partner”</i>
     * 
     * @return property partnerUnsupportedOsVersionBlocked
     */
    @Property(name="partnerUnsupportedOsVersionBlocked")
    @JsonIgnore
    public Optional<Boolean> getPartnerUnsupportedOsVersionBlocked() {
        return Optional.ofNullable(partnerUnsupportedOsVersionBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * partnerUnsupportedOsVersionBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Get or set whether to block devices on the enabled platforms that do not meet
     * the minimum version requirements of the Data Sync Partner”</i>
     * 
     * @param partnerUnsupportedOsVersionBlocked
     *            new value of {@code partnerUnsupportedOsVersionBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code partnerUnsupportedOsVersionBlocked} field changed
     */
    public MobileThreatDefenseConnector withPartnerUnsupportedOsVersionBlocked(Boolean partnerUnsupportedOsVersionBlocked) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("partnerUnsupportedOsVersionBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.partnerUnsupportedOsVersionBlocked = partnerUnsupportedOsVersionBlocked;
        return _x;
    }

    /**
     * <i>“For Windows, set whether Intune must receive data from the data sync partner
     * prior to marking a device compliant”</i>
     * 
     * @return property windowsDeviceBlockedOnMissingPartnerData
     */
    @Property(name="windowsDeviceBlockedOnMissingPartnerData")
    @JsonIgnore
    public Optional<Boolean> getWindowsDeviceBlockedOnMissingPartnerData() {
        return Optional.ofNullable(windowsDeviceBlockedOnMissingPartnerData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsDeviceBlockedOnMissingPartnerData} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“For Windows, set whether Intune must receive data from the data sync partner
     * prior to marking a device compliant”</i>
     * 
     * @param windowsDeviceBlockedOnMissingPartnerData
     *            new value of {@code windowsDeviceBlockedOnMissingPartnerData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsDeviceBlockedOnMissingPartnerData} field changed
     */
    public MobileThreatDefenseConnector withWindowsDeviceBlockedOnMissingPartnerData(Boolean windowsDeviceBlockedOnMissingPartnerData) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("windowsDeviceBlockedOnMissingPartnerData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.windowsDeviceBlockedOnMissingPartnerData = windowsDeviceBlockedOnMissingPartnerData;
        return _x;
    }

    /**
     * <i>“For Windows, get or set whether data from the data sync partner should be used
     * during compliance evaluations”</i>
     * 
     * @return property windowsEnabled
     */
    @Property(name="windowsEnabled")
    @JsonIgnore
    public Optional<Boolean> getWindowsEnabled() {
        return Optional.ofNullable(windowsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code windowsEnabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“For Windows, get or set whether data from the data sync partner should be used
     * during compliance evaluations”</i>
     * 
     * @param windowsEnabled
     *            new value of {@code windowsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsEnabled} field changed
     */
    public MobileThreatDefenseConnector withWindowsEnabled(Boolean windowsEnabled) {
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = changedFields.add("windowsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileThreatDefenseConnector");
        _x.windowsEnabled = windowsEnabled;
        return _x;
    }

    public MobileThreatDefenseConnector withUnmappedField(String name, Object value) {
        MobileThreatDefenseConnector _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileThreatDefenseConnector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileThreatDefenseConnector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileThreatDefenseConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileThreatDefenseConnector _copy() {
        MobileThreatDefenseConnector _x = new MobileThreatDefenseConnector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowPartnerToCollectIOSApplicationMetadata = allowPartnerToCollectIOSApplicationMetadata;
        _x.allowPartnerToCollectIOSPersonalApplicationMetadata = allowPartnerToCollectIOSPersonalApplicationMetadata;
        _x.androidDeviceBlockedOnMissingPartnerData = androidDeviceBlockedOnMissingPartnerData;
        _x.androidEnabled = androidEnabled;
        _x.androidMobileApplicationManagementEnabled = androidMobileApplicationManagementEnabled;
        _x.iosDeviceBlockedOnMissingPartnerData = iosDeviceBlockedOnMissingPartnerData;
        _x.iosEnabled = iosEnabled;
        _x.iosMobileApplicationManagementEnabled = iosMobileApplicationManagementEnabled;
        _x.lastHeartbeatDateTime = lastHeartbeatDateTime;
        _x.macDeviceBlockedOnMissingPartnerData = macDeviceBlockedOnMissingPartnerData;
        _x.macEnabled = macEnabled;
        _x.microsoftDefenderForEndpointAttachEnabled = microsoftDefenderForEndpointAttachEnabled;
        _x.partnerState = partnerState;
        _x.partnerUnresponsivenessThresholdInDays = partnerUnresponsivenessThresholdInDays;
        _x.partnerUnsupportedOsVersionBlocked = partnerUnsupportedOsVersionBlocked;
        _x.windowsDeviceBlockedOnMissingPartnerData = windowsDeviceBlockedOnMissingPartnerData;
        _x.windowsEnabled = windowsEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileThreatDefenseConnector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowPartnerToCollectIOSApplicationMetadata=");
        b.append(this.allowPartnerToCollectIOSApplicationMetadata);
        b.append(", ");
        b.append("allowPartnerToCollectIOSPersonalApplicationMetadata=");
        b.append(this.allowPartnerToCollectIOSPersonalApplicationMetadata);
        b.append(", ");
        b.append("androidDeviceBlockedOnMissingPartnerData=");
        b.append(this.androidDeviceBlockedOnMissingPartnerData);
        b.append(", ");
        b.append("androidEnabled=");
        b.append(this.androidEnabled);
        b.append(", ");
        b.append("androidMobileApplicationManagementEnabled=");
        b.append(this.androidMobileApplicationManagementEnabled);
        b.append(", ");
        b.append("iosDeviceBlockedOnMissingPartnerData=");
        b.append(this.iosDeviceBlockedOnMissingPartnerData);
        b.append(", ");
        b.append("iosEnabled=");
        b.append(this.iosEnabled);
        b.append(", ");
        b.append("iosMobileApplicationManagementEnabled=");
        b.append(this.iosMobileApplicationManagementEnabled);
        b.append(", ");
        b.append("lastHeartbeatDateTime=");
        b.append(this.lastHeartbeatDateTime);
        b.append(", ");
        b.append("macDeviceBlockedOnMissingPartnerData=");
        b.append(this.macDeviceBlockedOnMissingPartnerData);
        b.append(", ");
        b.append("macEnabled=");
        b.append(this.macEnabled);
        b.append(", ");
        b.append("microsoftDefenderForEndpointAttachEnabled=");
        b.append(this.microsoftDefenderForEndpointAttachEnabled);
        b.append(", ");
        b.append("partnerState=");
        b.append(this.partnerState);
        b.append(", ");
        b.append("partnerUnresponsivenessThresholdInDays=");
        b.append(this.partnerUnresponsivenessThresholdInDays);
        b.append(", ");
        b.append("partnerUnsupportedOsVersionBlocked=");
        b.append(this.partnerUnsupportedOsVersionBlocked);
        b.append(", ");
        b.append("windowsDeviceBlockedOnMissingPartnerData=");
        b.append(this.windowsDeviceBlockedOnMissingPartnerData);
        b.append(", ");
        b.append("windowsEnabled=");
        b.append(this.windowsEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
