package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MobileAppRelationshipType;
import odata.msgraph.client.beta.enums.MobileAppSupersedenceType;


/**
 * <i>“Describes a supersedence relationship between two mobile apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "supersededAppCount", 
    "supersedenceType", 
    "supersedingAppCount"})
@JsonInclude(Include.NON_NULL)
public class MobileAppSupersedence extends MobileAppRelationship implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppSupersedence";
    }

    @JsonProperty("supersededAppCount")
    protected Integer supersededAppCount;

    @JsonProperty("supersedenceType")
    protected MobileAppSupersedenceType supersedenceType;

    @JsonProperty("supersedingAppCount")
    protected Integer supersedingAppCount;

    protected MobileAppSupersedence() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppSupersedence() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String targetDisplayName;
        private String targetDisplayVersion;
        private String targetId;
        private String targetPublisher;
        private MobileAppRelationshipType targetType;
        private Integer supersededAppCount;
        private MobileAppSupersedenceType supersedenceType;
        private Integer supersedingAppCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder targetDisplayName(String targetDisplayName) {
            this.targetDisplayName = targetDisplayName;
            this.changedFields = changedFields.add("targetDisplayName");
            return this;
        }

        public Builder targetDisplayVersion(String targetDisplayVersion) {
            this.targetDisplayVersion = targetDisplayVersion;
            this.changedFields = changedFields.add("targetDisplayVersion");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.changedFields = changedFields.add("targetId");
            return this;
        }

        public Builder targetPublisher(String targetPublisher) {
            this.targetPublisher = targetPublisher;
            this.changedFields = changedFields.add("targetPublisher");
            return this;
        }

        public Builder targetType(MobileAppRelationshipType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        /**
         * <i>“The total number of apps directly or indirectly superseded by the child app.”</i>
         * 
         * @param supersededAppCount
         *            value of {@code supersededAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        /**
         * <i>“The supersedence relationship type between the parent and child apps.”</i>
         * 
         * @param supersedenceType
         *            value of {@code supersedenceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supersedenceType(MobileAppSupersedenceType supersedenceType) {
            this.supersedenceType = supersedenceType;
            this.changedFields = changedFields.add("supersedenceType");
            return this;
        }

        /**
         * <i>“The total number of apps directly or indirectly superseding the parent app.”</i>
         * 
         * @param supersedingAppCount
         *            value of {@code supersedingAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public MobileAppSupersedence build() {
            MobileAppSupersedence _x = new MobileAppSupersedence();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppSupersedence";
            _x.id = id;
            _x.targetDisplayName = targetDisplayName;
            _x.targetDisplayVersion = targetDisplayVersion;
            _x.targetId = targetId;
            _x.targetPublisher = targetPublisher;
            _x.targetType = targetType;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedenceType = supersedenceType;
            _x.supersedingAppCount = supersedingAppCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The total number of apps directly or indirectly superseded by the child app.”</i>
     * 
     * @return property supersededAppCount
     */
    @Property(name="supersededAppCount")
    @JsonIgnore
    public Optional<Integer> getSupersededAppCount() {
        return Optional.ofNullable(supersededAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supersededAppCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The total number of apps directly or indirectly superseded by the child app.”</i>
     * 
     * @param supersededAppCount
     *            new value of {@code supersededAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supersededAppCount} field changed
     */
    public MobileAppSupersedence withSupersededAppCount(Integer supersededAppCount) {
        MobileAppSupersedence _x = _copy();
        _x.changedFields = changedFields.add("supersededAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppSupersedence");
        _x.supersededAppCount = supersededAppCount;
        return _x;
    }

    /**
     * <i>“The supersedence relationship type between the parent and child apps.”</i>
     * 
     * @return property supersedenceType
     */
    @Property(name="supersedenceType")
    @JsonIgnore
    public Optional<MobileAppSupersedenceType> getSupersedenceType() {
        return Optional.ofNullable(supersedenceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supersedenceType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The supersedence relationship type between the parent and child apps.”</i>
     * 
     * @param supersedenceType
     *            new value of {@code supersedenceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supersedenceType} field changed
     */
    public MobileAppSupersedence withSupersedenceType(MobileAppSupersedenceType supersedenceType) {
        MobileAppSupersedence _x = _copy();
        _x.changedFields = changedFields.add("supersedenceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppSupersedence");
        _x.supersedenceType = supersedenceType;
        return _x;
    }

    /**
     * <i>“The total number of apps directly or indirectly superseding the parent app.”</i>
     * 
     * @return property supersedingAppCount
     */
    @Property(name="supersedingAppCount")
    @JsonIgnore
    public Optional<Integer> getSupersedingAppCount() {
        return Optional.ofNullable(supersedingAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supersedingAppCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The total number of apps directly or indirectly superseding the parent app.”</i>
     * 
     * @param supersedingAppCount
     *            new value of {@code supersedingAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supersedingAppCount} field changed
     */
    public MobileAppSupersedence withSupersedingAppCount(Integer supersedingAppCount) {
        MobileAppSupersedence _x = _copy();
        _x.changedFields = changedFields.add("supersedingAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppSupersedence");
        _x.supersedingAppCount = supersedingAppCount;
        return _x;
    }

    public MobileAppSupersedence withUnmappedField(String name, Object value) {
        MobileAppSupersedence _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppSupersedence patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppSupersedence _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppSupersedence put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppSupersedence _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppSupersedence _copy() {
        MobileAppSupersedence _x = new MobileAppSupersedence();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.targetDisplayName = targetDisplayName;
        _x.targetDisplayVersion = targetDisplayVersion;
        _x.targetId = targetId;
        _x.targetPublisher = targetPublisher;
        _x.targetType = targetType;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedenceType = supersedenceType;
        _x.supersedingAppCount = supersedingAppCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppSupersedence[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetDisplayName=");
        b.append(this.targetDisplayName);
        b.append(", ");
        b.append("targetDisplayVersion=");
        b.append(this.targetDisplayVersion);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("targetPublisher=");
        b.append(this.targetPublisher);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedenceType=");
        b.append(this.supersedenceType);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
