package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MobileAppAssignmentSettings;
import odata.msgraph.client.beta.enums.ErrorCode;
import odata.msgraph.client.beta.enums.InstallIntent;
import odata.msgraph.client.beta.enums.PolicySetStatus;


/**
 * <i>“A class containing the properties used for mobile app PolicySetItem.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "intent", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class MobileAppPolicySetItem extends PolicySetItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppPolicySetItem";
    }

    @JsonProperty("intent")
    protected InstallIntent intent;

    @JsonProperty("settings")
    protected MobileAppAssignmentSettings settings;

    protected MobileAppPolicySetItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppPolicySetItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private ErrorCode errorCode;
        private List<String> guidedDeploymentTags;
        private String guidedDeploymentTagsNextLink;
        private String itemType;
        private OffsetDateTime lastModifiedDateTime;
        private String payloadId;
        private PolicySetStatus status;
        private InstallIntent intent;
        private MobileAppAssignmentSettings settings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder guidedDeploymentTags(List<String> guidedDeploymentTags) {
            this.guidedDeploymentTags = guidedDeploymentTags;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        public Builder guidedDeploymentTags(String... guidedDeploymentTags) {
            return guidedDeploymentTags(Arrays.asList(guidedDeploymentTags));
        }

        public Builder guidedDeploymentTagsNextLink(String guidedDeploymentTagsNextLink) {
            this.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            this.changedFields = changedFields.add("guidedDeploymentTags");
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            this.changedFields = changedFields.add("itemType");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder payloadId(String payloadId) {
            this.payloadId = payloadId;
            this.changedFields = changedFields.add("payloadId");
            return this;
        }

        public Builder status(PolicySetStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Install intent of the MobileAppPolicySetItem.”</i>
         * 
         * @param intent
         *            value of {@code intent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intent(InstallIntent intent) {
            this.intent = intent;
            this.changedFields = changedFields.add("intent");
            return this;
        }

        /**
         * <i>“Settings of the MobileAppPolicySetItem.”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(MobileAppAssignmentSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public MobileAppPolicySetItem build() {
            MobileAppPolicySetItem _x = new MobileAppPolicySetItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppPolicySetItem";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.errorCode = errorCode;
            _x.guidedDeploymentTags = guidedDeploymentTags;
            _x.guidedDeploymentTagsNextLink = guidedDeploymentTagsNextLink;
            _x.itemType = itemType;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.payloadId = payloadId;
            _x.status = status;
            _x.intent = intent;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Install intent of the MobileAppPolicySetItem.”</i>
     * 
     * @return property intent
     */
    @Property(name="intent")
    @JsonIgnore
    public Optional<InstallIntent> getIntent() {
        return Optional.ofNullable(intent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intent} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Install intent of the MobileAppPolicySetItem.”</i>
     * 
     * @param intent
     *            new value of {@code intent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intent} field changed
     */
    public MobileAppPolicySetItem withIntent(InstallIntent intent) {
        MobileAppPolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("intent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppPolicySetItem");
        _x.intent = intent;
        return _x;
    }

    /**
     * <i>“Settings of the MobileAppPolicySetItem.”</i>
     * 
     * @return property settings
     */
    @Property(name="settings")
    @JsonIgnore
    public Optional<MobileAppAssignmentSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Settings of the MobileAppPolicySetItem.”</i>
     * 
     * @param settings
     *            new value of {@code settings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settings} field changed
     */
    public MobileAppPolicySetItem withSettings(MobileAppAssignmentSettings settings) {
        MobileAppPolicySetItem _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppPolicySetItem");
        _x.settings = settings;
        return _x;
    }

    public MobileAppPolicySetItem withUnmappedField(String name, Object value) {
        MobileAppPolicySetItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppPolicySetItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppPolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppPolicySetItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppPolicySetItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppPolicySetItem _copy() {
        MobileAppPolicySetItem _x = new MobileAppPolicySetItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.errorCode = errorCode;
        _x.guidedDeploymentTags = guidedDeploymentTags;
        _x.itemType = itemType;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.payloadId = payloadId;
        _x.status = status;
        _x.intent = intent;
        _x.settings = settings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppPolicySetItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("guidedDeploymentTags=");
        b.append(this.guidedDeploymentTags);
        b.append(", ");
        b.append("itemType=");
        b.append(this.itemType);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("payloadId=");
        b.append(this.payloadId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("intent=");
        b.append(this.intent);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
