package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for the installation summary of a mobile app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "failedDeviceCount", 
    "failedUserCount", 
    "installedDeviceCount", 
    "installedUserCount", 
    "notApplicableDeviceCount", 
    "notApplicableUserCount", 
    "notInstalledDeviceCount", 
    "notInstalledUserCount", 
    "pendingInstallDeviceCount", 
    "pendingInstallUserCount"})
@JsonInclude(Include.NON_NULL)
public class MobileAppInstallSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppInstallSummary";
    }

    @JsonProperty("failedDeviceCount")
    protected Integer failedDeviceCount;

    @JsonProperty("failedUserCount")
    protected Integer failedUserCount;

    @JsonProperty("installedDeviceCount")
    protected Integer installedDeviceCount;

    @JsonProperty("installedUserCount")
    protected Integer installedUserCount;

    @JsonProperty("notApplicableDeviceCount")
    protected Integer notApplicableDeviceCount;

    @JsonProperty("notApplicableUserCount")
    protected Integer notApplicableUserCount;

    @JsonProperty("notInstalledDeviceCount")
    protected Integer notInstalledDeviceCount;

    @JsonProperty("notInstalledUserCount")
    protected Integer notInstalledUserCount;

    @JsonProperty("pendingInstallDeviceCount")
    protected Integer pendingInstallDeviceCount;

    @JsonProperty("pendingInstallUserCount")
    protected Integer pendingInstallUserCount;

    protected MobileAppInstallSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppInstallSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer failedDeviceCount;
        private Integer failedUserCount;
        private Integer installedDeviceCount;
        private Integer installedUserCount;
        private Integer notApplicableDeviceCount;
        private Integer notApplicableUserCount;
        private Integer notInstalledDeviceCount;
        private Integer notInstalledUserCount;
        private Integer pendingInstallDeviceCount;
        private Integer pendingInstallUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of Devices that have failed to install this app.”</i>
         * 
         * @param failedDeviceCount
         *            value of {@code failedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceCount(Integer failedDeviceCount) {
            this.failedDeviceCount = failedDeviceCount;
            this.changedFields = changedFields.add("failedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Users that have 1 or more device that failed to install this app.”</i>
         * 
         * @param failedUserCount
         *            value of {@code failedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedUserCount(Integer failedUserCount) {
            this.failedUserCount = failedUserCount;
            this.changedFields = changedFields.add("failedUserCount");
            return this;
        }

        /**
         * <i>“Number of Devices that have successfully installed this app.”</i>
         * 
         * @param installedDeviceCount
         *            value of {@code installedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installedDeviceCount(Integer installedDeviceCount) {
            this.installedDeviceCount = installedDeviceCount;
            this.changedFields = changedFields.add("installedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Users whose devices have all succeeded to install this app.”</i>
         * 
         * @param installedUserCount
         *            value of {@code installedUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installedUserCount(Integer installedUserCount) {
            this.installedUserCount = installedUserCount;
            this.changedFields = changedFields.add("installedUserCount");
            return this;
        }

        /**
         * <i>“Number of Devices that are not applicable for this app.”</i>
         * 
         * @param notApplicableDeviceCount
         *            value of {@code notApplicableDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableDeviceCount(Integer notApplicableDeviceCount) {
            this.notApplicableDeviceCount = notApplicableDeviceCount;
            this.changedFields = changedFields.add("notApplicableDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Users whose devices were all not applicable for this app.”</i>
         * 
         * @param notApplicableUserCount
         *            value of {@code notApplicableUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableUserCount(Integer notApplicableUserCount) {
            this.notApplicableUserCount = notApplicableUserCount;
            this.changedFields = changedFields.add("notApplicableUserCount");
            return this;
        }

        /**
         * <i>“Number of Devices that does not have this app installed.”</i>
         * 
         * @param notInstalledDeviceCount
         *            value of {@code notInstalledDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notInstalledDeviceCount(Integer notInstalledDeviceCount) {
            this.notInstalledDeviceCount = notInstalledDeviceCount;
            this.changedFields = changedFields.add("notInstalledDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Users that have 1 or more devices that did not install this app.”</i>
         * 
         * @param notInstalledUserCount
         *            value of {@code notInstalledUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notInstalledUserCount(Integer notInstalledUserCount) {
            this.notInstalledUserCount = notInstalledUserCount;
            this.changedFields = changedFields.add("notInstalledUserCount");
            return this;
        }

        /**
         * <i>“Number of Devices that have been notified to install this app.”</i>
         * 
         * @param pendingInstallDeviceCount
         *            value of {@code pendingInstallDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pendingInstallDeviceCount(Integer pendingInstallDeviceCount) {
            this.pendingInstallDeviceCount = pendingInstallDeviceCount;
            this.changedFields = changedFields.add("pendingInstallDeviceCount");
            return this;
        }

        /**
         * <i>“Number of Users that have 1 or more device that have been notified to install
         * this app and have 0 devices with failures.”</i>
         * 
         * @param pendingInstallUserCount
         *            value of {@code pendingInstallUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pendingInstallUserCount(Integer pendingInstallUserCount) {
            this.pendingInstallUserCount = pendingInstallUserCount;
            this.changedFields = changedFields.add("pendingInstallUserCount");
            return this;
        }

        public MobileAppInstallSummary build() {
            MobileAppInstallSummary _x = new MobileAppInstallSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppInstallSummary";
            _x.id = id;
            _x.failedDeviceCount = failedDeviceCount;
            _x.failedUserCount = failedUserCount;
            _x.installedDeviceCount = installedDeviceCount;
            _x.installedUserCount = installedUserCount;
            _x.notApplicableDeviceCount = notApplicableDeviceCount;
            _x.notApplicableUserCount = notApplicableUserCount;
            _x.notInstalledDeviceCount = notInstalledDeviceCount;
            _x.notInstalledUserCount = notInstalledUserCount;
            _x.pendingInstallDeviceCount = pendingInstallDeviceCount;
            _x.pendingInstallUserCount = pendingInstallUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of Devices that have failed to install this app.”</i>
     * 
     * @return property failedDeviceCount
     */
    @Property(name="failedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getFailedDeviceCount() {
        return Optional.ofNullable(failedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedDeviceCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Devices that have failed to install this app.”</i>
     * 
     * @param failedDeviceCount
     *            new value of {@code failedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedDeviceCount} field changed
     */
    public MobileAppInstallSummary withFailedDeviceCount(Integer failedDeviceCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("failedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.failedDeviceCount = failedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Users that have 1 or more device that failed to install this app.”</i>
     * 
     * @return property failedUserCount
     */
    @Property(name="failedUserCount")
    @JsonIgnore
    public Optional<Integer> getFailedUserCount() {
        return Optional.ofNullable(failedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of Users that have 1 or more device that failed to install this app.”</i>
     * 
     * @param failedUserCount
     *            new value of {@code failedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedUserCount} field changed
     */
    public MobileAppInstallSummary withFailedUserCount(Integer failedUserCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("failedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.failedUserCount = failedUserCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that have successfully installed this app.”</i>
     * 
     * @return property installedDeviceCount
     */
    @Property(name="installedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getInstalledDeviceCount() {
        return Optional.ofNullable(installedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that have successfully installed this app.”</i>
     * 
     * @param installedDeviceCount
     *            new value of {@code installedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installedDeviceCount} field changed
     */
    public MobileAppInstallSummary withInstalledDeviceCount(Integer installedDeviceCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("installedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.installedDeviceCount = installedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Users whose devices have all succeeded to install this app.”</i>
     * 
     * @return property installedUserCount
     */
    @Property(name="installedUserCount")
    @JsonIgnore
    public Optional<Integer> getInstalledUserCount() {
        return Optional.ofNullable(installedUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installedUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Users whose devices have all succeeded to install this app.”</i>
     * 
     * @param installedUserCount
     *            new value of {@code installedUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installedUserCount} field changed
     */
    public MobileAppInstallSummary withInstalledUserCount(Integer installedUserCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("installedUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.installedUserCount = installedUserCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that are not applicable for this app.”</i>
     * 
     * @return property notApplicableDeviceCount
     */
    @Property(name="notApplicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableDeviceCount() {
        return Optional.ofNullable(notApplicableDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that are not applicable for this app.”</i>
     * 
     * @param notApplicableDeviceCount
     *            new value of {@code notApplicableDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableDeviceCount} field changed
     */
    public MobileAppInstallSummary withNotApplicableDeviceCount(Integer notApplicableDeviceCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Users whose devices were all not applicable for this app.”</i>
     * 
     * @return property notApplicableUserCount
     */
    @Property(name="notApplicableUserCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableUserCount() {
        return Optional.ofNullable(notApplicableUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableUserCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of Users whose devices were all not applicable for this app.”</i>
     * 
     * @param notApplicableUserCount
     *            new value of {@code notApplicableUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableUserCount} field changed
     */
    public MobileAppInstallSummary withNotApplicableUserCount(Integer notApplicableUserCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.notApplicableUserCount = notApplicableUserCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that does not have this app installed.”</i>
     * 
     * @return property notInstalledDeviceCount
     */
    @Property(name="notInstalledDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNotInstalledDeviceCount() {
        return Optional.ofNullable(notInstalledDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notInstalledDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that does not have this app installed.”</i>
     * 
     * @param notInstalledDeviceCount
     *            new value of {@code notInstalledDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notInstalledDeviceCount} field changed
     */
    public MobileAppInstallSummary withNotInstalledDeviceCount(Integer notInstalledDeviceCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("notInstalledDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.notInstalledDeviceCount = notInstalledDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Users that have 1 or more devices that did not install this app.”</i>
     * 
     * @return property notInstalledUserCount
     */
    @Property(name="notInstalledUserCount")
    @JsonIgnore
    public Optional<Integer> getNotInstalledUserCount() {
        return Optional.ofNullable(notInstalledUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notInstalledUserCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of Users that have 1 or more devices that did not install this app.”</i>
     * 
     * @param notInstalledUserCount
     *            new value of {@code notInstalledUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notInstalledUserCount} field changed
     */
    public MobileAppInstallSummary withNotInstalledUserCount(Integer notInstalledUserCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("notInstalledUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.notInstalledUserCount = notInstalledUserCount;
        return _x;
    }

    /**
     * <i>“Number of Devices that have been notified to install this app.”</i>
     * 
     * @return property pendingInstallDeviceCount
     */
    @Property(name="pendingInstallDeviceCount")
    @JsonIgnore
    public Optional<Integer> getPendingInstallDeviceCount() {
        return Optional.ofNullable(pendingInstallDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pendingInstallDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of Devices that have been notified to install this app.”</i>
     * 
     * @param pendingInstallDeviceCount
     *            new value of {@code pendingInstallDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pendingInstallDeviceCount} field changed
     */
    public MobileAppInstallSummary withPendingInstallDeviceCount(Integer pendingInstallDeviceCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("pendingInstallDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.pendingInstallDeviceCount = pendingInstallDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of Users that have 1 or more device that have been notified to install
     * this app and have 0 devices with failures.”</i>
     * 
     * @return property pendingInstallUserCount
     */
    @Property(name="pendingInstallUserCount")
    @JsonIgnore
    public Optional<Integer> getPendingInstallUserCount() {
        return Optional.ofNullable(pendingInstallUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * pendingInstallUserCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of Users that have 1 or more device that have been notified to install
     * this app and have 0 devices with failures.”</i>
     * 
     * @param pendingInstallUserCount
     *            new value of {@code pendingInstallUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pendingInstallUserCount} field changed
     */
    public MobileAppInstallSummary withPendingInstallUserCount(Integer pendingInstallUserCount) {
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = changedFields.add("pendingInstallUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppInstallSummary");
        _x.pendingInstallUserCount = pendingInstallUserCount;
        return _x;
    }

    public MobileAppInstallSummary withUnmappedField(String name, Object value) {
        MobileAppInstallSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppInstallSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppInstallSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppInstallSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppInstallSummary _copy() {
        MobileAppInstallSummary _x = new MobileAppInstallSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.failedDeviceCount = failedDeviceCount;
        _x.failedUserCount = failedUserCount;
        _x.installedDeviceCount = installedDeviceCount;
        _x.installedUserCount = installedUserCount;
        _x.notApplicableDeviceCount = notApplicableDeviceCount;
        _x.notApplicableUserCount = notApplicableUserCount;
        _x.notInstalledDeviceCount = notInstalledDeviceCount;
        _x.notInstalledUserCount = notInstalledUserCount;
        _x.pendingInstallDeviceCount = pendingInstallDeviceCount;
        _x.pendingInstallUserCount = pendingInstallUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppInstallSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("failedDeviceCount=");
        b.append(this.failedDeviceCount);
        b.append(", ");
        b.append("failedUserCount=");
        b.append(this.failedUserCount);
        b.append(", ");
        b.append("installedDeviceCount=");
        b.append(this.installedDeviceCount);
        b.append(", ");
        b.append("installedUserCount=");
        b.append(this.installedUserCount);
        b.append(", ");
        b.append("notApplicableDeviceCount=");
        b.append(this.notApplicableDeviceCount);
        b.append(", ");
        b.append("notApplicableUserCount=");
        b.append(this.notApplicableUserCount);
        b.append(", ");
        b.append("notInstalledDeviceCount=");
        b.append(this.notInstalledDeviceCount);
        b.append(", ");
        b.append("notInstalledUserCount=");
        b.append(this.notInstalledUserCount);
        b.append(", ");
        b.append("pendingInstallDeviceCount=");
        b.append(this.pendingInstallDeviceCount);
        b.append(", ");
        b.append("pendingInstallUserCount=");
        b.append(this.pendingInstallUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
