package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.MobileAppDependencyType;
import odata.msgraph.client.beta.enums.MobileAppRelationshipType;


/**
 * <i>“Describes a dependency type between two mobile apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "dependencyType", 
    "dependentAppCount", 
    "dependsOnAppCount"})
@JsonInclude(Include.NON_NULL)
public class MobileAppDependency extends MobileAppRelationship implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mobileAppDependency";
    }

    @JsonProperty("dependencyType")
    protected MobileAppDependencyType dependencyType;

    @JsonProperty("dependentAppCount")
    protected Integer dependentAppCount;

    @JsonProperty("dependsOnAppCount")
    protected Integer dependsOnAppCount;

    protected MobileAppDependency() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileAppDependency() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String targetDisplayName;
        private String targetDisplayVersion;
        private String targetId;
        private String targetPublisher;
        private MobileAppRelationshipType targetType;
        private MobileAppDependencyType dependencyType;
        private Integer dependentAppCount;
        private Integer dependsOnAppCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder targetDisplayName(String targetDisplayName) {
            this.targetDisplayName = targetDisplayName;
            this.changedFields = changedFields.add("targetDisplayName");
            return this;
        }

        public Builder targetDisplayVersion(String targetDisplayVersion) {
            this.targetDisplayVersion = targetDisplayVersion;
            this.changedFields = changedFields.add("targetDisplayVersion");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.changedFields = changedFields.add("targetId");
            return this;
        }

        public Builder targetPublisher(String targetPublisher) {
            this.targetPublisher = targetPublisher;
            this.changedFields = changedFields.add("targetPublisher");
            return this;
        }

        public Builder targetType(MobileAppRelationshipType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        /**
         * <i>“The type of dependency relationship between the parent and child apps.”</i>
         * 
         * @param dependencyType
         *            value of {@code dependencyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependencyType(MobileAppDependencyType dependencyType) {
            this.dependencyType = dependencyType;
            this.changedFields = changedFields.add("dependencyType");
            return this;
        }

        /**
         * <i>“The total number of apps that directly or indirectly depend on the parent app.”</i>
         * 
         * @param dependentAppCount
         *            value of {@code dependentAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        /**
         * <i>“The total number of apps the child app directly or indirectly depends on.”</i>
         * 
         * @param dependsOnAppCount
         *            value of {@code dependsOnAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependsOnAppCount(Integer dependsOnAppCount) {
            this.dependsOnAppCount = dependsOnAppCount;
            this.changedFields = changedFields.add("dependsOnAppCount");
            return this;
        }

        public MobileAppDependency build() {
            MobileAppDependency _x = new MobileAppDependency();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mobileAppDependency";
            _x.id = id;
            _x.targetDisplayName = targetDisplayName;
            _x.targetDisplayVersion = targetDisplayVersion;
            _x.targetId = targetId;
            _x.targetPublisher = targetPublisher;
            _x.targetType = targetType;
            _x.dependencyType = dependencyType;
            _x.dependentAppCount = dependentAppCount;
            _x.dependsOnAppCount = dependsOnAppCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The type of dependency relationship between the parent and child apps.”</i>
     * 
     * @return property dependencyType
     */
    @Property(name="dependencyType")
    @JsonIgnore
    public Optional<MobileAppDependencyType> getDependencyType() {
        return Optional.ofNullable(dependencyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependencyType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The type of dependency relationship between the parent and child apps.”</i>
     * 
     * @param dependencyType
     *            new value of {@code dependencyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependencyType} field changed
     */
    public MobileAppDependency withDependencyType(MobileAppDependencyType dependencyType) {
        MobileAppDependency _x = _copy();
        _x.changedFields = changedFields.add("dependencyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppDependency");
        _x.dependencyType = dependencyType;
        return _x;
    }

    /**
     * <i>“The total number of apps that directly or indirectly depend on the parent app.”</i>
     * 
     * @return property dependentAppCount
     */
    @Property(name="dependentAppCount")
    @JsonIgnore
    public Optional<Integer> getDependentAppCount() {
        return Optional.ofNullable(dependentAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependentAppCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of apps that directly or indirectly depend on the parent app.”</i>
     * 
     * @param dependentAppCount
     *            new value of {@code dependentAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependentAppCount} field changed
     */
    public MobileAppDependency withDependentAppCount(Integer dependentAppCount) {
        MobileAppDependency _x = _copy();
        _x.changedFields = changedFields.add("dependentAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppDependency");
        _x.dependentAppCount = dependentAppCount;
        return _x;
    }

    /**
     * <i>“The total number of apps the child app directly or indirectly depends on.”</i>
     * 
     * @return property dependsOnAppCount
     */
    @Property(name="dependsOnAppCount")
    @JsonIgnore
    public Optional<Integer> getDependsOnAppCount() {
        return Optional.ofNullable(dependsOnAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependsOnAppCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of apps the child app directly or indirectly depends on.”</i>
     * 
     * @param dependsOnAppCount
     *            new value of {@code dependsOnAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependsOnAppCount} field changed
     */
    public MobileAppDependency withDependsOnAppCount(Integer dependsOnAppCount) {
        MobileAppDependency _x = _copy();
        _x.changedFields = changedFields.add("dependsOnAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mobileAppDependency");
        _x.dependsOnAppCount = dependsOnAppCount;
        return _x;
    }

    public MobileAppDependency withUnmappedField(String name, Object value) {
        MobileAppDependency _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppDependency patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MobileAppDependency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MobileAppDependency put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MobileAppDependency _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MobileAppDependency _copy() {
        MobileAppDependency _x = new MobileAppDependency();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.targetDisplayName = targetDisplayName;
        _x.targetDisplayVersion = targetDisplayVersion;
        _x.targetId = targetId;
        _x.targetPublisher = targetPublisher;
        _x.targetType = targetType;
        _x.dependencyType = dependencyType;
        _x.dependentAppCount = dependentAppCount;
        _x.dependsOnAppCount = dependsOnAppCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MobileAppDependency[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("targetDisplayName=");
        b.append(this.targetDisplayName);
        b.append(", ");
        b.append("targetDisplayVersion=");
        b.append(this.targetDisplayVersion);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("targetPublisher=");
        b.append(this.targetPublisher);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append(", ");
        b.append("dependencyType=");
        b.append(this.dependencyType);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("dependsOnAppCount=");
        b.append(this.dependsOnAppCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
