package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelServerCollectionRequest;
import odata.msgraph.client.beta.entity.request.MicrosoftTunnelConfigurationRequest;


/**
 * <i>“Entity that represents a Microsoft Tunnel site”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "internalNetworkProbeUrl", 
    "publicAddress", 
    "roleScopeTagIds", 
    "upgradeAutomatically", 
    "upgradeAvailable", 
    "upgradeWindowEndTime", 
    "upgradeWindowStartTime", 
    "upgradeWindowUtcOffsetInMinutes", 
    "microsoftTunnelConfiguration", 
    "microsoftTunnelServers"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftTunnelSite extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftTunnelSite";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("internalNetworkProbeUrl")
    protected String internalNetworkProbeUrl;

    @JsonProperty("publicAddress")
    protected String publicAddress;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("upgradeAutomatically")
    protected Boolean upgradeAutomatically;

    @JsonProperty("upgradeAvailable")
    protected Boolean upgradeAvailable;

    @JsonProperty("upgradeWindowEndTime")
    protected LocalTime upgradeWindowEndTime;

    @JsonProperty("upgradeWindowStartTime")
    protected LocalTime upgradeWindowStartTime;

    @JsonProperty("upgradeWindowUtcOffsetInMinutes")
    protected Integer upgradeWindowUtcOffsetInMinutes;

    @JsonProperty("microsoftTunnelConfiguration")
    protected MicrosoftTunnelConfiguration microsoftTunnelConfiguration;

    @JsonProperty("microsoftTunnelServers")
    protected List<MicrosoftTunnelServer> microsoftTunnelServers;

    protected MicrosoftTunnelSite() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftTunnelSite() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private String internalNetworkProbeUrl;
        private String publicAddress;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean upgradeAutomatically;
        private Boolean upgradeAvailable;
        private LocalTime upgradeWindowEndTime;
        private LocalTime upgradeWindowStartTime;
        private Integer upgradeWindowUtcOffsetInMinutes;
        private MicrosoftTunnelConfiguration microsoftTunnelConfiguration;
        private List<MicrosoftTunnelServer> microsoftTunnelServers;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelSite's description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelSite's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelSite's Internal Network Access Probe URL”</i>
         * 
         * @param internalNetworkProbeUrl
         *            value of {@code internalNetworkProbeUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder internalNetworkProbeUrl(String internalNetworkProbeUrl) {
            this.internalNetworkProbeUrl = internalNetworkProbeUrl;
            this.changedFields = changedFields.add("internalNetworkProbeUrl");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelSite's public domain name or IP address”</i>
         * 
         * @param publicAddress
         *            value of {@code publicAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publicAddress(String publicAddress) {
            this.publicAddress = publicAddress;
            this.changedFields = changedFields.add("publicAddress");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“The site's automatic upgrade setting. True for automatic upgrades, false for
         * manual control”</i>
         * 
         * @param upgradeAutomatically
         *            value of {@code upgradeAutomatically} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeAutomatically(Boolean upgradeAutomatically) {
            this.upgradeAutomatically = upgradeAutomatically;
            this.changedFields = changedFields.add("upgradeAutomatically");
            return this;
        }

        /**
         * <i>“True if an upgrade is available”</i>
         * 
         * @param upgradeAvailable
         *            value of {@code upgradeAvailable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeAvailable(Boolean upgradeAvailable) {
            this.upgradeAvailable = upgradeAvailable;
            this.changedFields = changedFields.add("upgradeAvailable");
            return this;
        }

        /**
         * <i>“The site's upgrade window end time of day”</i>
         * 
         * @param upgradeWindowEndTime
         *            value of {@code upgradeWindowEndTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeWindowEndTime(LocalTime upgradeWindowEndTime) {
            this.upgradeWindowEndTime = upgradeWindowEndTime;
            this.changedFields = changedFields.add("upgradeWindowEndTime");
            return this;
        }

        /**
         * <i>“The site's upgrade window start time of day”</i>
         * 
         * @param upgradeWindowStartTime
         *            value of {@code upgradeWindowStartTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeWindowStartTime(LocalTime upgradeWindowStartTime) {
            this.upgradeWindowStartTime = upgradeWindowStartTime;
            this.changedFields = changedFields.add("upgradeWindowStartTime");
            return this;
        }

        /**
         * <i>“The site's timezone represented as a minute offset from UTC”</i>
         * 
         * @param upgradeWindowUtcOffsetInMinutes
         *            value of {@code upgradeWindowUtcOffsetInMinutes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder upgradeWindowUtcOffsetInMinutes(Integer upgradeWindowUtcOffsetInMinutes) {
            this.upgradeWindowUtcOffsetInMinutes = upgradeWindowUtcOffsetInMinutes;
            this.changedFields = changedFields.add("upgradeWindowUtcOffsetInMinutes");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelConfiguration that has been applied to this
         * MicrosoftTunnelSite”</i>
         * 
         * @param microsoftTunnelConfiguration
         *            value of {@code microsoftTunnelConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelConfiguration(MicrosoftTunnelConfiguration microsoftTunnelConfiguration) {
            this.microsoftTunnelConfiguration = microsoftTunnelConfiguration;
            this.changedFields = changedFields.add("microsoftTunnelConfiguration");
            return this;
        }

        /**
         * <i>“A list of MicrosoftTunnelServers that are registered to this MicrosoftTunnelSite”</i>
         * 
         * @param microsoftTunnelServers
         *            value of {@code microsoftTunnelServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelServers(List<MicrosoftTunnelServer> microsoftTunnelServers) {
            this.microsoftTunnelServers = microsoftTunnelServers;
            this.changedFields = changedFields.add("microsoftTunnelServers");
            return this;
        }

        /**
         * <i>“A list of MicrosoftTunnelServers that are registered to this MicrosoftTunnelSite”</i>
         * 
         * @param microsoftTunnelServers
         *            value of {@code microsoftTunnelServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelServers(MicrosoftTunnelServer... microsoftTunnelServers) {
            return microsoftTunnelServers(Arrays.asList(microsoftTunnelServers));
        }

        public MicrosoftTunnelSite build() {
            MicrosoftTunnelSite _x = new MicrosoftTunnelSite();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftTunnelSite";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.internalNetworkProbeUrl = internalNetworkProbeUrl;
            _x.publicAddress = publicAddress;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.upgradeAutomatically = upgradeAutomatically;
            _x.upgradeAvailable = upgradeAvailable;
            _x.upgradeWindowEndTime = upgradeWindowEndTime;
            _x.upgradeWindowStartTime = upgradeWindowStartTime;
            _x.upgradeWindowUtcOffsetInMinutes = upgradeWindowUtcOffsetInMinutes;
            _x.microsoftTunnelConfiguration = microsoftTunnelConfiguration;
            _x.microsoftTunnelServers = microsoftTunnelServers;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The MicrosoftTunnelSite's description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MicrosoftTunnelSite's description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public MicrosoftTunnelSite withDescription(String description) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelSite's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MicrosoftTunnelSite's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MicrosoftTunnelSite withDisplayName(String displayName) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelSite's Internal Network Access Probe URL”</i>
     * 
     * @return property internalNetworkProbeUrl
     */
    @Property(name="internalNetworkProbeUrl")
    @JsonIgnore
    public Optional<String> getInternalNetworkProbeUrl() {
        return Optional.ofNullable(internalNetworkProbeUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * internalNetworkProbeUrl} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The MicrosoftTunnelSite's Internal Network Access Probe URL”</i>
     * 
     * @param internalNetworkProbeUrl
     *            new value of {@code internalNetworkProbeUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code internalNetworkProbeUrl} field changed
     */
    public MicrosoftTunnelSite withInternalNetworkProbeUrl(String internalNetworkProbeUrl) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("internalNetworkProbeUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.internalNetworkProbeUrl = internalNetworkProbeUrl;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelSite's public domain name or IP address”</i>
     * 
     * @return property publicAddress
     */
    @Property(name="publicAddress")
    @JsonIgnore
    public Optional<String> getPublicAddress() {
        return Optional.ofNullable(publicAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publicAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MicrosoftTunnelSite's public domain name or IP address”</i>
     * 
     * @param publicAddress
     *            new value of {@code publicAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publicAddress} field changed
     */
    public MicrosoftTunnelSite withPublicAddress(String publicAddress) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("publicAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.publicAddress = publicAddress;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public MicrosoftTunnelSite withRoleScopeTagIds(List<String> roleScopeTagIds) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The site's automatic upgrade setting. True for automatic upgrades, false for
     * manual control”</i>
     * 
     * @return property upgradeAutomatically
     */
    @Property(name="upgradeAutomatically")
    @JsonIgnore
    public Optional<Boolean> getUpgradeAutomatically() {
        return Optional.ofNullable(upgradeAutomatically);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * upgradeAutomatically} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The site's automatic upgrade setting. True for automatic upgrades, false for
     * manual control”</i>
     * 
     * @param upgradeAutomatically
     *            new value of {@code upgradeAutomatically} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeAutomatically} field changed
     */
    public MicrosoftTunnelSite withUpgradeAutomatically(Boolean upgradeAutomatically) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("upgradeAutomatically");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.upgradeAutomatically = upgradeAutomatically;
        return _x;
    }

    /**
     * <i>“True if an upgrade is available”</i>
     * 
     * @return property upgradeAvailable
     */
    @Property(name="upgradeAvailable")
    @JsonIgnore
    public Optional<Boolean> getUpgradeAvailable() {
        return Optional.ofNullable(upgradeAvailable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code upgradeAvailable}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“True if an upgrade is available”</i>
     * 
     * @param upgradeAvailable
     *            new value of {@code upgradeAvailable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeAvailable} field changed
     */
    public MicrosoftTunnelSite withUpgradeAvailable(Boolean upgradeAvailable) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("upgradeAvailable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.upgradeAvailable = upgradeAvailable;
        return _x;
    }

    /**
     * <i>“The site's upgrade window end time of day”</i>
     * 
     * @return property upgradeWindowEndTime
     */
    @Property(name="upgradeWindowEndTime")
    @JsonIgnore
    public Optional<LocalTime> getUpgradeWindowEndTime() {
        return Optional.ofNullable(upgradeWindowEndTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * upgradeWindowEndTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The site's upgrade window end time of day”</i>
     * 
     * @param upgradeWindowEndTime
     *            new value of {@code upgradeWindowEndTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeWindowEndTime} field changed
     */
    public MicrosoftTunnelSite withUpgradeWindowEndTime(LocalTime upgradeWindowEndTime) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("upgradeWindowEndTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.upgradeWindowEndTime = upgradeWindowEndTime;
        return _x;
    }

    /**
     * <i>“The site's upgrade window start time of day”</i>
     * 
     * @return property upgradeWindowStartTime
     */
    @Property(name="upgradeWindowStartTime")
    @JsonIgnore
    public Optional<LocalTime> getUpgradeWindowStartTime() {
        return Optional.ofNullable(upgradeWindowStartTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * upgradeWindowStartTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The site's upgrade window start time of day”</i>
     * 
     * @param upgradeWindowStartTime
     *            new value of {@code upgradeWindowStartTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeWindowStartTime} field changed
     */
    public MicrosoftTunnelSite withUpgradeWindowStartTime(LocalTime upgradeWindowStartTime) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("upgradeWindowStartTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.upgradeWindowStartTime = upgradeWindowStartTime;
        return _x;
    }

    /**
     * <i>“The site's timezone represented as a minute offset from UTC”</i>
     * 
     * @return property upgradeWindowUtcOffsetInMinutes
     */
    @Property(name="upgradeWindowUtcOffsetInMinutes")
    @JsonIgnore
    public Optional<Integer> getUpgradeWindowUtcOffsetInMinutes() {
        return Optional.ofNullable(upgradeWindowUtcOffsetInMinutes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * upgradeWindowUtcOffsetInMinutes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The site's timezone represented as a minute offset from UTC”</i>
     * 
     * @param upgradeWindowUtcOffsetInMinutes
     *            new value of {@code upgradeWindowUtcOffsetInMinutes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code upgradeWindowUtcOffsetInMinutes} field changed
     */
    public MicrosoftTunnelSite withUpgradeWindowUtcOffsetInMinutes(Integer upgradeWindowUtcOffsetInMinutes) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("upgradeWindowUtcOffsetInMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.upgradeWindowUtcOffsetInMinutes = upgradeWindowUtcOffsetInMinutes;
        return _x;
    }

    public MicrosoftTunnelSite withUnmappedField(String name, Object value) {
        MicrosoftTunnelSite _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelConfiguration that has been applied to this
     * MicrosoftTunnelSite”</i>
     * 
     * @return navigational property microsoftTunnelConfiguration
     */
    @NavigationProperty(name="microsoftTunnelConfiguration")
    @JsonIgnore
    public MicrosoftTunnelConfigurationRequest getMicrosoftTunnelConfiguration() {
        return new MicrosoftTunnelConfigurationRequest(contextPath.addSegment("microsoftTunnelConfiguration"), Optional.ofNullable(microsoftTunnelConfiguration));
    }

    /**
     * <i>“A list of MicrosoftTunnelServers that are registered to this MicrosoftTunnelSite”</i>
     * 
     * @return navigational property microsoftTunnelServers
     */
    @NavigationProperty(name="microsoftTunnelServers")
    @JsonIgnore
    public MicrosoftTunnelServerCollectionRequest getMicrosoftTunnelServers() {
        return new MicrosoftTunnelServerCollectionRequest(
                        contextPath.addSegment("microsoftTunnelServers"), Optional.ofNullable(microsoftTunnelServers));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelConfiguration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The MicrosoftTunnelConfiguration that has been applied to this
     * MicrosoftTunnelSite”</i>
     * 
     * @param microsoftTunnelConfiguration
     *            new value of {@code microsoftTunnelConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelConfiguration} field changed
     */
    public MicrosoftTunnelSite withMicrosoftTunnelConfiguration(MicrosoftTunnelConfiguration microsoftTunnelConfiguration) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.microsoftTunnelConfiguration = microsoftTunnelConfiguration;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelServers} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A list of MicrosoftTunnelServers that are registered to this MicrosoftTunnelSite”</i>
     * 
     * @param microsoftTunnelServers
     *            new value of {@code microsoftTunnelServers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelServers} field changed
     */
    public MicrosoftTunnelSite withMicrosoftTunnelServers(List<MicrosoftTunnelServer> microsoftTunnelServers) {
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelServers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelSite");
        _x.microsoftTunnelServers = microsoftTunnelServers;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelSite patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelSite put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelSite _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftTunnelSite _copy() {
        MicrosoftTunnelSite _x = new MicrosoftTunnelSite();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.internalNetworkProbeUrl = internalNetworkProbeUrl;
        _x.publicAddress = publicAddress;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.upgradeAutomatically = upgradeAutomatically;
        _x.upgradeAvailable = upgradeAvailable;
        _x.upgradeWindowEndTime = upgradeWindowEndTime;
        _x.upgradeWindowStartTime = upgradeWindowStartTime;
        _x.upgradeWindowUtcOffsetInMinutes = upgradeWindowUtcOffsetInMinutes;
        _x.microsoftTunnelConfiguration = microsoftTunnelConfiguration;
        _x.microsoftTunnelServers = microsoftTunnelServers;
        return _x;
    }

    @Action(name = "requestUpgrade")
    @JsonIgnore
    public ActionRequestNoReturn requestUpgrade() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestUpgrade"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftTunnelSite[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("internalNetworkProbeUrl=");
        b.append(this.internalNetworkProbeUrl);
        b.append(", ");
        b.append("publicAddress=");
        b.append(this.publicAddress);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("upgradeAutomatically=");
        b.append(this.upgradeAutomatically);
        b.append(", ");
        b.append("upgradeAvailable=");
        b.append(this.upgradeAvailable);
        b.append(", ");
        b.append("upgradeWindowEndTime=");
        b.append(this.upgradeWindowEndTime);
        b.append(", ");
        b.append("upgradeWindowStartTime=");
        b.append(this.upgradeWindowStartTime);
        b.append(", ");
        b.append("upgradeWindowUtcOffsetInMinutes=");
        b.append(this.upgradeWindowUtcOffsetInMinutes);
        b.append(", ");
        b.append("microsoftTunnelConfiguration=");
        b.append(this.microsoftTunnelConfiguration);
        b.append(", ");
        b.append("microsoftTunnelServers=");
        b.append(this.microsoftTunnelServers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
