package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyLongValuePair;
import odata.msgraph.client.beta.complex.MetricTimeSeriesDataPoint;
import odata.msgraph.client.beta.enums.MicrosoftTunnelServerHealthStatus;


/**
 * <i>“Entity that represents a single Microsoft Tunnel server”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "agentImageDigest", 
    "displayName", 
    "lastCheckinDateTime", 
    "serverImageDigest", 
    "tunnelServerHealthStatus"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftTunnelServer extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftTunnelServer";
    }

    @JsonProperty("agentImageDigest")
    protected String agentImageDigest;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastCheckinDateTime")
    protected OffsetDateTime lastCheckinDateTime;

    @JsonProperty("serverImageDigest")
    protected String serverImageDigest;

    @JsonProperty("tunnelServerHealthStatus")
    protected MicrosoftTunnelServerHealthStatus tunnelServerHealthStatus;

    protected MicrosoftTunnelServer() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftTunnelServer() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String agentImageDigest;
        private String displayName;
        private OffsetDateTime lastCheckinDateTime;
        private String serverImageDigest;
        private MicrosoftTunnelServerHealthStatus tunnelServerHealthStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The digest of the current agent image running on this server”</i>
         * 
         * @param agentImageDigest
         *            value of {@code agentImageDigest} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder agentImageDigest(String agentImageDigest) {
            this.agentImageDigest = agentImageDigest;
            this.changedFields = changedFields.add("agentImageDigest");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelServer's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“When the MicrosoftTunnelServer last checked in”</i>
         * 
         * @param lastCheckinDateTime
         *            value of {@code lastCheckinDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCheckinDateTime(OffsetDateTime lastCheckinDateTime) {
            this.lastCheckinDateTime = lastCheckinDateTime;
            this.changedFields = changedFields.add("lastCheckinDateTime");
            return this;
        }

        /**
         * <i>“The digest of the current server image running on this server”</i>
         * 
         * @param serverImageDigest
         *            value of {@code serverImageDigest} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serverImageDigest(String serverImageDigest) {
            this.serverImageDigest = serverImageDigest;
            this.changedFields = changedFields.add("serverImageDigest");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelServer's health status”</i>
         * 
         * @param tunnelServerHealthStatus
         *            value of {@code tunnelServerHealthStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tunnelServerHealthStatus(MicrosoftTunnelServerHealthStatus tunnelServerHealthStatus) {
            this.tunnelServerHealthStatus = tunnelServerHealthStatus;
            this.changedFields = changedFields.add("tunnelServerHealthStatus");
            return this;
        }

        public MicrosoftTunnelServer build() {
            MicrosoftTunnelServer _x = new MicrosoftTunnelServer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftTunnelServer";
            _x.id = id;
            _x.agentImageDigest = agentImageDigest;
            _x.displayName = displayName;
            _x.lastCheckinDateTime = lastCheckinDateTime;
            _x.serverImageDigest = serverImageDigest;
            _x.tunnelServerHealthStatus = tunnelServerHealthStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The digest of the current agent image running on this server”</i>
     * 
     * @return property agentImageDigest
     */
    @Property(name="agentImageDigest")
    @JsonIgnore
    public Optional<String> getAgentImageDigest() {
        return Optional.ofNullable(agentImageDigest);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code agentImageDigest}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The digest of the current agent image running on this server”</i>
     * 
     * @param agentImageDigest
     *            new value of {@code agentImageDigest} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code agentImageDigest} field changed
     */
    public MicrosoftTunnelServer withAgentImageDigest(String agentImageDigest) {
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = changedFields.add("agentImageDigest");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServer");
        _x.agentImageDigest = agentImageDigest;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelServer's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MicrosoftTunnelServer's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MicrosoftTunnelServer withDisplayName(String displayName) {
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServer");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“When the MicrosoftTunnelServer last checked in”</i>
     * 
     * @return property lastCheckinDateTime
     */
    @Property(name="lastCheckinDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckinDateTime() {
        return Optional.ofNullable(lastCheckinDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCheckinDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“When the MicrosoftTunnelServer last checked in”</i>
     * 
     * @param lastCheckinDateTime
     *            new value of {@code lastCheckinDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCheckinDateTime} field changed
     */
    public MicrosoftTunnelServer withLastCheckinDateTime(OffsetDateTime lastCheckinDateTime) {
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = changedFields.add("lastCheckinDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServer");
        _x.lastCheckinDateTime = lastCheckinDateTime;
        return _x;
    }

    /**
     * <i>“The digest of the current server image running on this server”</i>
     * 
     * @return property serverImageDigest
     */
    @Property(name="serverImageDigest")
    @JsonIgnore
    public Optional<String> getServerImageDigest() {
        return Optional.ofNullable(serverImageDigest);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serverImageDigest
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The digest of the current server image running on this server”</i>
     * 
     * @param serverImageDigest
     *            new value of {@code serverImageDigest} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serverImageDigest} field changed
     */
    public MicrosoftTunnelServer withServerImageDigest(String serverImageDigest) {
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = changedFields.add("serverImageDigest");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServer");
        _x.serverImageDigest = serverImageDigest;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelServer's health status”</i>
     * 
     * @return property tunnelServerHealthStatus
     */
    @Property(name="tunnelServerHealthStatus")
    @JsonIgnore
    public Optional<MicrosoftTunnelServerHealthStatus> getTunnelServerHealthStatus() {
        return Optional.ofNullable(tunnelServerHealthStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tunnelServerHealthStatus} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The MicrosoftTunnelServer's health status”</i>
     * 
     * @param tunnelServerHealthStatus
     *            new value of {@code tunnelServerHealthStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tunnelServerHealthStatus} field changed
     */
    public MicrosoftTunnelServer withTunnelServerHealthStatus(MicrosoftTunnelServerHealthStatus tunnelServerHealthStatus) {
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = changedFields.add("tunnelServerHealthStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelServer");
        _x.tunnelServerHealthStatus = tunnelServerHealthStatus;
        return _x;
    }

    public MicrosoftTunnelServer withUnmappedField(String name, Object value) {
        MicrosoftTunnelServer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelServer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelServer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelServer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftTunnelServer _copy() {
        MicrosoftTunnelServer _x = new MicrosoftTunnelServer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.agentImageDigest = agentImageDigest;
        _x.displayName = displayName;
        _x.lastCheckinDateTime = lastCheckinDateTime;
        _x.serverImageDigest = serverImageDigest;
        _x.tunnelServerHealthStatus = tunnelServerHealthStatus;
        return _x;
    }

    @Action(name = "createServerLogCollectionRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MicrosoftTunnelServerLogCollectionResponse> createServerLogCollectionRequest(OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MicrosoftTunnelServerLogCollectionResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createServerLogCollectionRequest"), MicrosoftTunnelServerLogCollectionResponse.class, _parameters);
    }

    @Action(name = "getHealthMetrics")
    @JsonIgnore
    public CollectionPageNonEntityRequest<KeyLongValuePair> getHealthMetrics(List<String> metricNames) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("metricNames", "Collection(Edm.String)", Checks.checkIsAscii(metricNames))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetrics"), KeyLongValuePair.class, _parameters);
    }

    @Action(name = "getHealthMetricTimeSeries")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MetricTimeSeriesDataPoint> getHealthMetricTimeSeries(String metricName, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("metricName", "Edm.String", Checks.checkIsAscii(metricName))
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetricTimeSeries"), MetricTimeSeriesDataPoint.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftTunnelServer[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("agentImageDigest=");
        b.append(this.agentImageDigest);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastCheckinDateTime=");
        b.append(this.lastCheckinDateTime);
        b.append(", ");
        b.append("serverImageDigest=");
        b.append(this.serverImageDigest);
        b.append(", ");
        b.append("tunnelServerHealthStatus=");
        b.append(this.tunnelServerHealthStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
