package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;


/**
 * <i>“Entity that represents a collection of Microsoft Tunnel settings”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "advancedSettings", 
    "defaultDomainSuffix", 
    "description", 
    "disableUdpConnections", 
    "displayName", 
    "dnsServers", 
    "lastUpdateDateTime", 
    "listenPort", 
    "network", 
    "roleScopeTagIds", 
    "routesExclude", 
    "routesInclude", 
    "splitDNS"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftTunnelConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftTunnelConfiguration";
    }

    @JsonProperty("advancedSettings")
    protected List<KeyValuePair> advancedSettings;

    @JsonProperty("advancedSettings@nextLink")
    protected String advancedSettingsNextLink;

    @JsonProperty("defaultDomainSuffix")
    protected String defaultDomainSuffix;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("disableUdpConnections")
    protected Boolean disableUdpConnections;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("dnsServers")
    protected List<String> dnsServers;

    @JsonProperty("dnsServers@nextLink")
    protected String dnsServersNextLink;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    @JsonProperty("listenPort")
    protected Integer listenPort;

    @JsonProperty("network")
    protected String network;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("routesExclude")
    protected List<String> routesExclude;

    @JsonProperty("routesExclude@nextLink")
    protected String routesExcludeNextLink;

    @JsonProperty("routesInclude")
    protected List<String> routesInclude;

    @JsonProperty("routesInclude@nextLink")
    protected String routesIncludeNextLink;

    @JsonProperty("splitDNS")
    protected List<String> splitDNS;

    @JsonProperty("splitDNS@nextLink")
    protected String splitDNSNextLink;

    protected MicrosoftTunnelConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftTunnelConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<KeyValuePair> advancedSettings;
        private String advancedSettingsNextLink;
        private String defaultDomainSuffix;
        private String description;
        private Boolean disableUdpConnections;
        private String displayName;
        private List<String> dnsServers;
        private String dnsServersNextLink;
        private OffsetDateTime lastUpdateDateTime;
        private Integer listenPort;
        private String network;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<String> routesExclude;
        private String routesExcludeNextLink;
        private List<String> routesInclude;
        private String routesIncludeNextLink;
        private List<String> splitDNS;
        private String splitDNSNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Additional settings that may be applied to the server”</i>
         * 
         * @param advancedSettings
         *            value of {@code advancedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedSettings(List<KeyValuePair> advancedSettings) {
            this.advancedSettings = advancedSettings;
            this.changedFields = changedFields.add("advancedSettings");
            return this;
        }

        /**
         * <i>“Additional settings that may be applied to the server”</i>
         * 
         * @param advancedSettings
         *            value of {@code advancedSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedSettings(KeyValuePair... advancedSettings) {
            return advancedSettings(Arrays.asList(advancedSettings));
        }

        /**
         * <i>“Additional settings that may be applied to the server”</i>
         * 
         * @param advancedSettingsNextLink
         *            value of {@code advancedSettings@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedSettingsNextLink(String advancedSettingsNextLink) {
            this.advancedSettingsNextLink = advancedSettingsNextLink;
            this.changedFields = changedFields.add("advancedSettings");
            return this;
        }

        /**
         * <i>“The Default Domain appendix that will be used by the clients”</i>
         * 
         * @param defaultDomainSuffix
         *            value of {@code defaultDomainSuffix} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultDomainSuffix(String defaultDomainSuffix) {
            this.defaultDomainSuffix = defaultDomainSuffix;
            this.changedFields = changedFields.add("defaultDomainSuffix");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelConfiguration's description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“When DisableUdpConnections is set, the clients and VPN server will not use DTLS
         * connections to tansfer data.”</i>
         * 
         * @param disableUdpConnections
         *            value of {@code disableUdpConnections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableUdpConnections(Boolean disableUdpConnections) {
            this.disableUdpConnections = disableUdpConnections;
            this.changedFields = changedFields.add("disableUdpConnections");
            return this;
        }

        /**
         * <i>“The MicrosoftTunnelConfiguration's display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The DNS servers that will be used by the clients”</i>
         * 
         * @param dnsServers
         *            value of {@code dnsServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsServers(List<String> dnsServers) {
            this.dnsServers = dnsServers;
            this.changedFields = changedFields.add("dnsServers");
            return this;
        }

        /**
         * <i>“The DNS servers that will be used by the clients”</i>
         * 
         * @param dnsServers
         *            value of {@code dnsServers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsServers(String... dnsServers) {
            return dnsServers(Arrays.asList(dnsServers));
        }

        /**
         * <i>“The DNS servers that will be used by the clients”</i>
         * 
         * @param dnsServersNextLink
         *            value of {@code dnsServers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dnsServersNextLink(String dnsServersNextLink) {
            this.dnsServersNextLink = dnsServersNextLink;
            this.changedFields = changedFields.add("dnsServers");
            return this;
        }

        /**
         * <i>“When the MicrosoftTunnelConfiguration was last updated”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        /**
         * <i>“The port that both TCP and UPD will listen over on the server”</i>
         * 
         * @param listenPort
         *            value of {@code listenPort} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder listenPort(Integer listenPort) {
            this.listenPort = listenPort;
            this.changedFields = changedFields.add("listenPort");
            return this;
        }

        /**
         * <i>“The subnet that will be used to allocate virtual address for the clients”</i>
         * 
         * @param network
         *            value of {@code network} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder network(String network) {
            this.network = network;
            this.changedFields = changedFields.add("network");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Subsets of the routes that will not be routed by the server”</i>
         * 
         * @param routesExclude
         *            value of {@code routesExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesExclude(List<String> routesExclude) {
            this.routesExclude = routesExclude;
            this.changedFields = changedFields.add("routesExclude");
            return this;
        }

        /**
         * <i>“Subsets of the routes that will not be routed by the server”</i>
         * 
         * @param routesExclude
         *            value of {@code routesExclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesExclude(String... routesExclude) {
            return routesExclude(Arrays.asList(routesExclude));
        }

        /**
         * <i>“Subsets of the routes that will not be routed by the server”</i>
         * 
         * @param routesExcludeNextLink
         *            value of {@code routesExclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesExcludeNextLink(String routesExcludeNextLink) {
            this.routesExcludeNextLink = routesExcludeNextLink;
            this.changedFields = changedFields.add("routesExclude");
            return this;
        }

        /**
         * <i>“The routs that will be routed by the server”</i>
         * 
         * @param routesInclude
         *            value of {@code routesInclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesInclude(List<String> routesInclude) {
            this.routesInclude = routesInclude;
            this.changedFields = changedFields.add("routesInclude");
            return this;
        }

        /**
         * <i>“The routs that will be routed by the server”</i>
         * 
         * @param routesInclude
         *            value of {@code routesInclude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesInclude(String... routesInclude) {
            return routesInclude(Arrays.asList(routesInclude));
        }

        /**
         * <i>“The routs that will be routed by the server”</i>
         * 
         * @param routesIncludeNextLink
         *            value of {@code routesInclude@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder routesIncludeNextLink(String routesIncludeNextLink) {
            this.routesIncludeNextLink = routesIncludeNextLink;
            this.changedFields = changedFields.add("routesInclude");
            return this;
        }

        /**
         * <i>“The domains that will be resolved using the provided dns servers”</i>
         * 
         * @param splitDNS
         *            value of {@code splitDNS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder splitDNS(List<String> splitDNS) {
            this.splitDNS = splitDNS;
            this.changedFields = changedFields.add("splitDNS");
            return this;
        }

        /**
         * <i>“The domains that will be resolved using the provided dns servers”</i>
         * 
         * @param splitDNS
         *            value of {@code splitDNS} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder splitDNS(String... splitDNS) {
            return splitDNS(Arrays.asList(splitDNS));
        }

        /**
         * <i>“The domains that will be resolved using the provided dns servers”</i>
         * 
         * @param splitDNSNextLink
         *            value of {@code splitDNS@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder splitDNSNextLink(String splitDNSNextLink) {
            this.splitDNSNextLink = splitDNSNextLink;
            this.changedFields = changedFields.add("splitDNS");
            return this;
        }

        public MicrosoftTunnelConfiguration build() {
            MicrosoftTunnelConfiguration _x = new MicrosoftTunnelConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftTunnelConfiguration";
            _x.id = id;
            _x.advancedSettings = advancedSettings;
            _x.advancedSettingsNextLink = advancedSettingsNextLink;
            _x.defaultDomainSuffix = defaultDomainSuffix;
            _x.description = description;
            _x.disableUdpConnections = disableUdpConnections;
            _x.displayName = displayName;
            _x.dnsServers = dnsServers;
            _x.dnsServersNextLink = dnsServersNextLink;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            _x.listenPort = listenPort;
            _x.network = network;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.routesExclude = routesExclude;
            _x.routesExcludeNextLink = routesExcludeNextLink;
            _x.routesInclude = routesInclude;
            _x.routesIncludeNextLink = routesIncludeNextLink;
            _x.splitDNS = splitDNS;
            _x.splitDNSNextLink = splitDNSNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Additional settings that may be applied to the server”</i>
     * 
     * @return property advancedSettings
     */
    @Property(name="advancedSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAdvancedSettings() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.advancedSettings, Optional.ofNullable(advancedSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code advancedSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Additional settings that may be applied to the server”</i>
     * 
     * @param advancedSettings
     *            new value of {@code advancedSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedSettings} field changed
     */
    public MicrosoftTunnelConfiguration withAdvancedSettings(List<KeyValuePair> advancedSettings) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("advancedSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.advancedSettings = advancedSettings;
        return _x;
    }

    /**
     * <i>“Additional settings that may be applied to the server”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property advancedSettings
     */
    @Property(name="advancedSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getAdvancedSettings(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.advancedSettings, Optional.ofNullable(advancedSettingsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The Default Domain appendix that will be used by the clients”</i>
     * 
     * @return property defaultDomainSuffix
     */
    @Property(name="defaultDomainSuffix")
    @JsonIgnore
    public Optional<String> getDefaultDomainSuffix() {
        return Optional.ofNullable(defaultDomainSuffix);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultDomainSuffix} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Default Domain appendix that will be used by the clients”</i>
     * 
     * @param defaultDomainSuffix
     *            new value of {@code defaultDomainSuffix} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultDomainSuffix} field changed
     */
    public MicrosoftTunnelConfiguration withDefaultDomainSuffix(String defaultDomainSuffix) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("defaultDomainSuffix");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.defaultDomainSuffix = defaultDomainSuffix;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelConfiguration's description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MicrosoftTunnelConfiguration's description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public MicrosoftTunnelConfiguration withDescription(String description) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“When DisableUdpConnections is set, the clients and VPN server will not use DTLS
     * connections to tansfer data.”</i>
     * 
     * @return property disableUdpConnections
     */
    @Property(name="disableUdpConnections")
    @JsonIgnore
    public Optional<Boolean> getDisableUdpConnections() {
        return Optional.ofNullable(disableUdpConnections);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableUdpConnections} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“When DisableUdpConnections is set, the clients and VPN server will not use DTLS
     * connections to tansfer data.”</i>
     * 
     * @param disableUdpConnections
     *            new value of {@code disableUdpConnections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableUdpConnections} field changed
     */
    public MicrosoftTunnelConfiguration withDisableUdpConnections(Boolean disableUdpConnections) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableUdpConnections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.disableUdpConnections = disableUdpConnections;
        return _x;
    }

    /**
     * <i>“The MicrosoftTunnelConfiguration's display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The MicrosoftTunnelConfiguration's display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public MicrosoftTunnelConfiguration withDisplayName(String displayName) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The DNS servers that will be used by the clients”</i>
     * 
     * @return property dnsServers
     */
    @Property(name="dnsServers")
    @JsonIgnore
    public CollectionPage<String> getDnsServers() {
        return new CollectionPage<String>(contextPath, String.class, this.dnsServers, Optional.ofNullable(dnsServersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dnsServers} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The DNS servers that will be used by the clients”</i>
     * 
     * @param dnsServers
     *            new value of {@code dnsServers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dnsServers} field changed
     */
    public MicrosoftTunnelConfiguration withDnsServers(List<String> dnsServers) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dnsServers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.dnsServers = dnsServers;
        return _x;
    }

    /**
     * <i>“The DNS servers that will be used by the clients”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dnsServers
     */
    @Property(name="dnsServers")
    @JsonIgnore
    public CollectionPage<String> getDnsServers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.dnsServers, Optional.ofNullable(dnsServersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“When the MicrosoftTunnelConfiguration was last updated”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“When the MicrosoftTunnelConfiguration was last updated”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public MicrosoftTunnelConfiguration withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    /**
     * <i>“The port that both TCP and UPD will listen over on the server”</i>
     * 
     * @return property listenPort
     */
    @Property(name="listenPort")
    @JsonIgnore
    public Optional<Integer> getListenPort() {
        return Optional.ofNullable(listenPort);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code listenPort} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The port that both TCP and UPD will listen over on the server”</i>
     * 
     * @param listenPort
     *            new value of {@code listenPort} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code listenPort} field changed
     */
    public MicrosoftTunnelConfiguration withListenPort(Integer listenPort) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("listenPort");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.listenPort = listenPort;
        return _x;
    }

    /**
     * <i>“The subnet that will be used to allocate virtual address for the clients”</i>
     * 
     * @return property network
     */
    @Property(name="network")
    @JsonIgnore
    public Optional<String> getNetwork() {
        return Optional.ofNullable(network);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code network} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The subnet that will be used to allocate virtual address for the clients”</i>
     * 
     * @param network
     *            new value of {@code network} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code network} field changed
     */
    public MicrosoftTunnelConfiguration withNetwork(String network) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("network");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.network = network;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public MicrosoftTunnelConfiguration withRoleScopeTagIds(List<String> roleScopeTagIds) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Subsets of the routes that will not be routed by the server”</i>
     * 
     * @return property routesExclude
     */
    @Property(name="routesExclude")
    @JsonIgnore
    public CollectionPage<String> getRoutesExclude() {
        return new CollectionPage<String>(contextPath, String.class, this.routesExclude, Optional.ofNullable(routesExcludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code routesExclude}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Subsets of the routes that will not be routed by the server”</i>
     * 
     * @param routesExclude
     *            new value of {@code routesExclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code routesExclude} field changed
     */
    public MicrosoftTunnelConfiguration withRoutesExclude(List<String> routesExclude) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("routesExclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.routesExclude = routesExclude;
        return _x;
    }

    /**
     * <i>“Subsets of the routes that will not be routed by the server”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property routesExclude
     */
    @Property(name="routesExclude")
    @JsonIgnore
    public CollectionPage<String> getRoutesExclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.routesExclude, Optional.ofNullable(routesExcludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The routs that will be routed by the server”</i>
     * 
     * @return property routesInclude
     */
    @Property(name="routesInclude")
    @JsonIgnore
    public CollectionPage<String> getRoutesInclude() {
        return new CollectionPage<String>(contextPath, String.class, this.routesInclude, Optional.ofNullable(routesIncludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code routesInclude}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The routs that will be routed by the server”</i>
     * 
     * @param routesInclude
     *            new value of {@code routesInclude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code routesInclude} field changed
     */
    public MicrosoftTunnelConfiguration withRoutesInclude(List<String> routesInclude) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("routesInclude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.routesInclude = routesInclude;
        return _x;
    }

    /**
     * <i>“The routs that will be routed by the server”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property routesInclude
     */
    @Property(name="routesInclude")
    @JsonIgnore
    public CollectionPage<String> getRoutesInclude(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.routesInclude, Optional.ofNullable(routesIncludeNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The domains that will be resolved using the provided dns servers”</i>
     * 
     * @return property splitDNS
     */
    @Property(name="splitDNS")
    @JsonIgnore
    public CollectionPage<String> getSplitDNS() {
        return new CollectionPage<String>(contextPath, String.class, this.splitDNS, Optional.ofNullable(splitDNSNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code splitDNS} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The domains that will be resolved using the provided dns servers”</i>
     * 
     * @param splitDNS
     *            new value of {@code splitDNS} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code splitDNS} field changed
     */
    public MicrosoftTunnelConfiguration withSplitDNS(List<String> splitDNS) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = changedFields.add("splitDNS");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftTunnelConfiguration");
        _x.splitDNS = splitDNS;
        return _x;
    }

    /**
     * <i>“The domains that will be resolved using the provided dns servers”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property splitDNS
     */
    @Property(name="splitDNS")
    @JsonIgnore
    public CollectionPage<String> getSplitDNS(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.splitDNS, Optional.ofNullable(splitDNSNextLink), Collections.emptyList(), options);
    }

    public MicrosoftTunnelConfiguration withUnmappedField(String name, Object value) {
        MicrosoftTunnelConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftTunnelConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftTunnelConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftTunnelConfiguration _copy() {
        MicrosoftTunnelConfiguration _x = new MicrosoftTunnelConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.advancedSettings = advancedSettings;
        _x.defaultDomainSuffix = defaultDomainSuffix;
        _x.description = description;
        _x.disableUdpConnections = disableUdpConnections;
        _x.displayName = displayName;
        _x.dnsServers = dnsServers;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        _x.listenPort = listenPort;
        _x.network = network;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.routesExclude = routesExclude;
        _x.routesInclude = routesInclude;
        _x.splitDNS = splitDNS;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftTunnelConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("advancedSettings=");
        b.append(this.advancedSettings);
        b.append(", ");
        b.append("defaultDomainSuffix=");
        b.append(this.defaultDomainSuffix);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("disableUdpConnections=");
        b.append(this.disableUdpConnections);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dnsServers=");
        b.append(this.dnsServers);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append(", ");
        b.append("listenPort=");
        b.append(this.listenPort);
        b.append(", ");
        b.append("network=");
        b.append(this.network);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("routesExclude=");
        b.append(this.routesExclude);
        b.append(", ");
        b.append("routesInclude=");
        b.append(this.routesInclude);
        b.append(", ");
        b.append("splitDNS=");
        b.append(this.splitDNS);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
