package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“A class that represents a contained app of a MicrosoftStoreForBusinessApp.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appUserModelId"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftStoreForBusinessContainedApp extends MobileContainedApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftStoreForBusinessContainedApp";
    }

    @JsonProperty("appUserModelId")
    protected String appUserModelId;

    protected MicrosoftStoreForBusinessContainedApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftStoreForBusinessContainedApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appUserModelId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The app user model ID of the contained app of a MicrosoftStoreForBusinessApp.”</i>
         * 
         * @param appUserModelId
         *            value of {@code appUserModelId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appUserModelId(String appUserModelId) {
            this.appUserModelId = appUserModelId;
            this.changedFields = changedFields.add("appUserModelId");
            return this;
        }

        public MicrosoftStoreForBusinessContainedApp build() {
            MicrosoftStoreForBusinessContainedApp _x = new MicrosoftStoreForBusinessContainedApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftStoreForBusinessContainedApp";
            _x.id = id;
            _x.appUserModelId = appUserModelId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The app user model ID of the contained app of a MicrosoftStoreForBusinessApp.”</i>
     * 
     * @return property appUserModelId
     */
    @Property(name="appUserModelId")
    @JsonIgnore
    public Optional<String> getAppUserModelId() {
        return Optional.ofNullable(appUserModelId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appUserModelId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app user model ID of the contained app of a MicrosoftStoreForBusinessApp.”</i>
     * 
     * @param appUserModelId
     *            new value of {@code appUserModelId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appUserModelId} field changed
     */
    public MicrosoftStoreForBusinessContainedApp withAppUserModelId(String appUserModelId) {
        MicrosoftStoreForBusinessContainedApp _x = _copy();
        _x.changedFields = changedFields.add("appUserModelId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftStoreForBusinessContainedApp");
        _x.appUserModelId = appUserModelId;
        return _x;
    }

    public MicrosoftStoreForBusinessContainedApp withUnmappedField(String name, Object value) {
        MicrosoftStoreForBusinessContainedApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftStoreForBusinessContainedApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftStoreForBusinessContainedApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftStoreForBusinessContainedApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftStoreForBusinessContainedApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftStoreForBusinessContainedApp _copy() {
        MicrosoftStoreForBusinessContainedApp _x = new MicrosoftStoreForBusinessContainedApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appUserModelId = appUserModelId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftStoreForBusinessContainedApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appUserModelId=");
        b.append(this.appUserModelId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
