package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AdvancedConfigState;
import odata.msgraph.client.beta.enums.AuthenticationMethodTargetType;
import odata.msgraph.client.beta.enums.MicrosoftAuthenticatorAuthenticationMode;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMode", 
    "displayAppInformationRequiredState", 
    "numberMatchingRequiredState"})
@JsonInclude(Include.NON_NULL)
public class MicrosoftAuthenticatorAuthenticationMethodTarget extends AuthenticationMethodTarget implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget";
    }

    @JsonProperty("authenticationMode")
    protected MicrosoftAuthenticatorAuthenticationMode authenticationMode;

    @JsonProperty("displayAppInformationRequiredState")
    protected AdvancedConfigState displayAppInformationRequiredState;

    @JsonProperty("numberMatchingRequiredState")
    protected AdvancedConfigState numberMatchingRequiredState;

    protected MicrosoftAuthenticatorAuthenticationMethodTarget() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMicrosoftAuthenticatorAuthenticationMethodTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isRegistrationRequired;
        private AuthenticationMethodTargetType targetType;
        private MicrosoftAuthenticatorAuthenticationMode authenticationMode;
        private AdvancedConfigState displayAppInformationRequiredState;
        private AdvancedConfigState numberMatchingRequiredState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isRegistrationRequired(Boolean isRegistrationRequired) {
            this.isRegistrationRequired = isRegistrationRequired;
            this.changedFields = changedFields.add("isRegistrationRequired");
            return this;
        }

        public Builder targetType(AuthenticationMethodTargetType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        public Builder authenticationMode(MicrosoftAuthenticatorAuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            this.changedFields = changedFields.add("authenticationMode");
            return this;
        }

        public Builder displayAppInformationRequiredState(AdvancedConfigState displayAppInformationRequiredState) {
            this.displayAppInformationRequiredState = displayAppInformationRequiredState;
            this.changedFields = changedFields.add("displayAppInformationRequiredState");
            return this;
        }

        public Builder numberMatchingRequiredState(AdvancedConfigState numberMatchingRequiredState) {
            this.numberMatchingRequiredState = numberMatchingRequiredState;
            this.changedFields = changedFields.add("numberMatchingRequiredState");
            return this;
        }

        public MicrosoftAuthenticatorAuthenticationMethodTarget build() {
            MicrosoftAuthenticatorAuthenticationMethodTarget _x = new MicrosoftAuthenticatorAuthenticationMethodTarget();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget";
            _x.id = id;
            _x.isRegistrationRequired = isRegistrationRequired;
            _x.targetType = targetType;
            _x.authenticationMode = authenticationMode;
            _x.displayAppInformationRequiredState = displayAppInformationRequiredState;
            _x.numberMatchingRequiredState = numberMatchingRequiredState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authenticationMode")
    @JsonIgnore
    public Optional<MicrosoftAuthenticatorAuthenticationMode> getAuthenticationMode() {
        return Optional.ofNullable(authenticationMode);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget withAuthenticationMode(MicrosoftAuthenticatorAuthenticationMode authenticationMode) {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("authenticationMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget");
        _x.authenticationMode = authenticationMode;
        return _x;
    }

    @Property(name="displayAppInformationRequiredState")
    @JsonIgnore
    public Optional<AdvancedConfigState> getDisplayAppInformationRequiredState() {
        return Optional.ofNullable(displayAppInformationRequiredState);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget withDisplayAppInformationRequiredState(AdvancedConfigState displayAppInformationRequiredState) {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("displayAppInformationRequiredState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget");
        _x.displayAppInformationRequiredState = displayAppInformationRequiredState;
        return _x;
    }

    @Property(name="numberMatchingRequiredState")
    @JsonIgnore
    public Optional<AdvancedConfigState> getNumberMatchingRequiredState() {
        return Optional.ofNullable(numberMatchingRequiredState);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget withNumberMatchingRequiredState(AdvancedConfigState numberMatchingRequiredState) {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("numberMatchingRequiredState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.microsoftAuthenticatorAuthenticationMethodTarget");
        _x.numberMatchingRequiredState = numberMatchingRequiredState;
        return _x;
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget withUnmappedField(String name, Object value) {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftAuthenticatorAuthenticationMethodTarget patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MicrosoftAuthenticatorAuthenticationMethodTarget put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MicrosoftAuthenticatorAuthenticationMethodTarget _copy() {
        MicrosoftAuthenticatorAuthenticationMethodTarget _x = new MicrosoftAuthenticatorAuthenticationMethodTarget();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isRegistrationRequired = isRegistrationRequired;
        _x.targetType = targetType;
        _x.authenticationMode = authenticationMode;
        _x.displayAppInformationRequiredState = displayAppInformationRequiredState;
        _x.numberMatchingRequiredState = numberMatchingRequiredState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MicrosoftAuthenticatorAuthenticationMethodTarget[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isRegistrationRequired=");
        b.append(this.isRegistrationRequired);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append(", ");
        b.append("authenticationMode=");
        b.append(this.authenticationMode);
        b.append(", ");
        b.append("displayAppInformationRequiredState=");
        b.append(this.displayAppInformationRequiredState);
        b.append(", ");
        b.append("numberMatchingRequiredState=");
        b.append(this.numberMatchingRequiredState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
