package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EmailAddress;

@JsonPropertyOrder({
    "@odata.type", 
    "application", 
    "clientReference", 
    "createdBy", 
    "createdDateTime", 
    "deepLink", 
    "mentioned", 
    "mentionText", 
    "serverCreatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Mention extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mention";
    }

    @JsonProperty("application")
    protected String application;

    @JsonProperty("clientReference")
    protected String clientReference;

    @JsonProperty("createdBy")
    protected EmailAddress createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deepLink")
    protected String deepLink;

    @JsonProperty("mentioned")
    protected EmailAddress mentioned;

    @JsonProperty("mentionText")
    protected String mentionText;

    @JsonProperty("serverCreatedDateTime")
    protected OffsetDateTime serverCreatedDateTime;

    protected Mention() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMention() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String application;
        private String clientReference;
        private EmailAddress createdBy;
        private OffsetDateTime createdDateTime;
        private String deepLink;
        private EmailAddress mentioned;
        private String mentionText;
        private OffsetDateTime serverCreatedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder application(String application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder clientReference(String clientReference) {
            this.clientReference = clientReference;
            this.changedFields = changedFields.add("clientReference");
            return this;
        }

        public Builder createdBy(EmailAddress createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder deepLink(String deepLink) {
            this.deepLink = deepLink;
            this.changedFields = changedFields.add("deepLink");
            return this;
        }

        public Builder mentioned(EmailAddress mentioned) {
            this.mentioned = mentioned;
            this.changedFields = changedFields.add("mentioned");
            return this;
        }

        public Builder mentionText(String mentionText) {
            this.mentionText = mentionText;
            this.changedFields = changedFields.add("mentionText");
            return this;
        }

        public Builder serverCreatedDateTime(OffsetDateTime serverCreatedDateTime) {
            this.serverCreatedDateTime = serverCreatedDateTime;
            this.changedFields = changedFields.add("serverCreatedDateTime");
            return this;
        }

        public Mention build() {
            Mention _x = new Mention();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mention";
            _x.id = id;
            _x.application = application;
            _x.clientReference = clientReference;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.deepLink = deepLink;
            _x.mentioned = mentioned;
            _x.mentionText = mentionText;
            _x.serverCreatedDateTime = serverCreatedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="application")
    @JsonIgnore
    public Optional<String> getApplication() {
        return Optional.ofNullable(application);
    }

    public Mention withApplication(String application) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("application");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.application = application;
        return _x;
    }

    @Property(name="clientReference")
    @JsonIgnore
    public Optional<String> getClientReference() {
        return Optional.ofNullable(clientReference);
    }

    public Mention withClientReference(String clientReference) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("clientReference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.clientReference = clientReference;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<EmailAddress> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public Mention withCreatedBy(EmailAddress createdBy) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Mention withCreatedDateTime(OffsetDateTime createdDateTime) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="deepLink")
    @JsonIgnore
    public Optional<String> getDeepLink() {
        return Optional.ofNullable(deepLink);
    }

    public Mention withDeepLink(String deepLink) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("deepLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.deepLink = deepLink;
        return _x;
    }

    @Property(name="mentioned")
    @JsonIgnore
    public Optional<EmailAddress> getMentioned() {
        return Optional.ofNullable(mentioned);
    }

    public Mention withMentioned(EmailAddress mentioned) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("mentioned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.mentioned = mentioned;
        return _x;
    }

    @Property(name="mentionText")
    @JsonIgnore
    public Optional<String> getMentionText() {
        return Optional.ofNullable(mentionText);
    }

    public Mention withMentionText(String mentionText) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("mentionText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.mentionText = mentionText;
        return _x;
    }

    @Property(name="serverCreatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getServerCreatedDateTime() {
        return Optional.ofNullable(serverCreatedDateTime);
    }

    public Mention withServerCreatedDateTime(OffsetDateTime serverCreatedDateTime) {
        Mention _x = _copy();
        _x.changedFields = changedFields.add("serverCreatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mention");
        _x.serverCreatedDateTime = serverCreatedDateTime;
        return _x;
    }

    public Mention withUnmappedField(String name, Object value) {
        Mention _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mention patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Mention _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mention put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Mention _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Mention _copy() {
        Mention _x = new Mention();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.application = application;
        _x.clientReference = clientReference;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.deepLink = deepLink;
        _x.mentioned = mentioned;
        _x.mentionText = mentionText;
        _x.serverCreatedDateTime = serverCreatedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Mention[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("clientReference=");
        b.append(this.clientReference);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deepLink=");
        b.append(this.deepLink);
        b.append(", ");
        b.append("mentioned=");
        b.append(this.mentioned);
        b.append(", ");
        b.append("mentionText=");
        b.append(this.mentionText);
        b.append(", ");
        b.append("serverCreatedDateTime=");
        b.append(this.serverCreatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
