package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MeetingSpeaker;
import odata.msgraph.client.beta.entity.collection.request.MeetingRegistrationQuestionCollectionRequest;
import odata.msgraph.client.beta.enums.MeetingAudience;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "endDateTime", 
    "registrationPageViewCount", 
    "registrationPageWebUrl", 
    "speakers", 
    "startDateTime", 
    "subject", 
    "customQuestions"})
@JsonInclude(Include.NON_NULL)
public class MeetingRegistration extends MeetingRegistrationBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingRegistration";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("registrationPageViewCount")
    protected Integer registrationPageViewCount;

    @JsonProperty("registrationPageWebUrl")
    protected String registrationPageWebUrl;

    @JsonProperty("speakers")
    protected List<MeetingSpeaker> speakers;

    @JsonProperty("speakers@nextLink")
    protected String speakersNextLink;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("customQuestions")
    protected List<MeetingRegistrationQuestion> customQuestions;

    protected MeetingRegistration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMeetingRegistration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private MeetingAudience allowedRegistrant;
        private List<MeetingRegistrantBase> registrants;
        private String description;
        private OffsetDateTime endDateTime;
        private Integer registrationPageViewCount;
        private String registrationPageWebUrl;
        private List<MeetingSpeaker> speakers;
        private String speakersNextLink;
        private OffsetDateTime startDateTime;
        private String subject;
        private List<MeetingRegistrationQuestion> customQuestions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder allowedRegistrant(MeetingAudience allowedRegistrant) {
            this.allowedRegistrant = allowedRegistrant;
            this.changedFields = changedFields.add("allowedRegistrant");
            return this;
        }

        public Builder registrants(List<MeetingRegistrantBase> registrants) {
            this.registrants = registrants;
            this.changedFields = changedFields.add("registrants");
            return this;
        }

        public Builder registrants(MeetingRegistrantBase... registrants) {
            return registrants(Arrays.asList(registrants));
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder registrationPageViewCount(Integer registrationPageViewCount) {
            this.registrationPageViewCount = registrationPageViewCount;
            this.changedFields = changedFields.add("registrationPageViewCount");
            return this;
        }

        public Builder registrationPageWebUrl(String registrationPageWebUrl) {
            this.registrationPageWebUrl = registrationPageWebUrl;
            this.changedFields = changedFields.add("registrationPageWebUrl");
            return this;
        }

        public Builder speakers(List<MeetingSpeaker> speakers) {
            this.speakers = speakers;
            this.changedFields = changedFields.add("speakers");
            return this;
        }

        public Builder speakers(MeetingSpeaker... speakers) {
            return speakers(Arrays.asList(speakers));
        }

        public Builder speakersNextLink(String speakersNextLink) {
            this.speakersNextLink = speakersNextLink;
            this.changedFields = changedFields.add("speakers");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder customQuestions(List<MeetingRegistrationQuestion> customQuestions) {
            this.customQuestions = customQuestions;
            this.changedFields = changedFields.add("customQuestions");
            return this;
        }

        public Builder customQuestions(MeetingRegistrationQuestion... customQuestions) {
            return customQuestions(Arrays.asList(customQuestions));
        }

        public MeetingRegistration build() {
            MeetingRegistration _x = new MeetingRegistration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingRegistration";
            _x.id = id;
            _x.allowedRegistrant = allowedRegistrant;
            _x.registrants = registrants;
            _x.description = description;
            _x.endDateTime = endDateTime;
            _x.registrationPageViewCount = registrationPageViewCount;
            _x.registrationPageWebUrl = registrationPageWebUrl;
            _x.speakers = speakers;
            _x.speakersNextLink = speakersNextLink;
            _x.startDateTime = startDateTime;
            _x.subject = subject;
            _x.customQuestions = customQuestions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public MeetingRegistration withDescription(String description) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.description = description;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public MeetingRegistration withEndDateTime(OffsetDateTime endDateTime) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="registrationPageViewCount")
    @JsonIgnore
    public Optional<Integer> getRegistrationPageViewCount() {
        return Optional.ofNullable(registrationPageViewCount);
    }

    public MeetingRegistration withRegistrationPageViewCount(Integer registrationPageViewCount) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("registrationPageViewCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.registrationPageViewCount = registrationPageViewCount;
        return _x;
    }

    @Property(name="registrationPageWebUrl")
    @JsonIgnore
    public Optional<String> getRegistrationPageWebUrl() {
        return Optional.ofNullable(registrationPageWebUrl);
    }

    public MeetingRegistration withRegistrationPageWebUrl(String registrationPageWebUrl) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("registrationPageWebUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.registrationPageWebUrl = registrationPageWebUrl;
        return _x;
    }

    @Property(name="speakers")
    @JsonIgnore
    public CollectionPage<MeetingSpeaker> getSpeakers() {
        return new CollectionPage<MeetingSpeaker>(contextPath, MeetingSpeaker.class, this.speakers, Optional.ofNullable(speakersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public MeetingRegistration withSpeakers(List<MeetingSpeaker> speakers) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("speakers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.speakers = speakers;
        return _x;
    }

    @Property(name="speakers")
    @JsonIgnore
    public CollectionPage<MeetingSpeaker> getSpeakers(HttpRequestOptions options) {
        return new CollectionPage<MeetingSpeaker>(contextPath, MeetingSpeaker.class, this.speakers, Optional.ofNullable(speakersNextLink), Collections.emptyList(), options);
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public MeetingRegistration withStartDateTime(OffsetDateTime startDateTime) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public MeetingRegistration withSubject(String subject) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.subject = subject;
        return _x;
    }

    public MeetingRegistration withUnmappedField(String name, Object value) {
        MeetingRegistration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="customQuestions")
    @JsonIgnore
    public MeetingRegistrationQuestionCollectionRequest getCustomQuestions() {
        return new MeetingRegistrationQuestionCollectionRequest(
                        contextPath.addSegment("customQuestions"), Optional.ofNullable(customQuestions));
    }

    public MeetingRegistration withCustomQuestions(List<MeetingRegistrationQuestion> customQuestions) {
        MeetingRegistration _x = _copy();
        _x.changedFields = changedFields.add("customQuestions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingRegistration");
        _x.customQuestions = customQuestions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingRegistration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MeetingRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MeetingRegistration _copy() {
        MeetingRegistration _x = new MeetingRegistration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.allowedRegistrant = allowedRegistrant;
        _x.registrants = registrants;
        _x.description = description;
        _x.endDateTime = endDateTime;
        _x.registrationPageViewCount = registrationPageViewCount;
        _x.registrationPageWebUrl = registrationPageWebUrl;
        _x.speakers = speakers;
        _x.startDateTime = startDateTime;
        _x.subject = subject;
        _x.customQuestions = customQuestions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingRegistration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("allowedRegistrant=");
        b.append(this.allowedRegistrant);
        b.append(", ");
        b.append("registrants=");
        b.append(this.registrants);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("registrationPageViewCount=");
        b.append(this.registrationPageViewCount);
        b.append(", ");
        b.append("registrationPageWebUrl=");
        b.append(this.registrationPageWebUrl);
        b.append(", ");
        b.append("speakers=");
        b.append(this.speakers);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("customQuestions=");
        b.append(this.customQuestions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
