package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AttendanceRecordCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "meetingEndDateTime", 
    "meetingStartDateTime", 
    "totalParticipantCount", 
    "attendanceRecords"})
@JsonInclude(Include.NON_NULL)
public class MeetingAttendanceReport extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingAttendanceReport";
    }

    @JsonProperty("meetingEndDateTime")
    protected OffsetDateTime meetingEndDateTime;

    @JsonProperty("meetingStartDateTime")
    protected OffsetDateTime meetingStartDateTime;

    @JsonProperty("totalParticipantCount")
    protected Integer totalParticipantCount;

    @JsonProperty("attendanceRecords")
    protected List<AttendanceRecord> attendanceRecords;

    protected MeetingAttendanceReport() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMeetingAttendanceReport() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime meetingEndDateTime;
        private OffsetDateTime meetingStartDateTime;
        private Integer totalParticipantCount;
        private List<AttendanceRecord> attendanceRecords;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder meetingEndDateTime(OffsetDateTime meetingEndDateTime) {
            this.meetingEndDateTime = meetingEndDateTime;
            this.changedFields = changedFields.add("meetingEndDateTime");
            return this;
        }

        public Builder meetingStartDateTime(OffsetDateTime meetingStartDateTime) {
            this.meetingStartDateTime = meetingStartDateTime;
            this.changedFields = changedFields.add("meetingStartDateTime");
            return this;
        }

        public Builder totalParticipantCount(Integer totalParticipantCount) {
            this.totalParticipantCount = totalParticipantCount;
            this.changedFields = changedFields.add("totalParticipantCount");
            return this;
        }

        public Builder attendanceRecords(List<AttendanceRecord> attendanceRecords) {
            this.attendanceRecords = attendanceRecords;
            this.changedFields = changedFields.add("attendanceRecords");
            return this;
        }

        public Builder attendanceRecords(AttendanceRecord... attendanceRecords) {
            return attendanceRecords(Arrays.asList(attendanceRecords));
        }

        public MeetingAttendanceReport build() {
            MeetingAttendanceReport _x = new MeetingAttendanceReport();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingAttendanceReport";
            _x.id = id;
            _x.meetingEndDateTime = meetingEndDateTime;
            _x.meetingStartDateTime = meetingStartDateTime;
            _x.totalParticipantCount = totalParticipantCount;
            _x.attendanceRecords = attendanceRecords;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="meetingEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMeetingEndDateTime() {
        return Optional.ofNullable(meetingEndDateTime);
    }

    public MeetingAttendanceReport withMeetingEndDateTime(OffsetDateTime meetingEndDateTime) {
        MeetingAttendanceReport _x = _copy();
        _x.changedFields = changedFields.add("meetingEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingAttendanceReport");
        _x.meetingEndDateTime = meetingEndDateTime;
        return _x;
    }

    @Property(name="meetingStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMeetingStartDateTime() {
        return Optional.ofNullable(meetingStartDateTime);
    }

    public MeetingAttendanceReport withMeetingStartDateTime(OffsetDateTime meetingStartDateTime) {
        MeetingAttendanceReport _x = _copy();
        _x.changedFields = changedFields.add("meetingStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingAttendanceReport");
        _x.meetingStartDateTime = meetingStartDateTime;
        return _x;
    }

    @Property(name="totalParticipantCount")
    @JsonIgnore
    public Optional<Integer> getTotalParticipantCount() {
        return Optional.ofNullable(totalParticipantCount);
    }

    public MeetingAttendanceReport withTotalParticipantCount(Integer totalParticipantCount) {
        MeetingAttendanceReport _x = _copy();
        _x.changedFields = changedFields.add("totalParticipantCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingAttendanceReport");
        _x.totalParticipantCount = totalParticipantCount;
        return _x;
    }

    public MeetingAttendanceReport withUnmappedField(String name, Object value) {
        MeetingAttendanceReport _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="attendanceRecords")
    @JsonIgnore
    public AttendanceRecordCollectionRequest getAttendanceRecords() {
        return new AttendanceRecordCollectionRequest(
                        contextPath.addSegment("attendanceRecords"), Optional.ofNullable(attendanceRecords));
    }

    public MeetingAttendanceReport withAttendanceRecords(List<AttendanceRecord> attendanceRecords) {
        MeetingAttendanceReport _x = _copy();
        _x.changedFields = changedFields.add("attendanceRecords");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingAttendanceReport");
        _x.attendanceRecords = attendanceRecords;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingAttendanceReport patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MeetingAttendanceReport _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingAttendanceReport put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MeetingAttendanceReport _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MeetingAttendanceReport _copy() {
        MeetingAttendanceReport _x = new MeetingAttendanceReport();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.meetingEndDateTime = meetingEndDateTime;
        _x.meetingStartDateTime = meetingStartDateTime;
        _x.totalParticipantCount = totalParticipantCount;
        _x.attendanceRecords = attendanceRecords;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingAttendanceReport[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("meetingEndDateTime=");
        b.append(this.meetingEndDateTime);
        b.append(", ");
        b.append("meetingStartDateTime=");
        b.append(this.meetingStartDateTime);
        b.append(", ");
        b.append("totalParticipantCount=");
        b.append(this.totalParticipantCount);
        b.append(", ");
        b.append("attendanceRecords=");
        b.append(this.attendanceRecords);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
