package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AnalyticsActivityType;

@JsonPropertyOrder({
    "@odata.type", 
    "afterHours", 
    "conflicting", 
    "long", 
    "multitasking", 
    "organized", 
    "recurring"})
@JsonInclude(Include.NON_NULL)
public class MeetingActivityStatistics extends ActivityStatistics implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.meetingActivityStatistics";
    }

    @JsonProperty("afterHours")
    protected Duration afterHours;

    @JsonProperty("conflicting")
    protected Duration conflicting;

    @JsonProperty("long")
    protected Duration long_;

    @JsonProperty("multitasking")
    protected Duration multitasking;

    @JsonProperty("organized")
    protected Duration organized;

    @JsonProperty("recurring")
    protected Duration recurring;

    protected MeetingActivityStatistics() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMeetingActivityStatistics() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AnalyticsActivityType activity;
        private Duration duration;
        private LocalDate endDate;
        private LocalDate startDate;
        private String timeZoneUsed;
        private Duration afterHours;
        private Duration conflicting;
        private Duration long_;
        private Duration multitasking;
        private Duration organized;
        private Duration recurring;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activity(AnalyticsActivityType activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder duration(Duration duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("endDate");
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("startDate");
            return this;
        }

        public Builder timeZoneUsed(String timeZoneUsed) {
            this.timeZoneUsed = timeZoneUsed;
            this.changedFields = changedFields.add("timeZoneUsed");
            return this;
        }

        public Builder afterHours(Duration afterHours) {
            this.afterHours = afterHours;
            this.changedFields = changedFields.add("afterHours");
            return this;
        }

        public Builder conflicting(Duration conflicting) {
            this.conflicting = conflicting;
            this.changedFields = changedFields.add("conflicting");
            return this;
        }

        public Builder long_(Duration long_) {
            this.long_ = long_;
            this.changedFields = changedFields.add("long");
            return this;
        }

        public Builder multitasking(Duration multitasking) {
            this.multitasking = multitasking;
            this.changedFields = changedFields.add("multitasking");
            return this;
        }

        public Builder organized(Duration organized) {
            this.organized = organized;
            this.changedFields = changedFields.add("organized");
            return this;
        }

        public Builder recurring(Duration recurring) {
            this.recurring = recurring;
            this.changedFields = changedFields.add("recurring");
            return this;
        }

        public MeetingActivityStatistics build() {
            MeetingActivityStatistics _x = new MeetingActivityStatistics();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.meetingActivityStatistics";
            _x.id = id;
            _x.activity = activity;
            _x.duration = duration;
            _x.endDate = endDate;
            _x.startDate = startDate;
            _x.timeZoneUsed = timeZoneUsed;
            _x.afterHours = afterHours;
            _x.conflicting = conflicting;
            _x.long_ = long_;
            _x.multitasking = multitasking;
            _x.organized = organized;
            _x.recurring = recurring;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="afterHours")
    @JsonIgnore
    public Optional<Duration> getAfterHours() {
        return Optional.ofNullable(afterHours);
    }

    public MeetingActivityStatistics withAfterHours(Duration afterHours) {
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("afterHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingActivityStatistics");
        _x.afterHours = afterHours;
        return _x;
    }

    @Property(name="conflicting")
    @JsonIgnore
    public Optional<Duration> getConflicting() {
        return Optional.ofNullable(conflicting);
    }

    public MeetingActivityStatistics withConflicting(Duration conflicting) {
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("conflicting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingActivityStatistics");
        _x.conflicting = conflicting;
        return _x;
    }

    @Property(name="long")
    @JsonIgnore
    public Optional<Duration> getLong() {
        return Optional.ofNullable(long_);
    }

    public MeetingActivityStatistics withLong(Duration long_) {
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("long");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingActivityStatistics");
        _x.long_ = long_;
        return _x;
    }

    @Property(name="multitasking")
    @JsonIgnore
    public Optional<Duration> getMultitasking() {
        return Optional.ofNullable(multitasking);
    }

    public MeetingActivityStatistics withMultitasking(Duration multitasking) {
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("multitasking");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingActivityStatistics");
        _x.multitasking = multitasking;
        return _x;
    }

    @Property(name="organized")
    @JsonIgnore
    public Optional<Duration> getOrganized() {
        return Optional.ofNullable(organized);
    }

    public MeetingActivityStatistics withOrganized(Duration organized) {
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("organized");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingActivityStatistics");
        _x.organized = organized;
        return _x;
    }

    @Property(name="recurring")
    @JsonIgnore
    public Optional<Duration> getRecurring() {
        return Optional.ofNullable(recurring);
    }

    public MeetingActivityStatistics withRecurring(Duration recurring) {
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("recurring");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.meetingActivityStatistics");
        _x.recurring = recurring;
        return _x;
    }

    public MeetingActivityStatistics withUnmappedField(String name, Object value) {
        MeetingActivityStatistics _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingActivityStatistics patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MeetingActivityStatistics put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MeetingActivityStatistics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MeetingActivityStatistics _copy() {
        MeetingActivityStatistics _x = new MeetingActivityStatistics();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activity = activity;
        _x.duration = duration;
        _x.endDate = endDate;
        _x.startDate = startDate;
        _x.timeZoneUsed = timeZoneUsed;
        _x.afterHours = afterHours;
        _x.conflicting = conflicting;
        _x.long_ = long_;
        _x.multitasking = multitasking;
        _x.organized = organized;
        _x.recurring = recurring;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MeetingActivityStatistics[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("timeZoneUsed=");
        b.append(this.timeZoneUsed);
        b.append(", ");
        b.append("afterHours=");
        b.append(this.afterHours);
        b.append(", ");
        b.append("conflicting=");
        b.append(this.conflicting);
        b.append(", ");
        b.append("long=");
        b.append(this.long_);
        b.append(", ");
        b.append("multitasking=");
        b.append(this.multitasking);
        b.append(", ");
        b.append("organized=");
        b.append(this.organized);
        b.append(", ");
        b.append("recurring=");
        b.append(this.recurring);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
