package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;
import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“Management conditions are events that can be triggered dynamically such as geo-
 * fences, time-fences, and network-fences.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "applicablePlatforms", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "eTag", 
    "modifiedDateTime", 
    "uniqueName"})
@JsonInclude(Include.NON_NULL)
public class ManagementCondition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managementCondition";
    }

    @JsonProperty("applicablePlatforms")
    protected List<DevicePlatformType> applicablePlatforms;

    @JsonProperty("applicablePlatforms@nextLink")
    protected String applicablePlatformsNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("eTag")
    protected String eTag;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("uniqueName")
    protected String uniqueName;

    protected ManagementCondition() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The applicable platforms for this management condition.”</i>
     * 
     * @return property applicablePlatforms
     */
    @Property(name="applicablePlatforms")
    @JsonIgnore
    public CollectionPage<DevicePlatformType> getApplicablePlatforms() {
        return new CollectionPage<DevicePlatformType>(contextPath, DevicePlatformType.class, this.applicablePlatforms, Optional.ofNullable(applicablePlatformsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicablePlatforms} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The applicable platforms for this management condition.”</i>
     * 
     * @param applicablePlatforms
     *            new value of {@code applicablePlatforms} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicablePlatforms} field changed
     */
    public ManagementCondition withApplicablePlatforms(List<DevicePlatformType> applicablePlatforms) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("applicablePlatforms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.applicablePlatforms = applicablePlatforms;
        return _x;
    }

    /**
     * <i>“The applicable platforms for this management condition.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property applicablePlatforms
     */
    @Property(name="applicablePlatforms")
    @JsonIgnore
    public CollectionPage<DevicePlatformType> getApplicablePlatforms(HttpRequestOptions options) {
        return new CollectionPage<DevicePlatformType>(contextPath, DevicePlatformType.class, this.applicablePlatforms, Optional.ofNullable(applicablePlatformsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The time the management condition was created. Generated service side.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the management condition was created. Generated service side.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ManagementCondition withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The admin defined description of the management condition.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin defined description of the management condition.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ManagementCondition withDescription(String description) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The admin defined name of the management condition.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The admin defined name of the management condition.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ManagementCondition withDisplayName(String displayName) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“ETag of the management condition. Updated service side.”</i>
     * 
     * @return property eTag
     */
    @Property(name="eTag")
    @JsonIgnore
    public Optional<String> getETag() {
        return Optional.ofNullable(eTag);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eTag} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“ETag of the management condition. Updated service side.”</i>
     * 
     * @param eTag
     *            new value of {@code eTag} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eTag} field changed
     */
    public ManagementCondition withETag(String eTag) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("eTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.eTag = eTag;
        return _x;
    }

    /**
     * <i>“The time the management condition was last modified. Updated service side.”</i>
     * 
     * @return property modifiedDateTime
     */
    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modifiedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time the management condition was last modified. Updated service side.”</i>
     * 
     * @param modifiedDateTime
     *            new value of {@code modifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modifiedDateTime} field changed
     */
    public ManagementCondition withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    /**
     * <i>“Unique name for the management condition. Used in management condition
     * expressions.”</i>
     * 
     * @return property uniqueName
     */
    @Property(name="uniqueName")
    @JsonIgnore
    public Optional<String> getUniqueName() {
        return Optional.ofNullable(uniqueName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uniqueName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Unique name for the management condition. Used in management condition
     * expressions.”</i>
     * 
     * @param uniqueName
     *            new value of {@code uniqueName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uniqueName} field changed
     */
    public ManagementCondition withUniqueName(String uniqueName) {
        ManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("uniqueName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managementCondition");
        _x.uniqueName = uniqueName;
        return _x;
    }

    public ManagementCondition withUnmappedField(String name, Object value) {
        ManagementCondition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The management condition statements associated to the management condition.”</i>
     * 
     * @return navigational property managementConditionStatements
     */
    @NavigationProperty(name="managementConditionStatements")
    @JsonIgnore
    public ManagementConditionStatementCollectionRequest getManagementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"), RequestHelper.getValue(unmappedFields, "managementConditionStatements"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementCondition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagementCondition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagementCondition _copy() {
        ManagementCondition _x = new ManagementCondition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicablePlatforms = applicablePlatforms;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.eTag = eTag;
        _x.modifiedDateTime = modifiedDateTime;
        _x.uniqueName = uniqueName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagementCondition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicablePlatforms=");
        b.append(this.applicablePlatforms);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("uniqueName=");
        b.append(this.uniqueName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
