package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MobileAppIdentifier;


/**
 * <i>“The identifier for the deployment an app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "mobileAppIdentifier", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class ManagedMobileApp extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedMobileApp";
    }

    @JsonProperty("mobileAppIdentifier")
    protected MobileAppIdentifier mobileAppIdentifier;

    @JsonProperty("version")
    protected String version;

    protected ManagedMobileApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedMobileApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private MobileAppIdentifier mobileAppIdentifier;
        private String version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The identifier for an app with it's operating system type.”</i>
         * 
         * @param mobileAppIdentifier
         *            value of {@code mobileAppIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppIdentifier(MobileAppIdentifier mobileAppIdentifier) {
            this.mobileAppIdentifier = mobileAppIdentifier;
            this.changedFields = changedFields.add("mobileAppIdentifier");
            return this;
        }

        /**
         * <i>“Version of the entity.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public ManagedMobileApp build() {
            ManagedMobileApp _x = new ManagedMobileApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedMobileApp";
            _x.id = id;
            _x.mobileAppIdentifier = mobileAppIdentifier;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The identifier for an app with it's operating system type.”</i>
     * 
     * @return property mobileAppIdentifier
     */
    @Property(name="mobileAppIdentifier")
    @JsonIgnore
    public Optional<MobileAppIdentifier> getMobileAppIdentifier() {
        return Optional.ofNullable(mobileAppIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The identifier for an app with it's operating system type.”</i>
     * 
     * @param mobileAppIdentifier
     *            new value of {@code mobileAppIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppIdentifier} field changed
     */
    public ManagedMobileApp withMobileAppIdentifier(MobileAppIdentifier mobileAppIdentifier) {
        ManagedMobileApp _x = _copy();
        _x.changedFields = changedFields.add("mobileAppIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedMobileApp");
        _x.mobileAppIdentifier = mobileAppIdentifier;
        return _x;
    }

    /**
     * <i>“Version of the entity.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the entity.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public ManagedMobileApp withVersion(String version) {
        ManagedMobileApp _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedMobileApp");
        _x.version = version;
        return _x;
    }

    public ManagedMobileApp withUnmappedField(String name, Object value) {
        ManagedMobileApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedMobileApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedMobileApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedMobileApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedMobileApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedMobileApp _copy() {
        ManagedMobileApp _x = new ManagedMobileApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.mobileAppIdentifier = mobileAppIdentifier;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedMobileApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("mobileAppIdentifier=");
        b.append(this.mobileAppIdentifier);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
