package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Contains properties, inherited properties and actions for an MDM mobile app
 * configuration user status summary.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "configurationVersion", 
    "conflictCount", 
    "errorCount", 
    "failedCount", 
    "lastUpdateDateTime", 
    "notApplicableCount", 
    "pendingCount", 
    "successCount"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceMobileAppConfigurationUserSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary";
    }

    @JsonProperty("configurationVersion")
    protected Integer configurationVersion;

    @JsonProperty("conflictCount")
    protected Integer conflictCount;

    @JsonProperty("errorCount")
    protected Integer errorCount;

    @JsonProperty("failedCount")
    protected Integer failedCount;

    @JsonProperty("lastUpdateDateTime")
    protected OffsetDateTime lastUpdateDateTime;

    @JsonProperty("notApplicableCount")
    protected Integer notApplicableCount;

    @JsonProperty("pendingCount")
    protected Integer pendingCount;

    @JsonProperty("successCount")
    protected Integer successCount;

    protected ManagedDeviceMobileAppConfigurationUserSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManagedDeviceMobileAppConfigurationUserSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer configurationVersion;
        private Integer conflictCount;
        private Integer errorCount;
        private Integer failedCount;
        private OffsetDateTime lastUpdateDateTime;
        private Integer notApplicableCount;
        private Integer pendingCount;
        private Integer successCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Version of the policy for that overview”</i>
         * 
         * @param configurationVersion
         *            value of {@code configurationVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationVersion(Integer configurationVersion) {
            this.configurationVersion = configurationVersion;
            this.changedFields = changedFields.add("configurationVersion");
            return this;
        }

        /**
         * <i>“Number of users in conflict”</i>
         * 
         * @param conflictCount
         *            value of {@code conflictCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictCount(Integer conflictCount) {
            this.conflictCount = conflictCount;
            this.changedFields = changedFields.add("conflictCount");
            return this;
        }

        /**
         * <i>“Number of error Users”</i>
         * 
         * @param errorCount
         *            value of {@code errorCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            this.changedFields = changedFields.add("errorCount");
            return this;
        }

        /**
         * <i>“Number of failed Users”</i>
         * 
         * @param failedCount
         *            value of {@code failedCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            this.changedFields = changedFields.add("failedCount");
            return this;
        }

        /**
         * <i>“Last update time”</i>
         * 
         * @param lastUpdateDateTime
         *            value of {@code lastUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            this.changedFields = changedFields.add("lastUpdateDateTime");
            return this;
        }

        /**
         * <i>“Number of not applicable users”</i>
         * 
         * @param notApplicableCount
         *            value of {@code notApplicableCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            this.changedFields = changedFields.add("notApplicableCount");
            return this;
        }

        /**
         * <i>“Number of pending Users”</i>
         * 
         * @param pendingCount
         *            value of {@code pendingCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            this.changedFields = changedFields.add("pendingCount");
            return this;
        }

        /**
         * <i>“Number of succeeded Users”</i>
         * 
         * @param successCount
         *            value of {@code successCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successCount(Integer successCount) {
            this.successCount = successCount;
            this.changedFields = changedFields.add("successCount");
            return this;
        }

        public ManagedDeviceMobileAppConfigurationUserSummary build() {
            ManagedDeviceMobileAppConfigurationUserSummary _x = new ManagedDeviceMobileAppConfigurationUserSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary";
            _x.id = id;
            _x.configurationVersion = configurationVersion;
            _x.conflictCount = conflictCount;
            _x.errorCount = errorCount;
            _x.failedCount = failedCount;
            _x.lastUpdateDateTime = lastUpdateDateTime;
            _x.notApplicableCount = notApplicableCount;
            _x.pendingCount = pendingCount;
            _x.successCount = successCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Version of the policy for that overview”</i>
     * 
     * @return property configurationVersion
     */
    @Property(name="configurationVersion")
    @JsonIgnore
    public Optional<Integer> getConfigurationVersion() {
        return Optional.ofNullable(configurationVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Version of the policy for that overview”</i>
     * 
     * @param configurationVersion
     *            new value of {@code configurationVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationVersion} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withConfigurationVersion(Integer configurationVersion) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("configurationVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.configurationVersion = configurationVersion;
        return _x;
    }

    /**
     * <i>“Number of users in conflict”</i>
     * 
     * @return property conflictCount
     */
    @Property(name="conflictCount")
    @JsonIgnore
    public Optional<Integer> getConflictCount() {
        return Optional.ofNullable(conflictCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code conflictCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of users in conflict”</i>
     * 
     * @param conflictCount
     *            new value of {@code conflictCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictCount} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withConflictCount(Integer conflictCount) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.conflictCount = conflictCount;
        return _x;
    }

    /**
     * <i>“Number of error Users”</i>
     * 
     * @return property errorCount
     */
    @Property(name="errorCount")
    @JsonIgnore
    public Optional<Integer> getErrorCount() {
        return Optional.ofNullable(errorCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of error Users”</i>
     * 
     * @param errorCount
     *            new value of {@code errorCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCount} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withErrorCount(Integer errorCount) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("errorCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.errorCount = errorCount;
        return _x;
    }

    /**
     * <i>“Number of failed Users”</i>
     * 
     * @return property failedCount
     */
    @Property(name="failedCount")
    @JsonIgnore
    public Optional<Integer> getFailedCount() {
        return Optional.ofNullable(failedCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code failedCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of failed Users”</i>
     * 
     * @param failedCount
     *            new value of {@code failedCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code failedCount} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withFailedCount(Integer failedCount) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("failedCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.failedCount = failedCount;
        return _x;
    }

    /**
     * <i>“Last update time”</i>
     * 
     * @return property lastUpdateDateTime
     */
    @Property(name="lastUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdateDateTime() {
        return Optional.ofNullable(lastUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdateDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last update time”</i>
     * 
     * @param lastUpdateDateTime
     *            new value of {@code lastUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdateDateTime} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("lastUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.lastUpdateDateTime = lastUpdateDateTime;
        return _x;
    }

    /**
     * <i>“Number of not applicable users”</i>
     * 
     * @return property notApplicableCount
     */
    @Property(name="notApplicableCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableCount() {
        return Optional.ofNullable(notApplicableCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable users”</i>
     * 
     * @param notApplicableCount
     *            new value of {@code notApplicableCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableCount} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withNotApplicableCount(Integer notApplicableCount) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.notApplicableCount = notApplicableCount;
        return _x;
    }

    /**
     * <i>“Number of pending Users”</i>
     * 
     * @return property pendingCount
     */
    @Property(name="pendingCount")
    @JsonIgnore
    public Optional<Integer> getPendingCount() {
        return Optional.ofNullable(pendingCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code pendingCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of pending Users”</i>
     * 
     * @param pendingCount
     *            new value of {@code pendingCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code pendingCount} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withPendingCount(Integer pendingCount) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("pendingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.pendingCount = pendingCount;
        return _x;
    }

    /**
     * <i>“Number of succeeded Users”</i>
     * 
     * @return property successCount
     */
    @Property(name="successCount")
    @JsonIgnore
    public Optional<Integer> getSuccessCount() {
        return Optional.ofNullable(successCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code successCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of succeeded Users”</i>
     * 
     * @param successCount
     *            new value of {@code successCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successCount} field changed
     */
    public ManagedDeviceMobileAppConfigurationUserSummary withSuccessCount(Integer successCount) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = changedFields.add("successCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfigurationUserSummary");
        _x.successCount = successCount;
        return _x;
    }

    public ManagedDeviceMobileAppConfigurationUserSummary withUnmappedField(String name, Object value) {
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceMobileAppConfigurationUserSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceMobileAppConfigurationUserSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceMobileAppConfigurationUserSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceMobileAppConfigurationUserSummary _copy() {
        ManagedDeviceMobileAppConfigurationUserSummary _x = new ManagedDeviceMobileAppConfigurationUserSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configurationVersion = configurationVersion;
        _x.conflictCount = conflictCount;
        _x.errorCount = errorCount;
        _x.failedCount = failedCount;
        _x.lastUpdateDateTime = lastUpdateDateTime;
        _x.notApplicableCount = notApplicableCount;
        _x.pendingCount = pendingCount;
        _x.successCount = successCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceMobileAppConfigurationUserSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configurationVersion=");
        b.append(this.configurationVersion);
        b.append(", ");
        b.append("conflictCount=");
        b.append(this.conflictCount);
        b.append(", ");
        b.append("errorCount=");
        b.append(this.errorCount);
        b.append(", ");
        b.append("failedCount=");
        b.append(this.failedCount);
        b.append(", ");
        b.append("lastUpdateDateTime=");
        b.append(this.lastUpdateDateTime);
        b.append(", ");
        b.append("notApplicableCount=");
        b.append(this.notApplicableCount);
        b.append(", ");
        b.append("pendingCount=");
        b.append(this.pendingCount);
        b.append(", ");
        b.append("successCount=");
        b.append(this.successCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
