package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationDeviceSummaryRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceMobileAppConfigurationUserSummaryRequest;


/**
 * <i>“An abstract class for Mobile app configuration for enrolled devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "targetedMobileApps", 
    "version", 
    "assignments", 
    "deviceStatuses", 
    "deviceStatusSummary", 
    "userStatuses", 
    "userStatusSummary"})
@JsonInclude(Include.NON_NULL)
public class ManagedDeviceMobileAppConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedDeviceMobileAppConfiguration";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("targetedMobileApps")
    protected List<String> targetedMobileApps;

    @JsonProperty("targetedMobileApps@nextLink")
    protected String targetedMobileAppsNextLink;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("assignments")
    protected List<ManagedDeviceMobileAppConfigurationAssignment> assignments;

    @JsonProperty("deviceStatuses")
    protected List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses;

    @JsonProperty("deviceStatusSummary")
    protected ManagedDeviceMobileAppConfigurationDeviceSummary deviceStatusSummary;

    @JsonProperty("userStatuses")
    protected List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses;

    @JsonProperty("userStatusSummary")
    protected ManagedDeviceMobileAppConfigurationUserSummary userStatusSummary;

    protected ManagedDeviceMobileAppConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ManagedDeviceMobileAppConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ManagedDeviceMobileAppConfiguration withDescription(String description) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ManagedDeviceMobileAppConfiguration withDisplayName(String displayName) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ManagedDeviceMobileAppConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this App configuration entity.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this App configuration entity.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public ManagedDeviceMobileAppConfiguration withRoleScopeTagIds(List<String> roleScopeTagIds) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this App configuration entity.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“the associated app.”</i>
     * 
     * @return property targetedMobileApps
     */
    @Property(name="targetedMobileApps")
    @JsonIgnore
    public CollectionPage<String> getTargetedMobileApps() {
        return new CollectionPage<String>(contextPath, String.class, this.targetedMobileApps, Optional.ofNullable(targetedMobileAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedMobileApps} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“the associated app.”</i>
     * 
     * @param targetedMobileApps
     *            new value of {@code targetedMobileApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedMobileApps} field changed
     */
    public ManagedDeviceMobileAppConfiguration withTargetedMobileApps(List<String> targetedMobileApps) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("targetedMobileApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.targetedMobileApps = targetedMobileApps;
        return _x;
    }

    /**
     * <i>“the associated app.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property targetedMobileApps
     */
    @Property(name="targetedMobileApps")
    @JsonIgnore
    public CollectionPage<String> getTargetedMobileApps(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.targetedMobileApps, Optional.ofNullable(targetedMobileAppsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public ManagedDeviceMobileAppConfiguration withVersion(Integer version) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.version = version;
        return _x;
    }

    public ManagedDeviceMobileAppConfiguration withUnmappedField(String name, Object value) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of group assignemenets for app configration.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest getAssignments() {
        return new ManagedDeviceMobileAppConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“List of ManagedDeviceMobileAppConfigurationDeviceStatus.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest getDeviceStatuses() {
        return new ManagedDeviceMobileAppConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.ofNullable(deviceStatuses));
    }

    /**
     * <i>“App configuration device status summary.”</i>
     * 
     * @return navigational property deviceStatusSummary
     */
    @NavigationProperty(name="deviceStatusSummary")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationDeviceSummaryRequest getDeviceStatusSummary() {
        return new ManagedDeviceMobileAppConfigurationDeviceSummaryRequest(contextPath.addSegment("deviceStatusSummary"), Optional.ofNullable(deviceStatusSummary));
    }

    /**
     * <i>“List of ManagedDeviceMobileAppConfigurationUserStatus.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest getUserStatuses() {
        return new ManagedDeviceMobileAppConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.ofNullable(userStatuses));
    }

    /**
     * <i>“App configuration user status summary.”</i>
     * 
     * @return navigational property userStatusSummary
     */
    @NavigationProperty(name="userStatusSummary")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationUserSummaryRequest getUserStatusSummary() {
        return new ManagedDeviceMobileAppConfigurationUserSummaryRequest(contextPath.addSegment("userStatusSummary"), Optional.ofNullable(userStatusSummary));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignemenets for app configration.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public ManagedDeviceMobileAppConfiguration withAssignments(List<ManagedDeviceMobileAppConfigurationAssignment> assignments) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of ManagedDeviceMobileAppConfigurationDeviceStatus.”</i>
     * 
     * @param deviceStatuses
     *            new value of {@code deviceStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatuses} field changed
     */
    public ManagedDeviceMobileAppConfiguration withDeviceStatuses(List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.deviceStatuses = deviceStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceStatusSummary} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“App configuration device status summary.”</i>
     * 
     * @param deviceStatusSummary
     *            new value of {@code deviceStatusSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatusSummary} field changed
     */
    public ManagedDeviceMobileAppConfiguration withDeviceStatusSummary(ManagedDeviceMobileAppConfigurationDeviceSummary deviceStatusSummary) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceStatusSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.deviceStatusSummary = deviceStatusSummary;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of ManagedDeviceMobileAppConfigurationUserStatus.”</i>
     * 
     * @param userStatuses
     *            new value of {@code userStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatuses} field changed
     */
    public ManagedDeviceMobileAppConfiguration withUserStatuses(List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.userStatuses = userStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStatusSummary
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“App configuration user status summary.”</i>
     * 
     * @param userStatusSummary
     *            new value of {@code userStatusSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatusSummary} field changed
     */
    public ManagedDeviceMobileAppConfiguration withUserStatusSummary(ManagedDeviceMobileAppConfigurationUserSummary userStatusSummary) {
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userStatusSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedDeviceMobileAppConfiguration");
        _x.userStatusSummary = userStatusSummary;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceMobileAppConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedDeviceMobileAppConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedDeviceMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedDeviceMobileAppConfiguration _copy() {
        ManagedDeviceMobileAppConfiguration _x = new ManagedDeviceMobileAppConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.targetedMobileApps = targetedMobileApps;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusSummary = deviceStatusSummary;
        _x.userStatuses = userStatuses;
        _x.userStatusSummary = userStatusSummary;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<ManagedDeviceMobileAppConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.managedDeviceMobileAppConfigurationAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedDeviceMobileAppConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("targetedMobileApps=");
        b.append(this.targetedMobileApps);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusSummary=");
        b.append(this.deviceStatusSummary);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusSummary=");
        b.append(this.userStatusSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
