package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MobileAppIdentifier;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppPolicyCollectionRequest;
import odata.msgraph.client.beta.enums.ManagedAppFlaggedReason;


/**
 * <i>“The ManagedAppRegistration resource represents the details of an app, with
 * management capability, used by a member of the organization.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appIdentifier", 
    "applicationVersion", 
    "azureADDeviceId", 
    "createdDateTime", 
    "deviceManufacturer", 
    "deviceModel", 
    "deviceName", 
    "deviceTag", 
    "deviceType", 
    "flaggedReasons", 
    "lastSyncDateTime", 
    "managedDeviceId", 
    "managementSdkVersion", 
    "platformVersion", 
    "userId", 
    "version", 
    "appliedPolicies", 
    "intendedPolicies", 
    "operations"})
@JsonInclude(Include.NON_NULL)
public class ManagedAppRegistration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedAppRegistration";
    }

    @JsonProperty("appIdentifier")
    protected MobileAppIdentifier appIdentifier;

    @JsonProperty("applicationVersion")
    protected String applicationVersion;

    @JsonProperty("azureADDeviceId")
    protected String azureADDeviceId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deviceManufacturer")
    protected String deviceManufacturer;

    @JsonProperty("deviceModel")
    protected String deviceModel;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("deviceTag")
    protected String deviceTag;

    @JsonProperty("deviceType")
    protected String deviceType;

    @JsonProperty("flaggedReasons")
    protected List<ManagedAppFlaggedReason> flaggedReasons;

    @JsonProperty("flaggedReasons@nextLink")
    protected String flaggedReasonsNextLink;

    @JsonProperty("lastSyncDateTime")
    protected OffsetDateTime lastSyncDateTime;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managementSdkVersion")
    protected String managementSdkVersion;

    @JsonProperty("platformVersion")
    protected String platformVersion;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("appliedPolicies")
    protected List<ManagedAppPolicy> appliedPolicies;

    @JsonProperty("intendedPolicies")
    protected List<ManagedAppPolicy> intendedPolicies;

    @JsonProperty("operations")
    protected List<ManagedAppOperation> operations;

    protected ManagedAppRegistration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The app package Identifier”</i>
     * 
     * @return property appIdentifier
     */
    @Property(name="appIdentifier")
    @JsonIgnore
    public Optional<MobileAppIdentifier> getAppIdentifier() {
        return Optional.ofNullable(appIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app package Identifier”</i>
     * 
     * @param appIdentifier
     *            new value of {@code appIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appIdentifier} field changed
     */
    public ManagedAppRegistration withAppIdentifier(MobileAppIdentifier appIdentifier) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("appIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.appIdentifier = appIdentifier;
        return _x;
    }

    /**
     * <i>“App version”</i>
     * 
     * @return property applicationVersion
     */
    @Property(name="applicationVersion")
    @JsonIgnore
    public Optional<String> getApplicationVersion() {
        return Optional.ofNullable(applicationVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * applicationVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“App version”</i>
     * 
     * @param applicationVersion
     *            new value of {@code applicationVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicationVersion} field changed
     */
    public ManagedAppRegistration withApplicationVersion(String applicationVersion) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("applicationVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.applicationVersion = applicationVersion;
        return _x;
    }

    /**
     * <i>“The Azure Active Directory Device identifier of the host device. Value could be
     * empty even when the host device is Azure Active Directory registered.”</i>
     * 
     * @return property azureADDeviceId
     */
    @Property(name="azureADDeviceId")
    @JsonIgnore
    public Optional<String> getAzureADDeviceId() {
        return Optional.ofNullable(azureADDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code azureADDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Azure Active Directory Device identifier of the host device. Value could be
     * empty even when the host device is Azure Active Directory registered.”</i>
     * 
     * @param azureADDeviceId
     *            new value of {@code azureADDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code azureADDeviceId} field changed
     */
    public ManagedAppRegistration withAzureADDeviceId(String azureADDeviceId) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("azureADDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.azureADDeviceId = azureADDeviceId;
        return _x;
    }

    /**
     * <i>“Date and time of creation”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Date and time of creation”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ManagedAppRegistration withCreatedDateTime(OffsetDateTime createdDateTime) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The device manufacturer for the current app registration”</i>
     * 
     * @return property deviceManufacturer
     */
    @Property(name="deviceManufacturer")
    @JsonIgnore
    public Optional<String> getDeviceManufacturer() {
        return Optional.ofNullable(deviceManufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManufacturer} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The device manufacturer for the current app registration”</i>
     * 
     * @param deviceManufacturer
     *            new value of {@code deviceManufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManufacturer} field changed
     */
    public ManagedAppRegistration withDeviceManufacturer(String deviceManufacturer) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceManufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.deviceManufacturer = deviceManufacturer;
        return _x;
    }

    /**
     * <i>“The device model for the current app registration”</i>
     * 
     * @return property deviceModel
     */
    @Property(name="deviceModel")
    @JsonIgnore
    public Optional<String> getDeviceModel() {
        return Optional.ofNullable(deviceModel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceModel}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The device model for the current app registration”</i>
     * 
     * @param deviceModel
     *            new value of {@code deviceModel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceModel} field changed
     */
    public ManagedAppRegistration withDeviceModel(String deviceModel) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceModel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.deviceModel = deviceModel;
        return _x;
    }

    /**
     * <i>“Host device name”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Host device name”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public ManagedAppRegistration withDeviceName(String deviceName) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“App management SDK generated tag, which helps relate apps hosted on the same
     * device. Not guaranteed to relate apps in all conditions.”</i>
     * 
     * @return property deviceTag
     */
    @Property(name="deviceTag")
    @JsonIgnore
    public Optional<String> getDeviceTag() {
        return Optional.ofNullable(deviceTag);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceTag} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“App management SDK generated tag, which helps relate apps hosted on the same
     * device. Not guaranteed to relate apps in all conditions.”</i>
     * 
     * @param deviceTag
     *            new value of {@code deviceTag} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceTag} field changed
     */
    public ManagedAppRegistration withDeviceTag(String deviceTag) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.deviceTag = deviceTag;
        return _x;
    }

    /**
     * <i>“Host device type”</i>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<String> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Host device type”</i>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public ManagedAppRegistration withDeviceType(String deviceType) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("deviceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“Zero or more reasons an app registration is flagged. E.g. app running on rooted
     * device”</i>
     * 
     * @return property flaggedReasons
     */
    @Property(name="flaggedReasons")
    @JsonIgnore
    public CollectionPage<ManagedAppFlaggedReason> getFlaggedReasons() {
        return new CollectionPage<ManagedAppFlaggedReason>(contextPath, ManagedAppFlaggedReason.class, this.flaggedReasons, Optional.ofNullable(flaggedReasonsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code flaggedReasons}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Zero or more reasons an app registration is flagged. E.g. app running on rooted
     * device”</i>
     * 
     * @param flaggedReasons
     *            new value of {@code flaggedReasons} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code flaggedReasons} field changed
     */
    public ManagedAppRegistration withFlaggedReasons(List<ManagedAppFlaggedReason> flaggedReasons) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("flaggedReasons");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.flaggedReasons = flaggedReasons;
        return _x;
    }

    /**
     * <i>“Zero or more reasons an app registration is flagged. E.g. app running on rooted
     * device”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property flaggedReasons
     */
    @Property(name="flaggedReasons")
    @JsonIgnore
    public CollectionPage<ManagedAppFlaggedReason> getFlaggedReasons(HttpRequestOptions options) {
        return new CollectionPage<ManagedAppFlaggedReason>(contextPath, ManagedAppFlaggedReason.class, this.flaggedReasons, Optional.ofNullable(flaggedReasonsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Date and time of last the app synced with management service.”</i>
     * 
     * @return property lastSyncDateTime
     */
    @Property(name="lastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSyncDateTime() {
        return Optional.ofNullable(lastSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastSyncDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Date and time of last the app synced with management service.”</i>
     * 
     * @param lastSyncDateTime
     *            new value of {@code lastSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastSyncDateTime} field changed
     */
    public ManagedAppRegistration withLastSyncDateTime(OffsetDateTime lastSyncDateTime) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("lastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.lastSyncDateTime = lastSyncDateTime;
        return _x;
    }

    /**
     * <i>“The Managed Device identifier of the host device. Value could be empty even when
     * the host device is managed.”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Managed Device identifier of the host device. Value could be empty even when
     * the host device is managed.”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public ManagedAppRegistration withManagedDeviceId(String managedDeviceId) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“App management SDK version”</i>
     * 
     * @return property managementSdkVersion
     */
    @Property(name="managementSdkVersion")
    @JsonIgnore
    public Optional<String> getManagementSdkVersion() {
        return Optional.ofNullable(managementSdkVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managementSdkVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“App management SDK version”</i>
     * 
     * @param managementSdkVersion
     *            new value of {@code managementSdkVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementSdkVersion} field changed
     */
    public ManagedAppRegistration withManagementSdkVersion(String managementSdkVersion) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("managementSdkVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.managementSdkVersion = managementSdkVersion;
        return _x;
    }

    /**
     * <i>“Operating System version”</i>
     * 
     * @return property platformVersion
     */
    @Property(name="platformVersion")
    @JsonIgnore
    public Optional<String> getPlatformVersion() {
        return Optional.ofNullable(platformVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Operating System version”</i>
     * 
     * @param platformVersion
     *            new value of {@code platformVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformVersion} field changed
     */
    public ManagedAppRegistration withPlatformVersion(String platformVersion) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("platformVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.platformVersion = platformVersion;
        return _x;
    }

    /**
     * <i>“The user Id to who this app registration belongs.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The user Id to who this app registration belongs.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public ManagedAppRegistration withUserId(String userId) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.userId = userId;
        return _x;
    }

    /**
     * <i>“Version of the entity.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the entity.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public ManagedAppRegistration withVersion(String version) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.version = version;
        return _x;
    }

    public ManagedAppRegistration withUnmappedField(String name, Object value) {
        ManagedAppRegistration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Zero or more policys already applied on the registered app when it last
     * synchronized with managment service.”</i>
     * 
     * @return navigational property appliedPolicies
     */
    @NavigationProperty(name="appliedPolicies")
    @JsonIgnore
    public ManagedAppPolicyCollectionRequest getAppliedPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("appliedPolicies"), Optional.ofNullable(appliedPolicies));
    }

    /**
     * <i>“Zero or more policies admin intended for the app as of now.”</i>
     * 
     * @return navigational property intendedPolicies
     */
    @NavigationProperty(name="intendedPolicies")
    @JsonIgnore
    public ManagedAppPolicyCollectionRequest getIntendedPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("intendedPolicies"), Optional.ofNullable(intendedPolicies));
    }

    /**
     * <i>“Zero or more long running operations triggered on the app registration.”</i>
     * 
     * @return navigational property operations
     */
    @NavigationProperty(name="operations")
    @JsonIgnore
    public ManagedAppOperationCollectionRequest getOperations() {
        return new ManagedAppOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appliedPolicies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Zero or more policys already applied on the registered app when it last
     * synchronized with managment service.”</i>
     * 
     * @param appliedPolicies
     *            new value of {@code appliedPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appliedPolicies} field changed
     */
    public ManagedAppRegistration withAppliedPolicies(List<ManagedAppPolicy> appliedPolicies) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("appliedPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.appliedPolicies = appliedPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intendedPolicies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Zero or more policies admin intended for the app as of now.”</i>
     * 
     * @param intendedPolicies
     *            new value of {@code intendedPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intendedPolicies} field changed
     */
    public ManagedAppRegistration withIntendedPolicies(List<ManagedAppPolicy> intendedPolicies) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("intendedPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.intendedPolicies = intendedPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operations} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Zero or more long running operations triggered on the app registration.”</i>
     * 
     * @param operations
     *            new value of {@code operations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operations} field changed
     */
    public ManagedAppRegistration withOperations(List<ManagedAppOperation> operations) {
        ManagedAppRegistration _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedAppRegistration");
        _x.operations = operations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppRegistration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManagedAppRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManagedAppRegistration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManagedAppRegistration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManagedAppRegistration _copy() {
        ManagedAppRegistration _x = new ManagedAppRegistration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appIdentifier = appIdentifier;
        _x.applicationVersion = applicationVersion;
        _x.azureADDeviceId = azureADDeviceId;
        _x.createdDateTime = createdDateTime;
        _x.deviceManufacturer = deviceManufacturer;
        _x.deviceModel = deviceModel;
        _x.deviceName = deviceName;
        _x.deviceTag = deviceTag;
        _x.deviceType = deviceType;
        _x.flaggedReasons = flaggedReasons;
        _x.lastSyncDateTime = lastSyncDateTime;
        _x.managedDeviceId = managedDeviceId;
        _x.managementSdkVersion = managementSdkVersion;
        _x.platformVersion = platformVersion;
        _x.userId = userId;
        _x.version = version;
        _x.appliedPolicies = appliedPolicies;
        _x.intendedPolicies = intendedPolicies;
        _x.operations = operations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManagedAppRegistration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appIdentifier=");
        b.append(this.appIdentifier);
        b.append(", ");
        b.append("applicationVersion=");
        b.append(this.applicationVersion);
        b.append(", ");
        b.append("azureADDeviceId=");
        b.append(this.azureADDeviceId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deviceManufacturer=");
        b.append(this.deviceManufacturer);
        b.append(", ");
        b.append("deviceModel=");
        b.append(this.deviceModel);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("deviceTag=");
        b.append(this.deviceTag);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("flaggedReasons=");
        b.append(this.flaggedReasons);
        b.append(", ");
        b.append("lastSyncDateTime=");
        b.append(this.lastSyncDateTime);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managementSdkVersion=");
        b.append(this.managementSdkVersion);
        b.append(", ");
        b.append("platformVersion=");
        b.append(this.platformVersion);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("appliedPolicies=");
        b.append(this.appliedPolicies);
        b.append(", ");
        b.append("intendedPolicies=");
        b.append(this.intendedPolicies);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
