package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.WindowsMalwareExecutionState;
import odata.msgraph.client.beta.enums.WindowsMalwareThreatState;


/**
 * <i>“Malware state for a windows device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "detectionCount", 
    "deviceName", 
    "executionState", 
    "initialDetectionDateTime", 
    "lastStateChangeDateTime", 
    "threatState"})
@JsonInclude(Include.NON_NULL)
public class MalwareStateForWindowsDevice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.malwareStateForWindowsDevice";
    }

    @JsonProperty("detectionCount")
    protected Integer detectionCount;

    @JsonProperty("deviceName")
    protected String deviceName;

    @JsonProperty("executionState")
    protected WindowsMalwareExecutionState executionState;

    @JsonProperty("initialDetectionDateTime")
    protected OffsetDateTime initialDetectionDateTime;

    @JsonProperty("lastStateChangeDateTime")
    protected OffsetDateTime lastStateChangeDateTime;

    @JsonProperty("threatState")
    protected WindowsMalwareThreatState threatState;

    protected MalwareStateForWindowsDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMalwareStateForWindowsDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer detectionCount;
        private String deviceName;
        private WindowsMalwareExecutionState executionState;
        private OffsetDateTime initialDetectionDateTime;
        private OffsetDateTime lastStateChangeDateTime;
        private WindowsMalwareThreatState threatState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of times the malware is detected”</i>
         * 
         * @param detectionCount
         *            value of {@code detectionCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionCount(Integer detectionCount) {
            this.detectionCount = detectionCount;
            this.changedFields = changedFields.add("detectionCount");
            return this;
        }

        /**
         * <i>“Device name”</i>
         * 
         * @param deviceName
         *            value of {@code deviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            this.changedFields = changedFields.add("deviceName");
            return this;
        }

        /**
         * <i>“Execution status of the malware like blocked/executing etc”</i>
         * 
         * @param executionState
         *            value of {@code executionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder executionState(WindowsMalwareExecutionState executionState) {
            this.executionState = executionState;
            this.changedFields = changedFields.add("executionState");
            return this;
        }

        /**
         * <i>“Initial detection datetime of the malware”</i>
         * 
         * @param initialDetectionDateTime
         *            value of {@code initialDetectionDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder initialDetectionDateTime(OffsetDateTime initialDetectionDateTime) {
            this.initialDetectionDateTime = initialDetectionDateTime;
            this.changedFields = changedFields.add("initialDetectionDateTime");
            return this;
        }

        /**
         * <i>“The last time this particular threat was changed”</i>
         * 
         * @param lastStateChangeDateTime
         *            value of {@code lastStateChangeDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastStateChangeDateTime(OffsetDateTime lastStateChangeDateTime) {
            this.lastStateChangeDateTime = lastStateChangeDateTime;
            this.changedFields = changedFields.add("lastStateChangeDateTime");
            return this;
        }

        /**
         * <i>“Threat status of the malware like cleaned/quarantined/allowed etc”</i>
         * 
         * @param threatState
         *            value of {@code threatState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder threatState(WindowsMalwareThreatState threatState) {
            this.threatState = threatState;
            this.changedFields = changedFields.add("threatState");
            return this;
        }

        public MalwareStateForWindowsDevice build() {
            MalwareStateForWindowsDevice _x = new MalwareStateForWindowsDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.malwareStateForWindowsDevice";
            _x.id = id;
            _x.detectionCount = detectionCount;
            _x.deviceName = deviceName;
            _x.executionState = executionState;
            _x.initialDetectionDateTime = initialDetectionDateTime;
            _x.lastStateChangeDateTime = lastStateChangeDateTime;
            _x.threatState = threatState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of times the malware is detected”</i>
     * 
     * @return property detectionCount
     */
    @Property(name="detectionCount")
    @JsonIgnore
    public Optional<Integer> getDetectionCount() {
        return Optional.ofNullable(detectionCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code detectionCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of times the malware is detected”</i>
     * 
     * @param detectionCount
     *            new value of {@code detectionCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionCount} field changed
     */
    public MalwareStateForWindowsDevice withDetectionCount(Integer detectionCount) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = changedFields.add("detectionCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareStateForWindowsDevice");
        _x.detectionCount = detectionCount;
        return _x;
    }

    /**
     * <i>“Device name”</i>
     * 
     * @return property deviceName
     */
    @Property(name="deviceName")
    @JsonIgnore
    public Optional<String> getDeviceName() {
        return Optional.ofNullable(deviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Device name”</i>
     * 
     * @param deviceName
     *            new value of {@code deviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceName} field changed
     */
    public MalwareStateForWindowsDevice withDeviceName(String deviceName) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = changedFields.add("deviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareStateForWindowsDevice");
        _x.deviceName = deviceName;
        return _x;
    }

    /**
     * <i>“Execution status of the malware like blocked/executing etc”</i>
     * 
     * @return property executionState
     */
    @Property(name="executionState")
    @JsonIgnore
    public Optional<WindowsMalwareExecutionState> getExecutionState() {
        return Optional.ofNullable(executionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code executionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Execution status of the malware like blocked/executing etc”</i>
     * 
     * @param executionState
     *            new value of {@code executionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code executionState} field changed
     */
    public MalwareStateForWindowsDevice withExecutionState(WindowsMalwareExecutionState executionState) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = changedFields.add("executionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareStateForWindowsDevice");
        _x.executionState = executionState;
        return _x;
    }

    /**
     * <i>“Initial detection datetime of the malware”</i>
     * 
     * @return property initialDetectionDateTime
     */
    @Property(name="initialDetectionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getInitialDetectionDateTime() {
        return Optional.ofNullable(initialDetectionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * initialDetectionDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Initial detection datetime of the malware”</i>
     * 
     * @param initialDetectionDateTime
     *            new value of {@code initialDetectionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code initialDetectionDateTime} field changed
     */
    public MalwareStateForWindowsDevice withInitialDetectionDateTime(OffsetDateTime initialDetectionDateTime) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = changedFields.add("initialDetectionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareStateForWindowsDevice");
        _x.initialDetectionDateTime = initialDetectionDateTime;
        return _x;
    }

    /**
     * <i>“The last time this particular threat was changed”</i>
     * 
     * @return property lastStateChangeDateTime
     */
    @Property(name="lastStateChangeDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastStateChangeDateTime() {
        return Optional.ofNullable(lastStateChangeDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastStateChangeDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The last time this particular threat was changed”</i>
     * 
     * @param lastStateChangeDateTime
     *            new value of {@code lastStateChangeDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastStateChangeDateTime} field changed
     */
    public MalwareStateForWindowsDevice withLastStateChangeDateTime(OffsetDateTime lastStateChangeDateTime) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = changedFields.add("lastStateChangeDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareStateForWindowsDevice");
        _x.lastStateChangeDateTime = lastStateChangeDateTime;
        return _x;
    }

    /**
     * <i>“Threat status of the malware like cleaned/quarantined/allowed etc”</i>
     * 
     * @return property threatState
     */
    @Property(name="threatState")
    @JsonIgnore
    public Optional<WindowsMalwareThreatState> getThreatState() {
        return Optional.ofNullable(threatState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code threatState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Threat status of the malware like cleaned/quarantined/allowed etc”</i>
     * 
     * @param threatState
     *            new value of {@code threatState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code threatState} field changed
     */
    public MalwareStateForWindowsDevice withThreatState(WindowsMalwareThreatState threatState) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = changedFields.add("threatState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.malwareStateForWindowsDevice");
        _x.threatState = threatState;
        return _x;
    }

    public MalwareStateForWindowsDevice withUnmappedField(String name, Object value) {
        MalwareStateForWindowsDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MalwareStateForWindowsDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MalwareStateForWindowsDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MalwareStateForWindowsDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MalwareStateForWindowsDevice _copy() {
        MalwareStateForWindowsDevice _x = new MalwareStateForWindowsDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.detectionCount = detectionCount;
        _x.deviceName = deviceName;
        _x.executionState = executionState;
        _x.initialDetectionDateTime = initialDetectionDateTime;
        _x.lastStateChangeDateTime = lastStateChangeDateTime;
        _x.threatState = threatState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MalwareStateForWindowsDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("detectionCount=");
        b.append(this.detectionCount);
        b.append(", ");
        b.append("deviceName=");
        b.append(this.deviceName);
        b.append(", ");
        b.append("executionState=");
        b.append(this.executionState);
        b.append(", ");
        b.append("initialDetectionDateTime=");
        b.append(this.initialDetectionDateTime);
        b.append(", ");
        b.append("lastStateChangeDateTime=");
        b.append(this.lastStateChangeDateTime);
        b.append(", ");
        b.append("threatState=");
        b.append(this.threatState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
