package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.MailFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MessageRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserConfigurationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "childFolderCount", 
    "displayName", 
    "isHidden", 
    "parentFolderId", 
    "totalItemCount", 
    "unreadItemCount", 
    "wellKnownName", 
    "childFolders", 
    "messageRules", 
    "messages", 
    "multiValueExtendedProperties", 
    "singleValueExtendedProperties", 
    "userConfigurations"})
@JsonInclude(Include.NON_NULL)
public class MailFolder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.mailFolder";
    }

    @JsonProperty("childFolderCount")
    protected Integer childFolderCount;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isHidden")
    protected Boolean isHidden;

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("totalItemCount")
    protected Integer totalItemCount;

    @JsonProperty("unreadItemCount")
    protected Integer unreadItemCount;

    @JsonProperty("wellKnownName")
    protected String wellKnownName;

    @JsonProperty("childFolders")
    protected List<MailFolder> childFolders;

    @JsonProperty("messageRules")
    protected List<MessageRule> messageRules;

    @JsonProperty("messages")
    protected List<Message> messages;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    @JsonProperty("userConfigurations")
    protected List<UserConfiguration> userConfigurations;

    protected MailFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMailFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer childFolderCount;
        private String displayName;
        private Boolean isHidden;
        private String parentFolderId;
        private Integer totalItemCount;
        private Integer unreadItemCount;
        private String wellKnownName;
        private List<MailFolder> childFolders;
        private List<MessageRule> messageRules;
        private List<Message> messages;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private List<UserConfiguration> userConfigurations;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder childFolderCount(Integer childFolderCount) {
            this.childFolderCount = childFolderCount;
            this.changedFields = changedFields.add("childFolderCount");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.changedFields = changedFields.add("isHidden");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder totalItemCount(Integer totalItemCount) {
            this.totalItemCount = totalItemCount;
            this.changedFields = changedFields.add("totalItemCount");
            return this;
        }

        public Builder unreadItemCount(Integer unreadItemCount) {
            this.unreadItemCount = unreadItemCount;
            this.changedFields = changedFields.add("unreadItemCount");
            return this;
        }

        public Builder wellKnownName(String wellKnownName) {
            this.wellKnownName = wellKnownName;
            this.changedFields = changedFields.add("wellKnownName");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param childFolders
         *            value of {@code childFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childFolders(List<MailFolder> childFolders) {
            this.childFolders = childFolders;
            this.changedFields = changedFields.add("childFolders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param childFolders
         *            value of {@code childFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childFolders(MailFolder... childFolders) {
            return childFolders(Arrays.asList(childFolders));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param messageRules
         *            value of {@code messageRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messageRules(List<MessageRule> messageRules) {
            this.messageRules = messageRules;
            this.changedFields = changedFields.add("messageRules");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param messageRules
         *            value of {@code messageRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messageRules(MessageRule... messageRules) {
            return messageRules(Arrays.asList(messageRules));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param messages
         *            value of {@code messages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messages(List<Message> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("messages");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param messages
         *            value of {@code messages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messages(Message... messages) {
            return messages(Arrays.asList(messages));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param userConfigurations
         *            value of {@code userConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userConfigurations(List<UserConfiguration> userConfigurations) {
            this.userConfigurations = userConfigurations;
            this.changedFields = changedFields.add("userConfigurations");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param userConfigurations
         *            value of {@code userConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userConfigurations(UserConfiguration... userConfigurations) {
            return userConfigurations(Arrays.asList(userConfigurations));
        }

        public MailFolder build() {
            MailFolder _x = new MailFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.mailFolder";
            _x.id = id;
            _x.childFolderCount = childFolderCount;
            _x.displayName = displayName;
            _x.isHidden = isHidden;
            _x.parentFolderId = parentFolderId;
            _x.totalItemCount = totalItemCount;
            _x.unreadItemCount = unreadItemCount;
            _x.wellKnownName = wellKnownName;
            _x.childFolders = childFolders;
            _x.messageRules = messageRules;
            _x.messages = messages;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            _x.userConfigurations = userConfigurations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="childFolderCount")
    @JsonIgnore
    public Optional<Integer> getChildFolderCount() {
        return Optional.ofNullable(childFolderCount);
    }

    public MailFolder withChildFolderCount(Integer childFolderCount) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("childFolderCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.childFolderCount = childFolderCount;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public MailFolder withDisplayName(String displayName) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isHidden")
    @JsonIgnore
    public Optional<Boolean> getIsHidden() {
        return Optional.ofNullable(isHidden);
    }

    public MailFolder withIsHidden(Boolean isHidden) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("isHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.isHidden = isHidden;
        return _x;
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public MailFolder withParentFolderId(String parentFolderId) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="totalItemCount")
    @JsonIgnore
    public Optional<Integer> getTotalItemCount() {
        return Optional.ofNullable(totalItemCount);
    }

    public MailFolder withTotalItemCount(Integer totalItemCount) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("totalItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.totalItemCount = totalItemCount;
        return _x;
    }

    @Property(name="unreadItemCount")
    @JsonIgnore
    public Optional<Integer> getUnreadItemCount() {
        return Optional.ofNullable(unreadItemCount);
    }

    public MailFolder withUnreadItemCount(Integer unreadItemCount) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("unreadItemCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.unreadItemCount = unreadItemCount;
        return _x;
    }

    @Property(name="wellKnownName")
    @JsonIgnore
    public Optional<String> getWellKnownName() {
        return Optional.ofNullable(wellKnownName);
    }

    public MailFolder withWellKnownName(String wellKnownName) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("wellKnownName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.wellKnownName = wellKnownName;
        return _x;
    }

    public MailFolder withUnmappedField(String name, Object value) {
        MailFolder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property childFolders
     */
    @NavigationProperty(name="childFolders")
    @JsonIgnore
    public MailFolderCollectionRequest getChildFolders() {
        return new MailFolderCollectionRequest(
                        contextPath.addSegment("childFolders"), Optional.ofNullable(childFolders));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property messageRules
     */
    @NavigationProperty(name="messageRules")
    @JsonIgnore
    public MessageRuleCollectionRequest getMessageRules() {
        return new MessageRuleCollectionRequest(
                        contextPath.addSegment("messageRules"), Optional.ofNullable(messageRules));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property messages
     */
    @NavigationProperty(name="messages")
    @JsonIgnore
    public MessageCollectionRequest getMessages() {
        return new MessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.ofNullable(messages));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property userConfigurations
     */
    @NavigationProperty(name="userConfigurations")
    @JsonIgnore
    public UserConfigurationCollectionRequest getUserConfigurations() {
        return new UserConfigurationCollectionRequest(
                        contextPath.addSegment("userConfigurations"), Optional.ofNullable(userConfigurations));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code childFolders}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param childFolders
     *            new value of {@code childFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childFolders} field changed
     */
    public MailFolder withChildFolders(List<MailFolder> childFolders) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("childFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.childFolders = childFolders;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messageRules}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param messageRules
     *            new value of {@code messageRules} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messageRules} field changed
     */
    public MailFolder withMessageRules(List<MessageRule> messageRules) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("messageRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.messageRules = messageRules;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messages} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param messages
     *            new value of {@code messages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messages} field changed
     */
    public MailFolder withMessages(List<Message> messages) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("messages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.messages = messages;
        return _x;
    }

    public MailFolder withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    public MailFolder withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userConfigurations} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param userConfigurations
     *            new value of {@code userConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userConfigurations} field changed
     */
    public MailFolder withUserConfigurations(List<UserConfiguration> userConfigurations) {
        MailFolder _x = _copy();
        _x.changedFields = changedFields.add("userConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.mailFolder");
        _x.userConfigurations = userConfigurations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MailFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MailFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MailFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MailFolder _copy() {
        MailFolder _x = new MailFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.childFolderCount = childFolderCount;
        _x.displayName = displayName;
        _x.isHidden = isHidden;
        _x.parentFolderId = parentFolderId;
        _x.totalItemCount = totalItemCount;
        _x.unreadItemCount = unreadItemCount;
        _x.wellKnownName = wellKnownName;
        _x.childFolders = childFolders;
        _x.messageRules = messageRules;
        _x.messages = messages;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        _x.userConfigurations = userConfigurations;
        return _x;
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MailFolder> copy(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MailFolder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), MailFolder.class, _parameters);
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<MailFolder> move(String destinationId) {
        Preconditions.checkNotNull(destinationId, "destinationId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("DestinationId", "Edm.String", Checks.checkIsAscii(destinationId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<MailFolder>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), MailFolder.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MailFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("childFolderCount=");
        b.append(this.childFolderCount);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isHidden=");
        b.append(this.isHidden);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("totalItemCount=");
        b.append(this.totalItemCount);
        b.append(", ");
        b.append("unreadItemCount=");
        b.append(this.unreadItemCount);
        b.append(", ");
        b.append("wellKnownName=");
        b.append(this.wellKnownName);
        b.append(", ");
        b.append("childFolders=");
        b.append(this.childFolders);
        b.append(", ");
        b.append("messageRules=");
        b.append(this.messageRules);
        b.append(", ");
        b.append("messages=");
        b.append(this.messages);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append(", ");
        b.append("userConfigurations=");
        b.append(this.userConfigurations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
