package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MacOsVppAppRevokeLicensesActionResult;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.complex.VppLicensingType;
import odata.msgraph.client.beta.entity.collection.request.MacOsVppAppAssignedLicenseCollectionRequest;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;
import odata.msgraph.client.beta.enums.VppTokenAccountType;


/**
 * <i>“Contains properties and inherited properties for MacOS Volume-Purchased Program
 * (VPP) Apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appStoreUrl", 
    "bundleId", 
    "licensingType", 
    "releaseDateTime", 
    "revokeLicenseActionResults", 
    "totalLicenseCount", 
    "usedLicenseCount", 
    "vppTokenAccountType", 
    "vppTokenAppleId", 
    "vppTokenId", 
    "vppTokenOrganizationName", 
    "assignedLicenses"})
@JsonInclude(Include.NON_NULL)
public class MacOsVppApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOsVppApp";
    }

    @JsonProperty("appStoreUrl")
    protected String appStoreUrl;

    @JsonProperty("bundleId")
    protected String bundleId;

    @JsonProperty("licensingType")
    protected VppLicensingType licensingType;

    @JsonProperty("releaseDateTime")
    protected OffsetDateTime releaseDateTime;

    @JsonProperty("revokeLicenseActionResults")
    protected List<MacOsVppAppRevokeLicensesActionResult> revokeLicenseActionResults;

    @JsonProperty("revokeLicenseActionResults@nextLink")
    protected String revokeLicenseActionResultsNextLink;

    @JsonProperty("totalLicenseCount")
    protected Integer totalLicenseCount;

    @JsonProperty("usedLicenseCount")
    protected Integer usedLicenseCount;

    @JsonProperty("vppTokenAccountType")
    protected VppTokenAccountType vppTokenAccountType;

    @JsonProperty("vppTokenAppleId")
    protected String vppTokenAppleId;

    @JsonProperty("vppTokenId")
    protected String vppTokenId;

    @JsonProperty("vppTokenOrganizationName")
    protected String vppTokenOrganizationName;

    @JsonProperty("assignedLicenses")
    protected List<MacOsVppAppAssignedLicense> assignedLicenses;

    protected MacOsVppApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOsVppApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private String appStoreUrl;
        private String bundleId;
        private VppLicensingType licensingType;
        private OffsetDateTime releaseDateTime;
        private List<MacOsVppAppRevokeLicensesActionResult> revokeLicenseActionResults;
        private String revokeLicenseActionResultsNextLink;
        private Integer totalLicenseCount;
        private Integer usedLicenseCount;
        private VppTokenAccountType vppTokenAccountType;
        private String vppTokenAppleId;
        private String vppTokenId;
        private String vppTokenOrganizationName;
        private List<MacOsVppAppAssignedLicense> assignedLicenses;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        /**
         * <i>“The store URL.”</i>
         * 
         * @param appStoreUrl
         *            value of {@code appStoreUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            this.changedFields = changedFields.add("appStoreUrl");
            return this;
        }

        /**
         * <i>“The Identity Name.”</i>
         * 
         * @param bundleId
         *            value of {@code bundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            this.changedFields = changedFields.add("bundleId");
            return this;
        }

        /**
         * <i>“The supported License Type.”</i>
         * 
         * @param licensingType
         *            value of {@code licensingType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder licensingType(VppLicensingType licensingType) {
            this.licensingType = licensingType;
            this.changedFields = changedFields.add("licensingType");
            return this;
        }

        /**
         * <i>“The VPP application release date and time.”</i>
         * 
         * @param releaseDateTime
         *            value of {@code releaseDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            this.changedFields = changedFields.add("releaseDateTime");
            return this;
        }

        /**
         * <i>“Results of revoke license actions on this app.”</i>
         * 
         * @param revokeLicenseActionResults
         *            value of {@code revokeLicenseActionResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder revokeLicenseActionResults(List<MacOsVppAppRevokeLicensesActionResult> revokeLicenseActionResults) {
            this.revokeLicenseActionResults = revokeLicenseActionResults;
            this.changedFields = changedFields.add("revokeLicenseActionResults");
            return this;
        }

        /**
         * <i>“Results of revoke license actions on this app.”</i>
         * 
         * @param revokeLicenseActionResults
         *            value of {@code revokeLicenseActionResults} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder revokeLicenseActionResults(MacOsVppAppRevokeLicensesActionResult... revokeLicenseActionResults) {
            return revokeLicenseActionResults(Arrays.asList(revokeLicenseActionResults));
        }

        /**
         * <i>“Results of revoke license actions on this app.”</i>
         * 
         * @param revokeLicenseActionResultsNextLink
         *            value of {@code revokeLicenseActionResults@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder revokeLicenseActionResultsNextLink(String revokeLicenseActionResultsNextLink) {
            this.revokeLicenseActionResultsNextLink = revokeLicenseActionResultsNextLink;
            this.changedFields = changedFields.add("revokeLicenseActionResults");
            return this;
        }

        /**
         * <i>“The total number of VPP licenses.”</i>
         * 
         * @param totalLicenseCount
         *            value of {@code totalLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        /**
         * <i>“The number of VPP licenses in use.”</i>
         * 
         * @param usedLicenseCount
         *            value of {@code usedLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        /**
         * <i>“The type of volume purchase program which the given Apple Volume Purchase
         * Program Token is associated with. Possible values are: `business`, `education`.”</i>
         * 
         * @param vppTokenAccountType
         *            value of {@code vppTokenAccountType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenAccountType(VppTokenAccountType vppTokenAccountType) {
            this.vppTokenAccountType = vppTokenAccountType;
            this.changedFields = changedFields.add("vppTokenAccountType");
            return this;
        }

        /**
         * <i>“The Apple Id associated with the given Apple Volume Purchase Program Token.”</i>
         * 
         * @param vppTokenAppleId
         *            value of {@code vppTokenAppleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenAppleId(String vppTokenAppleId) {
            this.vppTokenAppleId = vppTokenAppleId;
            this.changedFields = changedFields.add("vppTokenAppleId");
            return this;
        }

        /**
         * <i>“Identifier of the VPP token associated with this app.”</i>
         * 
         * @param vppTokenId
         *            value of {@code vppTokenId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenId(String vppTokenId) {
            this.vppTokenId = vppTokenId;
            this.changedFields = changedFields.add("vppTokenId");
            return this;
        }

        /**
         * <i>“The organization associated with the Apple Volume Purchase Program Token”</i>
         * 
         * @param vppTokenOrganizationName
         *            value of {@code vppTokenOrganizationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokenOrganizationName(String vppTokenOrganizationName) {
            this.vppTokenOrganizationName = vppTokenOrganizationName;
            this.changedFields = changedFields.add("vppTokenOrganizationName");
            return this;
        }

        /**
         * <i>“The licenses assigned to this app.”</i>
         * 
         * @param assignedLicenses
         *            value of {@code assignedLicenses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignedLicenses(List<MacOsVppAppAssignedLicense> assignedLicenses) {
            this.assignedLicenses = assignedLicenses;
            this.changedFields = changedFields.add("assignedLicenses");
            return this;
        }

        /**
         * <i>“The licenses assigned to this app.”</i>
         * 
         * @param assignedLicenses
         *            value of {@code assignedLicenses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignedLicenses(MacOsVppAppAssignedLicense... assignedLicenses) {
            return assignedLicenses(Arrays.asList(assignedLicenses));
        }

        public MacOsVppApp build() {
            MacOsVppApp _x = new MacOsVppApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOsVppApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.appStoreUrl = appStoreUrl;
            _x.bundleId = bundleId;
            _x.licensingType = licensingType;
            _x.releaseDateTime = releaseDateTime;
            _x.revokeLicenseActionResults = revokeLicenseActionResults;
            _x.revokeLicenseActionResultsNextLink = revokeLicenseActionResultsNextLink;
            _x.totalLicenseCount = totalLicenseCount;
            _x.usedLicenseCount = usedLicenseCount;
            _x.vppTokenAccountType = vppTokenAccountType;
            _x.vppTokenAppleId = vppTokenAppleId;
            _x.vppTokenId = vppTokenId;
            _x.vppTokenOrganizationName = vppTokenOrganizationName;
            _x.assignedLicenses = assignedLicenses;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The store URL.”</i>
     * 
     * @return property appStoreUrl
     */
    @Property(name="appStoreUrl")
    @JsonIgnore
    public Optional<String> getAppStoreUrl() {
        return Optional.ofNullable(appStoreUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appStoreUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The store URL.”</i>
     * 
     * @param appStoreUrl
     *            new value of {@code appStoreUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreUrl} field changed
     */
    public MacOsVppApp withAppStoreUrl(String appStoreUrl) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("appStoreUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.appStoreUrl = appStoreUrl;
        return _x;
    }

    /**
     * <i>“The Identity Name.”</i>
     * 
     * @return property bundleId
     */
    @Property(name="bundleId")
    @JsonIgnore
    public Optional<String> getBundleId() {
        return Optional.ofNullable(bundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Identity Name.”</i>
     * 
     * @param bundleId
     *            new value of {@code bundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleId} field changed
     */
    public MacOsVppApp withBundleId(String bundleId) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("bundleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.bundleId = bundleId;
        return _x;
    }

    /**
     * <i>“The supported License Type.”</i>
     * 
     * @return property licensingType
     */
    @Property(name="licensingType")
    @JsonIgnore
    public Optional<VppLicensingType> getLicensingType() {
        return Optional.ofNullable(licensingType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code licensingType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The supported License Type.”</i>
     * 
     * @param licensingType
     *            new value of {@code licensingType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code licensingType} field changed
     */
    public MacOsVppApp withLicensingType(VppLicensingType licensingType) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("licensingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.licensingType = licensingType;
        return _x;
    }

    /**
     * <i>“The VPP application release date and time.”</i>
     * 
     * @return property releaseDateTime
     */
    @Property(name="releaseDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleaseDateTime() {
        return Optional.ofNullable(releaseDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code releaseDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The VPP application release date and time.”</i>
     * 
     * @param releaseDateTime
     *            new value of {@code releaseDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code releaseDateTime} field changed
     */
    public MacOsVppApp withReleaseDateTime(OffsetDateTime releaseDateTime) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("releaseDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    /**
     * <i>“Results of revoke license actions on this app.”</i>
     * 
     * @return property revokeLicenseActionResults
     */
    @Property(name="revokeLicenseActionResults")
    @JsonIgnore
    public CollectionPage<MacOsVppAppRevokeLicensesActionResult> getRevokeLicenseActionResults() {
        return new CollectionPage<MacOsVppAppRevokeLicensesActionResult>(contextPath, MacOsVppAppRevokeLicensesActionResult.class, this.revokeLicenseActionResults, Optional.ofNullable(revokeLicenseActionResultsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * revokeLicenseActionResults} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Results of revoke license actions on this app.”</i>
     * 
     * @param revokeLicenseActionResults
     *            new value of {@code revokeLicenseActionResults} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code revokeLicenseActionResults} field changed
     */
    public MacOsVppApp withRevokeLicenseActionResults(List<MacOsVppAppRevokeLicensesActionResult> revokeLicenseActionResults) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("revokeLicenseActionResults");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.revokeLicenseActionResults = revokeLicenseActionResults;
        return _x;
    }

    /**
     * <i>“Results of revoke license actions on this app.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property revokeLicenseActionResults
     */
    @Property(name="revokeLicenseActionResults")
    @JsonIgnore
    public CollectionPage<MacOsVppAppRevokeLicensesActionResult> getRevokeLicenseActionResults(HttpRequestOptions options) {
        return new CollectionPage<MacOsVppAppRevokeLicensesActionResult>(contextPath, MacOsVppAppRevokeLicensesActionResult.class, this.revokeLicenseActionResults, Optional.ofNullable(revokeLicenseActionResultsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The total number of VPP licenses.”</i>
     * 
     * @return property totalLicenseCount
     */
    @Property(name="totalLicenseCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicenseCount() {
        return Optional.ofNullable(totalLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalLicenseCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of VPP licenses.”</i>
     * 
     * @param totalLicenseCount
     *            new value of {@code totalLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicenseCount} field changed
     */
    public MacOsVppApp withTotalLicenseCount(Integer totalLicenseCount) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("totalLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.totalLicenseCount = totalLicenseCount;
        return _x;
    }

    /**
     * <i>“The number of VPP licenses in use.”</i>
     * 
     * @return property usedLicenseCount
     */
    @Property(name="usedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getUsedLicenseCount() {
        return Optional.ofNullable(usedLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usedLicenseCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of VPP licenses in use.”</i>
     * 
     * @param usedLicenseCount
     *            new value of {@code usedLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usedLicenseCount} field changed
     */
    public MacOsVppApp withUsedLicenseCount(Integer usedLicenseCount) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("usedLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    /**
     * <i>“The type of volume purchase program which the given Apple Volume Purchase
     * Program Token is associated with. Possible values are: `business`, `education`.”</i>
     * 
     * @return property vppTokenAccountType
     */
    @Property(name="vppTokenAccountType")
    @JsonIgnore
    public Optional<VppTokenAccountType> getVppTokenAccountType() {
        return Optional.ofNullable(vppTokenAccountType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vppTokenAccountType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The type of volume purchase program which the given Apple Volume Purchase
     * Program Token is associated with. Possible values are: `business`, `education`.”</i>
     * 
     * @param vppTokenAccountType
     *            new value of {@code vppTokenAccountType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenAccountType} field changed
     */
    public MacOsVppApp withVppTokenAccountType(VppTokenAccountType vppTokenAccountType) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("vppTokenAccountType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.vppTokenAccountType = vppTokenAccountType;
        return _x;
    }

    /**
     * <i>“The Apple Id associated with the given Apple Volume Purchase Program Token.”</i>
     * 
     * @return property vppTokenAppleId
     */
    @Property(name="vppTokenAppleId")
    @JsonIgnore
    public Optional<String> getVppTokenAppleId() {
        return Optional.ofNullable(vppTokenAppleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vppTokenAppleId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Apple Id associated with the given Apple Volume Purchase Program Token.”</i>
     * 
     * @param vppTokenAppleId
     *            new value of {@code vppTokenAppleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenAppleId} field changed
     */
    public MacOsVppApp withVppTokenAppleId(String vppTokenAppleId) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("vppTokenAppleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.vppTokenAppleId = vppTokenAppleId;
        return _x;
    }

    /**
     * <i>“Identifier of the VPP token associated with this app.”</i>
     * 
     * @return property vppTokenId
     */
    @Property(name="vppTokenId")
    @JsonIgnore
    public Optional<String> getVppTokenId() {
        return Optional.ofNullable(vppTokenId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vppTokenId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier of the VPP token associated with this app.”</i>
     * 
     * @param vppTokenId
     *            new value of {@code vppTokenId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenId} field changed
     */
    public MacOsVppApp withVppTokenId(String vppTokenId) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("vppTokenId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.vppTokenId = vppTokenId;
        return _x;
    }

    /**
     * <i>“The organization associated with the Apple Volume Purchase Program Token”</i>
     * 
     * @return property vppTokenOrganizationName
     */
    @Property(name="vppTokenOrganizationName")
    @JsonIgnore
    public Optional<String> getVppTokenOrganizationName() {
        return Optional.ofNullable(vppTokenOrganizationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vppTokenOrganizationName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The organization associated with the Apple Volume Purchase Program Token”</i>
     * 
     * @param vppTokenOrganizationName
     *            new value of {@code vppTokenOrganizationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokenOrganizationName} field changed
     */
    public MacOsVppApp withVppTokenOrganizationName(String vppTokenOrganizationName) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("vppTokenOrganizationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.vppTokenOrganizationName = vppTokenOrganizationName;
        return _x;
    }

    public MacOsVppApp withUnmappedField(String name, Object value) {
        MacOsVppApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The licenses assigned to this app.”</i>
     * 
     * @return navigational property assignedLicenses
     */
    @NavigationProperty(name="assignedLicenses")
    @JsonIgnore
    public MacOsVppAppAssignedLicenseCollectionRequest getAssignedLicenses() {
        return new MacOsVppAppAssignedLicenseCollectionRequest(
                        contextPath.addSegment("assignedLicenses"), Optional.ofNullable(assignedLicenses));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignedLicenses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The licenses assigned to this app.”</i>
     * 
     * @param assignedLicenses
     *            new value of {@code assignedLicenses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignedLicenses} field changed
     */
    public MacOsVppApp withAssignedLicenses(List<MacOsVppAppAssignedLicense> assignedLicenses) {
        MacOsVppApp _x = _copy();
        _x.changedFields = changedFields.add("assignedLicenses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOsVppApp");
        _x.assignedLicenses = assignedLicenses;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOsVppApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOsVppApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOsVppApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOsVppApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOsVppApp _copy() {
        MacOsVppApp _x = new MacOsVppApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.appStoreUrl = appStoreUrl;
        _x.bundleId = bundleId;
        _x.licensingType = licensingType;
        _x.releaseDateTime = releaseDateTime;
        _x.revokeLicenseActionResults = revokeLicenseActionResults;
        _x.totalLicenseCount = totalLicenseCount;
        _x.usedLicenseCount = usedLicenseCount;
        _x.vppTokenAccountType = vppTokenAccountType;
        _x.vppTokenAppleId = vppTokenAppleId;
        _x.vppTokenId = vppTokenId;
        _x.vppTokenOrganizationName = vppTokenOrganizationName;
        _x.assignedLicenses = assignedLicenses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOsVppApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("appStoreUrl=");
        b.append(this.appStoreUrl);
        b.append(", ");
        b.append("bundleId=");
        b.append(this.bundleId);
        b.append(", ");
        b.append("licensingType=");
        b.append(this.licensingType);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append(", ");
        b.append("revokeLicenseActionResults=");
        b.append(this.revokeLicenseActionResults);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append(", ");
        b.append("vppTokenAccountType=");
        b.append(this.vppTokenAccountType);
        b.append(", ");
        b.append("vppTokenAppleId=");
        b.append(this.vppTokenAppleId);
        b.append(", ");
        b.append("vppTokenId=");
        b.append(this.vppTokenId);
        b.append(", ");
        b.append("vppTokenOrganizationName=");
        b.append(this.vppTokenOrganizationName);
        b.append(", ");
        b.append("assignedLicenses=");
        b.append(this.assignedLicenses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
