package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for the MacOS Office Suite App.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class MacOSOfficeSuiteApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSOfficeSuiteApp";
    }

    protected MacOSOfficeSuiteApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSOfficeSuiteApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public MacOSOfficeSuiteApp build() {
            MacOSOfficeSuiteApp _x = new MacOSOfficeSuiteApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSOfficeSuiteApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public MacOSOfficeSuiteApp withUnmappedField(String name, Object value) {
        MacOSOfficeSuiteApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSOfficeSuiteApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSOfficeSuiteApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSOfficeSuiteApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSOfficeSuiteApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSOfficeSuiteApp _copy() {
        MacOSOfficeSuiteApp _x = new MacOSOfficeSuiteApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSOfficeSuiteApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
