package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.collection.request.MacOSTrustedRootCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.request.MacOSCertificateProfileBaseRequest;
import odata.msgraph.client.beta.entity.request.MacOSTrustedRootCertificateRequest;
import odata.msgraph.client.beta.enums.EapFastConfiguration;
import odata.msgraph.client.beta.enums.EapType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForEapTtlsType;
import odata.msgraph.client.beta.enums.WiFiAuthenticationMethod;
import odata.msgraph.client.beta.enums.WiFiProxySetting;
import odata.msgraph.client.beta.enums.WiFiSecurityType;


/**
 * <i>“MacOS Wi-Fi WPA-Enterprise/WPA2-Enterprise configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethod", 
    "eapFastConfiguration", 
    "eapType", 
    "innerAuthenticationProtocolForEapTtls", 
    "outerIdentityPrivacyTemporaryValue", 
    "trustedServerCertificateNames"})
@JsonInclude(Include.NON_NULL)
public class MacOSEnterpriseWiFiConfiguration extends MacOSWiFiConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSEnterpriseWiFiConfiguration";
    }

    @JsonProperty("authenticationMethod")
    protected WiFiAuthenticationMethod authenticationMethod;

    @JsonProperty("eapFastConfiguration")
    protected EapFastConfiguration eapFastConfiguration;

    @JsonProperty("eapType")
    protected EapType eapType;

    @JsonProperty("innerAuthenticationProtocolForEapTtls")
    protected NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;

    @JsonProperty("outerIdentityPrivacyTemporaryValue")
    protected String outerIdentityPrivacyTemporaryValue;

    @JsonProperty("trustedServerCertificateNames")
    protected List<String> trustedServerCertificateNames;

    @JsonProperty("trustedServerCertificateNames@nextLink")
    protected String trustedServerCertificateNamesNextLink;

    protected MacOSEnterpriseWiFiConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSEnterpriseWiFiConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean connectAutomatically;
        private Boolean connectWhenNetworkNameIsHidden;
        private String networkName;
        private String preSharedKey;
        private String proxyAutomaticConfigurationUrl;
        private String proxyManualAddress;
        private Integer proxyManualPort;
        private WiFiProxySetting proxySettings;
        private String ssid;
        private WiFiSecurityType wiFiSecurityType;
        private WiFiAuthenticationMethod authenticationMethod;
        private EapFastConfiguration eapFastConfiguration;
        private EapType eapType;
        private NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;
        private String outerIdentityPrivacyTemporaryValue;
        private List<String> trustedServerCertificateNames;
        private String trustedServerCertificateNamesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        public Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            this.changedFields = changedFields.add("preSharedKey");
            return this;
        }

        public Builder proxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
            this.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            this.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
            return this;
        }

        public Builder proxyManualAddress(String proxyManualAddress) {
            this.proxyManualAddress = proxyManualAddress;
            this.changedFields = changedFields.add("proxyManualAddress");
            return this;
        }

        public Builder proxyManualPort(Integer proxyManualPort) {
            this.proxyManualPort = proxyManualPort;
            this.changedFields = changedFields.add("proxyManualPort");
            return this;
        }

        public Builder proxySettings(WiFiProxySetting proxySettings) {
            this.proxySettings = proxySettings;
            this.changedFields = changedFields.add("proxySettings");
            return this;
        }

        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        public Builder wiFiSecurityType(WiFiSecurityType wiFiSecurityType) {
            this.wiFiSecurityType = wiFiSecurityType;
            this.changedFields = changedFields.add("wiFiSecurityType");
            return this;
        }

        /**
         * <i>“Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.”</i>
         * 
         * @param eapFastConfiguration
         *            value of {@code eapFastConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapFastConfiguration(EapFastConfiguration eapFastConfiguration) {
            this.eapFastConfiguration = eapFastConfiguration;
            this.changedFields = changedFields.add("eapFastConfiguration");
            return this;
        }

        /**
         * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
         * on the Wi-Fi endpoint (router).”</i>
         * 
         * @param eapType
         *            value of {@code eapType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapType(EapType eapType) {
            this.eapType = eapType;
            this.changedFields = changedFields.add("eapType");
            return this;
        }

        /**
         * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
         * Authenticationmethod is Username and Password.”</i>
         * 
         * @param innerAuthenticationProtocolForEapTtls
         *            value of {@code innerAuthenticationProtocolForEapTtls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
            this.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
            return this;
        }

        /**
         * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
         * , EAP-FAST or PEAP. This property masks usernames with the text you enter. For
         * example, if you use 'anonymous', each user that authenticates with this Wi-Fi
         * connection using their real username is displayed as 'anonymous'.”</i>
         * 
         * @param outerIdentityPrivacyTemporaryValue
         *            value of {@code outerIdentityPrivacyTemporaryValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outerIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
            this.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            this.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
            return this;
        }

        /**
         * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
         * FAST or PEAP. This is the common name used in the certificates issued by your
         * trusted certificate authority (CA). If you provide this information, you can
         * bypass the dynamic trust dialog that is displayed on end users devices when they
         * connect to this Wi-Fi network.”</i>
         * 
         * @param trustedServerCertificateNames
         *            value of {@code trustedServerCertificateNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNames(List<String> trustedServerCertificateNames) {
            this.trustedServerCertificateNames = trustedServerCertificateNames;
            this.changedFields = changedFields.add("trustedServerCertificateNames");
            return this;
        }

        /**
         * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
         * FAST or PEAP. This is the common name used in the certificates issued by your
         * trusted certificate authority (CA). If you provide this information, you can
         * bypass the dynamic trust dialog that is displayed on end users devices when they
         * connect to this Wi-Fi network.”</i>
         * 
         * @param trustedServerCertificateNames
         *            value of {@code trustedServerCertificateNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNames(String... trustedServerCertificateNames) {
            return trustedServerCertificateNames(Arrays.asList(trustedServerCertificateNames));
        }

        /**
         * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
         * FAST or PEAP. This is the common name used in the certificates issued by your
         * trusted certificate authority (CA). If you provide this information, you can
         * bypass the dynamic trust dialog that is displayed on end users devices when they
         * connect to this Wi-Fi network.”</i>
         * 
         * @param trustedServerCertificateNamesNextLink
         *            value of {@code trustedServerCertificateNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trustedServerCertificateNamesNextLink(String trustedServerCertificateNamesNextLink) {
            this.trustedServerCertificateNamesNextLink = trustedServerCertificateNamesNextLink;
            this.changedFields = changedFields.add("trustedServerCertificateNames");
            return this;
        }

        public MacOSEnterpriseWiFiConfiguration build() {
            MacOSEnterpriseWiFiConfiguration _x = new MacOSEnterpriseWiFiConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSEnterpriseWiFiConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.connectAutomatically = connectAutomatically;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.networkName = networkName;
            _x.preSharedKey = preSharedKey;
            _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            _x.proxyManualAddress = proxyManualAddress;
            _x.proxyManualPort = proxyManualPort;
            _x.proxySettings = proxySettings;
            _x.ssid = ssid;
            _x.wiFiSecurityType = wiFiSecurityType;
            _x.authenticationMethod = authenticationMethod;
            _x.eapFastConfiguration = eapFastConfiguration;
            _x.eapType = eapType;
            _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            _x.trustedServerCertificateNames = trustedServerCertificateNames;
            _x.trustedServerCertificateNamesNextLink = trustedServerCertificateNamesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<WiFiAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication Method when EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public MacOSEnterpriseWiFiConfiguration withAuthenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSEnterpriseWiFiConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.”</i>
     * 
     * @return property eapFastConfiguration
     */
    @Property(name="eapFastConfiguration")
    @JsonIgnore
    public Optional<EapFastConfiguration> getEapFastConfiguration() {
        return Optional.ofNullable(eapFastConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * eapFastConfiguration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“EAP-FAST Configuration Option when EAP-FAST is the selected EAP Type.”</i>
     * 
     * @param eapFastConfiguration
     *            new value of {@code eapFastConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapFastConfiguration} field changed
     */
    public MacOSEnterpriseWiFiConfiguration withEapFastConfiguration(EapFastConfiguration eapFastConfiguration) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapFastConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSEnterpriseWiFiConfiguration");
        _x.eapFastConfiguration = eapFastConfiguration;
        return _x;
    }

    /**
     * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
     * on the Wi-Fi endpoint (router).”</i>
     * 
     * @return property eapType
     */
    @Property(name="eapType")
    @JsonIgnore
    public Optional<EapType> getEapType() {
        return Optional.ofNullable(eapType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eapType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Extensible Authentication Protocol (EAP). Indicates the type of EAP protocol set
     * on the Wi-Fi endpoint (router).”</i>
     * 
     * @param eapType
     *            new value of {@code eapType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapType} field changed
     */
    public MacOSEnterpriseWiFiConfiguration withEapType(EapType eapType) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSEnterpriseWiFiConfiguration");
        _x.eapType = eapType;
        return _x;
    }

    /**
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @return property innerAuthenticationProtocolForEapTtls
     */
    @Property(name="innerAuthenticationProtocolForEapTtls")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForEapTtlsType> getInnerAuthenticationProtocolForEapTtls() {
        return Optional.ofNullable(innerAuthenticationProtocolForEapTtls);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForEapTtls} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @param innerAuthenticationProtocolForEapTtls
     *            new value of {@code innerAuthenticationProtocolForEapTtls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForEapTtls} field changed
     */
    public MacOSEnterpriseWiFiConfiguration withInnerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSEnterpriseWiFiConfiguration");
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        return _x;
    }

    /**
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
     * , EAP-FAST or PEAP. This property masks usernames with the text you enter. For
     * example, if you use 'anonymous', each user that authenticates with this Wi-Fi
     * connection using their real username is displayed as 'anonymous'.”</i>
     * 
     * @return property outerIdentityPrivacyTemporaryValue
     */
    @Property(name="outerIdentityPrivacyTemporaryValue")
    @JsonIgnore
    public Optional<String> getOuterIdentityPrivacyTemporaryValue() {
        return Optional.ofNullable(outerIdentityPrivacyTemporaryValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outerIdentityPrivacyTemporaryValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
     * , EAP-FAST or PEAP. This property masks usernames with the text you enter. For
     * example, if you use 'anonymous', each user that authenticates with this Wi-Fi
     * connection using their real username is displayed as 'anonymous'.”</i>
     * 
     * @param outerIdentityPrivacyTemporaryValue
     *            new value of {@code outerIdentityPrivacyTemporaryValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outerIdentityPrivacyTemporaryValue} field changed
     */
    public MacOSEnterpriseWiFiConfiguration withOuterIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSEnterpriseWiFiConfiguration");
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        return _x;
    }

    /**
     * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
     * FAST or PEAP. This is the common name used in the certificates issued by your
     * trusted certificate authority (CA). If you provide this information, you can
     * bypass the dynamic trust dialog that is displayed on end users devices when they
     * connect to this Wi-Fi network.”</i>
     * 
     * @return property trustedServerCertificateNames
     */
    @Property(name="trustedServerCertificateNames")
    @JsonIgnore
    public CollectionPage<String> getTrustedServerCertificateNames() {
        return new CollectionPage<String>(contextPath, String.class, this.trustedServerCertificateNames, Optional.ofNullable(trustedServerCertificateNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * trustedServerCertificateNames} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
     * FAST or PEAP. This is the common name used in the certificates issued by your
     * trusted certificate authority (CA). If you provide this information, you can
     * bypass the dynamic trust dialog that is displayed on end users devices when they
     * connect to this Wi-Fi network.”</i>
     * 
     * @param trustedServerCertificateNames
     *            new value of {@code trustedServerCertificateNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trustedServerCertificateNames} field changed
     */
    public MacOSEnterpriseWiFiConfiguration withTrustedServerCertificateNames(List<String> trustedServerCertificateNames) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("trustedServerCertificateNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSEnterpriseWiFiConfiguration");
        _x.trustedServerCertificateNames = trustedServerCertificateNames;
        return _x;
    }

    /**
     * <i>“Trusted server certificate names when EAP Type is configured to EAP-TLS/TTLS/
     * FAST or PEAP. This is the common name used in the certificates issued by your
     * trusted certificate authority (CA). If you provide this information, you can
     * bypass the dynamic trust dialog that is displayed on end users devices when they
     * connect to this Wi-Fi network.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property trustedServerCertificateNames
     */
    @Property(name="trustedServerCertificateNames")
    @JsonIgnore
    public CollectionPage<String> getTrustedServerCertificateNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.trustedServerCertificateNames, Optional.ofNullable(trustedServerCertificateNamesNextLink), Collections.emptyList(), options);
    }

    public MacOSEnterpriseWiFiConfiguration withUnmappedField(String name, Object value) {
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Identity Certificate for client authentication when EAP Type is configured to
     * EAP-TLS, EAP-TTLS (with Certificate Authentication), or PEAP (with Certificate
     * Authentication).”</i>
     * 
     * @return navigational property identityCertificateForClientAuthentication
     */
    @NavigationProperty(name="identityCertificateForClientAuthentication")
    @JsonIgnore
    public MacOSCertificateProfileBaseRequest getIdentityCertificateForClientAuthentication() {
        return new MacOSCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), RequestHelper.getValue(unmappedFields, "identityCertificateForClientAuthentication"));
    }

    /**
     * <i>“Trusted Root Certificate for Server Validation when EAP Type is configured to
     * EAP-TLS/TTLS/FAST or PEAP.”</i>
     * 
     * @return navigational property rootCertificateForServerValidation
     */
    @NavigationProperty(name="rootCertificateForServerValidation")
    @JsonIgnore
    public MacOSTrustedRootCertificateRequest getRootCertificateForServerValidation() {
        return new MacOSTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"), RequestHelper.getValue(unmappedFields, "rootCertificateForServerValidation"));
    }

    /**
     * <i>“Trusted Root Certificates for Server Validation when EAP Type is configured to
     * EAP-TLS/TTLS/FAST or PEAP. If you provide this value you do not need to provide
     * trustedServerCertificateNames, and vice versa. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return navigational property rootCertificatesForServerValidation
     */
    @NavigationProperty(name="rootCertificatesForServerValidation")
    @JsonIgnore
    public MacOSTrustedRootCertificateCollectionRequest getRootCertificatesForServerValidation() {
        return new MacOSTrustedRootCertificateCollectionRequest(
                        contextPath.addSegment("rootCertificatesForServerValidation"), RequestHelper.getValue(unmappedFields, "rootCertificatesForServerValidation"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSEnterpriseWiFiConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSEnterpriseWiFiConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSEnterpriseWiFiConfiguration _copy() {
        MacOSEnterpriseWiFiConfiguration _x = new MacOSEnterpriseWiFiConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.connectAutomatically = connectAutomatically;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.networkName = networkName;
        _x.preSharedKey = preSharedKey;
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        _x.proxyManualAddress = proxyManualAddress;
        _x.proxyManualPort = proxyManualPort;
        _x.proxySettings = proxySettings;
        _x.ssid = ssid;
        _x.wiFiSecurityType = wiFiSecurityType;
        _x.authenticationMethod = authenticationMethod;
        _x.eapFastConfiguration = eapFastConfiguration;
        _x.eapType = eapType;
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        _x.trustedServerCertificateNames = trustedServerCertificateNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSEnterpriseWiFiConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("preSharedKey=");
        b.append(this.preSharedKey);
        b.append(", ");
        b.append("proxyAutomaticConfigurationUrl=");
        b.append(this.proxyAutomaticConfigurationUrl);
        b.append(", ");
        b.append("proxyManualAddress=");
        b.append(this.proxyManualAddress);
        b.append(", ");
        b.append("proxyManualPort=");
        b.append(this.proxyManualPort);
        b.append(", ");
        b.append("proxySettings=");
        b.append(this.proxySettings);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("wiFiSecurityType=");
        b.append(this.wiFiSecurityType);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("eapFastConfiguration=");
        b.append(this.eapFastConfiguration);
        b.append(", ");
        b.append("eapType=");
        b.append(this.eapType);
        b.append(", ");
        b.append("innerAuthenticationProtocolForEapTtls=");
        b.append(this.innerAuthenticationProtocolForEapTtls);
        b.append(", ");
        b.append("outerIdentityPrivacyTemporaryValue=");
        b.append(this.outerIdentityPrivacyTemporaryValue);
        b.append(", ");
        b.append("trustedServerCertificateNames=");
        b.append(this.trustedServerCertificateNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
