package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MacOSIncludedApp;
import odata.msgraph.client.beta.complex.MacOSMinimumOperatingSystem;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for the MacOS DMG App.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "ignoreVersionDetection", 
    "includedApps", 
    "minimumSupportedOperatingSystem", 
    "primaryBundleId", 
    "primaryBundleVersion"})
@JsonInclude(Include.NON_NULL)
public class MacOSDmgApp extends MobileLobApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.macOSDmgApp";
    }

    @JsonProperty("ignoreVersionDetection")
    protected Boolean ignoreVersionDetection;

    @JsonProperty("includedApps")
    protected List<MacOSIncludedApp> includedApps;

    @JsonProperty("includedApps@nextLink")
    protected String includedAppsNextLink;

    @JsonProperty("minimumSupportedOperatingSystem")
    protected MacOSMinimumOperatingSystem minimumSupportedOperatingSystem;

    @JsonProperty("primaryBundleId")
    protected String primaryBundleId;

    @JsonProperty("primaryBundleVersion")
    protected String primaryBundleVersion;

    protected MacOSDmgApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMacOSDmgApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private String committedContentVersion;
        private String fileName;
        private Long size;
        private List<MobileAppContent> contentVersions;
        private Boolean ignoreVersionDetection;
        private List<MacOSIncludedApp> includedApps;
        private String includedAppsNextLink;
        private MacOSMinimumOperatingSystem minimumSupportedOperatingSystem;
        private String primaryBundleId;
        private String primaryBundleVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder committedContentVersion(String committedContentVersion) {
            this.committedContentVersion = committedContentVersion;
            this.changedFields = changedFields.add("committedContentVersion");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder contentVersions(List<MobileAppContent> contentVersions) {
            this.contentVersions = contentVersions;
            this.changedFields = changedFields.add("contentVersions");
            return this;
        }

        public Builder contentVersions(MobileAppContent... contentVersions) {
            return contentVersions(Arrays.asList(contentVersions));
        }

        /**
         * <i>“A value indicating whether the app's version will be used to detect the app
         * after it is installed on a device. Set this to true for apps that use a self-
         * update feature. Set this to false to install the app when it is not already
         * installed on the device, or if the deploying app's version number does not match
         * the version that's already installed on the device.”</i>
         * 
         * @param ignoreVersionDetection
         *            value of {@code ignoreVersionDetection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ignoreVersionDetection(Boolean ignoreVersionDetection) {
            this.ignoreVersionDetection = ignoreVersionDetection;
            this.changedFields = changedFields.add("ignoreVersionDetection");
            return this;
        }

        /**
         * <i>“The list of apps expected to be installed by the DMG.”</i>
         * 
         * @param includedApps
         *            value of {@code includedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder includedApps(List<MacOSIncludedApp> includedApps) {
            this.includedApps = includedApps;
            this.changedFields = changedFields.add("includedApps");
            return this;
        }

        /**
         * <i>“The list of apps expected to be installed by the DMG.”</i>
         * 
         * @param includedApps
         *            value of {@code includedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder includedApps(MacOSIncludedApp... includedApps) {
            return includedApps(Arrays.asList(includedApps));
        }

        /**
         * <i>“The list of apps expected to be installed by the DMG.”</i>
         * 
         * @param includedAppsNextLink
         *            value of {@code includedApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder includedAppsNextLink(String includedAppsNextLink) {
            this.includedAppsNextLink = includedAppsNextLink;
            this.changedFields = changedFields.add("includedApps");
            return this;
        }

        /**
         * <i>“The value for the minimum applicable operating system.”</i>
         * 
         * @param minimumSupportedOperatingSystem
         *            value of {@code minimumSupportedOperatingSystem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumSupportedOperatingSystem(MacOSMinimumOperatingSystem minimumSupportedOperatingSystem) {
            this.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            this.changedFields = changedFields.add("minimumSupportedOperatingSystem");
            return this;
        }

        /**
         * <i>“The primary CFBundleIdentifier of the DMG.”</i>
         * 
         * @param primaryBundleId
         *            value of {@code primaryBundleId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder primaryBundleId(String primaryBundleId) {
            this.primaryBundleId = primaryBundleId;
            this.changedFields = changedFields.add("primaryBundleId");
            return this;
        }

        /**
         * <i>“The primary CFBundleVersion of the DMG.”</i>
         * 
         * @param primaryBundleVersion
         *            value of {@code primaryBundleVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder primaryBundleVersion(String primaryBundleVersion) {
            this.primaryBundleVersion = primaryBundleVersion;
            this.changedFields = changedFields.add("primaryBundleVersion");
            return this;
        }

        public MacOSDmgApp build() {
            MacOSDmgApp _x = new MacOSDmgApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.macOSDmgApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.committedContentVersion = committedContentVersion;
            _x.fileName = fileName;
            _x.size = size;
            _x.contentVersions = contentVersions;
            _x.ignoreVersionDetection = ignoreVersionDetection;
            _x.includedApps = includedApps;
            _x.includedAppsNextLink = includedAppsNextLink;
            _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
            _x.primaryBundleId = primaryBundleId;
            _x.primaryBundleVersion = primaryBundleVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“A value indicating whether the app's version will be used to detect the app
     * after it is installed on a device. Set this to true for apps that use a self-
     * update feature. Set this to false to install the app when it is not already
     * installed on the device, or if the deploying app's version number does not match
     * the version that's already installed on the device.”</i>
     * 
     * @return property ignoreVersionDetection
     */
    @Property(name="ignoreVersionDetection")
    @JsonIgnore
    public Optional<Boolean> getIgnoreVersionDetection() {
        return Optional.ofNullable(ignoreVersionDetection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ignoreVersionDetection} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“A value indicating whether the app's version will be used to detect the app
     * after it is installed on a device. Set this to true for apps that use a self-
     * update feature. Set this to false to install the app when it is not already
     * installed on the device, or if the deploying app's version number does not match
     * the version that's already installed on the device.”</i>
     * 
     * @param ignoreVersionDetection
     *            new value of {@code ignoreVersionDetection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ignoreVersionDetection} field changed
     */
    public MacOSDmgApp withIgnoreVersionDetection(Boolean ignoreVersionDetection) {
        MacOSDmgApp _x = _copy();
        _x.changedFields = changedFields.add("ignoreVersionDetection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDmgApp");
        _x.ignoreVersionDetection = ignoreVersionDetection;
        return _x;
    }

    /**
     * <i>“The list of apps expected to be installed by the DMG.”</i>
     * 
     * @return property includedApps
     */
    @Property(name="includedApps")
    @JsonIgnore
    public CollectionPage<MacOSIncludedApp> getIncludedApps() {
        return new CollectionPage<MacOSIncludedApp>(contextPath, MacOSIncludedApp.class, this.includedApps, Optional.ofNullable(includedAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code includedApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of apps expected to be installed by the DMG.”</i>
     * 
     * @param includedApps
     *            new value of {@code includedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code includedApps} field changed
     */
    public MacOSDmgApp withIncludedApps(List<MacOSIncludedApp> includedApps) {
        MacOSDmgApp _x = _copy();
        _x.changedFields = changedFields.add("includedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDmgApp");
        _x.includedApps = includedApps;
        return _x;
    }

    /**
     * <i>“The list of apps expected to be installed by the DMG.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property includedApps
     */
    @Property(name="includedApps")
    @JsonIgnore
    public CollectionPage<MacOSIncludedApp> getIncludedApps(HttpRequestOptions options) {
        return new CollectionPage<MacOSIncludedApp>(contextPath, MacOSIncludedApp.class, this.includedApps, Optional.ofNullable(includedAppsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @return property minimumSupportedOperatingSystem
     */
    @Property(name="minimumSupportedOperatingSystem")
    @JsonIgnore
    public Optional<MacOSMinimumOperatingSystem> getMinimumSupportedOperatingSystem() {
        return Optional.ofNullable(minimumSupportedOperatingSystem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumSupportedOperatingSystem} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The value for the minimum applicable operating system.”</i>
     * 
     * @param minimumSupportedOperatingSystem
     *            new value of {@code minimumSupportedOperatingSystem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumSupportedOperatingSystem} field changed
     */
    public MacOSDmgApp withMinimumSupportedOperatingSystem(MacOSMinimumOperatingSystem minimumSupportedOperatingSystem) {
        MacOSDmgApp _x = _copy();
        _x.changedFields = changedFields.add("minimumSupportedOperatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDmgApp");
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        return _x;
    }

    /**
     * <i>“The primary CFBundleIdentifier of the DMG.”</i>
     * 
     * @return property primaryBundleId
     */
    @Property(name="primaryBundleId")
    @JsonIgnore
    public Optional<String> getPrimaryBundleId() {
        return Optional.ofNullable(primaryBundleId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code primaryBundleId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The primary CFBundleIdentifier of the DMG.”</i>
     * 
     * @param primaryBundleId
     *            new value of {@code primaryBundleId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code primaryBundleId} field changed
     */
    public MacOSDmgApp withPrimaryBundleId(String primaryBundleId) {
        MacOSDmgApp _x = _copy();
        _x.changedFields = changedFields.add("primaryBundleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDmgApp");
        _x.primaryBundleId = primaryBundleId;
        return _x;
    }

    /**
     * <i>“The primary CFBundleVersion of the DMG.”</i>
     * 
     * @return property primaryBundleVersion
     */
    @Property(name="primaryBundleVersion")
    @JsonIgnore
    public Optional<String> getPrimaryBundleVersion() {
        return Optional.ofNullable(primaryBundleVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * primaryBundleVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The primary CFBundleVersion of the DMG.”</i>
     * 
     * @param primaryBundleVersion
     *            new value of {@code primaryBundleVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code primaryBundleVersion} field changed
     */
    public MacOSDmgApp withPrimaryBundleVersion(String primaryBundleVersion) {
        MacOSDmgApp _x = _copy();
        _x.changedFields = changedFields.add("primaryBundleVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.macOSDmgApp");
        _x.primaryBundleVersion = primaryBundleVersion;
        return _x;
    }

    public MacOSDmgApp withUnmappedField(String name, Object value) {
        MacOSDmgApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSDmgApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        MacOSDmgApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public MacOSDmgApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        MacOSDmgApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private MacOSDmgApp _copy() {
        MacOSDmgApp _x = new MacOSDmgApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.committedContentVersion = committedContentVersion;
        _x.fileName = fileName;
        _x.size = size;
        _x.contentVersions = contentVersions;
        _x.ignoreVersionDetection = ignoreVersionDetection;
        _x.includedApps = includedApps;
        _x.minimumSupportedOperatingSystem = minimumSupportedOperatingSystem;
        _x.primaryBundleId = primaryBundleId;
        _x.primaryBundleVersion = primaryBundleVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MacOSDmgApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("committedContentVersion=");
        b.append(this.committedContentVersion);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("contentVersions=");
        b.append(this.contentVersions);
        b.append(", ");
        b.append("ignoreVersionDetection=");
        b.append(this.ignoreVersionDetection);
        b.append(", ");
        b.append("includedApps=");
        b.append(this.includedApps);
        b.append(", ");
        b.append("minimumSupportedOperatingSystem=");
        b.append(this.minimumSupportedOperatingSystem);
        b.append(", ");
        b.append("primaryBundleId=");
        b.append(this.primaryBundleId);
        b.append(", ");
        b.append("primaryBundleVersion=");
        b.append(this.primaryBundleVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
