package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ContentTypeInfo;
import odata.msgraph.client.beta.complex.Deleted;
import odata.msgraph.client.beta.complex.DriveRecipient;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.SharepointIds;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListItemVersionCollectionRequest;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.FieldValueSetRequest;
import odata.msgraph.client.beta.entity.request.ItemAnalyticsRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "contentType", 
    "deleted", 
    "sharepointIds", 
    "activities", 
    "driveItem", 
    "fields", 
    "versions"})
@JsonInclude(Include.NON_NULL)
public class ListItem extends BaseItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.listItem";
    }

    @JsonProperty("contentType")
    protected ContentTypeInfo contentType;

    @JsonProperty("deleted")
    protected Deleted deleted;

    @JsonProperty("sharepointIds")
    protected SharepointIds sharepointIds;

    @JsonProperty("activities")
    protected List<ItemActivityOLD> activities;

    @JsonProperty("driveItem")
    protected DriveItem driveItem;

    @JsonProperty("fields")
    protected FieldValueSet fields;

    @JsonProperty("versions")
    protected List<ListItemVersion> versions;

    protected ListItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderListItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String eTag;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;
        private ContentTypeInfo contentType;
        private Deleted deleted;
        private SharepointIds sharepointIds;
        private List<ItemActivityOLD> activities;
        private DriveItem driveItem;
        private FieldValueSet fields;
        private List<ListItemVersion> versions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder contentType(ContentTypeInfo contentType) {
            this.contentType = contentType;
            this.changedFields = changedFields.add("contentType");
            return this;
        }

        public Builder deleted(Deleted deleted) {
            this.deleted = deleted;
            this.changedFields = changedFields.add("deleted");
            return this;
        }

        public Builder sharepointIds(SharepointIds sharepointIds) {
            this.sharepointIds = sharepointIds;
            this.changedFields = changedFields.add("sharepointIds");
            return this;
        }

        public Builder activities(List<ItemActivityOLD> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(ItemActivityOLD... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder driveItem(DriveItem driveItem) {
            this.driveItem = driveItem;
            this.changedFields = changedFields.add("driveItem");
            return this;
        }

        public Builder fields(FieldValueSet fields) {
            this.fields = fields;
            this.changedFields = changedFields.add("fields");
            return this;
        }

        public Builder versions(List<ListItemVersion> versions) {
            this.versions = versions;
            this.changedFields = changedFields.add("versions");
            return this;
        }

        public Builder versions(ListItemVersion... versions) {
            return versions(Arrays.asList(versions));
        }

        public ListItem build() {
            ListItem _x = new ListItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.listItem";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.eTag = eTag;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.parentReference = parentReference;
            _x.webUrl = webUrl;
            _x.contentType = contentType;
            _x.deleted = deleted;
            _x.sharepointIds = sharepointIds;
            _x.activities = activities;
            _x.driveItem = driveItem;
            _x.fields = fields;
            _x.versions = versions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contentType")
    @JsonIgnore
    public Optional<ContentTypeInfo> getContentType() {
        return Optional.ofNullable(contentType);
    }

    public ListItem withContentType(ContentTypeInfo contentType) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("contentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.contentType = contentType;
        return _x;
    }

    @Property(name="deleted")
    @JsonIgnore
    public Optional<Deleted> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    public ListItem withDeleted(Deleted deleted) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("deleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.deleted = deleted;
        return _x;
    }

    @Property(name="sharepointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharepointIds() {
        return Optional.ofNullable(sharepointIds);
    }

    public ListItem withSharepointIds(SharepointIds sharepointIds) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("sharepointIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.sharepointIds = sharepointIds;
        return _x;
    }

    public ListItem withUnmappedField(String name, Object value) {
        ListItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public ItemActivityOLDCollectionRequest getActivities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"), Optional.ofNullable(activities));
    }

    @NavigationProperty(name="analytics")
    @JsonIgnore
    public ItemAnalyticsRequest getAnalytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"), RequestHelper.getValue(unmappedFields, "analytics"));
    }

    @NavigationProperty(name="driveItem")
    @JsonIgnore
    public DriveItemRequest getDriveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"), Optional.ofNullable(driveItem));
    }

    @NavigationProperty(name="fields")
    @JsonIgnore
    public FieldValueSetRequest getFields() {
        return new FieldValueSetRequest(contextPath.addSegment("fields"), Optional.ofNullable(fields));
    }

    @NavigationProperty(name="versions")
    @JsonIgnore
    public ListItemVersionCollectionRequest getVersions() {
        return new ListItemVersionCollectionRequest(
                        contextPath.addSegment("versions"), Optional.ofNullable(versions));
    }

    public ListItem withActivities(List<ItemActivityOLD> activities) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("activities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.activities = activities;
        return _x;
    }

    public ListItem withDriveItem(DriveItem driveItem) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("driveItem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.driveItem = driveItem;
        return _x;
    }

    public ListItem withFields(FieldValueSet fields) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("fields");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.fields = fields;
        return _x;
    }

    public ListItem withVersions(List<ListItemVersion> versions) {
        ListItem _x = _copy();
        _x.changedFields = changedFields.add("versions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.listItem");
        _x.versions = versions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ListItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ListItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ListItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ListItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ListItem _copy() {
        ListItem _x = new ListItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.eTag = eTag;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.parentReference = parentReference;
        _x.webUrl = webUrl;
        _x.contentType = contentType;
        _x.deleted = deleted;
        _x.sharepointIds = sharepointIds;
        _x.activities = activities;
        _x.driveItem = driveItem;
        _x.fields = fields;
        _x.versions = versions;
        return _x;
    }

    @Action(name = "createLink")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Permission> createLink(String type, String scope, OffsetDateTime expirationDateTime, String password, List<DriveRecipient> recipients, Boolean retainInheritedPermissions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("type", "Edm.String", Checks.checkIsAscii(type))
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .put("expirationDateTime", "Edm.DateTimeOffset", expirationDateTime)
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .put("retainInheritedPermissions", "Edm.Boolean", retainInheritedPermissions)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Permission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createLink"), Permission.class, _parameters);
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ListItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("contentType=");
        b.append(this.contentType);
        b.append(", ");
        b.append("deleted=");
        b.append(this.deleted);
        b.append(", ");
        b.append("sharepointIds=");
        b.append(this.sharepointIds);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("driveItem=");
        b.append(this.driveItem);
        b.append(", ");
        b.append("fields=");
        b.append(this.fields);
        b.append(", ");
        b.append("versions=");
        b.append(this.versions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
