package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessAction;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "access", 
    "activityDateTime", 
    "actor", 
    "driveItem"})
@JsonInclude(Include.NON_NULL)
public class ItemActivity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.itemActivity";
    }

    @JsonProperty("access")
    protected AccessAction access;

    @JsonProperty("activityDateTime")
    protected OffsetDateTime activityDateTime;

    @JsonProperty("actor")
    protected IdentitySet actor;

    @JsonProperty("driveItem")
    protected DriveItem driveItem;

    protected ItemActivity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItemActivity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AccessAction access;
        private OffsetDateTime activityDateTime;
        private IdentitySet actor;
        private DriveItem driveItem;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder access(AccessAction access) {
            this.access = access;
            this.changedFields = changedFields.add("access");
            return this;
        }

        public Builder activityDateTime(OffsetDateTime activityDateTime) {
            this.activityDateTime = activityDateTime;
            this.changedFields = changedFields.add("activityDateTime");
            return this;
        }

        public Builder actor(IdentitySet actor) {
            this.actor = actor;
            this.changedFields = changedFields.add("actor");
            return this;
        }

        public Builder driveItem(DriveItem driveItem) {
            this.driveItem = driveItem;
            this.changedFields = changedFields.add("driveItem");
            return this;
        }

        public ItemActivity build() {
            ItemActivity _x = new ItemActivity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.itemActivity";
            _x.id = id;
            _x.access = access;
            _x.activityDateTime = activityDateTime;
            _x.actor = actor;
            _x.driveItem = driveItem;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="access")
    @JsonIgnore
    public Optional<AccessAction> getAccess() {
        return Optional.ofNullable(access);
    }

    public ItemActivity withAccess(AccessAction access) {
        ItemActivity _x = _copy();
        _x.changedFields = changedFields.add("access");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivity");
        _x.access = access;
        return _x;
    }

    @Property(name="activityDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityDateTime() {
        return Optional.ofNullable(activityDateTime);
    }

    public ItemActivity withActivityDateTime(OffsetDateTime activityDateTime) {
        ItemActivity _x = _copy();
        _x.changedFields = changedFields.add("activityDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivity");
        _x.activityDateTime = activityDateTime;
        return _x;
    }

    @Property(name="actor")
    @JsonIgnore
    public Optional<IdentitySet> getActor() {
        return Optional.ofNullable(actor);
    }

    public ItemActivity withActor(IdentitySet actor) {
        ItemActivity _x = _copy();
        _x.changedFields = changedFields.add("actor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivity");
        _x.actor = actor;
        return _x;
    }

    public ItemActivity withUnmappedField(String name, Object value) {
        ItemActivity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="driveItem")
    @JsonIgnore
    public DriveItemRequest getDriveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"), Optional.ofNullable(driveItem));
    }

    public ItemActivity withDriveItem(DriveItem driveItem) {
        ItemActivity _x = _copy();
        _x.changedFields = changedFields.add("driveItem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.itemActivity");
        _x.driveItem = driveItem;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemActivity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ItemActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ItemActivity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ItemActivity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ItemActivity _copy() {
        ItemActivity _x = new ItemActivity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.access = access;
        _x.activityDateTime = activityDateTime;
        _x.actor = actor;
        _x.driveItem = driveItem;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ItemActivity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("access=");
        b.append(this.access);
        b.append(", ");
        b.append("activityDateTime=");
        b.append(this.activityDateTime);
        b.append(", ");
        b.append("actor=");
        b.append(this.actor);
        b.append(", ");
        b.append("driveItem=");
        b.append(this.driveItem);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
