package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.entity.request.ItemCategoryRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "baseUnitOfMeasureId", 
    "blocked", 
    "displayName", 
    "gtin", 
    "inventory", 
    "itemCategoryCode", 
    "itemCategoryId", 
    "lastModifiedDateTime", 
    "number", 
    "priceIncludesTax", 
    "taxGroupCode", 
    "taxGroupId", 
    "type", 
    "unitCost", 
    "unitPrice", 
    "itemCategory", 
    "picture"})
@JsonInclude(Include.NON_NULL)
public class Item extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.item";
    }

    @JsonProperty("baseUnitOfMeasureId")
    protected UUID baseUnitOfMeasureId;

    @JsonProperty("blocked")
    protected Boolean blocked;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("gtin")
    protected String gtin;

    @JsonProperty("inventory")
    protected BigDecimal inventory;

    @JsonProperty("itemCategoryCode")
    protected String itemCategoryCode;

    @JsonProperty("itemCategoryId")
    protected UUID itemCategoryId;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("number")
    protected String number;

    @JsonProperty("priceIncludesTax")
    protected Boolean priceIncludesTax;

    @JsonProperty("taxGroupCode")
    protected String taxGroupCode;

    @JsonProperty("taxGroupId")
    protected UUID taxGroupId;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("unitCost")
    protected BigDecimal unitCost;

    @JsonProperty("unitPrice")
    protected BigDecimal unitPrice;

    @JsonProperty("itemCategory")
    protected ItemCategory itemCategory;

    @JsonProperty("picture")
    protected List<Picture> picture;

    protected Item() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UUID baseUnitOfMeasureId;
        private Boolean blocked;
        private String displayName;
        private String gtin;
        private BigDecimal inventory;
        private String itemCategoryCode;
        private UUID itemCategoryId;
        private OffsetDateTime lastModifiedDateTime;
        private String number;
        private Boolean priceIncludesTax;
        private String taxGroupCode;
        private UUID taxGroupId;
        private String type;
        private BigDecimal unitCost;
        private BigDecimal unitPrice;
        private ItemCategory itemCategory;
        private List<Picture> picture;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder baseUnitOfMeasureId(UUID baseUnitOfMeasureId) {
            this.baseUnitOfMeasureId = baseUnitOfMeasureId;
            this.changedFields = changedFields.add("baseUnitOfMeasureId");
            return this;
        }

        public Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            this.changedFields = changedFields.add("blocked");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder gtin(String gtin) {
            this.gtin = gtin;
            this.changedFields = changedFields.add("gtin");
            return this;
        }

        public Builder inventory(BigDecimal inventory) {
            this.inventory = inventory;
            this.changedFields = changedFields.add("inventory");
            return this;
        }

        public Builder itemCategoryCode(String itemCategoryCode) {
            this.itemCategoryCode = itemCategoryCode;
            this.changedFields = changedFields.add("itemCategoryCode");
            return this;
        }

        public Builder itemCategoryId(UUID itemCategoryId) {
            this.itemCategoryId = itemCategoryId;
            this.changedFields = changedFields.add("itemCategoryId");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder priceIncludesTax(Boolean priceIncludesTax) {
            this.priceIncludesTax = priceIncludesTax;
            this.changedFields = changedFields.add("priceIncludesTax");
            return this;
        }

        public Builder taxGroupCode(String taxGroupCode) {
            this.taxGroupCode = taxGroupCode;
            this.changedFields = changedFields.add("taxGroupCode");
            return this;
        }

        public Builder taxGroupId(UUID taxGroupId) {
            this.taxGroupId = taxGroupId;
            this.changedFields = changedFields.add("taxGroupId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder unitCost(BigDecimal unitCost) {
            this.unitCost = unitCost;
            this.changedFields = changedFields.add("unitCost");
            return this;
        }

        public Builder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            this.changedFields = changedFields.add("unitPrice");
            return this;
        }

        public Builder itemCategory(ItemCategory itemCategory) {
            this.itemCategory = itemCategory;
            this.changedFields = changedFields.add("itemCategory");
            return this;
        }

        public Builder picture(List<Picture> picture) {
            this.picture = picture;
            this.changedFields = changedFields.add("picture");
            return this;
        }

        public Builder picture(Picture... picture) {
            return picture(Arrays.asList(picture));
        }

        public Item build() {
            Item _x = new Item();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.item";
            _x.id = id;
            _x.baseUnitOfMeasureId = baseUnitOfMeasureId;
            _x.blocked = blocked;
            _x.displayName = displayName;
            _x.gtin = gtin;
            _x.inventory = inventory;
            _x.itemCategoryCode = itemCategoryCode;
            _x.itemCategoryId = itemCategoryId;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.number = number;
            _x.priceIncludesTax = priceIncludesTax;
            _x.taxGroupCode = taxGroupCode;
            _x.taxGroupId = taxGroupId;
            _x.type = type;
            _x.unitCost = unitCost;
            _x.unitPrice = unitPrice;
            _x.itemCategory = itemCategory;
            _x.picture = picture;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="baseUnitOfMeasureId")
    @JsonIgnore
    public Optional<UUID> getBaseUnitOfMeasureId() {
        return Optional.ofNullable(baseUnitOfMeasureId);
    }

    public Item withBaseUnitOfMeasureId(UUID baseUnitOfMeasureId) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("baseUnitOfMeasureId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.baseUnitOfMeasureId = baseUnitOfMeasureId;
        return _x;
    }

    @Property(name="blocked")
    @JsonIgnore
    public Optional<Boolean> getBlocked() {
        return Optional.ofNullable(blocked);
    }

    public Item withBlocked(Boolean blocked) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("blocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.blocked = blocked;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Item withDisplayName(String displayName) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="gtin")
    @JsonIgnore
    public Optional<String> getGtin() {
        return Optional.ofNullable(gtin);
    }

    public Item withGtin(String gtin) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("gtin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.gtin = gtin;
        return _x;
    }

    @Property(name="inventory")
    @JsonIgnore
    public Optional<BigDecimal> getInventory() {
        return Optional.ofNullable(inventory);
    }

    public Item withInventory(BigDecimal inventory) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("inventory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.inventory = inventory;
        return _x;
    }

    @Property(name="itemCategoryCode")
    @JsonIgnore
    public Optional<String> getItemCategoryCode() {
        return Optional.ofNullable(itemCategoryCode);
    }

    public Item withItemCategoryCode(String itemCategoryCode) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("itemCategoryCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.itemCategoryCode = itemCategoryCode;
        return _x;
    }

    @Property(name="itemCategoryId")
    @JsonIgnore
    public Optional<UUID> getItemCategoryId() {
        return Optional.ofNullable(itemCategoryId);
    }

    public Item withItemCategoryId(UUID itemCategoryId) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("itemCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.itemCategoryId = itemCategoryId;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Item withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Item withNumber(String number) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.number = number;
        return _x;
    }

    @Property(name="priceIncludesTax")
    @JsonIgnore
    public Optional<Boolean> getPriceIncludesTax() {
        return Optional.ofNullable(priceIncludesTax);
    }

    public Item withPriceIncludesTax(Boolean priceIncludesTax) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("priceIncludesTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.priceIncludesTax = priceIncludesTax;
        return _x;
    }

    @Property(name="taxGroupCode")
    @JsonIgnore
    public Optional<String> getTaxGroupCode() {
        return Optional.ofNullable(taxGroupCode);
    }

    public Item withTaxGroupCode(String taxGroupCode) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("taxGroupCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.taxGroupCode = taxGroupCode;
        return _x;
    }

    @Property(name="taxGroupId")
    @JsonIgnore
    public Optional<UUID> getTaxGroupId() {
        return Optional.ofNullable(taxGroupId);
    }

    public Item withTaxGroupId(UUID taxGroupId) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("taxGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.taxGroupId = taxGroupId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public Item withType(String type) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.type = type;
        return _x;
    }

    @Property(name="unitCost")
    @JsonIgnore
    public Optional<BigDecimal> getUnitCost() {
        return Optional.ofNullable(unitCost);
    }

    public Item withUnitCost(BigDecimal unitCost) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("unitCost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.unitCost = unitCost;
        return _x;
    }

    @Property(name="unitPrice")
    @JsonIgnore
    public Optional<BigDecimal> getUnitPrice() {
        return Optional.ofNullable(unitPrice);
    }

    public Item withUnitPrice(BigDecimal unitPrice) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("unitPrice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.unitPrice = unitPrice;
        return _x;
    }

    public Item withUnmappedField(String name, Object value) {
        Item _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="itemCategory")
    @JsonIgnore
    public ItemCategoryRequest getItemCategory() {
        return new ItemCategoryRequest(contextPath.addSegment("itemCategory"), Optional.ofNullable(itemCategory));
    }

    @NavigationProperty(name="picture")
    @JsonIgnore
    public PictureCollectionRequest getPicture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.ofNullable(picture));
    }

    public Item withItemCategory(ItemCategory itemCategory) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("itemCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.itemCategory = itemCategory;
        return _x;
    }

    public Item withPicture(List<Picture> picture) {
        Item _x = _copy();
        _x.changedFields = changedFields.add("picture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.item");
        _x.picture = picture;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Item patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Item _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Item put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Item _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Item _copy() {
        Item _x = new Item();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.baseUnitOfMeasureId = baseUnitOfMeasureId;
        _x.blocked = blocked;
        _x.displayName = displayName;
        _x.gtin = gtin;
        _x.inventory = inventory;
        _x.itemCategoryCode = itemCategoryCode;
        _x.itemCategoryId = itemCategoryId;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.number = number;
        _x.priceIncludesTax = priceIncludesTax;
        _x.taxGroupCode = taxGroupCode;
        _x.taxGroupId = taxGroupId;
        _x.type = type;
        _x.unitCost = unitCost;
        _x.unitPrice = unitPrice;
        _x.itemCategory = itemCategory;
        _x.picture = picture;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Item[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("baseUnitOfMeasureId=");
        b.append(this.baseUnitOfMeasureId);
        b.append(", ");
        b.append("blocked=");
        b.append(this.blocked);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("gtin=");
        b.append(this.gtin);
        b.append(", ");
        b.append("inventory=");
        b.append(this.inventory);
        b.append(", ");
        b.append("itemCategoryCode=");
        b.append(this.itemCategoryCode);
        b.append(", ");
        b.append("itemCategoryId=");
        b.append(this.itemCategoryId);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("priceIncludesTax=");
        b.append(this.priceIncludesTax);
        b.append(", ");
        b.append("taxGroupCode=");
        b.append(this.taxGroupCode);
        b.append(", ");
        b.append("taxGroupId=");
        b.append(this.taxGroupId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("unitCost=");
        b.append(this.unitCost);
        b.append(", ");
        b.append("unitPrice=");
        b.append(this.unitPrice);
        b.append(", ");
        b.append("itemCategory=");
        b.append(this.itemCategory);
        b.append(", ");
        b.append("picture=");
        b.append(this.picture);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
