package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.AppleVpnAlwaysOnConfiguration;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.IosVpnSecurityAssociationParameters;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.VpnOnDemandRule;
import odata.msgraph.client.beta.complex.VpnProxyServer;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.enums.AppleVpnConnectionType;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;
import odata.msgraph.client.beta.enums.VpnClientAuthenticationType;
import odata.msgraph.client.beta.enums.VpnDeadPeerDetectionRate;
import odata.msgraph.client.beta.enums.VpnLocalIdentifier;
import odata.msgraph.client.beta.enums.VpnProviderType;
import odata.msgraph.client.beta.enums.VpnServerCertificateType;


/**
 * <i>“By providing the configurations in this profile you can instruct the iOS device
 * to connect to desired IKEv2 VPN endpoint.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowDefaultChildSecurityAssociationParameters", 
    "allowDefaultSecurityAssociationParameters", 
    "alwaysOnConfiguration", 
    "childSecurityAssociationParameters", 
    "clientAuthenticationType", 
    "deadPeerDetectionRate", 
    "disableMobilityAndMultihoming", 
    "disableRedirect", 
    "enableAlwaysOnConfiguration", 
    "enableCertificateRevocationCheck", 
    "enableEAP", 
    "enablePerfectForwardSecrecy", 
    "enableUseInternalSubnetAttributes", 
    "localIdentifier", 
    "mtuSizeInBytes", 
    "remoteIdentifier", 
    "securityAssociationParameters", 
    "serverCertificateCommonName", 
    "serverCertificateIssuerCommonName", 
    "serverCertificateType", 
    "sharedSecret", 
    "tlsMaximumVersion", 
    "tlsMinimumVersion"})
@JsonInclude(Include.NON_NULL)
public class IosikEv2VpnConfiguration extends IosVpnConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosikEv2VpnConfiguration";
    }

    @JsonProperty("allowDefaultChildSecurityAssociationParameters")
    protected Boolean allowDefaultChildSecurityAssociationParameters;

    @JsonProperty("allowDefaultSecurityAssociationParameters")
    protected Boolean allowDefaultSecurityAssociationParameters;

    @JsonProperty("alwaysOnConfiguration")
    protected AppleVpnAlwaysOnConfiguration alwaysOnConfiguration;

    @JsonProperty("childSecurityAssociationParameters")
    protected IosVpnSecurityAssociationParameters childSecurityAssociationParameters;

    @JsonProperty("clientAuthenticationType")
    protected VpnClientAuthenticationType clientAuthenticationType;

    @JsonProperty("deadPeerDetectionRate")
    protected VpnDeadPeerDetectionRate deadPeerDetectionRate;

    @JsonProperty("disableMobilityAndMultihoming")
    protected Boolean disableMobilityAndMultihoming;

    @JsonProperty("disableRedirect")
    protected Boolean disableRedirect;

    @JsonProperty("enableAlwaysOnConfiguration")
    protected Boolean enableAlwaysOnConfiguration;

    @JsonProperty("enableCertificateRevocationCheck")
    protected Boolean enableCertificateRevocationCheck;

    @JsonProperty("enableEAP")
    protected Boolean enableEAP;

    @JsonProperty("enablePerfectForwardSecrecy")
    protected Boolean enablePerfectForwardSecrecy;

    @JsonProperty("enableUseInternalSubnetAttributes")
    protected Boolean enableUseInternalSubnetAttributes;

    @JsonProperty("localIdentifier")
    protected VpnLocalIdentifier localIdentifier;

    @JsonProperty("mtuSizeInBytes")
    protected Integer mtuSizeInBytes;

    @JsonProperty("remoteIdentifier")
    protected String remoteIdentifier;

    @JsonProperty("securityAssociationParameters")
    protected IosVpnSecurityAssociationParameters securityAssociationParameters;

    @JsonProperty("serverCertificateCommonName")
    protected String serverCertificateCommonName;

    @JsonProperty("serverCertificateIssuerCommonName")
    protected String serverCertificateIssuerCommonName;

    @JsonProperty("serverCertificateType")
    protected VpnServerCertificateType serverCertificateType;

    @JsonProperty("sharedSecret")
    protected String sharedSecret;

    @JsonProperty("tlsMaximumVersion")
    protected String tlsMaximumVersion;

    @JsonProperty("tlsMinimumVersion")
    protected String tlsMinimumVersion;

    protected IosikEv2VpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosikEv2VpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private List<String> associatedDomains;
        private String associatedDomainsNextLink;
        private VpnAuthenticationMethod authenticationMethod;
        private String connectionName;
        private AppleVpnConnectionType connectionType;
        private List<KeyValue> customData;
        private String customDataNextLink;
        private List<KeyValuePair> customKeyValueData;
        private String customKeyValueDataNextLink;
        private Boolean disableOnDemandUserOverride;
        private Boolean disconnectOnIdle;
        private Integer disconnectOnIdleTimerInSeconds;
        private Boolean enablePerApp;
        private Boolean enableSplitTunneling;
        private List<String> excludedDomains;
        private String excludedDomainsNextLink;
        private String identifier;
        private String loginGroupOrDomain;
        private List<VpnOnDemandRule> onDemandRules;
        private String onDemandRulesNextLink;
        private Boolean optInToDeviceIdSharing;
        private VpnProviderType providerType;
        private VpnProxyServer proxyServer;
        private String realm;
        private String role;
        private List<String> safariDomains;
        private String safariDomainsNextLink;
        private VpnServer server;
        private String cloudName;
        private List<String> excludeList;
        private String excludeListNextLink;
        private String microsoftTunnelSiteId;
        private Boolean strictEnforcement;
        private List<AppListItem> targetedMobileApps;
        private String targetedMobileAppsNextLink;
        private String userDomain;
        private Boolean allowDefaultChildSecurityAssociationParameters;
        private Boolean allowDefaultSecurityAssociationParameters;
        private AppleVpnAlwaysOnConfiguration alwaysOnConfiguration;
        private IosVpnSecurityAssociationParameters childSecurityAssociationParameters;
        private VpnClientAuthenticationType clientAuthenticationType;
        private VpnDeadPeerDetectionRate deadPeerDetectionRate;
        private Boolean disableMobilityAndMultihoming;
        private Boolean disableRedirect;
        private Boolean enableAlwaysOnConfiguration;
        private Boolean enableCertificateRevocationCheck;
        private Boolean enableEAP;
        private Boolean enablePerfectForwardSecrecy;
        private Boolean enableUseInternalSubnetAttributes;
        private VpnLocalIdentifier localIdentifier;
        private Integer mtuSizeInBytes;
        private String remoteIdentifier;
        private IosVpnSecurityAssociationParameters securityAssociationParameters;
        private String serverCertificateCommonName;
        private String serverCertificateIssuerCommonName;
        private VpnServerCertificateType serverCertificateType;
        private String sharedSecret;
        private String tlsMaximumVersion;
        private String tlsMinimumVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        public Builder associatedDomains(List<String> associatedDomains) {
            this.associatedDomains = associatedDomains;
            this.changedFields = changedFields.add("associatedDomains");
            return this;
        }

        public Builder associatedDomains(String... associatedDomains) {
            return associatedDomains(Arrays.asList(associatedDomains));
        }

        public Builder associatedDomainsNextLink(String associatedDomainsNextLink) {
            this.associatedDomainsNextLink = associatedDomainsNextLink;
            this.changedFields = changedFields.add("associatedDomains");
            return this;
        }

        public Builder authenticationMethod(VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        public Builder connectionType(AppleVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        public Builder customData(List<KeyValue> customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder customData(KeyValue... customData) {
            return customData(Arrays.asList(customData));
        }

        public Builder customDataNextLink(String customDataNextLink) {
            this.customDataNextLink = customDataNextLink;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder customKeyValueData(List<KeyValuePair> customKeyValueData) {
            this.customKeyValueData = customKeyValueData;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        public Builder customKeyValueData(KeyValuePair... customKeyValueData) {
            return customKeyValueData(Arrays.asList(customKeyValueData));
        }

        public Builder customKeyValueDataNextLink(String customKeyValueDataNextLink) {
            this.customKeyValueDataNextLink = customKeyValueDataNextLink;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        public Builder disableOnDemandUserOverride(Boolean disableOnDemandUserOverride) {
            this.disableOnDemandUserOverride = disableOnDemandUserOverride;
            this.changedFields = changedFields.add("disableOnDemandUserOverride");
            return this;
        }

        public Builder disconnectOnIdle(Boolean disconnectOnIdle) {
            this.disconnectOnIdle = disconnectOnIdle;
            this.changedFields = changedFields.add("disconnectOnIdle");
            return this;
        }

        public Builder disconnectOnIdleTimerInSeconds(Integer disconnectOnIdleTimerInSeconds) {
            this.disconnectOnIdleTimerInSeconds = disconnectOnIdleTimerInSeconds;
            this.changedFields = changedFields.add("disconnectOnIdleTimerInSeconds");
            return this;
        }

        public Builder enablePerApp(Boolean enablePerApp) {
            this.enablePerApp = enablePerApp;
            this.changedFields = changedFields.add("enablePerApp");
            return this;
        }

        public Builder enableSplitTunneling(Boolean enableSplitTunneling) {
            this.enableSplitTunneling = enableSplitTunneling;
            this.changedFields = changedFields.add("enableSplitTunneling");
            return this;
        }

        public Builder excludedDomains(List<String> excludedDomains) {
            this.excludedDomains = excludedDomains;
            this.changedFields = changedFields.add("excludedDomains");
            return this;
        }

        public Builder excludedDomains(String... excludedDomains) {
            return excludedDomains(Arrays.asList(excludedDomains));
        }

        public Builder excludedDomainsNextLink(String excludedDomainsNextLink) {
            this.excludedDomainsNextLink = excludedDomainsNextLink;
            this.changedFields = changedFields.add("excludedDomains");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        public Builder loginGroupOrDomain(String loginGroupOrDomain) {
            this.loginGroupOrDomain = loginGroupOrDomain;
            this.changedFields = changedFields.add("loginGroupOrDomain");
            return this;
        }

        public Builder onDemandRules(List<VpnOnDemandRule> onDemandRules) {
            this.onDemandRules = onDemandRules;
            this.changedFields = changedFields.add("onDemandRules");
            return this;
        }

        public Builder onDemandRules(VpnOnDemandRule... onDemandRules) {
            return onDemandRules(Arrays.asList(onDemandRules));
        }

        public Builder onDemandRulesNextLink(String onDemandRulesNextLink) {
            this.onDemandRulesNextLink = onDemandRulesNextLink;
            this.changedFields = changedFields.add("onDemandRules");
            return this;
        }

        public Builder optInToDeviceIdSharing(Boolean optInToDeviceIdSharing) {
            this.optInToDeviceIdSharing = optInToDeviceIdSharing;
            this.changedFields = changedFields.add("optInToDeviceIdSharing");
            return this;
        }

        public Builder providerType(VpnProviderType providerType) {
            this.providerType = providerType;
            this.changedFields = changedFields.add("providerType");
            return this;
        }

        public Builder proxyServer(VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            this.changedFields = changedFields.add("realm");
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder safariDomains(List<String> safariDomains) {
            this.safariDomains = safariDomains;
            this.changedFields = changedFields.add("safariDomains");
            return this;
        }

        public Builder safariDomains(String... safariDomains) {
            return safariDomains(Arrays.asList(safariDomains));
        }

        public Builder safariDomainsNextLink(String safariDomainsNextLink) {
            this.safariDomainsNextLink = safariDomainsNextLink;
            this.changedFields = changedFields.add("safariDomains");
            return this;
        }

        public Builder server(VpnServer server) {
            this.server = server;
            this.changedFields = changedFields.add("server");
            return this;
        }

        public Builder cloudName(String cloudName) {
            this.cloudName = cloudName;
            this.changedFields = changedFields.add("cloudName");
            return this;
        }

        public Builder excludeList(List<String> excludeList) {
            this.excludeList = excludeList;
            this.changedFields = changedFields.add("excludeList");
            return this;
        }

        public Builder excludeList(String... excludeList) {
            return excludeList(Arrays.asList(excludeList));
        }

        public Builder excludeListNextLink(String excludeListNextLink) {
            this.excludeListNextLink = excludeListNextLink;
            this.changedFields = changedFields.add("excludeList");
            return this;
        }

        public Builder microsoftTunnelSiteId(String microsoftTunnelSiteId) {
            this.microsoftTunnelSiteId = microsoftTunnelSiteId;
            this.changedFields = changedFields.add("microsoftTunnelSiteId");
            return this;
        }

        public Builder strictEnforcement(Boolean strictEnforcement) {
            this.strictEnforcement = strictEnforcement;
            this.changedFields = changedFields.add("strictEnforcement");
            return this;
        }

        public Builder targetedMobileApps(List<AppListItem> targetedMobileApps) {
            this.targetedMobileApps = targetedMobileApps;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        public Builder targetedMobileApps(AppListItem... targetedMobileApps) {
            return targetedMobileApps(Arrays.asList(targetedMobileApps));
        }

        public Builder targetedMobileAppsNextLink(String targetedMobileAppsNextLink) {
            this.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        public Builder userDomain(String userDomain) {
            this.userDomain = userDomain;
            this.changedFields = changedFields.add("userDomain");
            return this;
        }

        /**
         * <i>“Allows the use of child security association parameters by setting all
         * parameters to the device's default unless explicitly specified.”</i>
         * 
         * @param allowDefaultChildSecurityAssociationParameters
         *            value of {@code allowDefaultChildSecurityAssociationParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDefaultChildSecurityAssociationParameters(Boolean allowDefaultChildSecurityAssociationParameters) {
            this.allowDefaultChildSecurityAssociationParameters = allowDefaultChildSecurityAssociationParameters;
            this.changedFields = changedFields.add("allowDefaultChildSecurityAssociationParameters");
            return this;
        }

        /**
         * <i>“Allows the use of security association parameters by setting all parameters to
         * the device's default unless explicitly specified.”</i>
         * 
         * @param allowDefaultSecurityAssociationParameters
         *            value of {@code allowDefaultSecurityAssociationParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowDefaultSecurityAssociationParameters(Boolean allowDefaultSecurityAssociationParameters) {
            this.allowDefaultSecurityAssociationParameters = allowDefaultSecurityAssociationParameters;
            this.changedFields = changedFields.add("allowDefaultSecurityAssociationParameters");
            return this;
        }

        /**
         * <i>“AlwaysOn Configuration”</i>
         * 
         * @param alwaysOnConfiguration
         *            value of {@code alwaysOnConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder alwaysOnConfiguration(AppleVpnAlwaysOnConfiguration alwaysOnConfiguration) {
            this.alwaysOnConfiguration = alwaysOnConfiguration;
            this.changedFields = changedFields.add("alwaysOnConfiguration");
            return this;
        }

        /**
         * <i>“Child Security Association Parameters”</i>
         * 
         * @param childSecurityAssociationParameters
         *            value of {@code childSecurityAssociationParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childSecurityAssociationParameters(IosVpnSecurityAssociationParameters childSecurityAssociationParameters) {
            this.childSecurityAssociationParameters = childSecurityAssociationParameters;
            this.changedFields = changedFields.add("childSecurityAssociationParameters");
            return this;
        }

        /**
         * <i>“Type of Client Authentication the VPN client will use.”</i>
         * 
         * @param clientAuthenticationType
         *            value of {@code clientAuthenticationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder clientAuthenticationType(VpnClientAuthenticationType clientAuthenticationType) {
            this.clientAuthenticationType = clientAuthenticationType;
            this.changedFields = changedFields.add("clientAuthenticationType");
            return this;
        }

        /**
         * <i>“Determine how often to check if a peer connection is still active.”</i>
         * 
         * @param deadPeerDetectionRate
         *            value of {@code deadPeerDetectionRate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deadPeerDetectionRate(VpnDeadPeerDetectionRate deadPeerDetectionRate) {
            this.deadPeerDetectionRate = deadPeerDetectionRate;
            this.changedFields = changedFields.add("deadPeerDetectionRate");
            return this;
        }

        /**
         * <i>“Disable MOBIKE”</i>
         * 
         * @param disableMobilityAndMultihoming
         *            value of {@code disableMobilityAndMultihoming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableMobilityAndMultihoming(Boolean disableMobilityAndMultihoming) {
            this.disableMobilityAndMultihoming = disableMobilityAndMultihoming;
            this.changedFields = changedFields.add("disableMobilityAndMultihoming");
            return this;
        }

        /**
         * <i>“Disable Redirect”</i>
         * 
         * @param disableRedirect
         *            value of {@code disableRedirect} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableRedirect(Boolean disableRedirect) {
            this.disableRedirect = disableRedirect;
            this.changedFields = changedFields.add("disableRedirect");
            return this;
        }

        /**
         * <i>“Determines if Always on VPN is enabled”</i>
         * 
         * @param enableAlwaysOnConfiguration
         *            value of {@code enableAlwaysOnConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableAlwaysOnConfiguration(Boolean enableAlwaysOnConfiguration) {
            this.enableAlwaysOnConfiguration = enableAlwaysOnConfiguration;
            this.changedFields = changedFields.add("enableAlwaysOnConfiguration");
            return this;
        }

        /**
         * <i>“Enables a best-effort revocation check; server response timeouts will not cause
         * it to fail”</i>
         * 
         * @param enableCertificateRevocationCheck
         *            value of {@code enableCertificateRevocationCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableCertificateRevocationCheck(Boolean enableCertificateRevocationCheck) {
            this.enableCertificateRevocationCheck = enableCertificateRevocationCheck;
            this.changedFields = changedFields.add("enableCertificateRevocationCheck");
            return this;
        }

        /**
         * <i>“Enables EAP only authentication”</i>
         * 
         * @param enableEAP
         *            value of {@code enableEAP} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableEAP(Boolean enableEAP) {
            this.enableEAP = enableEAP;
            this.changedFields = changedFields.add("enableEAP");
            return this;
        }

        /**
         * <i>“Enable Perfect Forward Secrecy (PFS).”</i>
         * 
         * @param enablePerfectForwardSecrecy
         *            value of {@code enablePerfectForwardSecrecy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enablePerfectForwardSecrecy(Boolean enablePerfectForwardSecrecy) {
            this.enablePerfectForwardSecrecy = enablePerfectForwardSecrecy;
            this.changedFields = changedFields.add("enablePerfectForwardSecrecy");
            return this;
        }

        /**
         * <i>“Enable Use Internal Subnet Attributes.”</i>
         * 
         * @param enableUseInternalSubnetAttributes
         *            value of {@code enableUseInternalSubnetAttributes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enableUseInternalSubnetAttributes(Boolean enableUseInternalSubnetAttributes) {
            this.enableUseInternalSubnetAttributes = enableUseInternalSubnetAttributes;
            this.changedFields = changedFields.add("enableUseInternalSubnetAttributes");
            return this;
        }

        /**
         * <i>“Method of identifying the client that is trying to connect via VPN.”</i>
         * 
         * @param localIdentifier
         *            value of {@code localIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder localIdentifier(VpnLocalIdentifier localIdentifier) {
            this.localIdentifier = localIdentifier;
            this.changedFields = changedFields.add("localIdentifier");
            return this;
        }

        /**
         * <i>“Maximum transmission unit. Valid values 1280 to 1400”</i>
         * 
         * @param mtuSizeInBytes
         *            value of {@code mtuSizeInBytes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mtuSizeInBytes(Integer mtuSizeInBytes) {
            this.mtuSizeInBytes = mtuSizeInBytes;
            this.changedFields = changedFields.add("mtuSizeInBytes");
            return this;
        }

        /**
         * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
         * ASN1DN”</i>
         * 
         * @param remoteIdentifier
         *            value of {@code remoteIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remoteIdentifier(String remoteIdentifier) {
            this.remoteIdentifier = remoteIdentifier;
            this.changedFields = changedFields.add("remoteIdentifier");
            return this;
        }

        /**
         * <i>“Security Association Parameters”</i>
         * 
         * @param securityAssociationParameters
         *            value of {@code securityAssociationParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityAssociationParameters(IosVpnSecurityAssociationParameters securityAssociationParameters) {
            this.securityAssociationParameters = securityAssociationParameters;
            this.changedFields = changedFields.add("securityAssociationParameters");
            return this;
        }

        /**
         * <i>“Common name of the IKEv2 Server Certificate used in Server Authentication”</i>
         * 
         * @param serverCertificateCommonName
         *            value of {@code serverCertificateCommonName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serverCertificateCommonName(String serverCertificateCommonName) {
            this.serverCertificateCommonName = serverCertificateCommonName;
            this.changedFields = changedFields.add("serverCertificateCommonName");
            return this;
        }

        /**
         * <i>“Issuer Common name of the IKEv2 Server Certificate issuer used in Authentication”</i>
         * 
         * @param serverCertificateIssuerCommonName
         *            value of {@code serverCertificateIssuerCommonName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serverCertificateIssuerCommonName(String serverCertificateIssuerCommonName) {
            this.serverCertificateIssuerCommonName = serverCertificateIssuerCommonName;
            this.changedFields = changedFields.add("serverCertificateIssuerCommonName");
            return this;
        }

        /**
         * <i>“The type of certificate the VPN server will present to the VPN client for
         * authentication.”</i>
         * 
         * @param serverCertificateType
         *            value of {@code serverCertificateType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serverCertificateType(VpnServerCertificateType serverCertificateType) {
            this.serverCertificateType = serverCertificateType;
            this.changedFields = changedFields.add("serverCertificateType");
            return this;
        }

        /**
         * <i>“Used when Shared Secret Authentication is selected”</i>
         * 
         * @param sharedSecret
         *            value of {@code sharedSecret} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
            this.changedFields = changedFields.add("sharedSecret");
            return this;
        }

        /**
         * <i>“The maximum TLS version to be used with EAP-TLS authentication”</i>
         * 
         * @param tlsMaximumVersion
         *            value of {@code tlsMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tlsMaximumVersion(String tlsMaximumVersion) {
            this.tlsMaximumVersion = tlsMaximumVersion;
            this.changedFields = changedFields.add("tlsMaximumVersion");
            return this;
        }

        /**
         * <i>“The minimum TLS version to be used with EAP-TLS authentication”</i>
         * 
         * @param tlsMinimumVersion
         *            value of {@code tlsMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tlsMinimumVersion(String tlsMinimumVersion) {
            this.tlsMinimumVersion = tlsMinimumVersion;
            this.changedFields = changedFields.add("tlsMinimumVersion");
            return this;
        }

        public IosikEv2VpnConfiguration build() {
            IosikEv2VpnConfiguration _x = new IosikEv2VpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosikEv2VpnConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.associatedDomains = associatedDomains;
            _x.associatedDomainsNextLink = associatedDomainsNextLink;
            _x.authenticationMethod = authenticationMethod;
            _x.connectionName = connectionName;
            _x.connectionType = connectionType;
            _x.customData = customData;
            _x.customDataNextLink = customDataNextLink;
            _x.customKeyValueData = customKeyValueData;
            _x.customKeyValueDataNextLink = customKeyValueDataNextLink;
            _x.disableOnDemandUserOverride = disableOnDemandUserOverride;
            _x.disconnectOnIdle = disconnectOnIdle;
            _x.disconnectOnIdleTimerInSeconds = disconnectOnIdleTimerInSeconds;
            _x.enablePerApp = enablePerApp;
            _x.enableSplitTunneling = enableSplitTunneling;
            _x.excludedDomains = excludedDomains;
            _x.excludedDomainsNextLink = excludedDomainsNextLink;
            _x.identifier = identifier;
            _x.loginGroupOrDomain = loginGroupOrDomain;
            _x.onDemandRules = onDemandRules;
            _x.onDemandRulesNextLink = onDemandRulesNextLink;
            _x.optInToDeviceIdSharing = optInToDeviceIdSharing;
            _x.providerType = providerType;
            _x.proxyServer = proxyServer;
            _x.realm = realm;
            _x.role = role;
            _x.safariDomains = safariDomains;
            _x.safariDomainsNextLink = safariDomainsNextLink;
            _x.server = server;
            _x.cloudName = cloudName;
            _x.excludeList = excludeList;
            _x.excludeListNextLink = excludeListNextLink;
            _x.microsoftTunnelSiteId = microsoftTunnelSiteId;
            _x.strictEnforcement = strictEnforcement;
            _x.targetedMobileApps = targetedMobileApps;
            _x.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            _x.userDomain = userDomain;
            _x.allowDefaultChildSecurityAssociationParameters = allowDefaultChildSecurityAssociationParameters;
            _x.allowDefaultSecurityAssociationParameters = allowDefaultSecurityAssociationParameters;
            _x.alwaysOnConfiguration = alwaysOnConfiguration;
            _x.childSecurityAssociationParameters = childSecurityAssociationParameters;
            _x.clientAuthenticationType = clientAuthenticationType;
            _x.deadPeerDetectionRate = deadPeerDetectionRate;
            _x.disableMobilityAndMultihoming = disableMobilityAndMultihoming;
            _x.disableRedirect = disableRedirect;
            _x.enableAlwaysOnConfiguration = enableAlwaysOnConfiguration;
            _x.enableCertificateRevocationCheck = enableCertificateRevocationCheck;
            _x.enableEAP = enableEAP;
            _x.enablePerfectForwardSecrecy = enablePerfectForwardSecrecy;
            _x.enableUseInternalSubnetAttributes = enableUseInternalSubnetAttributes;
            _x.localIdentifier = localIdentifier;
            _x.mtuSizeInBytes = mtuSizeInBytes;
            _x.remoteIdentifier = remoteIdentifier;
            _x.securityAssociationParameters = securityAssociationParameters;
            _x.serverCertificateCommonName = serverCertificateCommonName;
            _x.serverCertificateIssuerCommonName = serverCertificateIssuerCommonName;
            _x.serverCertificateType = serverCertificateType;
            _x.sharedSecret = sharedSecret;
            _x.tlsMaximumVersion = tlsMaximumVersion;
            _x.tlsMinimumVersion = tlsMinimumVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Allows the use of child security association parameters by setting all
     * parameters to the device's default unless explicitly specified.”</i>
     * 
     * @return property allowDefaultChildSecurityAssociationParameters
     */
    @Property(name="allowDefaultChildSecurityAssociationParameters")
    @JsonIgnore
    public Optional<Boolean> getAllowDefaultChildSecurityAssociationParameters() {
        return Optional.ofNullable(allowDefaultChildSecurityAssociationParameters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDefaultChildSecurityAssociationParameters} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows the use of child security association parameters by setting all
     * parameters to the device's default unless explicitly specified.”</i>
     * 
     * @param allowDefaultChildSecurityAssociationParameters
     *            new value of {@code allowDefaultChildSecurityAssociationParameters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDefaultChildSecurityAssociationParameters} field changed
     */
    public IosikEv2VpnConfiguration withAllowDefaultChildSecurityAssociationParameters(Boolean allowDefaultChildSecurityAssociationParameters) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowDefaultChildSecurityAssociationParameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.allowDefaultChildSecurityAssociationParameters = allowDefaultChildSecurityAssociationParameters;
        return _x;
    }

    /**
     * <i>“Allows the use of security association parameters by setting all parameters to
     * the device's default unless explicitly specified.”</i>
     * 
     * @return property allowDefaultSecurityAssociationParameters
     */
    @Property(name="allowDefaultSecurityAssociationParameters")
    @JsonIgnore
    public Optional<Boolean> getAllowDefaultSecurityAssociationParameters() {
        return Optional.ofNullable(allowDefaultSecurityAssociationParameters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowDefaultSecurityAssociationParameters} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Allows the use of security association parameters by setting all parameters to
     * the device's default unless explicitly specified.”</i>
     * 
     * @param allowDefaultSecurityAssociationParameters
     *            new value of {@code allowDefaultSecurityAssociationParameters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowDefaultSecurityAssociationParameters} field changed
     */
    public IosikEv2VpnConfiguration withAllowDefaultSecurityAssociationParameters(Boolean allowDefaultSecurityAssociationParameters) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("allowDefaultSecurityAssociationParameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.allowDefaultSecurityAssociationParameters = allowDefaultSecurityAssociationParameters;
        return _x;
    }

    /**
     * <i>“AlwaysOn Configuration”</i>
     * 
     * @return property alwaysOnConfiguration
     */
    @Property(name="alwaysOnConfiguration")
    @JsonIgnore
    public Optional<AppleVpnAlwaysOnConfiguration> getAlwaysOnConfiguration() {
        return Optional.ofNullable(alwaysOnConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * alwaysOnConfiguration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“AlwaysOn Configuration”</i>
     * 
     * @param alwaysOnConfiguration
     *            new value of {@code alwaysOnConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code alwaysOnConfiguration} field changed
     */
    public IosikEv2VpnConfiguration withAlwaysOnConfiguration(AppleVpnAlwaysOnConfiguration alwaysOnConfiguration) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("alwaysOnConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.alwaysOnConfiguration = alwaysOnConfiguration;
        return _x;
    }

    /**
     * <i>“Child Security Association Parameters”</i>
     * 
     * @return property childSecurityAssociationParameters
     */
    @Property(name="childSecurityAssociationParameters")
    @JsonIgnore
    public Optional<IosVpnSecurityAssociationParameters> getChildSecurityAssociationParameters() {
        return Optional.ofNullable(childSecurityAssociationParameters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * childSecurityAssociationParameters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Child Security Association Parameters”</i>
     * 
     * @param childSecurityAssociationParameters
     *            new value of {@code childSecurityAssociationParameters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childSecurityAssociationParameters} field changed
     */
    public IosikEv2VpnConfiguration withChildSecurityAssociationParameters(IosVpnSecurityAssociationParameters childSecurityAssociationParameters) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("childSecurityAssociationParameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.childSecurityAssociationParameters = childSecurityAssociationParameters;
        return _x;
    }

    /**
     * <i>“Type of Client Authentication the VPN client will use.”</i>
     * 
     * @return property clientAuthenticationType
     */
    @Property(name="clientAuthenticationType")
    @JsonIgnore
    public Optional<VpnClientAuthenticationType> getClientAuthenticationType() {
        return Optional.ofNullable(clientAuthenticationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * clientAuthenticationType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Type of Client Authentication the VPN client will use.”</i>
     * 
     * @param clientAuthenticationType
     *            new value of {@code clientAuthenticationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code clientAuthenticationType} field changed
     */
    public IosikEv2VpnConfiguration withClientAuthenticationType(VpnClientAuthenticationType clientAuthenticationType) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("clientAuthenticationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.clientAuthenticationType = clientAuthenticationType;
        return _x;
    }

    /**
     * <i>“Determine how often to check if a peer connection is still active.”</i>
     * 
     * @return property deadPeerDetectionRate
     */
    @Property(name="deadPeerDetectionRate")
    @JsonIgnore
    public Optional<VpnDeadPeerDetectionRate> getDeadPeerDetectionRate() {
        return Optional.ofNullable(deadPeerDetectionRate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deadPeerDetectionRate} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Determine how often to check if a peer connection is still active.”</i>
     * 
     * @param deadPeerDetectionRate
     *            new value of {@code deadPeerDetectionRate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deadPeerDetectionRate} field changed
     */
    public IosikEv2VpnConfiguration withDeadPeerDetectionRate(VpnDeadPeerDetectionRate deadPeerDetectionRate) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deadPeerDetectionRate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.deadPeerDetectionRate = deadPeerDetectionRate;
        return _x;
    }

    /**
     * <i>“Disable MOBIKE”</i>
     * 
     * @return property disableMobilityAndMultihoming
     */
    @Property(name="disableMobilityAndMultihoming")
    @JsonIgnore
    public Optional<Boolean> getDisableMobilityAndMultihoming() {
        return Optional.ofNullable(disableMobilityAndMultihoming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableMobilityAndMultihoming} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Disable MOBIKE”</i>
     * 
     * @param disableMobilityAndMultihoming
     *            new value of {@code disableMobilityAndMultihoming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableMobilityAndMultihoming} field changed
     */
    public IosikEv2VpnConfiguration withDisableMobilityAndMultihoming(Boolean disableMobilityAndMultihoming) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableMobilityAndMultihoming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.disableMobilityAndMultihoming = disableMobilityAndMultihoming;
        return _x;
    }

    /**
     * <i>“Disable Redirect”</i>
     * 
     * @return property disableRedirect
     */
    @Property(name="disableRedirect")
    @JsonIgnore
    public Optional<Boolean> getDisableRedirect() {
        return Optional.ofNullable(disableRedirect);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code disableRedirect}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Disable Redirect”</i>
     * 
     * @param disableRedirect
     *            new value of {@code disableRedirect} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableRedirect} field changed
     */
    public IosikEv2VpnConfiguration withDisableRedirect(Boolean disableRedirect) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("disableRedirect");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.disableRedirect = disableRedirect;
        return _x;
    }

    /**
     * <i>“Determines if Always on VPN is enabled”</i>
     * 
     * @return property enableAlwaysOnConfiguration
     */
    @Property(name="enableAlwaysOnConfiguration")
    @JsonIgnore
    public Optional<Boolean> getEnableAlwaysOnConfiguration() {
        return Optional.ofNullable(enableAlwaysOnConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableAlwaysOnConfiguration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines if Always on VPN is enabled”</i>
     * 
     * @param enableAlwaysOnConfiguration
     *            new value of {@code enableAlwaysOnConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableAlwaysOnConfiguration} field changed
     */
    public IosikEv2VpnConfiguration withEnableAlwaysOnConfiguration(Boolean enableAlwaysOnConfiguration) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableAlwaysOnConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.enableAlwaysOnConfiguration = enableAlwaysOnConfiguration;
        return _x;
    }

    /**
     * <i>“Enables a best-effort revocation check; server response timeouts will not cause
     * it to fail”</i>
     * 
     * @return property enableCertificateRevocationCheck
     */
    @Property(name="enableCertificateRevocationCheck")
    @JsonIgnore
    public Optional<Boolean> getEnableCertificateRevocationCheck() {
        return Optional.ofNullable(enableCertificateRevocationCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableCertificateRevocationCheck} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enables a best-effort revocation check; server response timeouts will not cause
     * it to fail”</i>
     * 
     * @param enableCertificateRevocationCheck
     *            new value of {@code enableCertificateRevocationCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableCertificateRevocationCheck} field changed
     */
    public IosikEv2VpnConfiguration withEnableCertificateRevocationCheck(Boolean enableCertificateRevocationCheck) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableCertificateRevocationCheck");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.enableCertificateRevocationCheck = enableCertificateRevocationCheck;
        return _x;
    }

    /**
     * <i>“Enables EAP only authentication”</i>
     * 
     * @return property enableEAP
     */
    @Property(name="enableEAP")
    @JsonIgnore
    public Optional<Boolean> getEnableEAP() {
        return Optional.ofNullable(enableEAP);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enableEAP} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Enables EAP only authentication”</i>
     * 
     * @param enableEAP
     *            new value of {@code enableEAP} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableEAP} field changed
     */
    public IosikEv2VpnConfiguration withEnableEAP(Boolean enableEAP) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableEAP");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.enableEAP = enableEAP;
        return _x;
    }

    /**
     * <i>“Enable Perfect Forward Secrecy (PFS).”</i>
     * 
     * @return property enablePerfectForwardSecrecy
     */
    @Property(name="enablePerfectForwardSecrecy")
    @JsonIgnore
    public Optional<Boolean> getEnablePerfectForwardSecrecy() {
        return Optional.ofNullable(enablePerfectForwardSecrecy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enablePerfectForwardSecrecy} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enable Perfect Forward Secrecy (PFS).”</i>
     * 
     * @param enablePerfectForwardSecrecy
     *            new value of {@code enablePerfectForwardSecrecy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enablePerfectForwardSecrecy} field changed
     */
    public IosikEv2VpnConfiguration withEnablePerfectForwardSecrecy(Boolean enablePerfectForwardSecrecy) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enablePerfectForwardSecrecy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.enablePerfectForwardSecrecy = enablePerfectForwardSecrecy;
        return _x;
    }

    /**
     * <i>“Enable Use Internal Subnet Attributes.”</i>
     * 
     * @return property enableUseInternalSubnetAttributes
     */
    @Property(name="enableUseInternalSubnetAttributes")
    @JsonIgnore
    public Optional<Boolean> getEnableUseInternalSubnetAttributes() {
        return Optional.ofNullable(enableUseInternalSubnetAttributes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableUseInternalSubnetAttributes} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable Use Internal Subnet Attributes.”</i>
     * 
     * @param enableUseInternalSubnetAttributes
     *            new value of {@code enableUseInternalSubnetAttributes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableUseInternalSubnetAttributes} field changed
     */
    public IosikEv2VpnConfiguration withEnableUseInternalSubnetAttributes(Boolean enableUseInternalSubnetAttributes) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableUseInternalSubnetAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.enableUseInternalSubnetAttributes = enableUseInternalSubnetAttributes;
        return _x;
    }

    /**
     * <i>“Method of identifying the client that is trying to connect via VPN.”</i>
     * 
     * @return property localIdentifier
     */
    @Property(name="localIdentifier")
    @JsonIgnore
    public Optional<VpnLocalIdentifier> getLocalIdentifier() {
        return Optional.ofNullable(localIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code localIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Method of identifying the client that is trying to connect via VPN.”</i>
     * 
     * @param localIdentifier
     *            new value of {@code localIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code localIdentifier} field changed
     */
    public IosikEv2VpnConfiguration withLocalIdentifier(VpnLocalIdentifier localIdentifier) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("localIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.localIdentifier = localIdentifier;
        return _x;
    }

    /**
     * <i>“Maximum transmission unit. Valid values 1280 to 1400”</i>
     * 
     * @return property mtuSizeInBytes
     */
    @Property(name="mtuSizeInBytes")
    @JsonIgnore
    public Optional<Integer> getMtuSizeInBytes() {
        return Optional.ofNullable(mtuSizeInBytes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mtuSizeInBytes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum transmission unit. Valid values 1280 to 1400”</i>
     * 
     * @param mtuSizeInBytes
     *            new value of {@code mtuSizeInBytes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mtuSizeInBytes} field changed
     */
    public IosikEv2VpnConfiguration withMtuSizeInBytes(Integer mtuSizeInBytes) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("mtuSizeInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.mtuSizeInBytes = mtuSizeInBytes;
        return _x;
    }

    /**
     * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
     * ASN1DN”</i>
     * 
     * @return property remoteIdentifier
     */
    @Property(name="remoteIdentifier")
    @JsonIgnore
    public Optional<String> getRemoteIdentifier() {
        return Optional.ofNullable(remoteIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code remoteIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Address of the IKEv2 server. Must be a FQDN, UserFQDN, network address, or
     * ASN1DN”</i>
     * 
     * @param remoteIdentifier
     *            new value of {@code remoteIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remoteIdentifier} field changed
     */
    public IosikEv2VpnConfiguration withRemoteIdentifier(String remoteIdentifier) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("remoteIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.remoteIdentifier = remoteIdentifier;
        return _x;
    }

    /**
     * <i>“Security Association Parameters”</i>
     * 
     * @return property securityAssociationParameters
     */
    @Property(name="securityAssociationParameters")
    @JsonIgnore
    public Optional<IosVpnSecurityAssociationParameters> getSecurityAssociationParameters() {
        return Optional.ofNullable(securityAssociationParameters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityAssociationParameters} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Security Association Parameters”</i>
     * 
     * @param securityAssociationParameters
     *            new value of {@code securityAssociationParameters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityAssociationParameters} field changed
     */
    public IosikEv2VpnConfiguration withSecurityAssociationParameters(IosVpnSecurityAssociationParameters securityAssociationParameters) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityAssociationParameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.securityAssociationParameters = securityAssociationParameters;
        return _x;
    }

    /**
     * <i>“Common name of the IKEv2 Server Certificate used in Server Authentication”</i>
     * 
     * @return property serverCertificateCommonName
     */
    @Property(name="serverCertificateCommonName")
    @JsonIgnore
    public Optional<String> getServerCertificateCommonName() {
        return Optional.ofNullable(serverCertificateCommonName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * serverCertificateCommonName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Common name of the IKEv2 Server Certificate used in Server Authentication”</i>
     * 
     * @param serverCertificateCommonName
     *            new value of {@code serverCertificateCommonName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serverCertificateCommonName} field changed
     */
    public IosikEv2VpnConfiguration withServerCertificateCommonName(String serverCertificateCommonName) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("serverCertificateCommonName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.serverCertificateCommonName = serverCertificateCommonName;
        return _x;
    }

    /**
     * <i>“Issuer Common name of the IKEv2 Server Certificate issuer used in Authentication”</i>
     * 
     * @return property serverCertificateIssuerCommonName
     */
    @Property(name="serverCertificateIssuerCommonName")
    @JsonIgnore
    public Optional<String> getServerCertificateIssuerCommonName() {
        return Optional.ofNullable(serverCertificateIssuerCommonName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * serverCertificateIssuerCommonName} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Issuer Common name of the IKEv2 Server Certificate issuer used in Authentication”</i>
     * 
     * @param serverCertificateIssuerCommonName
     *            new value of {@code serverCertificateIssuerCommonName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serverCertificateIssuerCommonName} field changed
     */
    public IosikEv2VpnConfiguration withServerCertificateIssuerCommonName(String serverCertificateIssuerCommonName) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("serverCertificateIssuerCommonName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.serverCertificateIssuerCommonName = serverCertificateIssuerCommonName;
        return _x;
    }

    /**
     * <i>“The type of certificate the VPN server will present to the VPN client for
     * authentication.”</i>
     * 
     * @return property serverCertificateType
     */
    @Property(name="serverCertificateType")
    @JsonIgnore
    public Optional<VpnServerCertificateType> getServerCertificateType() {
        return Optional.ofNullable(serverCertificateType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * serverCertificateType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The type of certificate the VPN server will present to the VPN client for
     * authentication.”</i>
     * 
     * @param serverCertificateType
     *            new value of {@code serverCertificateType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serverCertificateType} field changed
     */
    public IosikEv2VpnConfiguration withServerCertificateType(VpnServerCertificateType serverCertificateType) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("serverCertificateType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.serverCertificateType = serverCertificateType;
        return _x;
    }

    /**
     * <i>“Used when Shared Secret Authentication is selected”</i>
     * 
     * @return property sharedSecret
     */
    @Property(name="sharedSecret")
    @JsonIgnore
    public Optional<String> getSharedSecret() {
        return Optional.ofNullable(sharedSecret);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sharedSecret}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Used when Shared Secret Authentication is selected”</i>
     * 
     * @param sharedSecret
     *            new value of {@code sharedSecret} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sharedSecret} field changed
     */
    public IosikEv2VpnConfiguration withSharedSecret(String sharedSecret) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("sharedSecret");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.sharedSecret = sharedSecret;
        return _x;
    }

    /**
     * <i>“The maximum TLS version to be used with EAP-TLS authentication”</i>
     * 
     * @return property tlsMaximumVersion
     */
    @Property(name="tlsMaximumVersion")
    @JsonIgnore
    public Optional<String> getTlsMaximumVersion() {
        return Optional.ofNullable(tlsMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tlsMaximumVersion
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The maximum TLS version to be used with EAP-TLS authentication”</i>
     * 
     * @param tlsMaximumVersion
     *            new value of {@code tlsMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tlsMaximumVersion} field changed
     */
    public IosikEv2VpnConfiguration withTlsMaximumVersion(String tlsMaximumVersion) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("tlsMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.tlsMaximumVersion = tlsMaximumVersion;
        return _x;
    }

    /**
     * <i>“The minimum TLS version to be used with EAP-TLS authentication”</i>
     * 
     * @return property tlsMinimumVersion
     */
    @Property(name="tlsMinimumVersion")
    @JsonIgnore
    public Optional<String> getTlsMinimumVersion() {
        return Optional.ofNullable(tlsMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tlsMinimumVersion
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The minimum TLS version to be used with EAP-TLS authentication”</i>
     * 
     * @param tlsMinimumVersion
     *            new value of {@code tlsMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tlsMinimumVersion} field changed
     */
    public IosikEv2VpnConfiguration withTlsMinimumVersion(String tlsMinimumVersion) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("tlsMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosikEv2VpnConfiguration");
        _x.tlsMinimumVersion = tlsMinimumVersion;
        return _x;
    }

    public IosikEv2VpnConfiguration withUnmappedField(String name, Object value) {
        IosikEv2VpnConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosikEv2VpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosikEv2VpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosikEv2VpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosikEv2VpnConfiguration _copy() {
        IosikEv2VpnConfiguration _x = new IosikEv2VpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.associatedDomains = associatedDomains;
        _x.authenticationMethod = authenticationMethod;
        _x.connectionName = connectionName;
        _x.connectionType = connectionType;
        _x.customData = customData;
        _x.customKeyValueData = customKeyValueData;
        _x.disableOnDemandUserOverride = disableOnDemandUserOverride;
        _x.disconnectOnIdle = disconnectOnIdle;
        _x.disconnectOnIdleTimerInSeconds = disconnectOnIdleTimerInSeconds;
        _x.enablePerApp = enablePerApp;
        _x.enableSplitTunneling = enableSplitTunneling;
        _x.excludedDomains = excludedDomains;
        _x.identifier = identifier;
        _x.loginGroupOrDomain = loginGroupOrDomain;
        _x.onDemandRules = onDemandRules;
        _x.optInToDeviceIdSharing = optInToDeviceIdSharing;
        _x.providerType = providerType;
        _x.proxyServer = proxyServer;
        _x.realm = realm;
        _x.role = role;
        _x.safariDomains = safariDomains;
        _x.server = server;
        _x.cloudName = cloudName;
        _x.excludeList = excludeList;
        _x.microsoftTunnelSiteId = microsoftTunnelSiteId;
        _x.strictEnforcement = strictEnforcement;
        _x.targetedMobileApps = targetedMobileApps;
        _x.userDomain = userDomain;
        _x.allowDefaultChildSecurityAssociationParameters = allowDefaultChildSecurityAssociationParameters;
        _x.allowDefaultSecurityAssociationParameters = allowDefaultSecurityAssociationParameters;
        _x.alwaysOnConfiguration = alwaysOnConfiguration;
        _x.childSecurityAssociationParameters = childSecurityAssociationParameters;
        _x.clientAuthenticationType = clientAuthenticationType;
        _x.deadPeerDetectionRate = deadPeerDetectionRate;
        _x.disableMobilityAndMultihoming = disableMobilityAndMultihoming;
        _x.disableRedirect = disableRedirect;
        _x.enableAlwaysOnConfiguration = enableAlwaysOnConfiguration;
        _x.enableCertificateRevocationCheck = enableCertificateRevocationCheck;
        _x.enableEAP = enableEAP;
        _x.enablePerfectForwardSecrecy = enablePerfectForwardSecrecy;
        _x.enableUseInternalSubnetAttributes = enableUseInternalSubnetAttributes;
        _x.localIdentifier = localIdentifier;
        _x.mtuSizeInBytes = mtuSizeInBytes;
        _x.remoteIdentifier = remoteIdentifier;
        _x.securityAssociationParameters = securityAssociationParameters;
        _x.serverCertificateCommonName = serverCertificateCommonName;
        _x.serverCertificateIssuerCommonName = serverCertificateIssuerCommonName;
        _x.serverCertificateType = serverCertificateType;
        _x.sharedSecret = sharedSecret;
        _x.tlsMaximumVersion = tlsMaximumVersion;
        _x.tlsMinimumVersion = tlsMinimumVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosikEv2VpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("associatedDomains=");
        b.append(this.associatedDomains);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("customKeyValueData=");
        b.append(this.customKeyValueData);
        b.append(", ");
        b.append("disableOnDemandUserOverride=");
        b.append(this.disableOnDemandUserOverride);
        b.append(", ");
        b.append("disconnectOnIdle=");
        b.append(this.disconnectOnIdle);
        b.append(", ");
        b.append("disconnectOnIdleTimerInSeconds=");
        b.append(this.disconnectOnIdleTimerInSeconds);
        b.append(", ");
        b.append("enablePerApp=");
        b.append(this.enablePerApp);
        b.append(", ");
        b.append("enableSplitTunneling=");
        b.append(this.enableSplitTunneling);
        b.append(", ");
        b.append("excludedDomains=");
        b.append(this.excludedDomains);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("loginGroupOrDomain=");
        b.append(this.loginGroupOrDomain);
        b.append(", ");
        b.append("onDemandRules=");
        b.append(this.onDemandRules);
        b.append(", ");
        b.append("optInToDeviceIdSharing=");
        b.append(this.optInToDeviceIdSharing);
        b.append(", ");
        b.append("providerType=");
        b.append(this.providerType);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("safariDomains=");
        b.append(this.safariDomains);
        b.append(", ");
        b.append("server=");
        b.append(this.server);
        b.append(", ");
        b.append("cloudName=");
        b.append(this.cloudName);
        b.append(", ");
        b.append("excludeList=");
        b.append(this.excludeList);
        b.append(", ");
        b.append("microsoftTunnelSiteId=");
        b.append(this.microsoftTunnelSiteId);
        b.append(", ");
        b.append("strictEnforcement=");
        b.append(this.strictEnforcement);
        b.append(", ");
        b.append("targetedMobileApps=");
        b.append(this.targetedMobileApps);
        b.append(", ");
        b.append("userDomain=");
        b.append(this.userDomain);
        b.append(", ");
        b.append("allowDefaultChildSecurityAssociationParameters=");
        b.append(this.allowDefaultChildSecurityAssociationParameters);
        b.append(", ");
        b.append("allowDefaultSecurityAssociationParameters=");
        b.append(this.allowDefaultSecurityAssociationParameters);
        b.append(", ");
        b.append("alwaysOnConfiguration=");
        b.append(this.alwaysOnConfiguration);
        b.append(", ");
        b.append("childSecurityAssociationParameters=");
        b.append(this.childSecurityAssociationParameters);
        b.append(", ");
        b.append("clientAuthenticationType=");
        b.append(this.clientAuthenticationType);
        b.append(", ");
        b.append("deadPeerDetectionRate=");
        b.append(this.deadPeerDetectionRate);
        b.append(", ");
        b.append("disableMobilityAndMultihoming=");
        b.append(this.disableMobilityAndMultihoming);
        b.append(", ");
        b.append("disableRedirect=");
        b.append(this.disableRedirect);
        b.append(", ");
        b.append("enableAlwaysOnConfiguration=");
        b.append(this.enableAlwaysOnConfiguration);
        b.append(", ");
        b.append("enableCertificateRevocationCheck=");
        b.append(this.enableCertificateRevocationCheck);
        b.append(", ");
        b.append("enableEAP=");
        b.append(this.enableEAP);
        b.append(", ");
        b.append("enablePerfectForwardSecrecy=");
        b.append(this.enablePerfectForwardSecrecy);
        b.append(", ");
        b.append("enableUseInternalSubnetAttributes=");
        b.append(this.enableUseInternalSubnetAttributes);
        b.append(", ");
        b.append("localIdentifier=");
        b.append(this.localIdentifier);
        b.append(", ");
        b.append("mtuSizeInBytes=");
        b.append(this.mtuSizeInBytes);
        b.append(", ");
        b.append("remoteIdentifier=");
        b.append(this.remoteIdentifier);
        b.append(", ");
        b.append("securityAssociationParameters=");
        b.append(this.securityAssociationParameters);
        b.append(", ");
        b.append("serverCertificateCommonName=");
        b.append(this.serverCertificateCommonName);
        b.append(", ");
        b.append("serverCertificateIssuerCommonName=");
        b.append(this.serverCertificateIssuerCommonName);
        b.append(", ");
        b.append("serverCertificateType=");
        b.append(this.serverCertificateType);
        b.append(", ");
        b.append("sharedSecret=");
        b.append(this.sharedSecret);
        b.append(", ");
        b.append("tlsMaximumVersion=");
        b.append(this.tlsMaximumVersion);
        b.append(", ");
        b.append("tlsMinimumVersion=");
        b.append(this.tlsMinimumVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
