package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppConfigurationSettingItem;


/**
 * <i>“Contains properties, inherited properties and actions for iOS mobile app
 * configurations.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "encodedSettingXml", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class IosMobileAppConfiguration extends ManagedDeviceMobileAppConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosMobileAppConfiguration";
    }

    @JsonProperty("encodedSettingXml")
    protected byte[] encodedSettingXml;

    @JsonProperty("settings")
    protected List<AppConfigurationSettingItem> settings;

    @JsonProperty("settings@nextLink")
    protected String settingsNextLink;

    protected IosMobileAppConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosMobileAppConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<String> targetedMobileApps;
        private String targetedMobileAppsNextLink;
        private Integer version;
        private List<ManagedDeviceMobileAppConfigurationAssignment> assignments;
        private List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses;
        private ManagedDeviceMobileAppConfigurationDeviceSummary deviceStatusSummary;
        private List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses;
        private ManagedDeviceMobileAppConfigurationUserSummary userStatusSummary;
        private byte[] encodedSettingXml;
        private List<AppConfigurationSettingItem> settings;
        private String settingsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder targetedMobileApps(List<String> targetedMobileApps) {
            this.targetedMobileApps = targetedMobileApps;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        public Builder targetedMobileApps(String... targetedMobileApps) {
            return targetedMobileApps(Arrays.asList(targetedMobileApps));
        }

        public Builder targetedMobileAppsNextLink(String targetedMobileAppsNextLink) {
            this.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<ManagedDeviceMobileAppConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(ManagedDeviceMobileAppConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(ManagedDeviceMobileAppConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusSummary(ManagedDeviceMobileAppConfigurationDeviceSummary deviceStatusSummary) {
            this.deviceStatusSummary = deviceStatusSummary;
            this.changedFields = changedFields.add("deviceStatusSummary");
            return this;
        }

        public Builder userStatuses(List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(ManagedDeviceMobileAppConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusSummary(ManagedDeviceMobileAppConfigurationUserSummary userStatusSummary) {
            this.userStatusSummary = userStatusSummary;
            this.changedFields = changedFields.add("userStatusSummary");
            return this;
        }

        /**
         * <i>“mdm app configuration Base64 binary.”</i>
         * 
         * @param encodedSettingXml
         *            value of {@code encodedSettingXml} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encodedSettingXml(byte[] encodedSettingXml) {
            this.encodedSettingXml = encodedSettingXml;
            this.changedFields = changedFields.add("encodedSettingXml");
            return this;
        }

        /**
         * <i>“app configuration setting items.”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(List<AppConfigurationSettingItem> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        /**
         * <i>“app configuration setting items.”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(AppConfigurationSettingItem... settings) {
            return settings(Arrays.asList(settings));
        }

        /**
         * <i>“app configuration setting items.”</i>
         * 
         * @param settingsNextLink
         *            value of {@code settings@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingsNextLink(String settingsNextLink) {
            this.settingsNextLink = settingsNextLink;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public IosMobileAppConfiguration build() {
            IosMobileAppConfiguration _x = new IosMobileAppConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.iosMobileAppConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.targetedMobileApps = targetedMobileApps;
            _x.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusSummary = deviceStatusSummary;
            _x.userStatuses = userStatuses;
            _x.userStatusSummary = userStatusSummary;
            _x.encodedSettingXml = encodedSettingXml;
            _x.settings = settings;
            _x.settingsNextLink = settingsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“mdm app configuration Base64 binary.”</i>
     * 
     * @return property encodedSettingXml
     */
    @Property(name="encodedSettingXml")
    @JsonIgnore
    public Optional<byte[]> getEncodedSettingXml() {
        return Optional.ofNullable(encodedSettingXml);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encodedSettingXml
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“mdm app configuration Base64 binary.”</i>
     * 
     * @param encodedSettingXml
     *            new value of {@code encodedSettingXml} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encodedSettingXml} field changed
     */
    public IosMobileAppConfiguration withEncodedSettingXml(byte[] encodedSettingXml) {
        IosMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("encodedSettingXml");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMobileAppConfiguration");
        _x.encodedSettingXml = encodedSettingXml;
        return _x;
    }

    /**
     * <i>“app configuration setting items.”</i>
     * 
     * @return property settings
     */
    @Property(name="settings")
    @JsonIgnore
    public CollectionPage<AppConfigurationSettingItem> getSettings() {
        return new CollectionPage<AppConfigurationSettingItem>(contextPath, AppConfigurationSettingItem.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“app configuration setting items.”</i>
     * 
     * @param settings
     *            new value of {@code settings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settings} field changed
     */
    public IosMobileAppConfiguration withSettings(List<AppConfigurationSettingItem> settings) {
        IosMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosMobileAppConfiguration");
        _x.settings = settings;
        return _x;
    }

    /**
     * <i>“app configuration setting items.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property settings
     */
    @Property(name="settings")
    @JsonIgnore
    public CollectionPage<AppConfigurationSettingItem> getSettings(HttpRequestOptions options) {
        return new CollectionPage<AppConfigurationSettingItem>(contextPath, AppConfigurationSettingItem.class, this.settings, Optional.ofNullable(settingsNextLink), Collections.emptyList(), options);
    }

    public IosMobileAppConfiguration withUnmappedField(String name, Object value) {
        IosMobileAppConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosMobileAppConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IosMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IosMobileAppConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IosMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IosMobileAppConfiguration _copy() {
        IosMobileAppConfiguration _x = new IosMobileAppConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.targetedMobileApps = targetedMobileApps;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusSummary = deviceStatusSummary;
        _x.userStatuses = userStatuses;
        _x.userStatusSummary = userStatusSummary;
        _x.encodedSettingXml = encodedSettingXml;
        _x.settings = settings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosMobileAppConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("targetedMobileApps=");
        b.append(this.targetedMobileApps);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusSummary=");
        b.append(this.deviceStatusSummary);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusSummary=");
        b.append(this.userStatusSummary);
        b.append(", ");
        b.append("encodedSettingXml=");
        b.append(this.encodedSettingXml);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
