package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignmentTarget;


/**
 * <i>“This entity contains the properties used to assign a branding profile to a group
 * .”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class IntuneBrandingProfileAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.intuneBrandingProfileAssignment";
    }

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    protected IntuneBrandingProfileAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIntuneBrandingProfileAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceAndAppManagementAssignmentTarget target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Assignment target that the branding profile is assigned to.”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public IntuneBrandingProfileAssignment build() {
            IntuneBrandingProfileAssignment _x = new IntuneBrandingProfileAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.intuneBrandingProfileAssignment";
            _x.id = id;
            _x.target = target;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Assignment target that the branding profile is assigned to.”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Assignment target that the branding profile is assigned to.”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public IntuneBrandingProfileAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        IntuneBrandingProfileAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrandingProfileAssignment");
        _x.target = target;
        return _x;
    }

    public IntuneBrandingProfileAssignment withUnmappedField(String name, Object value) {
        IntuneBrandingProfileAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IntuneBrandingProfileAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IntuneBrandingProfileAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IntuneBrandingProfileAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IntuneBrandingProfileAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IntuneBrandingProfileAssignment _copy() {
        IntuneBrandingProfileAssignment _x = new IntuneBrandingProfileAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IntuneBrandingProfileAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
