package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SigningCertificateUpdateStatus;
import odata.msgraph.client.beta.enums.AuthenticationProtocol;
import odata.msgraph.client.beta.enums.FederatedIdpMfaBehavior;
import odata.msgraph.client.beta.enums.PromptLoginBehavior;

@JsonPropertyOrder({
    "@odata.type", 
    "activeSignInUri", 
    "federatedIdpMfaBehavior", 
    "isSignedAuthenticationRequestRequired", 
    "nextSigningCertificate", 
    "promptLoginBehavior", 
    "signingCertificateUpdateStatus", 
    "signOutUri"})
@JsonInclude(Include.NON_NULL)
public class InternalDomainFederation extends SamlOrWsFedProvider implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.internalDomainFederation";
    }

    @JsonProperty("activeSignInUri")
    protected String activeSignInUri;

    @JsonProperty("federatedIdpMfaBehavior")
    protected FederatedIdpMfaBehavior federatedIdpMfaBehavior;

    @JsonProperty("isSignedAuthenticationRequestRequired")
    protected Boolean isSignedAuthenticationRequestRequired;

    @JsonProperty("nextSigningCertificate")
    protected String nextSigningCertificate;

    @JsonProperty("promptLoginBehavior")
    protected PromptLoginBehavior promptLoginBehavior;

    @JsonProperty("signingCertificateUpdateStatus")
    protected SigningCertificateUpdateStatus signingCertificateUpdateStatus;

    @JsonProperty("signOutUri")
    protected String signOutUri;

    protected InternalDomainFederation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInternalDomainFederation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String issuerUri;
        private String metadataExchangeUri;
        private String passiveSignInUri;
        private AuthenticationProtocol preferredAuthenticationProtocol;
        private String signingCertificate;
        private String activeSignInUri;
        private FederatedIdpMfaBehavior federatedIdpMfaBehavior;
        private Boolean isSignedAuthenticationRequestRequired;
        private String nextSigningCertificate;
        private PromptLoginBehavior promptLoginBehavior;
        private SigningCertificateUpdateStatus signingCertificateUpdateStatus;
        private String signOutUri;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder issuerUri(String issuerUri) {
            this.issuerUri = issuerUri;
            this.changedFields = changedFields.add("issuerUri");
            return this;
        }

        public Builder metadataExchangeUri(String metadataExchangeUri) {
            this.metadataExchangeUri = metadataExchangeUri;
            this.changedFields = changedFields.add("metadataExchangeUri");
            return this;
        }

        public Builder passiveSignInUri(String passiveSignInUri) {
            this.passiveSignInUri = passiveSignInUri;
            this.changedFields = changedFields.add("passiveSignInUri");
            return this;
        }

        public Builder preferredAuthenticationProtocol(AuthenticationProtocol preferredAuthenticationProtocol) {
            this.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
            this.changedFields = changedFields.add("preferredAuthenticationProtocol");
            return this;
        }

        public Builder signingCertificate(String signingCertificate) {
            this.signingCertificate = signingCertificate;
            this.changedFields = changedFields.add("signingCertificate");
            return this;
        }

        public Builder activeSignInUri(String activeSignInUri) {
            this.activeSignInUri = activeSignInUri;
            this.changedFields = changedFields.add("activeSignInUri");
            return this;
        }

        public Builder federatedIdpMfaBehavior(FederatedIdpMfaBehavior federatedIdpMfaBehavior) {
            this.federatedIdpMfaBehavior = federatedIdpMfaBehavior;
            this.changedFields = changedFields.add("federatedIdpMfaBehavior");
            return this;
        }

        public Builder isSignedAuthenticationRequestRequired(Boolean isSignedAuthenticationRequestRequired) {
            this.isSignedAuthenticationRequestRequired = isSignedAuthenticationRequestRequired;
            this.changedFields = changedFields.add("isSignedAuthenticationRequestRequired");
            return this;
        }

        public Builder nextSigningCertificate(String nextSigningCertificate) {
            this.nextSigningCertificate = nextSigningCertificate;
            this.changedFields = changedFields.add("nextSigningCertificate");
            return this;
        }

        public Builder promptLoginBehavior(PromptLoginBehavior promptLoginBehavior) {
            this.promptLoginBehavior = promptLoginBehavior;
            this.changedFields = changedFields.add("promptLoginBehavior");
            return this;
        }

        public Builder signingCertificateUpdateStatus(SigningCertificateUpdateStatus signingCertificateUpdateStatus) {
            this.signingCertificateUpdateStatus = signingCertificateUpdateStatus;
            this.changedFields = changedFields.add("signingCertificateUpdateStatus");
            return this;
        }

        public Builder signOutUri(String signOutUri) {
            this.signOutUri = signOutUri;
            this.changedFields = changedFields.add("signOutUri");
            return this;
        }

        public InternalDomainFederation build() {
            InternalDomainFederation _x = new InternalDomainFederation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.internalDomainFederation";
            _x.id = id;
            _x.displayName = displayName;
            _x.issuerUri = issuerUri;
            _x.metadataExchangeUri = metadataExchangeUri;
            _x.passiveSignInUri = passiveSignInUri;
            _x.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
            _x.signingCertificate = signingCertificate;
            _x.activeSignInUri = activeSignInUri;
            _x.federatedIdpMfaBehavior = federatedIdpMfaBehavior;
            _x.isSignedAuthenticationRequestRequired = isSignedAuthenticationRequestRequired;
            _x.nextSigningCertificate = nextSigningCertificate;
            _x.promptLoginBehavior = promptLoginBehavior;
            _x.signingCertificateUpdateStatus = signingCertificateUpdateStatus;
            _x.signOutUri = signOutUri;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activeSignInUri")
    @JsonIgnore
    public Optional<String> getActiveSignInUri() {
        return Optional.ofNullable(activeSignInUri);
    }

    public InternalDomainFederation withActiveSignInUri(String activeSignInUri) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("activeSignInUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.activeSignInUri = activeSignInUri;
        return _x;
    }

    @Property(name="federatedIdpMfaBehavior")
    @JsonIgnore
    public Optional<FederatedIdpMfaBehavior> getFederatedIdpMfaBehavior() {
        return Optional.ofNullable(federatedIdpMfaBehavior);
    }

    public InternalDomainFederation withFederatedIdpMfaBehavior(FederatedIdpMfaBehavior federatedIdpMfaBehavior) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("federatedIdpMfaBehavior");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.federatedIdpMfaBehavior = federatedIdpMfaBehavior;
        return _x;
    }

    @Property(name="isSignedAuthenticationRequestRequired")
    @JsonIgnore
    public Optional<Boolean> getIsSignedAuthenticationRequestRequired() {
        return Optional.ofNullable(isSignedAuthenticationRequestRequired);
    }

    public InternalDomainFederation withIsSignedAuthenticationRequestRequired(Boolean isSignedAuthenticationRequestRequired) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("isSignedAuthenticationRequestRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.isSignedAuthenticationRequestRequired = isSignedAuthenticationRequestRequired;
        return _x;
    }

    @Property(name="nextSigningCertificate")
    @JsonIgnore
    public Optional<String> getNextSigningCertificate() {
        return Optional.ofNullable(nextSigningCertificate);
    }

    public InternalDomainFederation withNextSigningCertificate(String nextSigningCertificate) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("nextSigningCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.nextSigningCertificate = nextSigningCertificate;
        return _x;
    }

    @Property(name="promptLoginBehavior")
    @JsonIgnore
    public Optional<PromptLoginBehavior> getPromptLoginBehavior() {
        return Optional.ofNullable(promptLoginBehavior);
    }

    public InternalDomainFederation withPromptLoginBehavior(PromptLoginBehavior promptLoginBehavior) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("promptLoginBehavior");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.promptLoginBehavior = promptLoginBehavior;
        return _x;
    }

    @Property(name="signingCertificateUpdateStatus")
    @JsonIgnore
    public Optional<SigningCertificateUpdateStatus> getSigningCertificateUpdateStatus() {
        return Optional.ofNullable(signingCertificateUpdateStatus);
    }

    public InternalDomainFederation withSigningCertificateUpdateStatus(SigningCertificateUpdateStatus signingCertificateUpdateStatus) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("signingCertificateUpdateStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.signingCertificateUpdateStatus = signingCertificateUpdateStatus;
        return _x;
    }

    @Property(name="signOutUri")
    @JsonIgnore
    public Optional<String> getSignOutUri() {
        return Optional.ofNullable(signOutUri);
    }

    public InternalDomainFederation withSignOutUri(String signOutUri) {
        InternalDomainFederation _x = _copy();
        _x.changedFields = changedFields.add("signOutUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.internalDomainFederation");
        _x.signOutUri = signOutUri;
        return _x;
    }

    public InternalDomainFederation withUnmappedField(String name, Object value) {
        InternalDomainFederation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InternalDomainFederation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InternalDomainFederation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InternalDomainFederation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InternalDomainFederation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InternalDomainFederation _copy() {
        InternalDomainFederation _x = new InternalDomainFederation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.issuerUri = issuerUri;
        _x.metadataExchangeUri = metadataExchangeUri;
        _x.passiveSignInUri = passiveSignInUri;
        _x.preferredAuthenticationProtocol = preferredAuthenticationProtocol;
        _x.signingCertificate = signingCertificate;
        _x.activeSignInUri = activeSignInUri;
        _x.federatedIdpMfaBehavior = federatedIdpMfaBehavior;
        _x.isSignedAuthenticationRequestRequired = isSignedAuthenticationRequestRequired;
        _x.nextSigningCertificate = nextSigningCertificate;
        _x.promptLoginBehavior = promptLoginBehavior;
        _x.signingCertificateUpdateStatus = signingCertificateUpdateStatus;
        _x.signOutUri = signOutUri;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InternalDomainFederation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("issuerUri=");
        b.append(this.issuerUri);
        b.append(", ");
        b.append("metadataExchangeUri=");
        b.append(this.metadataExchangeUri);
        b.append(", ");
        b.append("passiveSignInUri=");
        b.append(this.passiveSignInUri);
        b.append(", ");
        b.append("preferredAuthenticationProtocol=");
        b.append(this.preferredAuthenticationProtocol);
        b.append(", ");
        b.append("signingCertificate=");
        b.append(this.signingCertificate);
        b.append(", ");
        b.append("activeSignInUri=");
        b.append(this.activeSignInUri);
        b.append(", ");
        b.append("federatedIdpMfaBehavior=");
        b.append(this.federatedIdpMfaBehavior);
        b.append(", ");
        b.append("isSignedAuthenticationRequestRequired=");
        b.append(this.isSignedAuthenticationRequestRequired);
        b.append(", ");
        b.append("nextSigningCertificate=");
        b.append(this.nextSigningCertificate);
        b.append(", ");
        b.append("promptLoginBehavior=");
        b.append(this.promptLoginBehavior);
        b.append(", ");
        b.append("signingCertificateUpdateStatus=");
        b.append(this.signingCertificateUpdateStatus);
        b.append(", ");
        b.append("signOutUri=");
        b.append(this.signOutUri);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
