package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EmailAddress;
import odata.msgraph.client.beta.enums.InferenceClassificationType;

@JsonPropertyOrder({
    "@odata.type", 
    "classifyAs", 
    "senderEmailAddress"})
@JsonInclude(Include.NON_NULL)
public class InferenceClassificationOverride extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.inferenceClassificationOverride";
    }

    @JsonProperty("classifyAs")
    protected InferenceClassificationType classifyAs;

    @JsonProperty("senderEmailAddress")
    protected EmailAddress senderEmailAddress;

    protected InferenceClassificationOverride() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInferenceClassificationOverride() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private InferenceClassificationType classifyAs;
        private EmailAddress senderEmailAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder classifyAs(InferenceClassificationType classifyAs) {
            this.classifyAs = classifyAs;
            this.changedFields = changedFields.add("classifyAs");
            return this;
        }

        public Builder senderEmailAddress(EmailAddress senderEmailAddress) {
            this.senderEmailAddress = senderEmailAddress;
            this.changedFields = changedFields.add("senderEmailAddress");
            return this;
        }

        public InferenceClassificationOverride build() {
            InferenceClassificationOverride _x = new InferenceClassificationOverride();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.inferenceClassificationOverride";
            _x.id = id;
            _x.classifyAs = classifyAs;
            _x.senderEmailAddress = senderEmailAddress;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="classifyAs")
    @JsonIgnore
    public Optional<InferenceClassificationType> getClassifyAs() {
        return Optional.ofNullable(classifyAs);
    }

    public InferenceClassificationOverride withClassifyAs(InferenceClassificationType classifyAs) {
        InferenceClassificationOverride _x = _copy();
        _x.changedFields = changedFields.add("classifyAs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inferenceClassificationOverride");
        _x.classifyAs = classifyAs;
        return _x;
    }

    @Property(name="senderEmailAddress")
    @JsonIgnore
    public Optional<EmailAddress> getSenderEmailAddress() {
        return Optional.ofNullable(senderEmailAddress);
    }

    public InferenceClassificationOverride withSenderEmailAddress(EmailAddress senderEmailAddress) {
        InferenceClassificationOverride _x = _copy();
        _x.changedFields = changedFields.add("senderEmailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inferenceClassificationOverride");
        _x.senderEmailAddress = senderEmailAddress;
        return _x;
    }

    public InferenceClassificationOverride withUnmappedField(String name, Object value) {
        InferenceClassificationOverride _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InferenceClassificationOverride patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InferenceClassificationOverride _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InferenceClassificationOverride put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InferenceClassificationOverride _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InferenceClassificationOverride _copy() {
        InferenceClassificationOverride _x = new InferenceClassificationOverride();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.classifyAs = classifyAs;
        _x.senderEmailAddress = senderEmailAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InferenceClassificationOverride[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classifyAs=");
        b.append(this.classifyAs);
        b.append(", ");
        b.append("senderEmailAddress=");
        b.append(this.senderEmailAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
