package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "homeTenantId", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class InboundSharedUserProfile extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.inboundSharedUserProfile";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("homeTenantId")
    protected String homeTenantId;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected InboundSharedUserProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInboundSharedUserProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String displayName;
        private String homeTenantId;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder homeTenantId(String homeTenantId) {
            this.homeTenantId = homeTenantId;
            this.changedFields = changedFields.add("homeTenantId");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public InboundSharedUserProfile build() {
            InboundSharedUserProfile _x = new InboundSharedUserProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.inboundSharedUserProfile";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.displayName = displayName;
            _x.homeTenantId = homeTenantId;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public InboundSharedUserProfile withDisplayName(String displayName) {
        InboundSharedUserProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inboundSharedUserProfile");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="homeTenantId")
    @JsonIgnore
    public Optional<String> getHomeTenantId() {
        return Optional.ofNullable(homeTenantId);
    }

    public InboundSharedUserProfile withHomeTenantId(String homeTenantId) {
        InboundSharedUserProfile _x = _copy();
        _x.changedFields = changedFields.add("homeTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inboundSharedUserProfile");
        _x.homeTenantId = homeTenantId;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public InboundSharedUserProfile withUserId(String userId) {
        InboundSharedUserProfile _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inboundSharedUserProfile");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public InboundSharedUserProfile withUserPrincipalName(String userPrincipalName) {
        InboundSharedUserProfile _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.inboundSharedUserProfile");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public InboundSharedUserProfile withUnmappedField(String name, Object value) {
        InboundSharedUserProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InboundSharedUserProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InboundSharedUserProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InboundSharedUserProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InboundSharedUserProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InboundSharedUserProfile _copy() {
        InboundSharedUserProfile _x = new InboundSharedUserProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.displayName = displayName;
        _x.homeTenantId = homeTenantId;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Action(name = "exportPersonalData")
    @JsonIgnore
    public ActionRequestNoReturn exportPersonalData(String storageLocation) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("storageLocation", "Edm.String", Checks.checkIsAscii(storageLocation))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.exportPersonalData"), _parameters);
    }

    @Action(name = "removePersonalData")
    @JsonIgnore
    public ActionRequestNoReturn removePersonalData() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removePersonalData"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InboundSharedUserProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("homeTenantId=");
        b.append(this.homeTenantId);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
