package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DiscoverySource;
import odata.msgraph.client.beta.enums.EnrollmentState;
import odata.msgraph.client.beta.enums.Platform;


/**
 * <i>“The importedAppleDeviceIdentity resource represents the imported device identity
 * of an Apple device .”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "discoverySource", 
    "enrollmentState", 
    "isDeleted", 
    "isSupervised", 
    "lastContactedDateTime", 
    "platform", 
    "requestedEnrollmentProfileAssignmentDateTime", 
    "requestedEnrollmentProfileId", 
    "serialNumber"})
@JsonInclude(Include.NON_NULL)
public class ImportedAppleDeviceIdentity extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.importedAppleDeviceIdentity";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("discoverySource")
    protected DiscoverySource discoverySource;

    @JsonProperty("enrollmentState")
    protected EnrollmentState enrollmentState;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("isSupervised")
    protected Boolean isSupervised;

    @JsonProperty("lastContactedDateTime")
    protected OffsetDateTime lastContactedDateTime;

    @JsonProperty("platform")
    protected Platform platform;

    @JsonProperty("requestedEnrollmentProfileAssignmentDateTime")
    protected OffsetDateTime requestedEnrollmentProfileAssignmentDateTime;

    @JsonProperty("requestedEnrollmentProfileId")
    protected String requestedEnrollmentProfileId;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    protected ImportedAppleDeviceIdentity() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportedAppleDeviceIdentity() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DiscoverySource discoverySource;
        private EnrollmentState enrollmentState;
        private Boolean isDeleted;
        private Boolean isSupervised;
        private OffsetDateTime lastContactedDateTime;
        private Platform platform;
        private OffsetDateTime requestedEnrollmentProfileAssignmentDateTime;
        private String requestedEnrollmentProfileId;
        private String serialNumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Created Date Time of the device”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The description of the device”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Apple device discovery source.”</i>
         * 
         * @param discoverySource
         *            value of {@code discoverySource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder discoverySource(DiscoverySource discoverySource) {
            this.discoverySource = discoverySource;
            this.changedFields = changedFields.add("discoverySource");
            return this;
        }

        /**
         * <i>“The state of the device in Intune”</i>
         * 
         * @param enrollmentState
         *            value of {@code enrollmentState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentState(EnrollmentState enrollmentState) {
            this.enrollmentState = enrollmentState;
            this.changedFields = changedFields.add("enrollmentState");
            return this;
        }

        /**
         * <i>“Indicates if the device is deleted from Apple Business Manager”</i>
         * 
         * @param isDeleted
         *            value of {@code isDeleted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        /**
         * <i>“Indicates if the Apple device is supervised. More information is at: https://
         * support.apple.com/en-us/HT202837”</i>
         * 
         * @param isSupervised
         *            value of {@code isSupervised} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSupervised(Boolean isSupervised) {
            this.isSupervised = isSupervised;
            this.changedFields = changedFields.add("isSupervised");
            return this;
        }

        /**
         * <i>“Last Contacted Date Time of the device”</i>
         * 
         * @param lastContactedDateTime
         *            value of {@code lastContactedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastContactedDateTime(OffsetDateTime lastContactedDateTime) {
            this.lastContactedDateTime = lastContactedDateTime;
            this.changedFields = changedFields.add("lastContactedDateTime");
            return this;
        }

        /**
         * <i>“The platform of the Device.”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(Platform platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        /**
         * <i>“The time enrollment profile was assigned to the device”</i>
         * 
         * @param requestedEnrollmentProfileAssignmentDateTime
         *            value of {@code requestedEnrollmentProfileAssignmentDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requestedEnrollmentProfileAssignmentDateTime(OffsetDateTime requestedEnrollmentProfileAssignmentDateTime) {
            this.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
            this.changedFields = changedFields.add("requestedEnrollmentProfileAssignmentDateTime");
            return this;
        }

        /**
         * <i>“Enrollment profile Id admin intends to apply to the device during next
         * enrollment”</i>
         * 
         * @param requestedEnrollmentProfileId
         *            value of {@code requestedEnrollmentProfileId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requestedEnrollmentProfileId(String requestedEnrollmentProfileId) {
            this.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
            this.changedFields = changedFields.add("requestedEnrollmentProfileId");
            return this;
        }

        /**
         * <i>“Device serial number”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        public ImportedAppleDeviceIdentity build() {
            ImportedAppleDeviceIdentity _x = new ImportedAppleDeviceIdentity();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.importedAppleDeviceIdentity";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.discoverySource = discoverySource;
            _x.enrollmentState = enrollmentState;
            _x.isDeleted = isDeleted;
            _x.isSupervised = isSupervised;
            _x.lastContactedDateTime = lastContactedDateTime;
            _x.platform = platform;
            _x.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
            _x.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
            _x.serialNumber = serialNumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Created Date Time of the device”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Created Date Time of the device”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ImportedAppleDeviceIdentity withCreatedDateTime(OffsetDateTime createdDateTime) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The description of the device”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description of the device”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ImportedAppleDeviceIdentity withDescription(String description) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Apple device discovery source.”</i>
     * 
     * @return property discoverySource
     */
    @Property(name="discoverySource")
    @JsonIgnore
    public Optional<DiscoverySource> getDiscoverySource() {
        return Optional.ofNullable(discoverySource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code discoverySource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Apple device discovery source.”</i>
     * 
     * @param discoverySource
     *            new value of {@code discoverySource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code discoverySource} field changed
     */
    public ImportedAppleDeviceIdentity withDiscoverySource(DiscoverySource discoverySource) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("discoverySource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.discoverySource = discoverySource;
        return _x;
    }

    /**
     * <i>“The state of the device in Intune”</i>
     * 
     * @return property enrollmentState
     */
    @Property(name="enrollmentState")
    @JsonIgnore
    public Optional<EnrollmentState> getEnrollmentState() {
        return Optional.ofNullable(enrollmentState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The state of the device in Intune”</i>
     * 
     * @param enrollmentState
     *            new value of {@code enrollmentState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentState} field changed
     */
    public ImportedAppleDeviceIdentity withEnrollmentState(EnrollmentState enrollmentState) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("enrollmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.enrollmentState = enrollmentState;
        return _x;
    }

    /**
     * <i>“Indicates if the device is deleted from Apple Business Manager”</i>
     * 
     * @return property isDeleted
     */
    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDeleted} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if the device is deleted from Apple Business Manager”</i>
     * 
     * @param isDeleted
     *            new value of {@code isDeleted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDeleted} field changed
     */
    public ImportedAppleDeviceIdentity withIsDeleted(Boolean isDeleted) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.isDeleted = isDeleted;
        return _x;
    }

    /**
     * <i>“Indicates if the Apple device is supervised. More information is at: https://
     * support.apple.com/en-us/HT202837”</i>
     * 
     * @return property isSupervised
     */
    @Property(name="isSupervised")
    @JsonIgnore
    public Optional<Boolean> getIsSupervised() {
        return Optional.ofNullable(isSupervised);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSupervised}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if the Apple device is supervised. More information is at: https://
     * support.apple.com/en-us/HT202837”</i>
     * 
     * @param isSupervised
     *            new value of {@code isSupervised} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSupervised} field changed
     */
    public ImportedAppleDeviceIdentity withIsSupervised(Boolean isSupervised) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("isSupervised");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.isSupervised = isSupervised;
        return _x;
    }

    /**
     * <i>“Last Contacted Date Time of the device”</i>
     * 
     * @return property lastContactedDateTime
     */
    @Property(name="lastContactedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastContactedDateTime() {
        return Optional.ofNullable(lastContactedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastContactedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last Contacted Date Time of the device”</i>
     * 
     * @param lastContactedDateTime
     *            new value of {@code lastContactedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastContactedDateTime} field changed
     */
    public ImportedAppleDeviceIdentity withLastContactedDateTime(OffsetDateTime lastContactedDateTime) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("lastContactedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.lastContactedDateTime = lastContactedDateTime;
        return _x;
    }

    /**
     * <i>“The platform of the Device.”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<Platform> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The platform of the Device.”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public ImportedAppleDeviceIdentity withPlatform(Platform platform) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.platform = platform;
        return _x;
    }

    /**
     * <i>“The time enrollment profile was assigned to the device”</i>
     * 
     * @return property requestedEnrollmentProfileAssignmentDateTime
     */
    @Property(name="requestedEnrollmentProfileAssignmentDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestedEnrollmentProfileAssignmentDateTime() {
        return Optional.ofNullable(requestedEnrollmentProfileAssignmentDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requestedEnrollmentProfileAssignmentDateTime} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The time enrollment profile was assigned to the device”</i>
     * 
     * @param requestedEnrollmentProfileAssignmentDateTime
     *            new value of {@code requestedEnrollmentProfileAssignmentDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requestedEnrollmentProfileAssignmentDateTime} field changed
     */
    public ImportedAppleDeviceIdentity withRequestedEnrollmentProfileAssignmentDateTime(OffsetDateTime requestedEnrollmentProfileAssignmentDateTime) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("requestedEnrollmentProfileAssignmentDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
        return _x;
    }

    /**
     * <i>“Enrollment profile Id admin intends to apply to the device during next
     * enrollment”</i>
     * 
     * @return property requestedEnrollmentProfileId
     */
    @Property(name="requestedEnrollmentProfileId")
    @JsonIgnore
    public Optional<String> getRequestedEnrollmentProfileId() {
        return Optional.ofNullable(requestedEnrollmentProfileId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requestedEnrollmentProfileId} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enrollment profile Id admin intends to apply to the device during next
     * enrollment”</i>
     * 
     * @param requestedEnrollmentProfileId
     *            new value of {@code requestedEnrollmentProfileId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requestedEnrollmentProfileId} field changed
     */
    public ImportedAppleDeviceIdentity withRequestedEnrollmentProfileId(String requestedEnrollmentProfileId) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("requestedEnrollmentProfileId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
        return _x;
    }

    /**
     * <i>“Device serial number”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device serial number”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public ImportedAppleDeviceIdentity withSerialNumber(String serialNumber) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = changedFields.add("serialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedAppleDeviceIdentity");
        _x.serialNumber = serialNumber;
        return _x;
    }

    public ImportedAppleDeviceIdentity withUnmappedField(String name, Object value) {
        ImportedAppleDeviceIdentity _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedAppleDeviceIdentity patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ImportedAppleDeviceIdentity put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ImportedAppleDeviceIdentity _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ImportedAppleDeviceIdentity _copy() {
        ImportedAppleDeviceIdentity _x = new ImportedAppleDeviceIdentity();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.discoverySource = discoverySource;
        _x.enrollmentState = enrollmentState;
        _x.isDeleted = isDeleted;
        _x.isSupervised = isSupervised;
        _x.lastContactedDateTime = lastContactedDateTime;
        _x.platform = platform;
        _x.requestedEnrollmentProfileAssignmentDateTime = requestedEnrollmentProfileAssignmentDateTime;
        _x.requestedEnrollmentProfileId = requestedEnrollmentProfileId;
        _x.serialNumber = serialNumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImportedAppleDeviceIdentity[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("discoverySource=");
        b.append(this.discoverySource);
        b.append(", ");
        b.append("enrollmentState=");
        b.append(this.enrollmentState);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("isSupervised=");
        b.append(this.isSupervised);
        b.append(", ");
        b.append("lastContactedDateTime=");
        b.append(this.lastContactedDateTime);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("requestedEnrollmentProfileAssignmentDateTime=");
        b.append(this.requestedEnrollmentProfileAssignmentDateTime);
        b.append(", ");
        b.append("requestedEnrollmentProfileId=");
        b.append(this.requestedEnrollmentProfileId);
        b.append(", ");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
