package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserAttributeValuesItem;
import odata.msgraph.client.beta.entity.request.IdentityUserFlowAttributeRequest;
import odata.msgraph.client.beta.enums.IdentityUserFlowAttributeInputType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isOptional", 
    "requiresVerification", 
    "userAttributeValues", 
    "userInputType"})
@JsonInclude(Include.NON_NULL)
public class IdentityUserFlowAttributeAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identityUserFlowAttributeAssignment";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isOptional")
    protected Boolean isOptional;

    @JsonProperty("requiresVerification")
    protected Boolean requiresVerification;

    @JsonProperty("userAttributeValues")
    protected List<UserAttributeValuesItem> userAttributeValues;

    @JsonProperty("userAttributeValues@nextLink")
    protected String userAttributeValuesNextLink;

    @JsonProperty("userInputType")
    protected IdentityUserFlowAttributeInputType userInputType;

    protected IdentityUserFlowAttributeAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIdentityUserFlowAttributeAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Boolean isOptional;
        private Boolean requiresVerification;
        private List<UserAttributeValuesItem> userAttributeValues;
        private String userAttributeValuesNextLink;
        private IdentityUserFlowAttributeInputType userInputType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            this.changedFields = changedFields.add("isOptional");
            return this;
        }

        public Builder requiresVerification(Boolean requiresVerification) {
            this.requiresVerification = requiresVerification;
            this.changedFields = changedFields.add("requiresVerification");
            return this;
        }

        public Builder userAttributeValues(List<UserAttributeValuesItem> userAttributeValues) {
            this.userAttributeValues = userAttributeValues;
            this.changedFields = changedFields.add("userAttributeValues");
            return this;
        }

        public Builder userAttributeValues(UserAttributeValuesItem... userAttributeValues) {
            return userAttributeValues(Arrays.asList(userAttributeValues));
        }

        public Builder userAttributeValuesNextLink(String userAttributeValuesNextLink) {
            this.userAttributeValuesNextLink = userAttributeValuesNextLink;
            this.changedFields = changedFields.add("userAttributeValues");
            return this;
        }

        public Builder userInputType(IdentityUserFlowAttributeInputType userInputType) {
            this.userInputType = userInputType;
            this.changedFields = changedFields.add("userInputType");
            return this;
        }

        public IdentityUserFlowAttributeAssignment build() {
            IdentityUserFlowAttributeAssignment _x = new IdentityUserFlowAttributeAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.identityUserFlowAttributeAssignment";
            _x.id = id;
            _x.displayName = displayName;
            _x.isOptional = isOptional;
            _x.requiresVerification = requiresVerification;
            _x.userAttributeValues = userAttributeValues;
            _x.userAttributeValuesNextLink = userAttributeValuesNextLink;
            _x.userInputType = userInputType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public IdentityUserFlowAttributeAssignment withDisplayName(String displayName) {
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityUserFlowAttributeAssignment");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="isOptional")
    @JsonIgnore
    public Optional<Boolean> getIsOptional() {
        return Optional.ofNullable(isOptional);
    }

    public IdentityUserFlowAttributeAssignment withIsOptional(Boolean isOptional) {
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = changedFields.add("isOptional");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityUserFlowAttributeAssignment");
        _x.isOptional = isOptional;
        return _x;
    }

    @Property(name="requiresVerification")
    @JsonIgnore
    public Optional<Boolean> getRequiresVerification() {
        return Optional.ofNullable(requiresVerification);
    }

    public IdentityUserFlowAttributeAssignment withRequiresVerification(Boolean requiresVerification) {
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = changedFields.add("requiresVerification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityUserFlowAttributeAssignment");
        _x.requiresVerification = requiresVerification;
        return _x;
    }

    @Property(name="userAttributeValues")
    @JsonIgnore
    public CollectionPage<UserAttributeValuesItem> getUserAttributeValues() {
        return new CollectionPage<UserAttributeValuesItem>(contextPath, UserAttributeValuesItem.class, this.userAttributeValues, Optional.ofNullable(userAttributeValuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public IdentityUserFlowAttributeAssignment withUserAttributeValues(List<UserAttributeValuesItem> userAttributeValues) {
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = changedFields.add("userAttributeValues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityUserFlowAttributeAssignment");
        _x.userAttributeValues = userAttributeValues;
        return _x;
    }

    @Property(name="userAttributeValues")
    @JsonIgnore
    public CollectionPage<UserAttributeValuesItem> getUserAttributeValues(HttpRequestOptions options) {
        return new CollectionPage<UserAttributeValuesItem>(contextPath, UserAttributeValuesItem.class, this.userAttributeValues, Optional.ofNullable(userAttributeValuesNextLink), Collections.emptyList(), options);
    }

    @Property(name="userInputType")
    @JsonIgnore
    public Optional<IdentityUserFlowAttributeInputType> getUserInputType() {
        return Optional.ofNullable(userInputType);
    }

    public IdentityUserFlowAttributeAssignment withUserInputType(IdentityUserFlowAttributeInputType userInputType) {
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = changedFields.add("userInputType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityUserFlowAttributeAssignment");
        _x.userInputType = userInputType;
        return _x;
    }

    public IdentityUserFlowAttributeAssignment withUnmappedField(String name, Object value) {
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="userAttribute")
    @JsonIgnore
    public IdentityUserFlowAttributeRequest getUserAttribute() {
        return new IdentityUserFlowAttributeRequest(contextPath.addSegment("userAttribute"), RequestHelper.getValue(unmappedFields, "userAttribute"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityUserFlowAttributeAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityUserFlowAttributeAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IdentityUserFlowAttributeAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IdentityUserFlowAttributeAssignment _copy() {
        IdentityUserFlowAttributeAssignment _x = new IdentityUserFlowAttributeAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.isOptional = isOptional;
        _x.requiresVerification = requiresVerification;
        _x.userAttributeValues = userAttributeValues;
        _x.userInputType = userInputType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentityUserFlowAttributeAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isOptional=");
        b.append(this.isOptional);
        b.append(", ");
        b.append("requiresVerification=");
        b.append(this.requiresVerification);
        b.append(", ");
        b.append("userAttributeValues=");
        b.append(this.userAttributeValues);
        b.append(", ");
        b.append("userInputType=");
        b.append(this.userInputType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
