package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccessReviewSetRequest;
import odata.msgraph.client.beta.entity.request.AppConsentApprovalRouteRequest;
import odata.msgraph.client.beta.entity.request.EntitlementManagementRequest;
import odata.msgraph.client.beta.entity.request.TermsOfUseContainerRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "accessReviews", 
    "appConsent", 
    "termsOfUse", 
    "entitlementManagement"})
@JsonInclude(Include.NON_NULL)
public class IdentityGovernance implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identityGovernance";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessReviews")
    protected AccessReviewSet accessReviews;

    @JsonProperty("appConsent")
    protected AppConsentApprovalRoute appConsent;

    @JsonProperty("termsOfUse")
    protected TermsOfUseContainer termsOfUse;

    @JsonProperty("entitlementManagement")
    protected EntitlementManagement entitlementManagement;

    protected IdentityGovernance() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AccessReviewSet accessReviews;
        private AppConsentApprovalRoute appConsent;
        private TermsOfUseContainer termsOfUse;
        private EntitlementManagement entitlementManagement;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessReviews(AccessReviewSet accessReviews) {
            this.accessReviews = accessReviews;
            this.changedFields = changedFields.add("accessReviews");
            return this;
        }

        public Builder appConsent(AppConsentApprovalRoute appConsent) {
            this.appConsent = appConsent;
            this.changedFields = changedFields.add("appConsent");
            return this;
        }

        public Builder termsOfUse(TermsOfUseContainer termsOfUse) {
            this.termsOfUse = termsOfUse;
            this.changedFields = changedFields.add("termsOfUse");
            return this;
        }

        public Builder entitlementManagement(EntitlementManagement entitlementManagement) {
            this.entitlementManagement = entitlementManagement;
            this.changedFields = changedFields.add("entitlementManagement");
            return this;
        }

        public IdentityGovernance build() {
            IdentityGovernance _x = new IdentityGovernance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.identityGovernance";
            _x.accessReviews = accessReviews;
            _x.appConsent = appConsent;
            _x.termsOfUse = termsOfUse;
            _x.entitlementManagement = entitlementManagement;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public IdentityGovernance withUnmappedField(String name, Object value) {
        IdentityGovernance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessReviews")
    @JsonIgnore
    public AccessReviewSetRequest getAccessReviews() {
        return new AccessReviewSetRequest(contextPath.addSegment("accessReviews"), Optional.ofNullable(accessReviews));
    }

    @NavigationProperty(name="appConsent")
    @JsonIgnore
    public AppConsentApprovalRouteRequest getAppConsent() {
        return new AppConsentApprovalRouteRequest(contextPath.addSegment("appConsent"), Optional.ofNullable(appConsent));
    }

    @NavigationProperty(name="termsOfUse")
    @JsonIgnore
    public TermsOfUseContainerRequest getTermsOfUse() {
        return new TermsOfUseContainerRequest(contextPath.addSegment("termsOfUse"), Optional.ofNullable(termsOfUse));
    }

    @NavigationProperty(name="entitlementManagement")
    @JsonIgnore
    public EntitlementManagementRequest getEntitlementManagement() {
        return new EntitlementManagementRequest(contextPath.addSegment("entitlementManagement"), Optional.ofNullable(entitlementManagement));
    }

    public IdentityGovernance withAccessReviews(AccessReviewSet accessReviews) {
        IdentityGovernance _x = _copy();
        _x.changedFields = changedFields.add("accessReviews");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityGovernance");
        _x.accessReviews = accessReviews;
        return _x;
    }

    public IdentityGovernance withAppConsent(AppConsentApprovalRoute appConsent) {
        IdentityGovernance _x = _copy();
        _x.changedFields = changedFields.add("appConsent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityGovernance");
        _x.appConsent = appConsent;
        return _x;
    }

    public IdentityGovernance withTermsOfUse(TermsOfUseContainer termsOfUse) {
        IdentityGovernance _x = _copy();
        _x.changedFields = changedFields.add("termsOfUse");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityGovernance");
        _x.termsOfUse = termsOfUse;
        return _x;
    }

    public IdentityGovernance withEntitlementManagement(EntitlementManagement entitlementManagement) {
        IdentityGovernance _x = _copy();
        _x.changedFields = changedFields.add("entitlementManagement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityGovernance");
        _x.entitlementManagement = entitlementManagement;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityGovernance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IdentityGovernance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityGovernance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IdentityGovernance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IdentityGovernance _copy() {
        IdentityGovernance _x = new IdentityGovernance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessReviews = accessReviews;
        _x.appConsent = appConsent;
        _x.termsOfUse = termsOfUse;
        _x.entitlementManagement = entitlementManagement;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentityGovernance[");
        b.append("accessReviews=");
        b.append(this.accessReviews);
        b.append(", ");
        b.append("appConsent=");
        b.append(this.appConsent);
        b.append(", ");
        b.append("termsOfUse=");
        b.append(this.termsOfUse);
        b.append(", ");
        b.append("entitlementManagement=");
        b.append(this.entitlementManagement);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
