package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.B2cIdentityUserFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.B2xIdentityUserFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityApiConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowAttributeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowCollectionRequest;
import odata.msgraph.client.beta.entity.request.ConditionalAccessRootRequest;
import odata.msgraph.client.beta.entity.request.ContinuousAccessEvaluationPolicyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "conditionalAccess", 
    "apiConnectors", 
    "b2cUserFlows", 
    "b2xUserFlows", 
    "identityProviders", 
    "userFlowAttributes", 
    "userFlows", 
    "continuousAccessEvaluationPolicy"})
@JsonInclude(Include.NON_NULL)
public class IdentityContainer implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identityContainer";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("conditionalAccess")
    protected ConditionalAccessRoot conditionalAccess;

    @JsonProperty("apiConnectors")
    protected List<IdentityApiConnector> apiConnectors;

    @JsonProperty("b2cUserFlows")
    protected List<B2cIdentityUserFlow> b2cUserFlows;

    @JsonProperty("b2xUserFlows")
    protected List<B2xIdentityUserFlow> b2xUserFlows;

    @JsonProperty("identityProviders")
    protected List<IdentityProviderBase> identityProviders;

    @JsonProperty("userFlowAttributes")
    protected List<IdentityUserFlowAttribute> userFlowAttributes;

    @JsonProperty("userFlows")
    protected List<IdentityUserFlow> userFlows;

    @JsonProperty("continuousAccessEvaluationPolicy")
    protected ContinuousAccessEvaluationPolicy continuousAccessEvaluationPolicy;

    protected IdentityContainer() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ConditionalAccessRoot conditionalAccess;
        private List<IdentityApiConnector> apiConnectors;
        private List<B2cIdentityUserFlow> b2cUserFlows;
        private List<B2xIdentityUserFlow> b2xUserFlows;
        private List<IdentityProviderBase> identityProviders;
        private List<IdentityUserFlowAttribute> userFlowAttributes;
        private List<IdentityUserFlow> userFlows;
        private ContinuousAccessEvaluationPolicy continuousAccessEvaluationPolicy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder conditionalAccess(ConditionalAccessRoot conditionalAccess) {
            this.conditionalAccess = conditionalAccess;
            this.changedFields = changedFields.add("conditionalAccess");
            return this;
        }

        public Builder apiConnectors(List<IdentityApiConnector> apiConnectors) {
            this.apiConnectors = apiConnectors;
            this.changedFields = changedFields.add("apiConnectors");
            return this;
        }

        public Builder apiConnectors(IdentityApiConnector... apiConnectors) {
            return apiConnectors(Arrays.asList(apiConnectors));
        }

        public Builder b2cUserFlows(List<B2cIdentityUserFlow> b2cUserFlows) {
            this.b2cUserFlows = b2cUserFlows;
            this.changedFields = changedFields.add("b2cUserFlows");
            return this;
        }

        public Builder b2cUserFlows(B2cIdentityUserFlow... b2cUserFlows) {
            return b2cUserFlows(Arrays.asList(b2cUserFlows));
        }

        public Builder b2xUserFlows(List<B2xIdentityUserFlow> b2xUserFlows) {
            this.b2xUserFlows = b2xUserFlows;
            this.changedFields = changedFields.add("b2xUserFlows");
            return this;
        }

        public Builder b2xUserFlows(B2xIdentityUserFlow... b2xUserFlows) {
            return b2xUserFlows(Arrays.asList(b2xUserFlows));
        }

        public Builder identityProviders(List<IdentityProviderBase> identityProviders) {
            this.identityProviders = identityProviders;
            this.changedFields = changedFields.add("identityProviders");
            return this;
        }

        public Builder identityProviders(IdentityProviderBase... identityProviders) {
            return identityProviders(Arrays.asList(identityProviders));
        }

        public Builder userFlowAttributes(List<IdentityUserFlowAttribute> userFlowAttributes) {
            this.userFlowAttributes = userFlowAttributes;
            this.changedFields = changedFields.add("userFlowAttributes");
            return this;
        }

        public Builder userFlowAttributes(IdentityUserFlowAttribute... userFlowAttributes) {
            return userFlowAttributes(Arrays.asList(userFlowAttributes));
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param userFlows
         *            value of {@code userFlows} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userFlows(List<IdentityUserFlow> userFlows) {
            this.userFlows = userFlows;
            this.changedFields = changedFields.add("userFlows");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param userFlows
         *            value of {@code userFlows} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userFlows(IdentityUserFlow... userFlows) {
            return userFlows(Arrays.asList(userFlows));
        }

        public Builder continuousAccessEvaluationPolicy(ContinuousAccessEvaluationPolicy continuousAccessEvaluationPolicy) {
            this.continuousAccessEvaluationPolicy = continuousAccessEvaluationPolicy;
            this.changedFields = changedFields.add("continuousAccessEvaluationPolicy");
            return this;
        }

        public IdentityContainer build() {
            IdentityContainer _x = new IdentityContainer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.identityContainer";
            _x.conditionalAccess = conditionalAccess;
            _x.apiConnectors = apiConnectors;
            _x.b2cUserFlows = b2cUserFlows;
            _x.b2xUserFlows = b2xUserFlows;
            _x.identityProviders = identityProviders;
            _x.userFlowAttributes = userFlowAttributes;
            _x.userFlows = userFlows;
            _x.continuousAccessEvaluationPolicy = continuousAccessEvaluationPolicy;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public IdentityContainer withUnmappedField(String name, Object value) {
        IdentityContainer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="conditionalAccess")
    @JsonIgnore
    public ConditionalAccessRootRequest getConditionalAccess() {
        return new ConditionalAccessRootRequest(contextPath.addSegment("conditionalAccess"), Optional.ofNullable(conditionalAccess));
    }

    @NavigationProperty(name="apiConnectors")
    @JsonIgnore
    public IdentityApiConnectorCollectionRequest getApiConnectors() {
        return new IdentityApiConnectorCollectionRequest(
                        contextPath.addSegment("apiConnectors"), Optional.ofNullable(apiConnectors));
    }

    @NavigationProperty(name="b2cUserFlows")
    @JsonIgnore
    public B2cIdentityUserFlowCollectionRequest getB2cUserFlows() {
        return new B2cIdentityUserFlowCollectionRequest(
                        contextPath.addSegment("b2cUserFlows"), Optional.ofNullable(b2cUserFlows));
    }

    @NavigationProperty(name="b2xUserFlows")
    @JsonIgnore
    public B2xIdentityUserFlowCollectionRequest getB2xUserFlows() {
        return new B2xIdentityUserFlowCollectionRequest(
                        contextPath.addSegment("b2xUserFlows"), Optional.ofNullable(b2xUserFlows));
    }

    @NavigationProperty(name="identityProviders")
    @JsonIgnore
    public IdentityProviderBaseCollectionRequest getIdentityProviders() {
        return new IdentityProviderBaseCollectionRequest(
                        contextPath.addSegment("identityProviders"), Optional.ofNullable(identityProviders));
    }

    @NavigationProperty(name="userFlowAttributes")
    @JsonIgnore
    public IdentityUserFlowAttributeCollectionRequest getUserFlowAttributes() {
        return new IdentityUserFlowAttributeCollectionRequest(
                        contextPath.addSegment("userFlowAttributes"), Optional.ofNullable(userFlowAttributes));
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return navigational property userFlows
     */
    @NavigationProperty(name="userFlows")
    @JsonIgnore
    public IdentityUserFlowCollectionRequest getUserFlows() {
        return new IdentityUserFlowCollectionRequest(
                        contextPath.addSegment("userFlows"), Optional.ofNullable(userFlows));
    }

    @NavigationProperty(name="continuousAccessEvaluationPolicy")
    @JsonIgnore
    public ContinuousAccessEvaluationPolicyRequest getContinuousAccessEvaluationPolicy() {
        return new ContinuousAccessEvaluationPolicyRequest(contextPath.addSegment("continuousAccessEvaluationPolicy"), Optional.ofNullable(continuousAccessEvaluationPolicy));
    }

    public IdentityContainer withConditionalAccess(ConditionalAccessRoot conditionalAccess) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("conditionalAccess");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.conditionalAccess = conditionalAccess;
        return _x;
    }

    public IdentityContainer withApiConnectors(List<IdentityApiConnector> apiConnectors) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("apiConnectors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.apiConnectors = apiConnectors;
        return _x;
    }

    public IdentityContainer withB2cUserFlows(List<B2cIdentityUserFlow> b2cUserFlows) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("b2cUserFlows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.b2cUserFlows = b2cUserFlows;
        return _x;
    }

    public IdentityContainer withB2xUserFlows(List<B2xIdentityUserFlow> b2xUserFlows) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("b2xUserFlows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.b2xUserFlows = b2xUserFlows;
        return _x;
    }

    public IdentityContainer withIdentityProviders(List<IdentityProviderBase> identityProviders) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("identityProviders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.identityProviders = identityProviders;
        return _x;
    }

    public IdentityContainer withUserFlowAttributes(List<IdentityUserFlowAttribute> userFlowAttributes) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("userFlowAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.userFlowAttributes = userFlowAttributes;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userFlows} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param userFlows
     *            new value of {@code userFlows} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userFlows} field changed
     */
    public IdentityContainer withUserFlows(List<IdentityUserFlow> userFlows) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("userFlows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.userFlows = userFlows;
        return _x;
    }

    public IdentityContainer withContinuousAccessEvaluationPolicy(ContinuousAccessEvaluationPolicy continuousAccessEvaluationPolicy) {
        IdentityContainer _x = _copy();
        _x.changedFields = changedFields.add("continuousAccessEvaluationPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityContainer");
        _x.continuousAccessEvaluationPolicy = continuousAccessEvaluationPolicy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityContainer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IdentityContainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityContainer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IdentityContainer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IdentityContainer _copy() {
        IdentityContainer _x = new IdentityContainer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.conditionalAccess = conditionalAccess;
        _x.apiConnectors = apiConnectors;
        _x.b2cUserFlows = b2cUserFlows;
        _x.b2xUserFlows = b2xUserFlows;
        _x.identityProviders = identityProviders;
        _x.userFlowAttributes = userFlowAttributes;
        _x.userFlows = userFlows;
        _x.continuousAccessEvaluationPolicy = continuousAccessEvaluationPolicy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentityContainer[");
        b.append("conditionalAccess=");
        b.append(this.conditionalAccess);
        b.append(", ");
        b.append("apiConnectors=");
        b.append(this.apiConnectors);
        b.append(", ");
        b.append("b2cUserFlows=");
        b.append(this.b2cUserFlows);
        b.append(", ");
        b.append("b2xUserFlows=");
        b.append(this.b2xUserFlows);
        b.append(", ");
        b.append("identityProviders=");
        b.append(this.identityProviders);
        b.append(", ");
        b.append("userFlowAttributes=");
        b.append(this.userFlowAttributes);
        b.append(", ");
        b.append("userFlows=");
        b.append(this.userFlows);
        b.append(", ");
        b.append("continuousAccessEvaluationPolicy=");
        b.append(this.continuousAccessEvaluationPolicy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
