package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ApiAuthenticationConfigurationBase;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationConfiguration", 
    "displayName", 
    "targetUrl"})
@JsonInclude(Include.NON_NULL)
public class IdentityApiConnector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identityApiConnector";
    }

    @JsonProperty("authenticationConfiguration")
    protected ApiAuthenticationConfigurationBase authenticationConfiguration;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("targetUrl")
    protected String targetUrl;

    protected IdentityApiConnector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIdentityApiConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ApiAuthenticationConfigurationBase authenticationConfiguration;
        private String displayName;
        private String targetUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authenticationConfiguration(ApiAuthenticationConfigurationBase authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            this.changedFields = changedFields.add("authenticationConfiguration");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder targetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
            this.changedFields = changedFields.add("targetUrl");
            return this;
        }

        public IdentityApiConnector build() {
            IdentityApiConnector _x = new IdentityApiConnector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.identityApiConnector";
            _x.id = id;
            _x.authenticationConfiguration = authenticationConfiguration;
            _x.displayName = displayName;
            _x.targetUrl = targetUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authenticationConfiguration")
    @JsonIgnore
    public Optional<ApiAuthenticationConfigurationBase> getAuthenticationConfiguration() {
        return Optional.ofNullable(authenticationConfiguration);
    }

    public IdentityApiConnector withAuthenticationConfiguration(ApiAuthenticationConfigurationBase authenticationConfiguration) {
        IdentityApiConnector _x = _copy();
        _x.changedFields = changedFields.add("authenticationConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityApiConnector");
        _x.authenticationConfiguration = authenticationConfiguration;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public IdentityApiConnector withDisplayName(String displayName) {
        IdentityApiConnector _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityApiConnector");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="targetUrl")
    @JsonIgnore
    public Optional<String> getTargetUrl() {
        return Optional.ofNullable(targetUrl);
    }

    public IdentityApiConnector withTargetUrl(String targetUrl) {
        IdentityApiConnector _x = _copy();
        _x.changedFields = changedFields.add("targetUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identityApiConnector");
        _x.targetUrl = targetUrl;
        return _x;
    }

    public IdentityApiConnector withUnmappedField(String name, Object value) {
        IdentityApiConnector _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityApiConnector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        IdentityApiConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public IdentityApiConnector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        IdentityApiConnector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private IdentityApiConnector _copy() {
        IdentityApiConnector _x = new IdentityApiConnector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authenticationConfiguration = authenticationConfiguration;
        _x.displayName = displayName;
        _x.targetUrl = targetUrl;
        return _x;
    }

    @Action(name = "uploadClientCertificate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<IdentityApiConnector> uploadClientCertificate(String pkcs12Value, String password) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("pkcs12Value", "Edm.String", Checks.checkIsAscii(pkcs12Value))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<IdentityApiConnector>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadClientCertificate"), IdentityApiConnector.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentityApiConnector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authenticationConfiguration=");
        b.append(this.authenticationConfiguration);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("targetUrl=");
        b.append(this.targetUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
