package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Represents an ADMX multiTextBox element and an ADMX multiText element.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "maxLength", 
    "maxStrings", 
    "required"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationMultiTextBox extends GroupPolicyPresentation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationMultiTextBox";
    }

    @JsonProperty("maxLength")
    protected Long maxLength;

    @JsonProperty("maxStrings")
    protected Long maxStrings;

    @JsonProperty("required")
    protected Boolean required;

    protected GroupPolicyPresentationMultiTextBox() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationMultiTextBox() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String label;
        private OffsetDateTime lastModifiedDateTime;
        private Long maxLength;
        private Long maxStrings;
        private Boolean required;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the maximum number of text characters.
         * Default value is 1023.”</i>
         * 
         * @param maxLength
         *            value of {@code maxLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxLength(Long maxLength) {
            this.maxLength = maxLength;
            this.changedFields = changedFields.add("maxLength");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the maximum number of strings. Default value
         * is 0.”</i>
         * 
         * @param maxStrings
         *            value of {@code maxStrings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxStrings(Long maxStrings) {
            this.maxStrings = maxStrings;
            this.changedFields = changedFields.add("maxStrings");
            return this;
        }

        /**
         * <i>“Requirement to enter a value in the text box. Default value is false.”</i>
         * 
         * @param required
         *            value of {@code required} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        public GroupPolicyPresentationMultiTextBox build() {
            GroupPolicyPresentationMultiTextBox _x = new GroupPolicyPresentationMultiTextBox();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyPresentationMultiTextBox";
            _x.id = id;
            _x.label = label;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.maxLength = maxLength;
            _x.maxStrings = maxStrings;
            _x.required = required;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“An unsigned integer that specifies the maximum number of text characters.
     * Default value is 1023.”</i>
     * 
     * @return property maxLength
     */
    @Property(name="maxLength")
    @JsonIgnore
    public Optional<Long> getMaxLength() {
        return Optional.ofNullable(maxLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maxLength} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“An unsigned integer that specifies the maximum number of text characters.
     * Default value is 1023.”</i>
     * 
     * @param maxLength
     *            new value of {@code maxLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxLength} field changed
     */
    public GroupPolicyPresentationMultiTextBox withMaxLength(Long maxLength) {
        GroupPolicyPresentationMultiTextBox _x = _copy();
        _x.changedFields = changedFields.add("maxLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationMultiTextBox");
        _x.maxLength = maxLength;
        return _x;
    }

    /**
     * <i>“An unsigned integer that specifies the maximum number of strings. Default value
     * is 0.”</i>
     * 
     * @return property maxStrings
     */
    @Property(name="maxStrings")
    @JsonIgnore
    public Optional<Long> getMaxStrings() {
        return Optional.ofNullable(maxStrings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maxStrings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“An unsigned integer that specifies the maximum number of strings. Default value
     * is 0.”</i>
     * 
     * @param maxStrings
     *            new value of {@code maxStrings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxStrings} field changed
     */
    public GroupPolicyPresentationMultiTextBox withMaxStrings(Long maxStrings) {
        GroupPolicyPresentationMultiTextBox _x = _copy();
        _x.changedFields = changedFields.add("maxStrings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationMultiTextBox");
        _x.maxStrings = maxStrings;
        return _x;
    }

    /**
     * <i>“Requirement to enter a value in the text box. Default value is false.”</i>
     * 
     * @return property required
     */
    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code required} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Requirement to enter a value in the text box. Default value is false.”</i>
     * 
     * @param required
     *            new value of {@code required} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code required} field changed
     */
    public GroupPolicyPresentationMultiTextBox withRequired(Boolean required) {
        GroupPolicyPresentationMultiTextBox _x = _copy();
        _x.changedFields = changedFields.add("required");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationMultiTextBox");
        _x.required = required;
        return _x;
    }

    public GroupPolicyPresentationMultiTextBox withUnmappedField(String name, Object value) {
        GroupPolicyPresentationMultiTextBox _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationMultiTextBox patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationMultiTextBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationMultiTextBox put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationMultiTextBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationMultiTextBox _copy() {
        GroupPolicyPresentationMultiTextBox _x = new GroupPolicyPresentationMultiTextBox();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.label = label;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.maxLength = maxLength;
        _x.maxStrings = maxStrings;
        _x.required = required;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationMultiTextBox[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("maxLength=");
        b.append(this.maxLength);
        b.append(", ");
        b.append("maxStrings=");
        b.append(this.maxStrings);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
