package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GroupPolicyPresentationDropdownListItem;


/**
 * <i>“Represents an ADMX dropdownList element and an ADMX enum element.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultItem", 
    "items", 
    "required"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationDropdownList extends GroupPolicyPresentation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationDropdownList";
    }

    @JsonProperty("defaultItem")
    protected GroupPolicyPresentationDropdownListItem defaultItem;

    @JsonProperty("items")
    protected List<GroupPolicyPresentationDropdownListItem> items;

    @JsonProperty("items@nextLink")
    protected String itemsNextLink;

    @JsonProperty("required")
    protected Boolean required;

    protected GroupPolicyPresentationDropdownList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationDropdownList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String label;
        private OffsetDateTime lastModifiedDateTime;
        private GroupPolicyPresentationDropdownListItem defaultItem;
        private List<GroupPolicyPresentationDropdownListItem> items;
        private String itemsNextLink;
        private Boolean required;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Localized string value identifying the default choice of the list of items.”</i>
         * 
         * @param defaultItem
         *            value of {@code defaultItem} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultItem(GroupPolicyPresentationDropdownListItem defaultItem) {
            this.defaultItem = defaultItem;
            this.changedFields = changedFields.add("defaultItem");
            return this;
        }

        /**
         * <i>“Represents a set of localized display names and their associated values.”</i>
         * 
         * @param items
         *            value of {@code items} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder items(List<GroupPolicyPresentationDropdownListItem> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        /**
         * <i>“Represents a set of localized display names and their associated values.”</i>
         * 
         * @param items
         *            value of {@code items} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder items(GroupPolicyPresentationDropdownListItem... items) {
            return items(Arrays.asList(items));
        }

        /**
         * <i>“Represents a set of localized display names and their associated values.”</i>
         * 
         * @param itemsNextLink
         *            value of {@code items@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder itemsNextLink(String itemsNextLink) {
            this.itemsNextLink = itemsNextLink;
            this.changedFields = changedFields.add("items");
            return this;
        }

        /**
         * <i>“Requirement to enter a value in the parameter box. The default value is false.”</i>
         * 
         * @param required
         *            value of {@code required} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        public GroupPolicyPresentationDropdownList build() {
            GroupPolicyPresentationDropdownList _x = new GroupPolicyPresentationDropdownList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyPresentationDropdownList";
            _x.id = id;
            _x.label = label;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.defaultItem = defaultItem;
            _x.items = items;
            _x.itemsNextLink = itemsNextLink;
            _x.required = required;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Localized string value identifying the default choice of the list of items.”</i>
     * 
     * @return property defaultItem
     */
    @Property(name="defaultItem")
    @JsonIgnore
    public Optional<GroupPolicyPresentationDropdownListItem> getDefaultItem() {
        return Optional.ofNullable(defaultItem);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultItem}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Localized string value identifying the default choice of the list of items.”</i>
     * 
     * @param defaultItem
     *            new value of {@code defaultItem} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultItem} field changed
     */
    public GroupPolicyPresentationDropdownList withDefaultItem(GroupPolicyPresentationDropdownListItem defaultItem) {
        GroupPolicyPresentationDropdownList _x = _copy();
        _x.changedFields = changedFields.add("defaultItem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDropdownList");
        _x.defaultItem = defaultItem;
        return _x;
    }

    /**
     * <i>“Represents a set of localized display names and their associated values.”</i>
     * 
     * @return property items
     */
    @Property(name="items")
    @JsonIgnore
    public CollectionPage<GroupPolicyPresentationDropdownListItem> getItems() {
        return new CollectionPage<GroupPolicyPresentationDropdownListItem>(contextPath, GroupPolicyPresentationDropdownListItem.class, this.items, Optional.ofNullable(itemsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code items} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Represents a set of localized display names and their associated values.”</i>
     * 
     * @param items
     *            new value of {@code items} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code items} field changed
     */
    public GroupPolicyPresentationDropdownList withItems(List<GroupPolicyPresentationDropdownListItem> items) {
        GroupPolicyPresentationDropdownList _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDropdownList");
        _x.items = items;
        return _x;
    }

    /**
     * <i>“Represents a set of localized display names and their associated values.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property items
     */
    @Property(name="items")
    @JsonIgnore
    public CollectionPage<GroupPolicyPresentationDropdownListItem> getItems(HttpRequestOptions options) {
        return new CollectionPage<GroupPolicyPresentationDropdownListItem>(contextPath, GroupPolicyPresentationDropdownListItem.class, this.items, Optional.ofNullable(itemsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Requirement to enter a value in the parameter box. The default value is false.”</i>
     * 
     * @return property required
     */
    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code required} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Requirement to enter a value in the parameter box. The default value is false.”</i>
     * 
     * @param required
     *            new value of {@code required} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code required} field changed
     */
    public GroupPolicyPresentationDropdownList withRequired(Boolean required) {
        GroupPolicyPresentationDropdownList _x = _copy();
        _x.changedFields = changedFields.add("required");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDropdownList");
        _x.required = required;
        return _x;
    }

    public GroupPolicyPresentationDropdownList withUnmappedField(String name, Object value) {
        GroupPolicyPresentationDropdownList _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationDropdownList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationDropdownList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationDropdownList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationDropdownList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationDropdownList _copy() {
        GroupPolicyPresentationDropdownList _x = new GroupPolicyPresentationDropdownList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.label = label;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.defaultItem = defaultItem;
        _x.items = items;
        _x.required = required;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationDropdownList[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("defaultItem=");
        b.append(this.defaultItem);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
