package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Represents an ADMX decimalTextBox element and an ADMX decimal element.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue", 
    "maxValue", 
    "minValue", 
    "required", 
    "spin", 
    "spinStep"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyPresentationDecimalTextBox extends GroupPolicyPresentation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyPresentationDecimalTextBox";
    }

    @JsonProperty("defaultValue")
    protected Long defaultValue;

    @JsonProperty("maxValue")
    protected Long maxValue;

    @JsonProperty("minValue")
    protected Long minValue;

    @JsonProperty("required")
    protected Boolean required;

    @JsonProperty("spin")
    protected Boolean spin;

    @JsonProperty("spinStep")
    protected Long spinStep;

    protected GroupPolicyPresentationDecimalTextBox() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupPolicyPresentationDecimalTextBox() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String label;
        private OffsetDateTime lastModifiedDateTime;
        private Long defaultValue;
        private Long maxValue;
        private Long minValue;
        private Boolean required;
        private Boolean spin;
        private Long spinStep;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the initial value for the decimal text box.
         * The default value is 1.”</i>
         * 
         * @param defaultValue
         *            value of {@code defaultValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultValue(Long defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the maximum allowed value. The default value
         * is 9999.”</i>
         * 
         * @param maxValue
         *            value of {@code maxValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maxValue(Long maxValue) {
            this.maxValue = maxValue;
            this.changedFields = changedFields.add("maxValue");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the minimum allowed value. The default value
         * is 0.”</i>
         * 
         * @param minValue
         *            value of {@code minValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minValue(Long minValue) {
            this.minValue = minValue;
            this.changedFields = changedFields.add("minValue");
            return this;
        }

        /**
         * <i>“Requirement to enter a value in the parameter box. The default value is false.”</i>
         * 
         * @param required
         *            value of {@code required} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        /**
         * <i>“If true, create a spin control; otherwise, create a text box for numeric entry.
         * The default value is true.”</i>
         * 
         * @param spin
         *            value of {@code spin} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder spin(Boolean spin) {
            this.spin = spin;
            this.changedFields = changedFields.add("spin");
            return this;
        }

        /**
         * <i>“An unsigned integer that specifies the increment of change for the spin control.
         * The default value is 1.”</i>
         * 
         * @param spinStep
         *            value of {@code spinStep} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder spinStep(Long spinStep) {
            this.spinStep = spinStep;
            this.changedFields = changedFields.add("spinStep");
            return this;
        }

        public GroupPolicyPresentationDecimalTextBox build() {
            GroupPolicyPresentationDecimalTextBox _x = new GroupPolicyPresentationDecimalTextBox();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.groupPolicyPresentationDecimalTextBox";
            _x.id = id;
            _x.label = label;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.defaultValue = defaultValue;
            _x.maxValue = maxValue;
            _x.minValue = minValue;
            _x.required = required;
            _x.spin = spin;
            _x.spinStep = spinStep;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“An unsigned integer that specifies the initial value for the decimal text box.
     * The default value is 1.”</i>
     * 
     * @return property defaultValue
     */
    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<Long> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultValue}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“An unsigned integer that specifies the initial value for the decimal text box.
     * The default value is 1.”</i>
     * 
     * @param defaultValue
     *            new value of {@code defaultValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultValue} field changed
     */
    public GroupPolicyPresentationDecimalTextBox withDefaultValue(Long defaultValue) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = changedFields.add("defaultValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDecimalTextBox");
        _x.defaultValue = defaultValue;
        return _x;
    }

    /**
     * <i>“An unsigned integer that specifies the maximum allowed value. The default value
     * is 9999.”</i>
     * 
     * @return property maxValue
     */
    @Property(name="maxValue")
    @JsonIgnore
    public Optional<Long> getMaxValue() {
        return Optional.ofNullable(maxValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maxValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“An unsigned integer that specifies the maximum allowed value. The default value
     * is 9999.”</i>
     * 
     * @param maxValue
     *            new value of {@code maxValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maxValue} field changed
     */
    public GroupPolicyPresentationDecimalTextBox withMaxValue(Long maxValue) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = changedFields.add("maxValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDecimalTextBox");
        _x.maxValue = maxValue;
        return _x;
    }

    /**
     * <i>“An unsigned integer that specifies the minimum allowed value. The default value
     * is 0.”</i>
     * 
     * @return property minValue
     */
    @Property(name="minValue")
    @JsonIgnore
    public Optional<Long> getMinValue() {
        return Optional.ofNullable(minValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“An unsigned integer that specifies the minimum allowed value. The default value
     * is 0.”</i>
     * 
     * @param minValue
     *            new value of {@code minValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minValue} field changed
     */
    public GroupPolicyPresentationDecimalTextBox withMinValue(Long minValue) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = changedFields.add("minValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDecimalTextBox");
        _x.minValue = minValue;
        return _x;
    }

    /**
     * <i>“Requirement to enter a value in the parameter box. The default value is false.”</i>
     * 
     * @return property required
     */
    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code required} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Requirement to enter a value in the parameter box. The default value is false.”</i>
     * 
     * @param required
     *            new value of {@code required} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code required} field changed
     */
    public GroupPolicyPresentationDecimalTextBox withRequired(Boolean required) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = changedFields.add("required");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDecimalTextBox");
        _x.required = required;
        return _x;
    }

    /**
     * <i>“If true, create a spin control; otherwise, create a text box for numeric entry.
     * The default value is true.”</i>
     * 
     * @return property spin
     */
    @Property(name="spin")
    @JsonIgnore
    public Optional<Boolean> getSpin() {
        return Optional.ofNullable(spin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code spin} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“If true, create a spin control; otherwise, create a text box for numeric entry.
     * The default value is true.”</i>
     * 
     * @param spin
     *            new value of {@code spin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code spin} field changed
     */
    public GroupPolicyPresentationDecimalTextBox withSpin(Boolean spin) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = changedFields.add("spin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDecimalTextBox");
        _x.spin = spin;
        return _x;
    }

    /**
     * <i>“An unsigned integer that specifies the increment of change for the spin control.
     * The default value is 1.”</i>
     * 
     * @return property spinStep
     */
    @Property(name="spinStep")
    @JsonIgnore
    public Optional<Long> getSpinStep() {
        return Optional.ofNullable(spinStep);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code spinStep} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“An unsigned integer that specifies the increment of change for the spin control.
     * The default value is 1.”</i>
     * 
     * @param spinStep
     *            new value of {@code spinStep} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code spinStep} field changed
     */
    public GroupPolicyPresentationDecimalTextBox withSpinStep(Long spinStep) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = changedFields.add("spinStep");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyPresentationDecimalTextBox");
        _x.spinStep = spinStep;
        return _x;
    }

    public GroupPolicyPresentationDecimalTextBox withUnmappedField(String name, Object value) {
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationDecimalTextBox patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GroupPolicyPresentationDecimalTextBox put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GroupPolicyPresentationDecimalTextBox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GroupPolicyPresentationDecimalTextBox _copy() {
        GroupPolicyPresentationDecimalTextBox _x = new GroupPolicyPresentationDecimalTextBox();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.label = label;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.defaultValue = defaultValue;
        _x.maxValue = maxValue;
        _x.minValue = minValue;
        _x.required = required;
        _x.spin = spin;
        _x.spinStep = spinStep;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyPresentationDecimalTextBox[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("maxValue=");
        b.append(this.maxValue);
        b.append(", ");
        b.append("minValue=");
        b.append(this.minValue);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append(", ");
        b.append("spin=");
        b.append(this.spin);
        b.append(", ");
        b.append("spinStep=");
        b.append(this.spinStep);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
