package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "insightCreatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class GovernanceInsight extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceInsight";
    }

    @JsonProperty("insightCreatedDateTime")
    protected OffsetDateTime insightCreatedDateTime;

    protected GovernanceInsight() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="insightCreatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getInsightCreatedDateTime() {
        return Optional.ofNullable(insightCreatedDateTime);
    }

    public GovernanceInsight withInsightCreatedDateTime(OffsetDateTime insightCreatedDateTime) {
        GovernanceInsight _x = _copy();
        _x.changedFields = changedFields.add("insightCreatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceInsight");
        _x.insightCreatedDateTime = insightCreatedDateTime;
        return _x;
    }

    public GovernanceInsight withUnmappedField(String name, Object value) {
        GovernanceInsight _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceInsight patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        GovernanceInsight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public GovernanceInsight put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        GovernanceInsight _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private GovernanceInsight _copy() {
        GovernanceInsight _x = new GovernanceInsight();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.insightCreatedDateTime = insightCreatedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceInsight[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("insightCreatedDateTime=");
        b.append(this.insightCreatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
