package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.CompanyCollectionRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.AsynchronousRequestsSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.BatchContinueOnErrorSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.BatchSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "companies"})
@JsonInclude(Include.NON_NULL)
public class Financials implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.financials";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("companies")
    protected List<Company> companies;

    protected Financials() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Company> companies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder companies(List<Company> companies) {
            this.companies = companies;
            this.changedFields = changedFields.add("companies");
            return this;
        }

        public Builder companies(Company... companies) {
            return companies(Arrays.asList(companies));
        }

        public Financials build() {
            Financials _x = new Financials();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.financials";
            _x.companies = companies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public Financials withUnmappedField(String name, Object value) {
        Financials _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="companies")
    @JsonIgnore
    public CompanyCollectionRequest getCompanies() {
        return new CompanyCollectionRequest(
                        contextPath.addSegment("companies"), Optional.ofNullable(companies));
    }

    public Financials withCompanies(List<Company> companies) {
        Financials _x = _copy();
        _x.changedFields = changedFields.add("companies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.financials");
        _x.companies = companies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Financials patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Financials _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Financials put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Financials _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Financials _copy() {
        Financials _x = new Financials();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.companies = companies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Financials[");
        b.append("companies=");
        b.append(this.companies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
